/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.konan.diagnostics;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.ResolveUtilKt;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.konan.diagnostics.ErrorsNative;
import org.jetbrains.kotlin.resolve.konan.diagnostics.NativeThreadLocalCheckerKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fR\u0014\u0010\u000e\u001a\u00020\r8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u000f"}, d2={"Lorg/jetbrains/kotlin/resolve/konan/diagnostics/NativeThreadLocalChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "<init>", "()V", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "declaration", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "descriptor", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "context", "", "check", "(Lorg/jetbrains/kotlin/psi/KtDeclaration;Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;)V", "Lorg/jetbrains/kotlin/name/FqName;", "threadLocalFqName", "Lorg/jetbrains/kotlin/name/FqName;"})
public final class NativeThreadLocalChecker
implements DeclarationChecker {
    @NotNull
    public static final NativeThreadLocalChecker INSTANCE = new NativeThreadLocalChecker();
    @NotNull
    private static final FqName threadLocalFqName = new FqName("kotlin.native.concurrent.ThreadLocal");

    private NativeThreadLocalChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(context, "context");
        NativeThreadLocalCheckerKt.check(this, threadLocalFqName, declaration, descriptor2, context, ErrorsNative.INAPPLICABLE_THREAD_LOCAL, arg_0 -> NativeThreadLocalChecker.check$lambda$0(descriptor2, context, declaration, arg_0));
        NativeThreadLocalCheckerKt.check(this, threadLocalFqName, declaration, descriptor2, context, ErrorsNative.INAPPLICABLE_THREAD_LOCAL_TOP_LEVEL, arg_0 -> NativeThreadLocalChecker.check$lambda$1(descriptor2, arg_0));
    }

    private static final boolean check$lambda$0(DeclarationDescriptor $descriptor, DeclarationCheckerContext $context, KtDeclaration $declaration, DeclarationDescriptor it) {
        Intrinsics.checkNotNullParameter(it, "it");
        boolean isVariable = $descriptor instanceof VariableDescriptor;
        boolean hasBackingField = $descriptor instanceof PropertyDescriptor && ResolveUtilKt.hasBackingField((PropertyDescriptor)$descriptor, $context.getTrace().getBindingContext());
        boolean hasDelegate = $declaration instanceof KtProperty && ((KtProperty)$declaration).getDelegate() != null;
        return isVariable && (hasBackingField || hasDelegate) || $descriptor instanceof ClassDescriptor && ((ClassDescriptor)$descriptor).getKind() == ClassKind.OBJECT;
    }

    private static final boolean check$lambda$1(DeclarationDescriptor $descriptor, DeclarationDescriptor it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return DescriptorUtils.isTopLevelDeclaration($descriptor) || $descriptor instanceof ClassDescriptor && ((ClassDescriptor)$descriptor).getKind() == ClassKind.OBJECT;
    }
}

