/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.konan.diagnostics;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory1;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.annotations.ThrowUtilKt;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.constants.ArrayValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.KClassValue;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.konan.diagnostics.ErrorsNative;
import org.jetbrains.kotlin.resolve.konan.diagnostics.NativeThrowsCheckerKt;
import org.jetbrains.kotlin.utils.DFS;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001*B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ9\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J#\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0007\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001d\u0010\u001b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001a0\u0019*\u00020\rH\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0019\u0010\u001d\u001a\u00020\u00162\b\u0010\u000e\u001a\u0004\u0018\u00010\rH\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJ%\u0010\"\u001a\u00020\u0011*\u0006\u0012\u0002\b\u00030\u001a2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020 0\u001fH\u0002\u00a2\u0006\u0004\b\"\u0010#R\u0014\u0010%\u001a\u00020$8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b%\u0010&R\u0014\u0010'\u001a\u00020$8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b'\u0010&R\u001a\u0010(\u001a\b\u0012\u0004\u0012\u00020 0\u001f8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b(\u0010)"}, d2={"Lorg/jetbrains/kotlin/resolve/konan/diagnostics/NativeThrowsChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "<init>", "()V", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "declaration", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "descriptor", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "context", "", "check", "(Lorg/jetbrains/kotlin/psi/KtDeclaration;Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;)V", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "throwsAnnotation", "Lorg/jetbrains/kotlin/psi/KtElement;", "reportLocation", "", "checkInheritance", "(Lorg/jetbrains/kotlin/psi/KtDeclaration;Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;Lorg/jetbrains/kotlin/psi/KtElement;)Z", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "", "Lorg/jetbrains/kotlin/resolve/konan/diagnostics/NativeThrowsChecker$ThrowsFilter;", "findInheritedThrows", "(Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;)Ljava/util/Map;", "", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "getVariadicArguments", "(Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;)Ljava/util/List;", "decodeThrowsFilter", "(Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;)Lorg/jetbrains/kotlin/resolve/konan/diagnostics/NativeThrowsChecker$ThrowsFilter;", "", "Lorg/jetbrains/kotlin/name/ClassId;", "classIds", "isGlobalClassWithId", "(Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;Ljava/util/Set;)Z", "Lorg/jetbrains/kotlin/name/FqName;", "throwsFqName", "Lorg/jetbrains/kotlin/name/FqName;", "cancellationExceptionFqName", "cancellationExceptionAndSupersClassIds", "Ljava/util/Set;", "ThrowsFilter"})
public final class NativeThrowsChecker
implements DeclarationChecker {
    @NotNull
    public static final NativeThrowsChecker INSTANCE = new NativeThrowsChecker();
    @NotNull
    private static final FqName throwsFqName = ThrowUtilKt.getKOTLIN_THROWS_ANNOTATION_FQ_NAME();
    @NotNull
    private static final FqName cancellationExceptionFqName = new FqName("kotlin.coroutines.cancellation.CancellationException");
    @NotNull
    private static final Set<ClassId> cancellationExceptionAndSupersClassIds;

    private NativeThrowsChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context) {
        KtElement reportLocation;
        KtAnnotationEntry throwsAnnotationEntry;
        KtAnnotationEntry ktAnnotationEntry;
        AnnotationDescriptor throwsAnnotation;
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(context, "context");
        AnnotationDescriptor annotationDescriptor = throwsAnnotation = descriptor2.getAnnotations().findAnnotation(throwsFqName);
        if (annotationDescriptor != null) {
            AnnotationDescriptor it = annotationDescriptor;
            boolean bl = false;
            ktAnnotationEntry = DescriptorToSourceUtils.getSourceFromAnnotation(it);
        } else {
            ktAnnotationEntry = null;
        }
        KtAnnotationEntry ktAnnotationEntry2 = throwsAnnotationEntry = ktAnnotationEntry;
        KtElement ktElement = reportLocation = ktAnnotationEntry2 != null ? (KtElement)ktAnnotationEntry2 : (KtElement)declaration;
        if (!this.checkInheritance(declaration, descriptor2, context, throwsAnnotation, reportLocation)) {
            return;
        }
        if (throwsAnnotation == null) {
            return;
        }
        BindingContext bindingContext = context.getTrace().getBindingContext();
        Intrinsics.checkNotNullExpressionValue(bindingContext, "getBindingContext(...)");
        BindingContext bindingContext2 = bindingContext;
        Object object = throwsAnnotationEntry;
        boolean bl = object != null && (object = CallUtilKt.getCall((KtElement)object, bindingContext2)) != null ? NativeThrowsCheckerKt.access$hasUnresolvedArgumentsRecursive((Call)object, bindingContext2) : false;
        if (bl) {
            return;
        }
        List<ConstantValue<?>> classes2 = this.getVariadicArguments(throwsAnnotation);
        if (classes2.isEmpty()) {
            context.getTrace().report(ErrorsNative.THROWS_LIST_EMPTY.on((KtElement)((PsiElement)reportLocation)));
            return;
        }
        if (declaration.hasModifier(KtTokens.SUSPEND_KEYWORD)) {
            boolean bl2;
            block11: {
                Iterable $this$none$iv = classes2;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl2 = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        ConstantValue it = (ConstantValue)element$iv;
                        boolean bl3 = false;
                        if (!INSTANCE.isGlobalClassWithId(it, cancellationExceptionAndSupersClassIds)) continue;
                        bl2 = false;
                        break block11;
                    }
                    bl2 = true;
                }
            }
            if (bl2) {
                context.getTrace().report(ErrorsNative.MISSING_EXCEPTION_IN_THROWS_ON_SUSPEND.on((KtElement)((PsiElement)reportLocation), cancellationExceptionFqName));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkInheritance(KtDeclaration declaration, DeclarationDescriptor descriptor2, DeclarationCheckerContext context, AnnotationDescriptor throwsAnnotation, KtElement reportLocation) {
        if (!(descriptor2 instanceof CallableMemberDescriptor) || ((CallableMemberDescriptor)descriptor2).getOverriddenDescriptors().isEmpty()) {
            return true;
        }
        Iterable $this$distinctBy$iv = this.findInheritedThrows((CallableMemberDescriptor)descriptor2).entrySet();
        boolean $i$f$distinctBy = false;
        HashSet<ThrowsFilter> set$iv = new HashSet<ThrowsFilter>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            Map.Entry it = (Map.Entry)e$iv;
            boolean bl = false;
            ThrowsFilter key$iv = (ThrowsFilter)it.getValue();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        List inherited = list$iv;
        if (inherited.size() >= 2) {
            Collection<DeclarationDescriptor> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            $this$distinctBy$iv = inherited;
            PsiElement psiElement = declaration;
            DiagnosticFactory1<KtDeclaration, Collection<DeclarationDescriptor>> diagnosticFactory1 = ErrorsNative.INCOMPATIBLE_THROWS_INHERITED;
            BindingTrace bindingTrace = context.getTrace();
            boolean $i$f$map = false;
            set$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Map.Entry bl = (Map.Entry)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                DeclarationDescriptor declarationDescriptor = ((CallableMemberDescriptor)it.getKey()).getContainingDeclaration();
                Intrinsics.checkNotNullExpressionValue(declarationDescriptor, "getContainingDeclaration(...)");
                collection.add(declarationDescriptor);
            }
            collection = (List)destination$iv$iv;
            bindingTrace.report(diagnosticFactory1.on((KtDeclaration)psiElement, collection));
            return false;
        }
        if (throwsAnnotation == null) {
            return true;
        }
        Map.Entry entry = (Map.Entry)CollectionsKt.firstOrNull(inherited);
        if (entry == null) {
            return true;
        }
        Map.Entry entry2 = entry;
        CallableMemberDescriptor overriddenMember = (CallableMemberDescriptor)entry2.getKey();
        ThrowsFilter overriddenThrows = (ThrowsFilter)entry2.getValue();
        if (!Intrinsics.areEqual(this.decodeThrowsFilter(throwsAnnotation), overriddenThrows)) {
            context.getTrace().report(ErrorsNative.INCOMPATIBLE_THROWS_OVERRIDE.on((KtElement)((PsiElement)reportLocation), overriddenMember.getContainingDeclaration()));
            return false;
        }
        return true;
    }

    private final Map<CallableMemberDescriptor, ThrowsFilter> findInheritedThrows(CallableMemberDescriptor descriptor2) {
        Map result2 = new LinkedHashMap();
        DFS.dfs(descriptor2.getOverriddenDescriptors(), NativeThrowsChecker::findInheritedThrows$lambda$5, new DFS.AbstractNodeHandler<CallableMemberDescriptor, Unit>((Map<CallableMemberDescriptor, ThrowsFilter>)result2){
            final /* synthetic */ Map<CallableMemberDescriptor, ThrowsFilter> $result;
            {
                this.$result = $result;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean beforeChildren(CallableMemberDescriptor current) {
                AnnotationDescriptor throwsAnnotation;
                AnnotationDescriptor annotationDescriptor;
                Intrinsics.checkNotNullParameter(current, "current");
                AnnotationDescriptor it = annotationDescriptor = current.getAnnotations().findAnnotation(NativeThrowsChecker.access$getThrowsFqName$p());
                boolean bl = false;
                AnnotationDescriptor annotationDescriptor2 = throwsAnnotation = current.getKind().isReal() ? annotationDescriptor : null;
                if (throwsAnnotation == null) {
                    Collection<? extends CallableMemberDescriptor> collection = current.getOverriddenDescriptors();
                    Intrinsics.checkNotNullExpressionValue(collection, "getOverriddenDescriptors(...)");
                    if (!collection.isEmpty()) {
                        return true;
                    }
                    boolean bl2 = false;
                    if (bl2) {
                        return true;
                    }
                }
                this.$result.put(current.getOriginal(), NativeThrowsChecker.access$decodeThrowsFilter(NativeThrowsChecker.INSTANCE, throwsAnnotation));
                return false;
            }

            public void result() {
            }
        });
        return result2;
    }

    private final List<ConstantValue<?>> getVariadicArguments(AnnotationDescriptor $this$getVariadicArguments) {
        ConstantValue<?> constantValue = DescriptorUtilsKt.firstArgument($this$getVariadicArguments);
        ArrayValue arrayValue = constantValue instanceof ArrayValue ? (ArrayValue)constantValue : null;
        if (arrayValue == null) {
            return CollectionsKt.emptyList();
        }
        ArrayValue argument = arrayValue;
        return (List)argument.getValue();
    }

    private final ThrowsFilter decodeThrowsFilter(AnnotationDescriptor throwsAnnotation) {
        Object object = throwsAnnotation;
        return new ThrowsFilter(object != null && (object = this.getVariadicArguments((AnnotationDescriptor)object)) != null ? CollectionsKt.toSet((Iterable)object) : null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isGlobalClassWithId(ConstantValue<?> $this$isGlobalClassWithId, Set<ClassId> classIds) {
        if (!($this$isGlobalClassWithId instanceof KClassValue)) return false;
        KClassValue.Value value2 = (KClassValue.Value)((KClassValue)$this$isGlobalClassWithId).getValue();
        if (!(value2 instanceof KClassValue.Value.NormalClass)) {
            if (!(value2 instanceof KClassValue.Value.LocalClass)) throw new NoWhenBranchMatchedException();
            return false;
        }
        boolean bl = classIds.contains(((KClassValue.Value.NormalClass)value2).getClassId());
        if (!bl) return false;
        return true;
    }

    private static final ClassId cancellationExceptionAndSupersClassIds$lambda$0(FqName it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return ClassId.Companion.topLevel(it);
    }

    private static final Iterable findInheritedThrows$lambda$5(CallableMemberDescriptor current) {
        return current.getOverriddenDescriptors();
    }

    public static final /* synthetic */ FqName access$getThrowsFqName$p() {
        return throwsFqName;
    }

    public static final /* synthetic */ ThrowsFilter access$decodeThrowsFilter(NativeThrowsChecker $this, AnnotationDescriptor throwsAnnotation) {
        return $this.decodeThrowsFilter(throwsAnnotation);
    }

    static {
        FqName[] fqNameArray = new FqName[]{StandardNames.FqNames.throwable, new FqName("kotlin.Exception"), new FqName("kotlin.RuntimeException"), new FqName("kotlin.IllegalStateException"), cancellationExceptionFqName};
        cancellationExceptionAndSupersClassIds = SequencesKt.toSet(SequencesKt.map(SequencesKt.sequenceOf(fqNameArray), NativeThrowsChecker::cancellationExceptionAndSupersClassIds$lambda$0));
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0082\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0012\u0010\u0004\u001a\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0003\u0018\u00010\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001c\u0010\u0007\u001a\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0003\u0018\u00010\u0002H\u00c7\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ&\u0010\t\u001a\u00020\u00002\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0003\u0018\u00010\u0002H\u00c7\u0001\u00a2\u0006\u0004\b\t\u0010\nJ\u001a\u0010\r\u001a\u00020\f2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u0010\u001a\u00020\u000fH\u00d6\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0013\u001a\u00020\u0012H\u00d7\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0014R&\u0010\u0004\u001a\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0003\u0018\u00010\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0015\u001a\u0004\b\u0016\u0010\b"}, d2={"Lorg/jetbrains/kotlin/resolve/konan/diagnostics/NativeThrowsChecker$ThrowsFilter;", "", "", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "classes", "<init>", "(Ljava/util/Set;)V", "component1", "()Ljava/util/Set;", "copy", "(Ljava/util/Set;)Lorg/jetbrains/kotlin/resolve/konan/diagnostics/NativeThrowsChecker$ThrowsFilter;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Ljava/util/Set;", "getClasses"})
    private static final class ThrowsFilter {
        @Nullable
        private final Set<ConstantValue<?>> classes;

        public ThrowsFilter(@Nullable Set<? extends ConstantValue<?>> classes2) {
            this.classes = classes2;
        }

        @Nullable
        public final Set<ConstantValue<?>> getClasses() {
            return this.classes;
        }

        @Nullable
        public final Set<ConstantValue<?>> component1() {
            return this.classes;
        }

        @NotNull
        public final ThrowsFilter copy(@Nullable Set<? extends ConstantValue<?>> classes2) {
            return new ThrowsFilter(classes2);
        }

        public static /* synthetic */ ThrowsFilter copy$default(ThrowsFilter throwsFilter, Set set, int n, Object object) {
            if ((n & 1) != 0) {
                set = throwsFilter.classes;
            }
            return throwsFilter.copy(set);
        }

        @NotNull
        public String toString() {
            return "ThrowsFilter(classes=" + this.classes + ')';
        }

        public int hashCode() {
            return this.classes == null ? 0 : ((Object)this.classes).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ThrowsFilter)) {
                return false;
            }
            ThrowsFilter throwsFilter = (ThrowsFilter)other;
            return Intrinsics.areEqual(this.classes, throwsFilter.classes);
        }
    }
}

