/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.lazy;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtImportInfo;
import org.jetbrains.kotlin.resolve.lazy.IndexedImports;
import org.jetbrains.kotlin.storage.NotNullLazyValue;
import org.jetbrains.kotlin.storage.StorageManager;

public final class ExplicitImportsIndexed<I extends KtImportInfo>
extends IndexedImports<I> {
    private final NotNullLazyValue<ListMultimap<Name, I>> nameToDirectives;

    public ExplicitImportsIndexed(I[] IArray, StorageManager storageManager) {
        Intrinsics.checkNotNullParameter(IArray, "imports");
        Intrinsics.checkNotNullParameter(storageManager, "storageManager");
        super(IArray);
        this.nameToDirectives = storageManager.createLazyValue(() -> ExplicitImportsIndexed.nameToDirectives$lambda$0(IArray));
    }

    @Override
    public List<I> importsForName(Name name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return ((ListMultimap)this.nameToDirectives.invoke()).get(name);
    }

    private static final ImmutableListMultimap nameToDirectives$lambda$0(KtImportInfo[] ktImportInfoArray) {
        ImmutableListMultimap.Builder builder2 = ImmutableListMultimap.builder();
        for (KtImportInfo ktImportInfo : ktImportInfoArray) {
            Name name;
            if (ktImportInfo.getImportedName() == null) continue;
            builder2.put(name, ktImportInfo);
        }
        return builder2.build();
    }
}

