/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.lazy;

import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtImportInfo;
import org.jetbrains.kotlin.resolve.extensions.ExtraImportsProviderExtension;
import org.jetbrains.kotlin.resolve.lazy.ExplicitImportsIndexed;
import org.jetbrains.kotlin.resolve.lazy.FileScopeFactory;
import org.jetbrains.kotlin.resolve.lazy.FileScopeFactory$DefaultImportResolvers;
import org.jetbrains.kotlin.resolve.lazy.FileScopeFactory$DummyContainerDescriptor;
import org.jetbrains.kotlin.resolve.lazy.FileScopeFactory$FilesScopesBuilder$importResolver$1;
import org.jetbrains.kotlin.resolve.lazy.FileScopeFactory$FilesScopesBuilder$lazyImportingScope$1;
import org.jetbrains.kotlin.resolve.lazy.FileScopeFactory$FilteringKind;
import org.jetbrains.kotlin.resolve.lazy.FileScopes;
import org.jetbrains.kotlin.resolve.lazy.ImportForceResolver;
import org.jetbrains.kotlin.resolve.lazy.IndexedImports;
import org.jetbrains.kotlin.resolve.lazy.LazyImportResolver;
import org.jetbrains.kotlin.resolve.lazy.LazyImportResolverForKtImportDirective;
import org.jetbrains.kotlin.resolve.lazy.LazyImportScope;
import org.jetbrains.kotlin.resolve.scopes.ImportingScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.SubpackagesImportingScope;
import org.jetbrains.kotlin.storage.StorageManager;

final class FileScopeFactory$FilesScopesBuilder {
    private final KtFile file;
    private final ImportingScope existingImports;
    private final PackageFragmentDescriptor packageFragment;
    private final PackageViewDescriptor packageView;
    private final boolean createDefaultImportingScopes;
    private final List<KtImportDirective> imports;
    private final List<FqName> aliasImportNames;
    private final LazyImportResolverForKtImportDirective explicitImportResolver;
    private final LazyImportResolverForKtImportDirective allUnderImportResolver;
    private final ImportingScope lazyImportingScope;
    private final LexicalScope.Base lexicalScope;
    private final ImportForceResolver importResolver;
    private final FileScopes result;
    final /* synthetic */ FileScopeFactory this$0;

    public FileScopeFactory$FilesScopesBuilder(FileScopeFactory fileScopeFactory, KtFile ktFile, ImportingScope importingScope, PackageFragmentDescriptor packageFragmentDescriptor, PackageViewDescriptor packageViewDescriptor, boolean bl) {
        KtImportInfo ktImportInfo;
        Object object2;
        Intrinsics.checkNotNullParameter(ktFile, "file");
        Intrinsics.checkNotNullParameter(packageFragmentDescriptor, "packageFragment");
        Intrinsics.checkNotNullParameter(packageViewDescriptor, "packageView");
        this.this$0 = fileScopeFactory;
        this.file = ktFile;
        this.existingImports = importingScope;
        this.packageFragment = packageFragmentDescriptor;
        this.packageView = packageViewDescriptor;
        this.createDefaultImportingScopes = bl;
        this.imports = this.file.getImportDirectives();
        Iterable iterable = this.imports;
        FileScopeFactory$FilesScopesBuilder fileScopeFactory$FilesScopesBuilder = this;
        boolean bl2 = false;
        Iterable iterable2 = iterable;
        Iterable iterable3 = new ArrayList();
        boolean bl3 = false;
        Iterable iterable4 = iterable2;
        boolean bl4 = false;
        for (Object object2 : iterable4) {
            FqName fqName2;
            Object t = object2;
            boolean bl5 = false;
            ktImportInfo = (KtImportDirective)t;
            boolean bl6 = false;
            if ((((KtImportDirective)ktImportInfo).getAliasName() != null ? ((KtImportDirective)ktImportInfo).getImportedFqName() : null) == null) continue;
            fqName2 = fqName2;
            boolean bl7 = false;
            iterable3.add(fqName2);
        }
        fileScopeFactory$FilesScopesBuilder.aliasImportNames = (List)iterable3;
        iterable = this.imports;
        StorageManager storageManager = FileScopeFactory.access$getComponents$p(this.this$0).getStorageManager();
        FileScopeFactory fileScopeFactory2 = this.this$0;
        fileScopeFactory$FilesScopesBuilder = this;
        boolean bl8 = false;
        iterable3 = iterable;
        bl4 = false;
        Object object3 = iterable3;
        object2 = new ArrayList();
        boolean bl9 = false;
        Iterator iterator22 = object3.iterator();
        while (iterator22.hasNext()) {
            ktImportInfo = iterator22.next();
            KtImportInfo ktImportInfo2 = ktImportInfo;
            boolean bl10 = false;
            if (!(!ktImportInfo2.isAllUnder())) continue;
            object2.add((KtImportDirective)ktImportInfo);
        }
        iterable3 = (List)object2;
        bl4 = false;
        object3 = iterable3;
        StorageManager storageManager2 = storageManager;
        KtImportInfo[] ktImportInfoArray = object3.toArray(new KtImportDirective[0]);
        IndexedImports indexedImports = new ExplicitImportsIndexed(ktImportInfoArray, storageManager2);
        fileScopeFactory$FilesScopesBuilder.explicitImportResolver = FileScopeFactory.createImportResolver$default(fileScopeFactory2, indexedImports, FileScopeFactory.access$getBindingTrace$p(this.this$0), this.aliasImportNames, this.packageFragment, null, 16, null);
        iterable = this.imports;
        fileScopeFactory2 = this.this$0;
        fileScopeFactory$FilesScopesBuilder = this;
        boolean bl11 = false;
        Iterable iterable5 = iterable;
        boolean bl12 = false;
        Iterable iterable6 = iterable5;
        object3 = new ArrayList();
        boolean bl13 = false;
        for (Iterator iterator22 : iterable6) {
            ktImportInfo = (KtImportInfo)((Object)iterator22);
            boolean bl14 = false;
            if (!ktImportInfo.isAllUnder()) continue;
            object3.add(iterator22);
        }
        iterable5 = (List)object3;
        bl12 = false;
        iterable6 = iterable5;
        KtImportInfo[] ktImportInfoArray2 = iterable6.toArray(new KtImportDirective[0]);
        indexedImports = new IndexedImports(ktImportInfoArray2);
        fileScopeFactory$FilesScopesBuilder.allUnderImportResolver = FileScopeFactory.createImportResolver$default(fileScopeFactory2, indexedImports, FileScopeFactory.access$getBindingTrace$p(this.this$0), this.aliasImportNames, this.packageFragment, null, 16, null);
        this.lazyImportingScope = new FileScopeFactory$FilesScopesBuilder$lazyImportingScope$1(this.this$0, this);
        this.lexicalScope = new LexicalScope.Base(this.lazyImportingScope, FileScopeFactory.access$getTopLevelDescriptorProvider$p(this.this$0).getPackageFragmentOrDiagnoseFailure(this.file.getPackageFqName(), this.file));
        this.importResolver = new FileScopeFactory$FilesScopesBuilder$importResolver$1(this);
        this.result = new FileScopes(this.lexicalScope, this.lazyImportingScope, this.importResolver);
    }

    public final List<KtImportDirective> getImports() {
        return this.imports;
    }

    public final List<FqName> getAliasImportNames() {
        return this.aliasImportNames;
    }

    public final LazyImportResolverForKtImportDirective getExplicitImportResolver() {
        return this.explicitImportResolver;
    }

    public final LazyImportResolverForKtImportDirective getAllUnderImportResolver() {
        return this.allUnderImportResolver;
    }

    public final ImportingScope getLazyImportingScope() {
        return this.lazyImportingScope;
    }

    public final LexicalScope.Base getLexicalScope() {
        return this.lexicalScope;
    }

    public final ImportForceResolver getImportResolver() {
        return this.importResolver;
    }

    public final FileScopes getResult() {
        return this.result;
    }

    private final FileScopeFactory$DefaultImportResolvers createDefaultImportResolversForFile() {
        Project project = this.file.getProject();
        Intrinsics.checkNotNullExpressionValue(project, "getProject(...)");
        Collection<KtImportInfo> collection = ExtraImportsProviderExtension.Companion.getInstance(project).getExtraImports(this.file);
        if (collection.isEmpty() && this.aliasImportNames.isEmpty()) {
            return FileScopeFactory.access$getDefaultImportResolvers(this.this$0);
        }
        return FileScopeFactory.access$createDefaultImportResolvers(this.this$0, collection, this.aliasImportNames);
    }

    public final LazyImportScope createImportingScope() {
        FileScopeFactory$DefaultImportResolvers fileScopeFactory$DefaultImportResolvers = this.createDefaultImportResolversForFile();
        LazyImportResolver<KtImportInfo> lazyImportResolver = fileScopeFactory$DefaultImportResolvers.component1();
        LazyImportResolver<KtImportInfo> lazyImportResolver2 = fileScopeFactory$DefaultImportResolvers.component2();
        LazyImportResolver<KtImportInfo> lazyImportResolver3 = fileScopeFactory$DefaultImportResolvers.component3();
        FileScopeFactory$DummyContainerDescriptor fileScopeFactory$DummyContainerDescriptor = new FileScopeFactory$DummyContainerDescriptor(this.file, this.packageFragment);
        ImportingScope importingScope = this.existingImports;
        String string2 = "LazyFileScope for file " + this.file.getName();
        if (this.createDefaultImportingScopes) {
            importingScope = new LazyImportScope(importingScope, lazyImportResolver2, lazyImportResolver3, LazyImportScope.FilteringKind.INVISIBLE_CLASSES, "Default all under imports in " + string2 + " (invisible classes only)");
        }
        importingScope = new LazyImportScope(importingScope, this.allUnderImportResolver, null, LazyImportScope.FilteringKind.INVISIBLE_CLASSES, "All under imports in " + string2 + " (invisible classes only)");
        importingScope = FileScopeFactory.access$currentPackageScope(this.this$0, this.packageView, this.aliasImportNames, fileScopeFactory$DummyContainerDescriptor, FileScopeFactory$FilteringKind.INVISIBLE_CLASSES, importingScope);
        if (this.createDefaultImportingScopes) {
            importingScope = new LazyImportScope(importingScope, lazyImportResolver2, lazyImportResolver3, LazyImportScope.FilteringKind.VISIBLE_CLASSES, "Default all under imports in " + string2 + " (visible classes)");
        }
        importingScope = new LazyImportScope(importingScope, this.allUnderImportResolver, null, LazyImportScope.FilteringKind.VISIBLE_CLASSES, "All under imports in " + string2 + " (visible classes)");
        if (this.createDefaultImportingScopes) {
            importingScope = new LazyImportScope(importingScope, lazyImportResolver, null, LazyImportScope.FilteringKind.ALL, "Default explicit imports in " + string2);
        }
        importingScope = new SubpackagesImportingScope(importingScope, FileScopeFactory.access$getComponents$p(this.this$0).getModuleDescriptor(), FqName.ROOT);
        importingScope = FileScopeFactory.access$currentPackageScope(this.this$0, this.packageView, this.aliasImportNames, fileScopeFactory$DummyContainerDescriptor, FileScopeFactory$FilteringKind.VISIBLE_CLASSES, importingScope);
        return new LazyImportScope(importingScope, this.explicitImportResolver, null, LazyImportScope.FilteringKind.ALL, "Explicit imports in " + string2);
    }
}

