/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.lazy;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.FileScopeFactory;
import org.jetbrains.kotlin.resolve.lazy.FileScopeProvider;
import org.jetbrains.kotlin.resolve.lazy.FileScopeProviderKt;
import org.jetbrains.kotlin.resolve.lazy.FileScopes;
import org.jetbrains.kotlin.storage.MemoizedFunctionToNotNull;
import org.jetbrains.kotlin.storage.StorageManager;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\nH\u0017\u00a2\u0006\u0004\b\r\u0010\u000eR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u000fR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0010R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0011R \u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\f0\u00128\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014"}, d2={"Lorg/jetbrains/kotlin/resolve/lazy/FileScopeProviderImpl;", "Lorg/jetbrains/kotlin/resolve/lazy/FileScopeProvider;", "Lorg/jetbrains/kotlin/resolve/lazy/FileScopeFactory;", "fileScopeFactory", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "bindingTrace", "Lorg/jetbrains/kotlin/storage/StorageManager;", "storageManager", "<init>", "(Lorg/jetbrains/kotlin/resolve/lazy/FileScopeFactory;Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/storage/StorageManager;)V", "Lorg/jetbrains/kotlin/psi/KtFile;", "file", "Lorg/jetbrains/kotlin/resolve/lazy/FileScopes;", "getFileScopes", "(Lorg/jetbrains/kotlin/psi/KtFile;)Lorg/jetbrains/kotlin/resolve/lazy/FileScopes;", "Lorg/jetbrains/kotlin/resolve/lazy/FileScopeFactory;", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "Lorg/jetbrains/kotlin/storage/StorageManager;", "Lorg/jetbrains/kotlin/storage/MemoizedFunctionToNotNull;", "cache", "Lorg/jetbrains/kotlin/storage/MemoizedFunctionToNotNull;"})
public final class FileScopeProviderImpl
implements FileScopeProvider {
    @NotNull
    private final FileScopeFactory fileScopeFactory;
    @NotNull
    private final BindingTrace bindingTrace;
    @NotNull
    private final StorageManager storageManager;
    @NotNull
    private final MemoizedFunctionToNotNull<KtFile, FileScopes> cache;

    public FileScopeProviderImpl(@NotNull FileScopeFactory fileScopeFactory, @NotNull BindingTrace bindingTrace, @NotNull StorageManager storageManager) {
        Intrinsics.checkNotNullParameter(fileScopeFactory, "fileScopeFactory");
        Intrinsics.checkNotNullParameter(bindingTrace, "bindingTrace");
        Intrinsics.checkNotNullParameter(storageManager, "storageManager");
        this.fileScopeFactory = fileScopeFactory;
        this.bindingTrace = bindingTrace;
        this.storageManager = storageManager;
        this.cache = this.storageManager.createMemoizedFunction(arg_0 -> FileScopeProviderImpl.cache$lambda$0(this, arg_0));
    }

    @Override
    @NotNull
    public FileScopes getFileScopes(@NotNull KtFile file2) {
        Intrinsics.checkNotNullParameter(file2, "file");
        return (FileScopes)this.cache.invoke(file2);
    }

    private static final FileScopes cache$lambda$0(FileScopeProviderImpl this$0, KtFile file2) {
        Intrinsics.checkNotNullParameter(file2, "file");
        Object object = (KtFile)file2.getOriginalFile();
        if (object == null || (object = FileScopeProviderKt.getFileScopesCustomizer((KtFile)object)) == null || (object = object.createFileScopes(this$0.fileScopeFactory)) == null) {
            object = FileScopeFactory.createScopesForFile$default(this$0.fileScopeFactory, file2, null, false, 6, null);
        }
        Object scopes = object;
        BindingContextUtilsKt.recordScope(this$0.bindingTrace, ((FileScopes)scopes).getLexicalScope(), file2);
        return scopes;
    }
}

