/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.lazy.declarations;

import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.lazy.data.KtClassInfoUtil;
import org.jetbrains.kotlin.resolve.lazy.data.KtClassOrObjectInfo;
import org.jetbrains.kotlin.resolve.lazy.data.KtScriptInfo;
import org.jetbrains.kotlin.resolve.lazy.declarations.DeclarationProvider;
import org.jetbrains.kotlin.resolve.scopes.DescriptorKindFilter;
import org.jetbrains.kotlin.storage.NotNullLazyValue;
import org.jetbrains.kotlin.storage.StorageManager;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001:\u00010B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001f\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\bH\u0017\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u000bH$\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0013\u001a\u00020\u0010H\u0001\u00a2\u0006\u0004\b\u0011\u0010\u0012J1\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u0015\u001a\u00020\u00142\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00170\u0016H\u0017\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u001d\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00192\u0006\u0010\u001d\u001a\u00020\u0007H\u0017\u00a2\u0006\u0004\b\u001f\u0010 J\u001d\u0010\"\u001a\b\u0012\u0004\u0012\u00020!0\u00192\u0006\u0010\u001d\u001a\u00020\u0007H\u0017\u00a2\u0006\u0004\b\"\u0010 J\u001d\u0010%\u001a\b\u0012\u0004\u0012\u00020$0#2\u0006\u0010\u001d\u001a\u00020\u0007H\u0017\u00a2\u0006\u0004\b%\u0010&J!\u0010(\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030'0#2\u0006\u0010\u001d\u001a\u00020\u0007H\u0017\u00a2\u0006\u0004\b(\u0010&J\u001d\u0010+\u001a\b\u0012\u0004\u0012\u00020*0)2\u0006\u0010\u001d\u001a\u00020\u0007H\u0017\u00a2\u0006\u0004\b+\u0010 J\u001d\u0010-\u001a\b\u0012\u0004\u0012\u00020,0#2\u0006\u0010\u001d\u001a\u00020\u0007H\u0017\u00a2\u0006\u0004\b-\u0010&R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0.8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\f\u0010/"}, d2={"Lorg/jetbrains/kotlin/resolve/lazy/declarations/AbstractPsiBasedDeclarationProvider;", "Lorg/jetbrains/kotlin/resolve/lazy/declarations/DeclarationProvider;", "Lorg/jetbrains/kotlin/storage/StorageManager;", "storageManager", "<init>", "(Lorg/jetbrains/kotlin/storage/StorageManager;)V", "Ljava/util/HashSet;", "Lorg/jetbrains/kotlin/name/Name;", "Lkotlin/collections/HashSet;", "getDeclarationNames", "()Ljava/util/HashSet;", "Lorg/jetbrains/kotlin/resolve/lazy/declarations/AbstractPsiBasedDeclarationProvider$Index;", "index", "", "doCreateIndex", "(Lorg/jetbrains/kotlin/resolve/lazy/declarations/AbstractPsiBasedDeclarationProvider$Index;)V", "", "toInfoString$frontend", "()Ljava/lang/String;", "toInfoString", "Lorg/jetbrains/kotlin/resolve/scopes/DescriptorKindFilter;", "kindFilter", "Lkotlin/Function1;", "", "nameFilter", "", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "getDeclarations", "(Lorg/jetbrains/kotlin/resolve/scopes/DescriptorKindFilter;Lkotlin/jvm/functions/Function1;)Ljava/util/List;", "name", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "getFunctionDeclarations", "(Lorg/jetbrains/kotlin/name/Name;)Ljava/util/List;", "Lorg/jetbrains/kotlin/psi/KtProperty;", "getPropertyDeclarations", "", "Lorg/jetbrains/kotlin/psi/KtDestructuringDeclarationEntry;", "getDestructuringDeclarationsEntries", "(Lorg/jetbrains/kotlin/name/Name;)Ljava/util/Collection;", "Lorg/jetbrains/kotlin/resolve/lazy/data/KtClassOrObjectInfo;", "getClassOrObjectDeclarations", "", "Lorg/jetbrains/kotlin/resolve/lazy/data/KtScriptInfo;", "getScriptDeclarations", "Lorg/jetbrains/kotlin/psi/KtTypeAlias;", "getTypeAliasDeclarations", "Lorg/jetbrains/kotlin/storage/NotNullLazyValue;", "Lorg/jetbrains/kotlin/storage/NotNullLazyValue;", "Index"})
public abstract class AbstractPsiBasedDeclarationProvider
implements DeclarationProvider {
    @NotNull
    private final NotNullLazyValue<Index> index;

    public AbstractPsiBasedDeclarationProvider(@NotNull StorageManager storageManager) {
        Intrinsics.checkNotNullParameter(storageManager, "storageManager");
        this.index = storageManager.createLazyValue(() -> AbstractPsiBasedDeclarationProvider.index$lambda$0(this));
    }

    @NotNull
    public HashSet<Name> getDeclarationNames() {
        return ((Index)this.index.invoke()).getNames();
    }

    protected abstract void doCreateIndex(@NotNull Index var1);

    @NotNull
    public final String toInfoString$frontend() {
        return this + ": " + this.index.invoke();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<KtDeclaration> getDeclarations(@NotNull DescriptorKindFilter kindFilter, @NotNull Function1<? super Name, Boolean> nameFilter) {
        Intrinsics.checkNotNullParameter(kindFilter, "kindFilter");
        Intrinsics.checkNotNullParameter(nameFilter, "nameFilter");
        ArrayList<KtDeclaration> allDeclarations = ((Index)this.index.invoke()).getAllDeclarations();
        if (Intrinsics.areEqual(kindFilter, DescriptorKindFilter.CLASSIFIERS)) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = allDeclarations;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                KtDeclaration it = (KtDeclaration)element$iv$iv;
                boolean bl = false;
                if (!(it instanceof KtClassOrObject || it instanceof KtTypeAlias)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }
        return allDeclarations;
    }

    @NotNull
    public List<KtNamedFunction> getFunctionDeclarations(@NotNull Name name) {
        Intrinsics.checkNotNullParameter(name, "name");
        List list = ((Index)this.index.invoke()).getFunctions().get((Object)KtPsiUtilKt.safeNameForLazyResolve(name));
        Intrinsics.checkNotNullExpressionValue(list, "get(...)");
        return CollectionsKt.toList(list);
    }

    @NotNull
    public List<KtProperty> getPropertyDeclarations(@NotNull Name name) {
        Intrinsics.checkNotNullParameter(name, "name");
        List list = ((Index)this.index.invoke()).getProperties().get((Object)KtPsiUtilKt.safeNameForLazyResolve(name));
        Intrinsics.checkNotNullExpressionValue(list, "get(...)");
        return CollectionsKt.toList(list);
    }

    @Override
    @NotNull
    public Collection<KtDestructuringDeclarationEntry> getDestructuringDeclarationsEntries(@NotNull Name name) {
        Intrinsics.checkNotNullParameter(name, "name");
        List list = ((Index)this.index.invoke()).getDestructuringDeclarationsEntries().get((Object)KtPsiUtilKt.safeNameForLazyResolve(name));
        Intrinsics.checkNotNullExpressionValue(list, "get(...)");
        return CollectionsKt.toList(list);
    }

    @Override
    @NotNull
    public Collection<KtClassOrObjectInfo<?>> getClassOrObjectDeclarations(@NotNull Name name) {
        Intrinsics.checkNotNullParameter(name, "name");
        List list = ((Index)this.index.invoke()).getClassesAndObjects().get((Object)KtPsiUtilKt.safeNameForLazyResolve(name));
        Intrinsics.checkNotNullExpressionValue(list, "get(...)");
        return list;
    }

    @NotNull
    public List<KtScriptInfo> getScriptDeclarations(@NotNull Name name) {
        Intrinsics.checkNotNullParameter(name, "name");
        List list = ((Index)this.index.invoke()).getScripts().get((Object)KtPsiUtilKt.safeNameForLazyResolve(name));
        Intrinsics.checkNotNullExpressionValue(list, "get(...)");
        return list;
    }

    @Override
    @NotNull
    public Collection<KtTypeAlias> getTypeAliasDeclarations(@NotNull Name name) {
        Intrinsics.checkNotNullParameter(name, "name");
        List list = ((Index)this.index.invoke()).getTypeAliases().get((Object)KtPsiUtilKt.safeNameForLazyResolve(name));
        Intrinsics.checkNotNullExpressionValue(list, "get(...)");
        return list;
    }

    private static final Index index$lambda$0(AbstractPsiBasedDeclarationProvider this$0) {
        Index index2 = new Index();
        this$0.doCreateIndex(index2);
        return index2;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\n\u001a\u00020\tH\u0017\u00a2\u0006\u0004\b\n\u0010\u000bR \u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\f8\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010RF\u0010\u0014\u001a.\u0012\b\u0012\u0006*\u00020\u00120\u0012\u0012\b\u0012\u0006*\u00020\u00130\u0013*\u0016\u0012\b\u0012\u0006*\u00020\u00120\u0012\u0012\b\u0012\u0006*\u00020\u00130\u00130\u00110\u00118\u0006X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017RC\u0010\u0019\u001a.\u0012\b\u0012\u0006*\u00020\u00120\u0012\u0012\b\u0012\u0006*\u00020\u00180\u0018*\u0016\u0012\b\u0012\u0006*\u00020\u00120\u0012\u0012\b\u0012\u0006*\u00020\u00180\u00180\u00110\u00118\u0006\u00a2\u0006\f\n\u0004\b\u0019\u0010\u0015\u001a\u0004\b\u001a\u0010\u0017RS\u0010\u001c\u001a>\u0012\b\u0012\u0006*\u00020\u00120\u0012\u0012\u0010\u0012\u000e\u0012\u0002\b\u0003*\u0006\u0012\u0002\b\u00030\u001b0\u001b*\u001e\u0012\b\u0012\u0006*\u00020\u00120\u0012\u0012\u0010\u0012\u000e\u0012\u0002\b\u0003*\u0006\u0012\u0002\b\u00030\u001b0\u001b0\u00110\u00118\u0006\u00a2\u0006\f\n\u0004\b\u001c\u0010\u0015\u001a\u0004\b\u001d\u0010\u0017RC\u0010\u001f\u001a.\u0012\b\u0012\u0006*\u00020\u00120\u0012\u0012\b\u0012\u0006*\u00020\u001e0\u001e*\u0016\u0012\b\u0012\u0006*\u00020\u00120\u0012\u0012\b\u0012\u0006*\u00020\u001e0\u001e0\u00110\u00118\u0006\u00a2\u0006\f\n\u0004\b\u001f\u0010\u0015\u001a\u0004\b \u0010\u0017RC\u0010\"\u001a.\u0012\b\u0012\u0006*\u00020\u00120\u0012\u0012\b\u0012\u0006*\u00020!0!*\u0016\u0012\b\u0012\u0006*\u00020\u00120\u0012\u0012\b\u0012\u0006*\u00020!0!0\u00110\u00118\u0006\u00a2\u0006\f\n\u0004\b\"\u0010\u0015\u001a\u0004\b#\u0010\u0017RC\u0010%\u001a.\u0012\b\u0012\u0006*\u00020\u00120\u0012\u0012\b\u0012\u0006*\u00020$0$*\u0016\u0012\b\u0012\u0006*\u00020\u00120\u0012\u0012\b\u0012\u0006*\u00020$0$0\u00110\u00118\u0006\u00a2\u0006\f\n\u0004\b%\u0010\u0015\u001a\u0004\b&\u0010\u0017R*\u0010)\u001a\u0012\u0012\u0004\u0012\u00020\u00120'j\b\u0012\u0004\u0012\u00020\u0012`(8\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b)\u0010*\u001a\u0004\b+\u0010,"}, d2={"Lorg/jetbrains/kotlin/resolve/lazy/declarations/AbstractPsiBasedDeclarationProvider$Index;", "", "<init>", "()V", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "declaration", "", "putToIndex", "(Lorg/jetbrains/kotlin/psi/KtDeclaration;)V", "", "toString", "()Ljava/lang/String;", "Ljava/util/ArrayList;", "allDeclarations", "Ljava/util/ArrayList;", "getAllDeclarations", "()Ljava/util/ArrayList;", "Lcom/google/common/collect/ArrayListMultimap;", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "functions", "Lcom/google/common/collect/ArrayListMultimap;", "getFunctions", "()Lcom/google/common/collect/ArrayListMultimap;", "Lorg/jetbrains/kotlin/psi/KtProperty;", "properties", "getProperties", "Lorg/jetbrains/kotlin/resolve/lazy/data/KtClassOrObjectInfo;", "classesAndObjects", "getClassesAndObjects", "Lorg/jetbrains/kotlin/resolve/lazy/data/KtScriptInfo;", "scripts", "getScripts", "Lorg/jetbrains/kotlin/psi/KtTypeAlias;", "typeAliases", "getTypeAliases", "Lorg/jetbrains/kotlin/psi/KtDestructuringDeclarationEntry;", "destructuringDeclarationsEntries", "getDestructuringDeclarationsEntries", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "names", "Ljava/util/HashSet;", "getNames", "()Ljava/util/HashSet;"})
    protected static final class Index {
        @NotNull
        private final ArrayList<KtDeclaration> allDeclarations = new ArrayList();
        private final ArrayListMultimap<Name, KtNamedFunction> functions = ArrayListMultimap.create();
        private final ArrayListMultimap<Name, KtProperty> properties = ArrayListMultimap.create();
        private final ArrayListMultimap<Name, KtClassOrObjectInfo<?>> classesAndObjects = ArrayListMultimap.create();
        private final ArrayListMultimap<Name, KtScriptInfo> scripts = ArrayListMultimap.create();
        private final ArrayListMultimap<Name, KtTypeAlias> typeAliases = ArrayListMultimap.create();
        private final ArrayListMultimap<Name, KtDestructuringDeclarationEntry> destructuringDeclarationsEntries = ArrayListMultimap.create();
        @NotNull
        private final HashSet<Name> names = new HashSet();

        @NotNull
        public final ArrayList<KtDeclaration> getAllDeclarations() {
            return this.allDeclarations;
        }

        public final ArrayListMultimap<Name, KtNamedFunction> getFunctions() {
            return this.functions;
        }

        public final ArrayListMultimap<Name, KtProperty> getProperties() {
            return this.properties;
        }

        public final ArrayListMultimap<Name, KtClassOrObjectInfo<?>> getClassesAndObjects() {
            return this.classesAndObjects;
        }

        public final ArrayListMultimap<Name, KtScriptInfo> getScripts() {
            return this.scripts;
        }

        public final ArrayListMultimap<Name, KtTypeAlias> getTypeAliases() {
            return this.typeAliases;
        }

        public final ArrayListMultimap<Name, KtDestructuringDeclarationEntry> getDestructuringDeclarationsEntries() {
            return this.destructuringDeclarationsEntries;
        }

        @NotNull
        public final HashSet<Name> getNames() {
            return this.names;
        }

        public final void putToIndex(@NotNull KtDeclaration declaration) {
            Intrinsics.checkNotNullParameter(declaration, "declaration");
            if (declaration instanceof KtAnonymousInitializer || declaration instanceof KtSecondaryConstructor) {
                return;
            }
            this.allDeclarations.add(declaration);
            KtDeclaration ktDeclaration = declaration;
            if (ktDeclaration instanceof KtNamedFunction) {
                this.functions.put((Object)KtPsiUtilKt.safeNameForLazyResolve((KtNamedDeclaration)declaration), declaration);
            } else if (ktDeclaration instanceof KtProperty) {
                this.properties.put((Object)KtPsiUtilKt.safeNameForLazyResolve((KtNamedDeclaration)declaration), declaration);
            } else if (ktDeclaration instanceof KtTypeAlias) {
                this.typeAliases.put((Object)KtPsiUtilKt.safeNameForLazyResolve(((KtTypeAlias)declaration).getNameAsName()), declaration);
            } else if (ktDeclaration instanceof KtClassOrObject) {
                this.classesAndObjects.put((Object)KtPsiUtilKt.safeNameForLazyResolve(((KtClassOrObject)declaration).getNameAsName()), KtClassInfoUtil.createClassOrObjectInfo((KtClassOrObject)declaration));
            } else if (ktDeclaration instanceof KtScript) {
                Name name = new KtScriptInfo((KtScript)declaration).getScript().getNameAsName();
                Intrinsics.checkNotNull(name);
                this.scripts.put((Object)name, (Object)new KtScriptInfo((KtScript)declaration));
            } else if (ktDeclaration instanceof KtDestructuringDeclaration) {
                for (KtDestructuringDeclarationEntry entry : ((KtDestructuringDeclaration)declaration).getEntries()) {
                    Name name = KtPsiUtilKt.safeNameForLazyResolve(entry.getNameAsName());
                    this.destructuringDeclarationsEntries.put((Object)name, (Object)entry);
                    this.names.add(name);
                }
            } else if (!(ktDeclaration instanceof KtParameter)) {
                throw new IllegalArgumentException("Unknown declaration: " + declaration);
            }
            if (declaration instanceof KtNamedDeclaration) {
                this.names.add(KtPsiUtilKt.safeNameForLazyResolve((KtNamedDeclaration)declaration));
            }
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public String toString() {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Iterable iterable = this.allDeclarations;
            StringBuilder stringBuilder = new StringBuilder().append("allDeclarations: ");
            boolean $i$f$mapNotNull = false;
            void var3_4 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                String it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                KtDeclaration it = (KtDeclaration)element$iv$iv;
                boolean bl2 = false;
                if (it.getName() == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return stringBuilder.append((List)destination$iv$iv).toString();
        }
    }
}

