/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.lazy.declarations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.lazy.declarations.AbstractPsiBasedDeclarationProvider;
import org.jetbrains.kotlin.resolve.lazy.declarations.FileBasedDeclarationProviderFactory;
import org.jetbrains.kotlin.resolve.lazy.declarations.PackageMemberDeclarationProvider;
import org.jetbrains.kotlin.storage.NotNullLazyValue;
import org.jetbrains.kotlin.storage.StorageManager;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B-\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u000eH\u0014\u00a2\u0006\u0004\b\u0011\u0010\u0012J)\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\t2\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013H\u0017\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0015\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0017\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u000f\u0010\u001f\u001a\u00020\u001eH\u0017\u00a2\u0006\u0004\b\u001f\u0010 R\u0014\u0010\u0006\u001a\u00020\u00058\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010!R\u0014\u0010\b\u001a\u00020\u00078\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010\"R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010#R \u0010%\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\t0$8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b%\u0010&"}, d2={"Lorg/jetbrains/kotlin/resolve/lazy/declarations/FileBasedPackageMemberDeclarationProvider;", "Lorg/jetbrains/kotlin/resolve/lazy/declarations/AbstractPsiBasedDeclarationProvider;", "Lorg/jetbrains/kotlin/resolve/lazy/declarations/PackageMemberDeclarationProvider;", "Lorg/jetbrains/kotlin/storage/StorageManager;", "storageManager", "Lorg/jetbrains/kotlin/name/FqName;", "fqName", "Lorg/jetbrains/kotlin/resolve/lazy/declarations/FileBasedDeclarationProviderFactory;", "factory", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "packageFiles", "<init>", "(Lorg/jetbrains/kotlin/storage/StorageManager;Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/resolve/lazy/declarations/FileBasedDeclarationProviderFactory;Ljava/util/Collection;)V", "Lorg/jetbrains/kotlin/resolve/lazy/declarations/AbstractPsiBasedDeclarationProvider$Index;", "index", "", "doCreateIndex", "(Lorg/jetbrains/kotlin/resolve/lazy/declarations/AbstractPsiBasedDeclarationProvider$Index;)V", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/name/Name;", "", "nameFilter", "getAllDeclaredSubPackages", "(Lkotlin/jvm/functions/Function1;)Ljava/util/Collection;", "getPackageFiles", "()Ljava/util/Collection;", "file", "containsFile", "(Lorg/jetbrains/kotlin/psi/KtFile;)Z", "", "toString", "()Ljava/lang/String;", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/resolve/lazy/declarations/FileBasedDeclarationProviderFactory;", "Ljava/util/Collection;", "Lorg/jetbrains/kotlin/storage/NotNullLazyValue;", "allDeclaredSubPackages", "Lorg/jetbrains/kotlin/storage/NotNullLazyValue;"})
public final class FileBasedPackageMemberDeclarationProvider
extends AbstractPsiBasedDeclarationProvider
implements PackageMemberDeclarationProvider {
    @NotNull
    private final FqName fqName;
    @NotNull
    private final FileBasedDeclarationProviderFactory factory;
    @NotNull
    private final Collection<KtFile> packageFiles;
    @NotNull
    private final NotNullLazyValue<Collection<FqName>> allDeclaredSubPackages;

    public FileBasedPackageMemberDeclarationProvider(@NotNull StorageManager storageManager, @NotNull FqName fqName2, @NotNull FileBasedDeclarationProviderFactory factory2, @NotNull Collection<? extends KtFile> packageFiles) {
        Intrinsics.checkNotNullParameter(storageManager, "storageManager");
        Intrinsics.checkNotNullParameter(fqName2, "fqName");
        Intrinsics.checkNotNullParameter(factory2, "factory");
        Intrinsics.checkNotNullParameter(packageFiles, "packageFiles");
        super(storageManager);
        this.fqName = fqName2;
        this.factory = factory2;
        this.packageFiles = packageFiles;
        this.allDeclaredSubPackages = storageManager.createLazyValue(() -> FileBasedPackageMemberDeclarationProvider.allDeclaredSubPackages$lambda$0(this));
    }

    @Override
    protected void doCreateIndex(@NotNull AbstractPsiBasedDeclarationProvider.Index index2) {
        Intrinsics.checkNotNullParameter(index2, "index");
        for (KtFile file2 : this.packageFiles) {
            for (KtDeclaration declaration : file2.getDeclarations()) {
                boolean bl = Intrinsics.areEqual(this.fqName, file2.getPackageFqName());
                if (_Assertions.ENABLED && !bl) {
                    boolean bl2 = false;
                    String string2 = "Files declaration utils contains file with invalid package";
                    throw new AssertionError((Object)string2);
                }
                index2.putToIndex(declaration);
            }
        }
    }

    @Override
    @NotNull
    public Collection<FqName> getAllDeclaredSubPackages(@NotNull Function1<? super Name, Boolean> nameFilter) {
        Intrinsics.checkNotNullParameter(nameFilter, "nameFilter");
        return (Collection)this.allDeclaredSubPackages.invoke();
    }

    @Override
    @NotNull
    public Collection<KtFile> getPackageFiles() {
        return this.packageFiles;
    }

    @Override
    public boolean containsFile(@NotNull KtFile file2) {
        Intrinsics.checkNotNullParameter(file2, "file");
        return this.packageFiles.contains(file2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String toString() {
        Object list$iv$iv;
        Iterable $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        KtFile it;
        Collection collection;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Iterable iterable = this.packageFiles;
        StringBuilder stringBuilder = new StringBuilder().append("Declarations for package ").append(this.fqName).append(" with files ");
        boolean $i$f$map = false;
        void var3_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            KtFile ktFile = (KtFile)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        $this$map$iv = this.packageFiles;
        stringBuilder = stringBuilder.append((List)destination$iv$iv).append(" with declarations inside ");
        boolean $i$f$flatMap = false;
        $this$mapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (KtFile)element$iv$iv;
            boolean bl = false;
            list$iv$iv = it.getDeclarations();
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            list$iv$iv = (KtDeclaration)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string2 = it.getName();
            if (string2 == null) {
                string2 = "???";
            }
            collection.add(string2);
        }
        return stringBuilder.append((List)destination$iv$iv).toString();
    }

    private static final Collection allDeclaredSubPackages$lambda$0(FileBasedPackageMemberDeclarationProvider this$0) {
        Collection<FqName> collection = this$0.factory.getAllDeclaredSubPackagesOf(this$0.fqName);
        Intrinsics.checkNotNullExpressionValue(collection, "getAllDeclaredSubPackagesOf(...)");
        return collection;
    }
}

