/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.lazy.descriptors;

import java.util.Iterator;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationWithTarget;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.LazyEntity;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyAnnotationDescriptor;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyAnnotationsContext;
import org.jetbrains.kotlin.storage.MemoizedFunctionToNotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0097\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0004\u001a\u00020\u00038\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016R \u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0007\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019R \u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000e0\u001a8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001c"}, d2={"Lorg/jetbrains/kotlin/resolve/lazy/descriptors/LazyAnnotations;", "Lorg/jetbrains/kotlin/descriptors/annotations/Annotations;", "Lorg/jetbrains/kotlin/resolve/lazy/LazyEntity;", "Lorg/jetbrains/kotlin/resolve/lazy/descriptors/LazyAnnotationsContext;", "c", "", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "annotationEntries", "<init>", "(Lorg/jetbrains/kotlin/resolve/lazy/descriptors/LazyAnnotationsContext;Ljava/util/List;)V", "", "isEmpty", "()Z", "", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "iterator", "()Ljava/util/Iterator;", "", "forceResolveAllContents", "()V", "Lorg/jetbrains/kotlin/resolve/lazy/descriptors/LazyAnnotationsContext;", "getC", "()Lorg/jetbrains/kotlin/resolve/lazy/descriptors/LazyAnnotationsContext;", "Ljava/util/List;", "getAnnotationEntries", "()Ljava/util/List;", "Lorg/jetbrains/kotlin/storage/MemoizedFunctionToNotNull;", "annotation", "Lorg/jetbrains/kotlin/storage/MemoizedFunctionToNotNull;"})
public final class LazyAnnotations
implements Annotations,
LazyEntity {
    @NotNull
    private final LazyAnnotationsContext c;
    @NotNull
    private final List<KtAnnotationEntry> annotationEntries;
    @NotNull
    private final MemoizedFunctionToNotNull<KtAnnotationEntry, AnnotationDescriptor> annotation;

    public LazyAnnotations(@NotNull LazyAnnotationsContext c, @NotNull List<? extends KtAnnotationEntry> annotationEntries) {
        Intrinsics.checkNotNullParameter(c, "c");
        Intrinsics.checkNotNullParameter(annotationEntries, "annotationEntries");
        this.c = c;
        this.annotationEntries = annotationEntries;
        this.annotation = this.c.getStorageManager().createMemoizedFunction(arg_0 -> LazyAnnotations.annotation$lambda$0(this, arg_0));
    }

    @NotNull
    public final LazyAnnotationsContext getC() {
        return this.c;
    }

    @NotNull
    public final List<KtAnnotationEntry> getAnnotationEntries() {
        return this.annotationEntries;
    }

    @Override
    public boolean isEmpty() {
        return this.annotationEntries.isEmpty();
    }

    @Override
    @NotNull
    public Iterator<AnnotationDescriptor> iterator() {
        return SequencesKt.map(CollectionsKt.asSequence((Iterable)this.annotationEntries), (Function1)this.annotation).iterator();
    }

    @Override
    public void forceResolveAllContents() {
        for (AnnotationDescriptor annotationDescriptor : this) {
        }
    }

    @Override
    @Nullable
    public AnnotationDescriptor findAnnotation(@NotNull FqName fqName2) {
        return Annotations.DefaultImpls.findAnnotation(this, fqName2);
    }

    @Override
    public boolean hasAnnotation(@NotNull FqName fqName2) {
        return Annotations.DefaultImpls.hasAnnotation(this, fqName2);
    }

    @Override
    @Deprecated(message="This method should only be used in frontend where we split annotations according to their use-site targets.")
    @NotNull
    public List<AnnotationWithTarget> getUseSiteTargetedAnnotations() {
        return Annotations.DefaultImpls.getUseSiteTargetedAnnotations(this);
    }

    private static final AnnotationDescriptor annotation$lambda$0(LazyAnnotations this$0, KtAnnotationEntry entry) {
        Intrinsics.checkNotNullParameter(entry, "entry");
        AnnotationDescriptor annotationDescriptor = (AnnotationDescriptor)this$0.c.getTrace().get(BindingContext.ANNOTATION, entry);
        if (annotationDescriptor == null) {
            annotationDescriptor = new LazyAnnotationDescriptor(this$0.c, entry);
        }
        return annotationDescriptor;
    }
}

