/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.multiplatform;

import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.multiplatform.ExpectedActualResolverKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bR\u001a\u0010\r\u001a\u00020\f8\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010"}, d2={"Lorg/jetbrains/kotlin/resolve/multiplatform/OptionalAnnotationUtil;", "", "<init>", "()V", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "descriptor", "", "shouldGenerateExpectClass", "(Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;)Z", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "isOptionalAnnotationClass", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;)Z", "Lorg/jetbrains/kotlin/name/FqName;", "OPTIONAL_EXPECTATION_FQ_NAME", "Lorg/jetbrains/kotlin/name/FqName;", "getOPTIONAL_EXPECTATION_FQ_NAME", "()Lorg/jetbrains/kotlin/name/FqName;"})
public final class OptionalAnnotationUtil {
    @NotNull
    public static final OptionalAnnotationUtil INSTANCE = new OptionalAnnotationUtil();
    @NotNull
    private static final FqName OPTIONAL_EXPECTATION_FQ_NAME = StandardClassIds.Annotations.INSTANCE.getOptionalExpectation().asSingleFqName();

    private OptionalAnnotationUtil() {
    }

    @NotNull
    public final FqName getOPTIONAL_EXPECTATION_FQ_NAME() {
        return OPTIONAL_EXPECTATION_FQ_NAME;
    }

    public static final boolean shouldGenerateExpectClass(@NotNull ClassDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        boolean bl = descriptor2.isExpect();
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string2 = "Not an expected class: " + descriptor2;
            throw new AssertionError((Object)string2);
        }
        if (OptionalAnnotationUtil.isOptionalAnnotationClass(descriptor2)) {
            return ExpectedActualResolverKt.findCompatibleActualsForExpected$default(descriptor2, DescriptorUtilsKt.getModule(descriptor2), null, 2, null).isEmpty();
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isOptionalAnnotationClass(@NotNull DeclarationDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        if (!(descriptor2 instanceof ClassDescriptor)) return false;
        if (((ClassDescriptor)descriptor2).getKind() != ClassKind.ANNOTATION_CLASS) return false;
        if (!((ClassDescriptor)descriptor2).isExpect()) return false;
        if (!descriptor2.getAnnotations().hasAnnotation(OPTIONAL_EXPECTATION_FQ_NAME)) return false;
        return true;
    }
}

