/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.sam;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.sam.SamConversionOracle;
import org.jetbrains.kotlin.resolve.sam.SamConversionResolver;
import org.jetbrains.kotlin.types.FlexibleType;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeFactory;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSubstitutionKt;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a\u0019\u0010\u0003\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0001\u001a\u00020\u0000H\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004\u001a\u001d\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0005\u001a\u00020\u0000H\u0007\u00a2\u0006\u0004\b\b\u0010\t\u001a\u001f\u0010\u000e\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u000bH\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000f\u001a%\u0010\u0015\u001a\u0004\u0018\u00010\u0011*\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0013H\u0007\u00a2\u0006\u0004\b\u0015\u0010\u0016\u001a)\u0010\u001a\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0013H\u0007\u00a2\u0006\u0004\b\u001a\u0010\u001b\u001a)\u0010\u001a\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001c\u001a\u0019\u0010\u001d\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0018\u001a\u00020\rH\u0007\u00a2\u0006\u0004\b\u001d\u0010\u001e"}, d2={"Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "klass", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "getSingleAbstractMethodOrNull", "(Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;)Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "classDescriptor", "", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "getAbstractMembers", "(Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;)Ljava/util/List;", "function", "", "shouldConvertFirstParameterToDescriptor", "Lorg/jetbrains/kotlin/types/SimpleType;", "getFunctionTypeForAbstractMethod", "(Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;Z)Lorg/jetbrains/kotlin/types/SimpleType;", "Lorg/jetbrains/kotlin/resolve/sam/SamConversionResolver;", "Lorg/jetbrains/kotlin/types/UnwrappedType;", "possibleSamType", "Lorg/jetbrains/kotlin/resolve/sam/SamConversionOracle;", "samConversionOracle", "getFunctionTypeForPossibleSamType", "(Lorg/jetbrains/kotlin/resolve/sam/SamConversionResolver;Lorg/jetbrains/kotlin/types/UnwrappedType;Lorg/jetbrains/kotlin/resolve/sam/SamConversionOracle;)Lorg/jetbrains/kotlin/types/UnwrappedType;", "Lorg/jetbrains/kotlin/types/KotlinType;", "samType", "samResolver", "getFunctionTypeForSamType", "(Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/resolve/sam/SamConversionResolver;Lorg/jetbrains/kotlin/resolve/sam/SamConversionOracle;)Lorg/jetbrains/kotlin/types/KotlinType;", "(Lorg/jetbrains/kotlin/types/SimpleType;Lorg/jetbrains/kotlin/resolve/sam/SamConversionResolver;Lorg/jetbrains/kotlin/resolve/sam/SamConversionOracle;)Lorg/jetbrains/kotlin/types/SimpleType;", "nonProjectionParametrization", "(Lorg/jetbrains/kotlin/types/SimpleType;)Lorg/jetbrains/kotlin/types/SimpleType;"})
public final class SamConversionResolverImplKt {
    @Nullable
    public static final FunctionDescriptor getSingleAbstractMethodOrNull(@NotNull ClassDescriptor klass) {
        Intrinsics.checkNotNullParameter(klass, "klass");
        if (StringsKt.endsWith$default(DescriptorUtilsKt.getFqNameSafe(klass).asString(), ".databinding.DataBindingComponent", false, 2, null)) {
            return null;
        }
        if (klass.isDefinitelyNotSamInterface()) {
            return null;
        }
        CallableMemberDescriptor callableMemberDescriptor = CollectionsKt.singleOrNull(SamConversionResolverImplKt.getAbstractMembers(klass));
        if (callableMemberDescriptor == null) {
            return null;
        }
        CallableMemberDescriptor abstractMember = callableMemberDescriptor;
        return abstractMember instanceof SimpleFunctionDescriptor && ((SimpleFunctionDescriptor)abstractMember).getTypeParameters().isEmpty() ? (FunctionDescriptor)abstractMember : null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<CallableMemberDescriptor> getAbstractMembers(@NotNull ClassDescriptor classDescriptor) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(classDescriptor, "classDescriptor");
        Collection<DeclarationDescriptor> collection = DescriptorUtils.getAllDescriptors(classDescriptor.getUnsubstitutedMemberScope());
        Intrinsics.checkNotNullExpressionValue(collection, "getAllDescriptors(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DeclarationDescriptor it = (DeclarationDescriptor)element$iv$iv;
            boolean bl = false;
            if (!(it instanceof CallableMemberDescriptor && ((CallableMemberDescriptor)it).getModality() == Modality.ABSTRACT)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final SimpleType getFunctionTypeForAbstractMethod(@NotNull FunctionDescriptor function2, boolean shouldConvertFirstParameterToDescriptor) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(function2, "function");
        KotlinType kotlinType = function2.getReturnType();
        if (kotlinType == null) {
            throw new IllegalStateException(("function is not initialized: " + function2).toString());
        }
        KotlinType returnType = kotlinType;
        List<ValueParameterDescriptor> list = function2.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list, "getValueParameters(...)");
        List<ValueParameterDescriptor> valueParameters2 = list;
        ArrayList<KotlinType> parameterTypes = new ArrayList<KotlinType>(valueParameters2.size());
        ArrayList<Name> parameterNames = new ArrayList<Name>(valueParameters2.size());
        List<ReceiverParameterDescriptor> list2 = function2.getContextReceiverParameters();
        Intrinsics.checkNotNullExpressionValue(list2, "getContextReceiverParameters(...)");
        Iterable $this$map$iv = list2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ReceiverParameterDescriptor receiverParameterDescriptor = (ReceiverParameterDescriptor)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getType());
        }
        List contextReceiversTypes = (List)destination$iv$iv;
        int startIndex = 0;
        KotlinType receiverType = null;
        ReceiverParameterDescriptor extensionReceiver = function2.getExtensionReceiverParameter();
        if (extensionReceiver != null) {
            receiverType = extensionReceiver.getType();
        } else if (shouldConvertFirstParameterToDescriptor) {
            List<ValueParameterDescriptor> list3 = function2.getValueParameters();
            Intrinsics.checkNotNullExpressionValue(list3, "getValueParameters(...)");
            if (!((Collection)list3).isEmpty()) {
                receiverType = valueParameters2.get(0).getType();
                startIndex = 1;
            }
        }
        int n = valueParameters2.size();
        for (int i = startIndex; i < n; ++i) {
            Name name;
            ValueParameterDescriptor parameter = valueParameters2.get(i);
            parameterTypes.add(parameter.getType());
            if (function2.hasSynthesizedParameterNames()) {
                name = SpecialNames.NO_NAME_PROVIDED;
            } else {
                Name name2 = parameter.getName();
                name = name2;
                Intrinsics.checkNotNullExpressionValue(name2, "getName(...)");
            }
            parameterNames.add(name);
        }
        return FunctionTypesKt.createFunctionType(DescriptorUtilsKt.getBuiltIns(function2), Annotations.Companion.getEMPTY(), receiverType, contextReceiversTypes, (List<? extends KotlinType>)parameterTypes, (List<Name>)parameterNames, returnType, function2.isSuspend());
    }

    @Nullable
    public static final UnwrappedType getFunctionTypeForPossibleSamType(@NotNull SamConversionResolver $this$getFunctionTypeForPossibleSamType, @NotNull UnwrappedType possibleSamType, @NotNull SamConversionOracle samConversionOracle) {
        Intrinsics.checkNotNullParameter($this$getFunctionTypeForPossibleSamType, "<this>");
        Intrinsics.checkNotNullParameter(possibleSamType, "possibleSamType");
        Intrinsics.checkNotNullParameter(samConversionOracle, "samConversionOracle");
        KotlinType kotlinType = SamConversionResolverImplKt.getFunctionTypeForSamType(possibleSamType, $this$getFunctionTypeForPossibleSamType, samConversionOracle);
        return kotlinType != null ? kotlinType.unwrap() : null;
    }

    @Nullable
    public static final KotlinType getFunctionTypeForSamType(@NotNull KotlinType samType, @NotNull SamConversionResolver samResolver, @NotNull SamConversionOracle samConversionOracle) {
        Intrinsics.checkNotNullParameter(samType, "samType");
        Intrinsics.checkNotNullParameter(samResolver, "samResolver");
        Intrinsics.checkNotNullParameter(samConversionOracle, "samConversionOracle");
        UnwrappedType unwrappedType = samType.unwrap();
        if (unwrappedType instanceof FlexibleType) {
            boolean bl;
            SimpleType lower = SamConversionResolverImplKt.getFunctionTypeForSamType(((FlexibleType)unwrappedType).getLowerBound(), samResolver, samConversionOracle);
            SimpleType upper = SamConversionResolverImplKt.getFunctionTypeForSamType(((FlexibleType)unwrappedType).getUpperBound(), samResolver, samConversionOracle);
            boolean bl2 = bl = lower == null == (upper == null);
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string2 = "Illegal flexible type: " + unwrappedType;
                throw new AssertionError((Object)string2);
            }
            if (lower == null || upper == null) {
                return null;
            }
            return KotlinTypeFactory.flexibleType(lower, upper);
        }
        Intrinsics.checkNotNull(unwrappedType, "null cannot be cast to non-null type org.jetbrains.kotlin.types.SimpleType");
        return SamConversionResolverImplKt.getFunctionTypeForSamType((SimpleType)unwrappedType, samResolver, samConversionOracle);
    }

    private static final SimpleType getFunctionTypeForSamType(SimpleType samType, SamConversionResolver samResolver, SamConversionOracle samConversionOracle) {
        boolean bl;
        ClassifierDescriptor classifier2 = samType.getConstructor().getDeclarationDescriptor();
        if (!(classifier2 instanceof ClassDescriptor)) {
            return null;
        }
        if (!samConversionOracle.isPossibleSamType(samType)) {
            return null;
        }
        SimpleType simpleType2 = samResolver.resolveFunctionTypeIfSamInterface((ClassDescriptor)classifier2);
        if (simpleType2 == null) {
            return null;
        }
        SimpleType functionTypeDefault = simpleType2;
        SimpleType simpleType3 = SamConversionResolverImplKt.nonProjectionParametrization(samType);
        if (simpleType3 == null) {
            return null;
        }
        SimpleType noProjectionsSamType = simpleType3;
        KotlinType type2 = TypeSubstitutor.create(noProjectionsSamType).substitute(functionTypeDefault, Variance.IN_VARIANCE);
        boolean bl2 = bl = type2 != null;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Substitution based on type with no projections '" + noProjectionsSamType + "' should not end with conflict";
            throw new AssertionError((Object)string2);
        }
        KotlinType kotlinType = type2;
        Intrinsics.checkNotNull(kotlinType);
        SimpleType simpleType4 = TypeSubstitutionKt.asSimpleType(kotlinType);
        return simpleType4.makeNullableAsSpecified(samType.isMarkedNullable());
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final SimpleType nonProjectionParametrization(@NotNull SimpleType samType) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        TypeProjection it;
        boolean bl;
        block9: {
            Intrinsics.checkNotNullParameter(samType, "samType");
            Iterable $this$none$iv = samType.getArguments();
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    it = (TypeProjection)element$iv;
                    boolean bl2 = false;
                    if (!(it.getProjectionKind() != Variance.INVARIANT)) continue;
                    bl = false;
                    break block9;
                }
                bl = true;
            }
        }
        if (bl) {
            return samType;
        }
        List<TypeParameterDescriptor> list = samType.getConstructor().getParameters();
        Intrinsics.checkNotNullExpressionValue(list, "getParameters(...)");
        List<TypeParameterDescriptor> parameters2 = list;
        Set parametersSet = CollectionsKt.toSet((Iterable)parameters2);
        Iterable iterable = CollectionsKt.zip((Iterable)samType.getArguments(), (Iterable)parameters2);
        SimpleType simpleType2 = samType;
        boolean $i$f$map = false;
        it = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object object;
            void it2;
            Object item$iv$iv = iterator2.next();
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            TypeProjection projection = (TypeProjection)it2.component1();
            TypeParameterDescriptor parameter = (TypeParameterDescriptor)it2.component2();
            if (projection.getProjectionKind() == Variance.INVARIANT) {
                object = projection;
            } else if (projection.isStarProjection()) {
                List<KotlinType> list2 = parameter.getUpperBounds();
                Intrinsics.checkNotNullExpressionValue(list2, "getUpperBounds(...)");
                Object object2 = CollectionsKt.first(list2);
                KotlinType t = object2;
                boolean bl4 = false;
                Intrinsics.checkNotNull(t);
                if (TypeUtilsKt.contains(t, arg_0 -> SamConversionResolverImplKt.nonProjectionParametrization$lambda$7$lambda$6$lambda$5(parametersSet, arg_0))) return null;
                KotlinType kotlinType = object2;
                KotlinType kotlinType2 = kotlinType;
                if (kotlinType2 == null) return null;
                object2 = TypeUtilsKt.asTypeProjection(kotlinType2);
                if (object2 == null) return null;
                object = object2;
            } else {
                KotlinType kotlinType = projection.getType();
                Intrinsics.checkNotNullExpressionValue(kotlinType, "getType(...)");
                object = TypeUtilsKt.asTypeProjection(kotlinType);
            }
            collection.add(object);
        }
        return TypeSubstitutionKt.replace$default(simpleType2, (List)destination$iv$iv, null, 2, null);
    }

    private static final boolean nonProjectionParametrization$lambda$7$lambda$6$lambda$5(Set $parametersSet, UnwrappedType it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return CollectionsKt.contains($parametersSet, it.getConstructor().getDeclarationDescriptor());
    }
}

