/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.scopes;

import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorWithDeprecation;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.scopes.DescriptorKindFilter;
import org.jetbrains.kotlin.resolve.scopes.ImportingScope;
import org.jetbrains.kotlin.utils.Printer;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0019\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0017\u00a2\u0006\u0004\b\t\u0010\nJ9\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\f\u001a\u00020\u000b2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0010\u001a\u00020\u000eH\u0017\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0015H\u0017\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0019\u001a\u00020\u0018H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ!\u0010 \u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u001dH\u0017\u00a2\u0006\u0004\b \u0010!J%\u0010#\u001a\b\u0012\u0004\u0012\u00020\"0\u00112\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u001dH\u0017\u00a2\u0006\u0004\b#\u0010$J%\u0010&\u001a\b\u0012\u0004\u0012\u00020%0\u00112\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u001dH\u0017\u00a2\u0006\u0004\b&\u0010$R\u0014\u0010\u0002\u001a\u00020\u00018\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0002\u0010'R\u0014\u0010\u0003\u001a\u00020\u00018\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010'R\u0016\u0010*\u001a\u0004\u0018\u00010\u00018WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)"}, d2={"Lorg/jetbrains/kotlin/resolve/scopes/CompositePrioritizedImportingScope;", "Lorg/jetbrains/kotlin/resolve/scopes/ImportingScope;", "primaryScope", "secondaryScope", "<init>", "(Lorg/jetbrains/kotlin/resolve/scopes/ImportingScope;Lorg/jetbrains/kotlin/resolve/scopes/ImportingScope;)V", "Lorg/jetbrains/kotlin/name/Name;", "name", "Lorg/jetbrains/kotlin/descriptors/PackageViewDescriptor;", "getContributedPackage", "(Lorg/jetbrains/kotlin/name/Name;)Lorg/jetbrains/kotlin/descriptors/PackageViewDescriptor;", "Lorg/jetbrains/kotlin/resolve/scopes/DescriptorKindFilter;", "kindFilter", "Lkotlin/Function1;", "", "nameFilter", "changeNamesForAliased", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "getContributedDescriptors", "(Lorg/jetbrains/kotlin/resolve/scopes/DescriptorKindFilter;Lkotlin/jvm/functions/Function1;Z)Ljava/util/Collection;", "", "computeImportedNames", "()Ljava/util/Set;", "Lorg/jetbrains/kotlin/utils/Printer;", "p", "", "printStructure", "(Lorg/jetbrains/kotlin/utils/Printer;)V", "Lorg/jetbrains/kotlin/incremental/components/LookupLocation;", "location", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "getContributedClassifier", "(Lorg/jetbrains/kotlin/name/Name;Lorg/jetbrains/kotlin/incremental/components/LookupLocation;)Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "getContributedVariables", "(Lorg/jetbrains/kotlin/name/Name;Lorg/jetbrains/kotlin/incremental/components/LookupLocation;)Ljava/util/Collection;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "getContributedFunctions", "Lorg/jetbrains/kotlin/resolve/scopes/ImportingScope;", "getParent", "()Lorg/jetbrains/kotlin/resolve/scopes/ImportingScope;", "parent"})
public final class CompositePrioritizedImportingScope
implements ImportingScope {
    @NotNull
    private final ImportingScope primaryScope;
    @NotNull
    private final ImportingScope secondaryScope;

    public CompositePrioritizedImportingScope(@NotNull ImportingScope primaryScope, @NotNull ImportingScope secondaryScope) {
        Intrinsics.checkNotNullParameter(primaryScope, "primaryScope");
        Intrinsics.checkNotNullParameter(secondaryScope, "secondaryScope");
        this.primaryScope = primaryScope;
        this.secondaryScope = secondaryScope;
    }

    @Override
    @Nullable
    public ImportingScope getParent() {
        ImportingScope importingScope = this.primaryScope.getParent();
        if (importingScope == null) {
            importingScope = this.secondaryScope.getParent();
        }
        return importingScope;
    }

    @Override
    @Nullable
    public PackageViewDescriptor getContributedPackage(@NotNull Name name) {
        Intrinsics.checkNotNullParameter(name, "name");
        PackageViewDescriptor packageViewDescriptor = this.primaryScope.getContributedPackage(name);
        if (packageViewDescriptor == null) {
            packageViewDescriptor = this.secondaryScope.getContributedPackage(name);
        }
        return packageViewDescriptor;
    }

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getContributedDescriptors(@NotNull DescriptorKindFilter kindFilter, @NotNull Function1<? super Name, Boolean> nameFilter, boolean changeNamesForAliased) {
        Intrinsics.checkNotNullParameter(kindFilter, "kindFilter");
        Intrinsics.checkNotNullParameter(nameFilter, "nameFilter");
        return CollectionsKt.union((Iterable)this.primaryScope.getContributedDescriptors(kindFilter, nameFilter, changeNamesForAliased), (Iterable)this.secondaryScope.getContributedDescriptors(kindFilter, nameFilter, changeNamesForAliased));
    }

    @Override
    @Nullable
    public Set<Name> computeImportedNames() {
        Set<Name> set;
        block5: {
            Set<Name> secondaryNames;
            block4: {
                Set<Name> primaryNames = this.primaryScope.computeImportedNames();
                secondaryNames = this.secondaryScope.computeImportedNames();
                set = primaryNames;
                if (set == null) break block4;
                Iterable iterable = set;
                Set<Name> set2 = secondaryNames;
                if (set2 == null) {
                    set2 = SetsKt.emptySet();
                }
                if ((set = CollectionsKt.union(iterable, (Iterable)set2)) != null) break block5;
            }
            set = secondaryNames;
        }
        return set;
    }

    @Override
    public void printStructure(@NotNull Printer p) {
        Intrinsics.checkNotNullParameter(p, "p");
        Object[] objectArray = new Object[]{this.primaryScope.getClass().getSimpleName()};
        p.println(objectArray);
    }

    @Override
    @Nullable
    public ClassifierDescriptor getContributedClassifier(@NotNull Name name, @NotNull LookupLocation location) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(location, "location");
        ClassifierDescriptor classifierDescriptor = this.primaryScope.getContributedClassifier(name, location);
        if (classifierDescriptor == null) {
            classifierDescriptor = this.secondaryScope.getContributedClassifier(name, location);
        }
        return classifierDescriptor;
    }

    @NotNull
    public Collection<VariableDescriptor> getContributedVariables(@NotNull Name name, @NotNull LookupLocation location) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(location, "location");
        return CollectionsKt.union((Iterable)this.primaryScope.getContributedVariables(name, location), (Iterable)this.secondaryScope.getContributedVariables(name, location));
    }

    @NotNull
    public Collection<FunctionDescriptor> getContributedFunctions(@NotNull Name name, @NotNull LookupLocation location) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(location, "location");
        return CollectionsKt.union((Iterable)this.primaryScope.getContributedFunctions(name, location), (Iterable)this.secondaryScope.getContributedFunctions(name, location));
    }

    @Override
    @Nullable
    public DescriptorWithDeprecation<ClassifierDescriptor> getContributedClassifierIncludeDeprecated(@NotNull Name name, @NotNull LookupLocation location) {
        return ImportingScope.DefaultImpls.getContributedClassifierIncludeDeprecated(this, name, location);
    }

    @Override
    public boolean definitelyDoesNotContainName(@NotNull Name name) {
        return ImportingScope.DefaultImpls.definitelyDoesNotContainName(this, name);
    }

    @Override
    public void recordLookup(@NotNull Name name, @NotNull LookupLocation location) {
        ImportingScope.DefaultImpls.recordLookup(this, name, location);
    }
}

