/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.scopes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorWithDeprecation;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.scopes.DescriptorKindFilter;
import org.jetbrains.kotlin.resolve.scopes.HierarchicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LocalRedeclarationChecker;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;
import org.jetbrains.kotlin.utils.SmartList;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010%\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001:\u0001EB\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J!\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0017\u00a2\u0006\u0004\b\r\u0010\u000eJ%\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0017\u00a2\u0006\u0004\b\u0011\u0010\u0012J%\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u000f2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0017\u00a2\u0006\u0004\b\u0014\u0010\u0012J1\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u0016\u001a\u00020\u00152\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0017\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0017\u0010 \u001a\u00020\u001f2\u0006\u0010\u001e\u001a\u00020\u001bH\u0004\u00a2\u0006\u0004\b \u0010!J\u0017\u0010#\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020\u0013H\u0004\u00a2\u0006\u0004\b#\u0010$J#\u0010'\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\t\u001a\u00020\b2\b\b\u0002\u0010&\u001a\u00020%H\u0005\u00a2\u0006\u0004\b'\u0010(J'\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00130\u000f2\u0006\u0010\t\u001a\u00020\b2\b\b\u0002\u0010&\u001a\u00020%H\u0005\u00a2\u0006\u0004\b)\u0010*J\u0017\u0010+\u001a\u00020%2\u0006\u0010\u001e\u001a\u00020\u001bH\u0002\u00a2\u0006\u0004\b+\u0010,J\u0013\u0010-\u001a\u00020\u001b*\u00020%H\u0002\u00a2\u0006\u0004\b-\u0010.J\u001e\u00101\u001a\u00020/*\u0004\u0018\u00010/2\u0006\u00100\u001a\u00020%H\u0082\u0002\u00a2\u0006\u0004\b1\u00102J#\u00104\u001a\b\u0012\u0004\u0012\u00028\u00000\u000f\"\b\b\u0000\u00103*\u00020\u001b*\u00020/H\u0002\u00a2\u0006\u0004\b4\u00105J\u0017\u00106\u001a\u00020\u00182\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b6\u00107R\u001a\u0010\u0005\u001a\u00020\u00048\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0005\u00108\u001a\u0004\b9\u0010:R\u001a\u0010\u0003\u001a\u00020\u00028\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010;\u001a\u0004\b<\u0010=R \u0010>\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a8\u0005X\u0085\u0004\u00a2\u0006\f\n\u0004\b>\u0010?\u001a\u0004\b@\u0010AR$\u0010)\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020/\u0018\u00010B8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b)\u0010CR$\u0010D\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020/\u0018\u00010B8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\bD\u0010C"}, d2={"Lorg/jetbrains/kotlin/resolve/scopes/LexicalScopeStorage;", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "Lorg/jetbrains/kotlin/resolve/scopes/HierarchicalScope;", "parent", "Lorg/jetbrains/kotlin/resolve/scopes/LocalRedeclarationChecker;", "redeclarationChecker", "<init>", "(Lorg/jetbrains/kotlin/resolve/scopes/HierarchicalScope;Lorg/jetbrains/kotlin/resolve/scopes/LocalRedeclarationChecker;)V", "Lorg/jetbrains/kotlin/name/Name;", "name", "Lorg/jetbrains/kotlin/incremental/components/LookupLocation;", "location", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "getContributedClassifier", "(Lorg/jetbrains/kotlin/name/Name;Lorg/jetbrains/kotlin/incremental/components/LookupLocation;)Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "getContributedVariables", "(Lorg/jetbrains/kotlin/name/Name;Lorg/jetbrains/kotlin/incremental/components/LookupLocation;)Ljava/util/List;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "getContributedFunctions", "Lorg/jetbrains/kotlin/resolve/scopes/DescriptorKindFilter;", "kindFilter", "Lkotlin/Function1;", "", "nameFilter", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "getContributedDescriptors", "(Lorg/jetbrains/kotlin/resolve/scopes/DescriptorKindFilter;Lkotlin/jvm/functions/Function1;)Ljava/util/List;", "descriptor", "", "addVariableOrClassDescriptor", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;)V", "functionDescriptor", "addFunctionDescriptorInternal", "(Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;)V", "", "descriptorLimit", "variableOrClassDescriptorByName", "(Lorg/jetbrains/kotlin/name/Name;I)Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "functionsByName", "(Lorg/jetbrains/kotlin/name/Name;I)Ljava/util/List;", "addDescriptor", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;)I", "descriptorByIndex", "(I)Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScopeStorage$IntList;", "value", "plus", "(Lorg/jetbrains/kotlin/resolve/scopes/LexicalScopeStorage$IntList;I)Lorg/jetbrains/kotlin/resolve/scopes/LexicalScopeStorage$IntList;", "TDescriptor", "toDescriptors", "(Lorg/jetbrains/kotlin/resolve/scopes/LexicalScopeStorage$IntList;)Ljava/util/List;", "definitelyDoesNotContainName", "(Lorg/jetbrains/kotlin/name/Name;)Z", "Lorg/jetbrains/kotlin/resolve/scopes/LocalRedeclarationChecker;", "getRedeclarationChecker", "()Lorg/jetbrains/kotlin/resolve/scopes/LocalRedeclarationChecker;", "Lorg/jetbrains/kotlin/resolve/scopes/HierarchicalScope;", "getParent", "()Lorg/jetbrains/kotlin/resolve/scopes/HierarchicalScope;", "addedDescriptors", "Ljava/util/List;", "getAddedDescriptors", "()Ljava/util/List;", "", "Ljava/util/Map;", "variablesAndClassifiersByName", "IntList"})
public abstract class LexicalScopeStorage
implements LexicalScope {
    @NotNull
    private final LocalRedeclarationChecker redeclarationChecker;
    @NotNull
    private final HierarchicalScope parent;
    @NotNull
    private final List<DeclarationDescriptor> addedDescriptors;
    @Nullable
    private Map<Name, IntList> functionsByName;
    @Nullable
    private Map<Name, IntList> variablesAndClassifiersByName;

    public LexicalScopeStorage(@NotNull HierarchicalScope parent2, @NotNull LocalRedeclarationChecker redeclarationChecker) {
        Intrinsics.checkNotNullParameter(parent2, "parent");
        Intrinsics.checkNotNullParameter(redeclarationChecker, "redeclarationChecker");
        this.redeclarationChecker = redeclarationChecker;
        this.parent = ScopeUtilsKt.takeSnapshot(parent2);
        this.addedDescriptors = new SmartList();
    }

    @NotNull
    public final LocalRedeclarationChecker getRedeclarationChecker() {
        return this.redeclarationChecker;
    }

    @Override
    @NotNull
    public HierarchicalScope getParent() {
        return this.parent;
    }

    @NotNull
    protected final List<DeclarationDescriptor> getAddedDescriptors() {
        return this.addedDescriptors;
    }

    @Override
    @Nullable
    public ClassifierDescriptor getContributedClassifier(@NotNull Name name, @NotNull LookupLocation location) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(location, "location");
        DeclarationDescriptor declarationDescriptor = LexicalScopeStorage.variableOrClassDescriptorByName$default(this, name, 0, 2, null);
        return declarationDescriptor instanceof ClassifierDescriptor ? (ClassifierDescriptor)declarationDescriptor : null;
    }

    @NotNull
    public List<VariableDescriptor> getContributedVariables(@NotNull Name name, @NotNull LookupLocation location) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(location, "location");
        DeclarationDescriptor declarationDescriptor = LexicalScopeStorage.variableOrClassDescriptorByName$default(this, name, 0, 2, null);
        return CollectionsKt.listOfNotNull(declarationDescriptor instanceof VariableDescriptor ? (VariableDescriptor)declarationDescriptor : null);
    }

    @NotNull
    public List<FunctionDescriptor> getContributedFunctions(@NotNull Name name, @NotNull LookupLocation location) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(location, "location");
        return LexicalScopeStorage.functionsByName$default(this, name, 0, 2, null);
    }

    @NotNull
    public List<DeclarationDescriptor> getContributedDescriptors(@NotNull DescriptorKindFilter kindFilter, @NotNull Function1<? super Name, Boolean> nameFilter) {
        Intrinsics.checkNotNullParameter(kindFilter, "kindFilter");
        Intrinsics.checkNotNullParameter(nameFilter, "nameFilter");
        return this.addedDescriptors;
    }

    protected final void addVariableOrClassDescriptor(@NotNull DeclarationDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Name name = descriptor2.getName();
        Intrinsics.checkNotNullExpressionValue(name, "getName(...)");
        Name name2 = name;
        if (name2.isSpecial()) {
            return;
        }
        int descriptorIndex = this.addDescriptor(descriptor2);
        if (this.variablesAndClassifiersByName == null) {
            this.variablesAndClassifiersByName = new HashMap();
        }
        Map<Name, IntList> map2 = this.variablesAndClassifiersByName;
        Intrinsics.checkNotNull(map2);
        Map<Name, IntList> map3 = this.variablesAndClassifiersByName;
        Intrinsics.checkNotNull(map3);
        map2.put(name2, this.plus(map3.get(name2), descriptorIndex));
    }

    protected final void addFunctionDescriptorInternal(@NotNull FunctionDescriptor functionDescriptor) {
        Intrinsics.checkNotNullParameter(functionDescriptor, "functionDescriptor");
        Name name = functionDescriptor.getName();
        Intrinsics.checkNotNullExpressionValue(name, "getName(...)");
        Name name2 = name;
        int descriptorIndex = this.addDescriptor(functionDescriptor);
        if (this.functionsByName == null) {
            this.functionsByName = new HashMap(1);
        }
        Map<Name, IntList> map2 = this.functionsByName;
        Intrinsics.checkNotNull(map2);
        Map<Name, IntList> map3 = this.functionsByName;
        Intrinsics.checkNotNull(map3);
        map2.put(name2, this.plus(map3.get(name2), descriptorIndex));
    }

    @Nullable
    protected final DeclarationDescriptor variableOrClassDescriptorByName(@NotNull Name name, int descriptorLimit) {
        IntList list;
        Intrinsics.checkNotNullParameter(name, "name");
        if (descriptorLimit == 0) {
            return null;
        }
        Map<Name, IntList> map2 = this.variablesAndClassifiersByName;
        IntList intList = list = map2 != null ? map2.get(name) : null;
        while (list != null) {
            int descriptorIndex = list.getLast();
            if (descriptorIndex < descriptorLimit) {
                return this.descriptorByIndex(descriptorIndex);
            }
            list = list.getPrev();
        }
        return null;
    }

    public static /* synthetic */ DeclarationDescriptor variableOrClassDescriptorByName$default(LexicalScopeStorage lexicalScopeStorage, Name name, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: variableOrClassDescriptorByName");
        }
        if ((n2 & 2) != 0) {
            n = lexicalScopeStorage.addedDescriptors.size();
        }
        return lexicalScopeStorage.variableOrClassDescriptorByName(name, n);
    }

    @NotNull
    protected final List<FunctionDescriptor> functionsByName(@NotNull Name name, int descriptorLimit) {
        IntList list;
        Intrinsics.checkNotNullParameter(name, "name");
        if (descriptorLimit == 0) {
            return CollectionsKt.emptyList();
        }
        Map<Name, IntList> map2 = this.functionsByName;
        IntList intList = list = map2 != null ? map2.get(name) : null;
        while (list != null) {
            if (list.getLast() < descriptorLimit) {
                return this.toDescriptors(list);
            }
            list = list.getPrev();
        }
        return CollectionsKt.emptyList();
    }

    public static /* synthetic */ List functionsByName$default(LexicalScopeStorage lexicalScopeStorage, Name name, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: functionsByName");
        }
        if ((n2 & 2) != 0) {
            n = lexicalScopeStorage.addedDescriptors.size();
        }
        return lexicalScopeStorage.functionsByName(name, n);
    }

    private final int addDescriptor(DeclarationDescriptor descriptor2) {
        this.redeclarationChecker.checkBeforeAddingToScope(this, descriptor2);
        this.addedDescriptors.add(descriptor2);
        return this.addedDescriptors.size() - 1;
    }

    private final DeclarationDescriptor descriptorByIndex(int $this$descriptorByIndex) {
        return this.addedDescriptors.get($this$descriptorByIndex);
    }

    private final IntList plus(IntList $this$plus, int value2) {
        return new IntList(value2, $this$plus);
    }

    private final <TDescriptor extends DeclarationDescriptor> List<TDescriptor> toDescriptors(IntList $this$toDescriptors) {
        ArrayList<DeclarationDescriptor> result2 = new ArrayList<DeclarationDescriptor>(1);
        IntList rest = $this$toDescriptors;
        do {
            IntList intList = rest;
            Intrinsics.checkNotNull(intList);
            DeclarationDescriptor declarationDescriptor = this.descriptorByIndex(intList.getLast());
            Intrinsics.checkNotNull(declarationDescriptor, "null cannot be cast to non-null type TDescriptor of org.jetbrains.kotlin.resolve.scopes.LexicalScopeStorage.toDescriptors");
            result2.add(declarationDescriptor);
        } while ((rest = rest.getPrev()) != null);
        return result2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean definitelyDoesNotContainName(@NotNull Name name) {
        Intrinsics.checkNotNullParameter(name, "name");
        Map<Name, IntList> map2 = this.functionsByName;
        if ((map2 != null ? map2.get(name) : null) != null) return false;
        Map<Name, IntList> map3 = this.variablesAndClassifiersByName;
        if (map3 == null) return true;
        IntList intList = map3.get(name);
        if (intList != null) return false;
        return true;
    }

    @Override
    @Nullable
    public DescriptorWithDeprecation<ClassifierDescriptor> getContributedClassifierIncludeDeprecated(@NotNull Name name, @NotNull LookupLocation location) {
        return LexicalScope.DefaultImpls.getContributedClassifierIncludeDeprecated(this, name, location);
    }

    @Override
    public void recordLookup(@NotNull Name name, @NotNull LookupLocation location) {
        LexicalScope.DefaultImpls.recordLookup(this, name, location);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\n\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0007\u001a\u0004\b\b\u0010\tR\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u00008\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0004\u0010\n\u001a\u0004\b\u000b\u0010\f"}, d2={"Lorg/jetbrains/kotlin/resolve/scopes/LexicalScopeStorage$IntList;", "", "", "last", "prev", "<init>", "(ILorg/jetbrains/kotlin/resolve/scopes/LexicalScopeStorage$IntList;)V", "I", "getLast", "()I", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScopeStorage$IntList;", "getPrev", "()Lorg/jetbrains/kotlin/resolve/scopes/LexicalScopeStorage$IntList;"})
    private static final class IntList {
        private final int last;
        @Nullable
        private final IntList prev;

        public IntList(int last2, @Nullable IntList prev) {
            this.last = last2;
            this.prev = prev;
        }

        public final int getLast() {
            return this.last;
        }

        @Nullable
        public final IntList getPrev() {
            return this.prev;
        }
    }
}

