/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.scopes;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorWithDeprecation;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.scopes.DescriptorKindFilter;
import org.jetbrains.kotlin.resolve.scopes.HierarchicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeKind;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeStorage;
import org.jetbrains.kotlin.resolve.scopes.LocalRedeclarationChecker;
import org.jetbrains.kotlin.utils.Printer;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001;B/\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\r\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0011\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0015\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0015\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0015\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001b\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u000f\u0010\u001f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u001f\u0010\u0010J\u000f\u0010!\u001a\u00020 H\u0017\u00a2\u0006\u0004\b!\u0010\"J\u0017\u0010%\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020#H\u0016\u00a2\u0006\u0004\b%\u0010&R\u001a\u0010\u0005\u001a\u00020\u00048\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010'\u001a\u0004\b(\u0010)R\u001a\u0010\u0007\u001a\u00020\u00068\u0016X\u0097\u0004\u00a2\u0006\f\n\u0004\b\u0007\u0010*\u001a\u0004\b\u0007\u0010+R\u001a\u0010\u000b\u001a\u00020\n8\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b\u000b\u0010,\u001a\u0004\b-\u0010.R\u0016\u00102\u001a\u0004\u0018\u00010/8WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u00101R\u001a\u00106\u001a\b\u0012\u0004\u0012\u00020/038WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u00105R\u0016\u00107\u001a\u00020\u00068\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b7\u0010*R\u001c\u00109\u001a\b\u0018\u000108R\u00020\u00008\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b9\u0010:"}, d2={"Lorg/jetbrains/kotlin/resolve/scopes/LexicalWritableScope;", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScopeStorage;", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "parent", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "ownerDescriptor", "", "isOwnerDescriptorAccessibleByLabel", "Lorg/jetbrains/kotlin/resolve/scopes/LocalRedeclarationChecker;", "redeclarationChecker", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScopeKind;", "kind", "<init>", "(Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;ZLorg/jetbrains/kotlin/resolve/scopes/LocalRedeclarationChecker;Lorg/jetbrains/kotlin/resolve/scopes/LexicalScopeKind;)V", "", "freeze", "()V", "takeSnapshot", "()Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "variableDescriptor", "addVariableDescriptor", "(Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;)V", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "functionDescriptor", "addFunctionDescriptor", "(Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;)V", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "classifierDescriptor", "addClassifierDescriptor", "(Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;)V", "checkMayWrite", "", "toString", "()Ljava/lang/String;", "Lorg/jetbrains/kotlin/utils/Printer;", "p", "printStructure", "(Lorg/jetbrains/kotlin/utils/Printer;)V", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "getOwnerDescriptor", "()Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "Z", "()Z", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScopeKind;", "getKind", "()Lorg/jetbrains/kotlin/resolve/scopes/LexicalScopeKind;", "Lorg/jetbrains/kotlin/descriptors/ReceiverParameterDescriptor;", "getImplicitReceiver", "()Lorg/jetbrains/kotlin/descriptors/ReceiverParameterDescriptor;", "implicitReceiver", "", "getContextReceiversGroup", "()Ljava/util/List;", "contextReceiversGroup", "canWrite", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalWritableScope$Snapshot;", "lastSnapshot", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalWritableScope$Snapshot;", "Snapshot"})
public final class LexicalWritableScope
extends LexicalScopeStorage {
    @NotNull
    private final DeclarationDescriptor ownerDescriptor;
    private final boolean isOwnerDescriptorAccessibleByLabel;
    @NotNull
    private final LexicalScopeKind kind;
    private boolean canWrite;
    @Nullable
    private Snapshot lastSnapshot;

    public LexicalWritableScope(@NotNull LexicalScope parent2, @NotNull DeclarationDescriptor ownerDescriptor, boolean isOwnerDescriptorAccessibleByLabel, @NotNull LocalRedeclarationChecker redeclarationChecker, @NotNull LexicalScopeKind kind) {
        Intrinsics.checkNotNullParameter(parent2, "parent");
        Intrinsics.checkNotNullParameter(ownerDescriptor, "ownerDescriptor");
        Intrinsics.checkNotNullParameter(redeclarationChecker, "redeclarationChecker");
        Intrinsics.checkNotNullParameter((Object)kind, "kind");
        super(parent2, redeclarationChecker);
        this.ownerDescriptor = ownerDescriptor;
        this.isOwnerDescriptorAccessibleByLabel = isOwnerDescriptorAccessibleByLabel;
        this.kind = kind;
        this.canWrite = true;
    }

    @Override
    @NotNull
    public DeclarationDescriptor getOwnerDescriptor() {
        return this.ownerDescriptor;
    }

    @Override
    public boolean isOwnerDescriptorAccessibleByLabel() {
        return this.isOwnerDescriptorAccessibleByLabel;
    }

    @Override
    @NotNull
    public LexicalScopeKind getKind() {
        return this.kind;
    }

    @Override
    @Nullable
    public ReceiverParameterDescriptor getImplicitReceiver() {
        return null;
    }

    @Override
    @NotNull
    public List<ReceiverParameterDescriptor> getContextReceiversGroup() {
        return CollectionsKt.emptyList();
    }

    public final void freeze() {
        this.canWrite = false;
    }

    @NotNull
    public final LexicalScope takeSnapshot() {
        block3: {
            block2: {
                if (this.lastSnapshot == null) break block2;
                Snapshot snapshot = this.lastSnapshot;
                Intrinsics.checkNotNull(snapshot);
                if (snapshot.getDescriptorLimit() == this.getAddedDescriptors().size()) break block3;
            }
            this.lastSnapshot = new Snapshot(this.getAddedDescriptors().size());
        }
        Snapshot snapshot = this.lastSnapshot;
        Intrinsics.checkNotNull(snapshot);
        return snapshot;
    }

    public final void addVariableDescriptor(@NotNull VariableDescriptor variableDescriptor) {
        Intrinsics.checkNotNullParameter(variableDescriptor, "variableDescriptor");
        this.checkMayWrite();
        this.addVariableOrClassDescriptor(variableDescriptor);
    }

    public final void addFunctionDescriptor(@NotNull FunctionDescriptor functionDescriptor) {
        Intrinsics.checkNotNullParameter(functionDescriptor, "functionDescriptor");
        this.checkMayWrite();
        this.addFunctionDescriptorInternal(functionDescriptor);
    }

    public final void addClassifierDescriptor(@NotNull ClassifierDescriptor classifierDescriptor) {
        Intrinsics.checkNotNullParameter(classifierDescriptor, "classifierDescriptor");
        this.checkMayWrite();
        this.addVariableOrClassDescriptor(classifierDescriptor);
    }

    private final void checkMayWrite() {
        if (!this.canWrite) {
            throw new IllegalStateException("Cannot write into freezed scope:" + this);
        }
    }

    @NotNull
    public String toString() {
        return this.getKind().toString();
    }

    @Override
    public void printStructure(@NotNull Printer p) {
        Intrinsics.checkNotNullParameter(p, "p");
        Object[] objectArray = new Object[10];
        objectArray[0] = this.getClass().getSimpleName();
        objectArray[1] = ": ";
        objectArray[2] = this.getKind();
        objectArray[3] = "; for descriptor: ";
        objectArray[4] = this.getOwnerDescriptor().getName();
        objectArray[5] = " with implicitReceivers: ";
        Object object = this.getImplicitReceiver();
        if (object == null || (object = object.getValue()) == null) {
            object = "NONE";
        }
        objectArray[6] = object;
        objectArray[7] = " with contextReceiversGroup: ";
        objectArray[8] = this.getContextReceiversGroup().isEmpty() ? "NONE" : CollectionsKt.joinToString$default(this.getContextReceiversGroup(), null, null, null, 0, null, LexicalWritableScope::printStructure$lambda$0, 31, null);
        objectArray[9] = " {";
        p.println(objectArray);
        p.pushIndent();
        objectArray = new Object[]{"parent = "};
        p.print(objectArray);
        this.getParent().printStructure(p.withholdIndentOnce());
        p.popIndent();
        objectArray = new Object[]{"}"};
        p.println(objectArray);
    }

    private static final CharSequence printStructure$lambda$0(ReceiverParameterDescriptor it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getValue().toString();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J1\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0007\u001a\u00020\u00062\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bH\u0017\u00a2\u0006\u0004\b\u000e\u0010\u000fJ!\u0010\u0014\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0011H\u0017\u00a2\u0006\u0004\b\u0014\u0010\u0015J'\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00162\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0011H\u0017\u00a2\u0006\u0004\b\u0017\u0010\u0018J%\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0011H\u0017\u00a2\u0006\u0004\b\u001b\u0010\u001cJ%\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00192\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0011H\u0017\u00a2\u0006\u0004\b\u001e\u0010\u001cJ\u000f\u0010 \u001a\u00020\u001fH\u0017\u00a2\u0006\u0004\b \u0010!J\u0017\u0010%\u001a\u00020$2\u0006\u0010#\u001a\u00020\"H\u0016\u00a2\u0006\u0004\b%\u0010&J\u0018\u0010'\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\tH\u0096\u0001\u00a2\u0006\u0004\b'\u0010(J \u0010)\u001a\u00020$2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0011H\u0096\u0001\u00a2\u0006\u0004\b)\u0010*R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010+\u001a\u0004\b,\u0010-R\u001a\u00101\u001a\b\u0012\u0004\u0012\u00020.0\u00198\u0017X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b/\u00100R\u0016\u00104\u001a\u0004\u0018\u00010.8\u0017X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b2\u00103R\u0014\u00105\u001a\u00020\n8\u0016X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b5\u00106R\u0014\u0010:\u001a\u0002078\u0017X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b8\u00109R\u0014\u0010=\u001a\u00020\r8\u0017X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b;\u0010<R\u0014\u0010A\u001a\u00020>8\u0017X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b?\u0010@"}, d2={"Lorg/jetbrains/kotlin/resolve/scopes/LexicalWritableScope$Snapshot;", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "", "descriptorLimit", "<init>", "(Lorg/jetbrains/kotlin/resolve/scopes/LexicalWritableScope;I)V", "Lorg/jetbrains/kotlin/resolve/scopes/DescriptorKindFilter;", "kindFilter", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/name/Name;", "", "nameFilter", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "getContributedDescriptors", "(Lorg/jetbrains/kotlin/resolve/scopes/DescriptorKindFilter;Lkotlin/jvm/functions/Function1;)Ljava/util/List;", "name", "Lorg/jetbrains/kotlin/incremental/components/LookupLocation;", "location", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "getContributedClassifier", "(Lorg/jetbrains/kotlin/name/Name;Lorg/jetbrains/kotlin/incremental/components/LookupLocation;)Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "Lorg/jetbrains/kotlin/descriptors/DescriptorWithDeprecation;", "getContributedClassifierIncludeDeprecated", "(Lorg/jetbrains/kotlin/name/Name;Lorg/jetbrains/kotlin/incremental/components/LookupLocation;)Lorg/jetbrains/kotlin/descriptors/DescriptorWithDeprecation;", "", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "getContributedVariables", "(Lorg/jetbrains/kotlin/name/Name;Lorg/jetbrains/kotlin/incremental/components/LookupLocation;)Ljava/util/List;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "getContributedFunctions", "", "toString", "()Ljava/lang/String;", "Lorg/jetbrains/kotlin/utils/Printer;", "p", "", "printStructure", "(Lorg/jetbrains/kotlin/utils/Printer;)V", "definitelyDoesNotContainName", "(Lorg/jetbrains/kotlin/name/Name;)Z", "recordLookup", "(Lorg/jetbrains/kotlin/name/Name;Lorg/jetbrains/kotlin/incremental/components/LookupLocation;)V", "I", "getDescriptorLimit", "()I", "Lorg/jetbrains/kotlin/descriptors/ReceiverParameterDescriptor;", "getContextReceiversGroup", "()Ljava/util/List;", "contextReceiversGroup", "getImplicitReceiver", "()Lorg/jetbrains/kotlin/descriptors/ReceiverParameterDescriptor;", "implicitReceiver", "isOwnerDescriptorAccessibleByLabel", "()Z", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScopeKind;", "getKind", "()Lorg/jetbrains/kotlin/resolve/scopes/LexicalScopeKind;", "kind", "getOwnerDescriptor", "()Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "ownerDescriptor", "Lorg/jetbrains/kotlin/resolve/scopes/HierarchicalScope;", "getParent", "()Lorg/jetbrains/kotlin/resolve/scopes/HierarchicalScope;", "parent"})
    private final class Snapshot
    implements LexicalScope {
        private final /* synthetic */ LexicalWritableScope $$delegate_0;
        private final int descriptorLimit;

        public Snapshot(int descriptorLimit) {
            this.$$delegate_0 = LexicalWritableScope.this;
            this.descriptorLimit = descriptorLimit;
        }

        public final int getDescriptorLimit() {
            return this.descriptorLimit;
        }

        @NotNull
        public List<DeclarationDescriptor> getContributedDescriptors(@NotNull DescriptorKindFilter kindFilter, @NotNull Function1<? super Name, Boolean> nameFilter) {
            Intrinsics.checkNotNullParameter(kindFilter, "kindFilter");
            Intrinsics.checkNotNullParameter(nameFilter, "nameFilter");
            return LexicalWritableScope.this.getAddedDescriptors().subList(0, this.descriptorLimit);
        }

        @Override
        @Nullable
        public ClassifierDescriptor getContributedClassifier(@NotNull Name name, @NotNull LookupLocation location) {
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(location, "location");
            DeclarationDescriptor declarationDescriptor = LexicalWritableScope.this.variableOrClassDescriptorByName(name, this.descriptorLimit);
            return declarationDescriptor instanceof ClassifierDescriptor ? (ClassifierDescriptor)declarationDescriptor : null;
        }

        @Override
        @Nullable
        public DescriptorWithDeprecation<ClassifierDescriptor> getContributedClassifierIncludeDeprecated(@NotNull Name name, @NotNull LookupLocation location) {
            DescriptorWithDeprecation<DeclarationDescriptor> descriptorWithDeprecation;
            ClassifierDescriptor classifierDescriptor;
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(location, "location");
            DeclarationDescriptor declarationDescriptor = LexicalWritableScope.this.variableOrClassDescriptorByName(name, this.descriptorLimit);
            ClassifierDescriptor classifierDescriptor2 = classifierDescriptor = declarationDescriptor instanceof ClassifierDescriptor ? (ClassifierDescriptor)declarationDescriptor : null;
            if (classifierDescriptor != null) {
                ClassifierDescriptor it = classifierDescriptor;
                boolean bl = false;
                descriptorWithDeprecation = DescriptorWithDeprecation.Companion.createNonDeprecated((DeclarationDescriptor)it);
            } else {
                descriptorWithDeprecation = null;
            }
            return descriptorWithDeprecation;
        }

        @NotNull
        public List<VariableDescriptor> getContributedVariables(@NotNull Name name, @NotNull LookupLocation location) {
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(location, "location");
            DeclarationDescriptor declarationDescriptor = LexicalWritableScope.this.variableOrClassDescriptorByName(name, this.descriptorLimit);
            return CollectionsKt.listOfNotNull(declarationDescriptor instanceof VariableDescriptor ? (VariableDescriptor)declarationDescriptor : null);
        }

        @NotNull
        public List<FunctionDescriptor> getContributedFunctions(@NotNull Name name, @NotNull LookupLocation location) {
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(location, "location");
            return LexicalWritableScope.this.functionsByName(name, this.descriptorLimit);
        }

        @NotNull
        public String toString() {
            return "Snapshot(" + this.descriptorLimit + ") for " + (Object)((Object)this.getKind());
        }

        @Override
        public void printStructure(@NotNull Printer p) {
            Intrinsics.checkNotNullParameter(p, "p");
            Object[] objectArray = new Object[]{"Snapshot with descriptorLimit = " + this.descriptorLimit + " for scope:"};
            p.println(objectArray);
            LexicalWritableScope.this.printStructure(p);
        }

        @Override
        @NotNull
        public HierarchicalScope getParent() {
            return this.$$delegate_0.getParent();
        }

        @Override
        @NotNull
        public DeclarationDescriptor getOwnerDescriptor() {
            return this.$$delegate_0.getOwnerDescriptor();
        }

        @Override
        public boolean isOwnerDescriptorAccessibleByLabel() {
            return this.$$delegate_0.isOwnerDescriptorAccessibleByLabel();
        }

        @Override
        @Nullable
        public ReceiverParameterDescriptor getImplicitReceiver() {
            return this.$$delegate_0.getImplicitReceiver();
        }

        @Override
        @NotNull
        public List<ReceiverParameterDescriptor> getContextReceiversGroup() {
            return this.$$delegate_0.getContextReceiversGroup();
        }

        @Override
        @NotNull
        public LexicalScopeKind getKind() {
            return this.$$delegate_0.getKind();
        }

        @Override
        public boolean definitelyDoesNotContainName(@NotNull Name name) {
            Intrinsics.checkNotNullParameter(name, "name");
            return this.$$delegate_0.definitelyDoesNotContainName(name);
        }

        @Override
        public void recordLookup(@NotNull Name name, @NotNull LookupLocation location) {
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(location, "location");
            this.$$delegate_0.recordLookup(name, location);
        }
    }
}

