/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.scopes;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.ParametrizedDiagnostic;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.OverloadChecker;
import org.jetbrains.kotlin.resolve.scopes.AbstractLocalRedeclarationChecker;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001f\u0010\f\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0014\u00a2\u0006\u0004\b\f\u0010\rJ\u001f\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000eH\u0014\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0003\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013"}, d2={"Lorg/jetbrains/kotlin/resolve/scopes/TraceBasedLocalRedeclarationChecker;", "Lorg/jetbrains/kotlin/resolve/scopes/AbstractLocalRedeclarationChecker;", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "trace", "Lorg/jetbrains/kotlin/resolve/OverloadChecker;", "overloadChecker", "<init>", "(Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/resolve/OverloadChecker;)V", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "first", "second", "", "handleRedeclaration", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;)V", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "handleConflictingOverloads", "(Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;)V", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "getTrace", "()Lorg/jetbrains/kotlin/resolve/BindingTrace;"})
public final class TraceBasedLocalRedeclarationChecker
extends AbstractLocalRedeclarationChecker {
    @NotNull
    private final BindingTrace trace;

    public TraceBasedLocalRedeclarationChecker(@NotNull BindingTrace trace, @NotNull OverloadChecker overloadChecker) {
        Intrinsics.checkNotNullParameter(trace, "trace");
        Intrinsics.checkNotNullParameter(overloadChecker, "overloadChecker");
        super(overloadChecker);
        this.trace = trace;
    }

    @NotNull
    public final BindingTrace getTrace() {
        return this.trace;
    }

    @Override
    protected void handleRedeclaration(@NotNull DeclarationDescriptor first2, @NotNull DeclarationDescriptor second2) {
        PsiElement it;
        Intrinsics.checkNotNullParameter(first2, "first");
        Intrinsics.checkNotNullParameter(second2, "second");
        BindingTrace trace$iv = this.trace;
        boolean $i$f$reportOnDeclarationOrFail = false;
        PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration(first2);
        if (psiElement == null) {
            throw new AssertionError((Object)("No declaration for " + first2));
        }
        PsiElement psiElement$iv = psiElement;
        boolean bl = false;
        PsiElement psiElement2 = psiElement$iv;
        BindingTrace bindingTrace = trace$iv;
        boolean bl2 = false;
        DeclarationDescriptor[] declarationDescriptorArray = new DeclarationDescriptor[]{first2, second2};
        ParametrizedDiagnostic<PsiElement> parametrizedDiagnostic = Errors.REDECLARATION.on(it, CollectionsKt.listOf(declarationDescriptorArray));
        Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, "on(...)");
        bindingTrace.report(parametrizedDiagnostic);
        trace$iv = this.trace;
        $i$f$reportOnDeclarationOrFail = false;
        PsiElement psiElement3 = DescriptorToSourceUtils.descriptorToDeclaration(second2);
        if (psiElement3 == null) {
            throw new AssertionError((Object)("No declaration for " + second2));
        }
        psiElement$iv = psiElement3;
        bl = false;
        it = psiElement$iv;
        bindingTrace = trace$iv;
        boolean bl3 = false;
        declarationDescriptorArray = new DeclarationDescriptor[]{first2, second2};
        ParametrizedDiagnostic<PsiElement> parametrizedDiagnostic2 = Errors.REDECLARATION.on(it, CollectionsKt.listOf(declarationDescriptorArray));
        Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic2, "on(...)");
        bindingTrace.report(parametrizedDiagnostic2);
    }

    @Override
    protected void handleConflictingOverloads(@NotNull CallableMemberDescriptor first2, @NotNull CallableMemberDescriptor second2) {
        PsiElement it;
        Intrinsics.checkNotNullParameter(first2, "first");
        Intrinsics.checkNotNullParameter(second2, "second");
        BindingTrace trace$iv = this.trace;
        boolean $i$f$reportOnDeclarationOrFail = false;
        PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration(first2);
        if (psiElement == null) {
            throw new AssertionError((Object)("No declaration for " + (DeclarationDescriptor)first2));
        }
        PsiElement psiElement$iv = psiElement;
        boolean bl = false;
        PsiElement psiElement2 = psiElement$iv;
        BindingTrace bindingTrace = trace$iv;
        boolean bl2 = false;
        CallableMemberDescriptor[] callableMemberDescriptorArray = new CallableMemberDescriptor[]{first2, second2};
        ParametrizedDiagnostic<PsiElement> parametrizedDiagnostic = Errors.CONFLICTING_OVERLOADS.on(it, CollectionsKt.listOf(callableMemberDescriptorArray));
        Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, "on(...)");
        bindingTrace.report(parametrizedDiagnostic);
        trace$iv = this.trace;
        $i$f$reportOnDeclarationOrFail = false;
        PsiElement psiElement3 = DescriptorToSourceUtils.descriptorToDeclaration(second2);
        if (psiElement3 == null) {
            throw new AssertionError((Object)("No declaration for " + (DeclarationDescriptor)second2));
        }
        psiElement$iv = psiElement3;
        bl = false;
        it = psiElement$iv;
        bindingTrace = trace$iv;
        boolean bl3 = false;
        callableMemberDescriptorArray = new CallableMemberDescriptor[]{first2, second2};
        ParametrizedDiagnostic<PsiElement> parametrizedDiagnostic2 = Errors.CONFLICTING_OVERLOADS.on(it, CollectionsKt.listOf(callableMemberDescriptorArray));
        Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic2, "on(...)");
        bindingTrace.report(parametrizedDiagnostic2);
    }
}

