/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.scopes.receivers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.psi.KtConstructorDelegationReferenceExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.scopes.receivers.AbstractReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.receivers.ContextClassReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.receivers.SuperCallReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.receivers.ThisClassReceiver;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\bf\u0018\u0000 \u00062\u00020\u0001:\u0001\u0006R\u0014\u0010\u0005\u001a\u00020\u00028'X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/resolve/scopes/receivers/ExpressionReceiver;", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "getExpression", "()Lorg/jetbrains/kotlin/psi/KtExpression;", "expression", "Companion"})
public interface ExpressionReceiver
extends ReceiverValue {
    @NotNull
    public static final Companion Companion = org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver$Companion.$$INSTANCE;

    @NotNull
    public KtExpression getExpression();

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0003\u0011\u0012\u0013B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001b\u0010\u000f\u001a\u00020\u000e*\u00020\r2\u0006\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010"}, d2={"Lorg/jetbrains/kotlin/resolve/scopes/receivers/ExpressionReceiver$Companion;", "", "<init>", "()V", "Lorg/jetbrains/kotlin/psi/KtExpression;", "expression", "Lorg/jetbrains/kotlin/types/KotlinType;", "type", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ExpressionReceiver;", "create", "(Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/resolve/BindingContext;)Lorg/jetbrains/kotlin/resolve/scopes/receivers/ExpressionReceiver;", "Lorg/jetbrains/kotlin/psi/KtReferenceExpression;", "", "isContextClassReceiverReference", "(Lorg/jetbrains/kotlin/psi/KtReferenceExpression;Lorg/jetbrains/kotlin/resolve/BindingContext;)Z", "ExpressionReceiverImpl", "ThisExpressionClassReceiver", "SuperExpressionReceiver"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        @NotNull
        public final ExpressionReceiver create(@NotNull KtExpression expression, @NotNull KotlinType type2, @NotNull BindingContext bindingContext) {
            KotlinType kotlinType;
            Intrinsics.checkNotNullParameter(expression, "expression");
            Intrinsics.checkNotNullParameter(type2, "type");
            Intrinsics.checkNotNullParameter(bindingContext, "bindingContext");
            KtReferenceExpression referenceExpression = null;
            if (expression instanceof KtThisExpression) {
                referenceExpression = ((KtThisExpression)expression).getInstanceReference();
            } else if (expression instanceof KtConstructorDelegationReferenceExpression) {
                referenceExpression = (KtReferenceExpression)expression;
            }
            if (referenceExpression != null) {
                DeclarationDescriptor descriptor2 = (DeclarationDescriptor)bindingContext.get(BindingContext.REFERENCE_TARGET, referenceExpression);
                if (descriptor2 instanceof ClassDescriptor && !this.isContextClassReceiverReference(referenceExpression, bindingContext)) {
                    ClassDescriptor classDescriptor = ((ClassDescriptor)descriptor2).getOriginal();
                    Intrinsics.checkNotNullExpressionValue(classDescriptor, "getOriginal(...)");
                    return new ThisExpressionClassReceiver(classDescriptor, expression, type2, null);
                }
            } else if (expression instanceof KtSuperExpression && (kotlinType = (KotlinType)bindingContext.get(BindingContext.THIS_TYPE_FOR_SUPER_EXPRESSION, expression)) != null) {
                KotlinType thisType = kotlinType;
                boolean bl = false;
                return new SuperExpressionReceiver(thisType, expression, type2, null);
            }
            return new ExpressionReceiverImpl(expression, type2, null);
        }

        private final boolean isContextClassReceiverReference(KtReferenceExpression $this$isContextClassReceiverReference, BindingContext bindingContext) {
            ReceiverParameterDescriptor receiverParameterDescriptor = (ReceiverParameterDescriptor)bindingContext.get(BindingContext.THIS_REFERENCE_TARGET, $this$isContextClassReceiverReference);
            return (receiverParameterDescriptor != null ? receiverParameterDescriptor.getValue() : null) instanceof ContextClassReceiver;
        }

        static {
            $$INSTANCE = new Companion();
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0012\u0018\u00002\u00020\u00012\u00020\u0002B!\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\f\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0005H\u0017\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000f\u001a\u00020\u000eH\u0017\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0004\u001a\u00020\u00038\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013"}, d2={"Lorg/jetbrains/kotlin/resolve/scopes/receivers/ExpressionReceiver$Companion$ExpressionReceiverImpl;", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/AbstractReceiverValue;", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ExpressionReceiver;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "expression", "Lorg/jetbrains/kotlin/types/KotlinType;", "type", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "original", "<init>", "(Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;)V", "newType", "replaceType", "(Lorg/jetbrains/kotlin/types/KotlinType;)Lorg/jetbrains/kotlin/resolve/scopes/receivers/ExpressionReceiver$Companion$ExpressionReceiverImpl;", "", "toString", "()Ljava/lang/String;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "getExpression", "()Lorg/jetbrains/kotlin/psi/KtExpression;"})
        private static class ExpressionReceiverImpl
        extends AbstractReceiverValue
        implements ExpressionReceiver {
            @NotNull
            private final KtExpression expression;

            public ExpressionReceiverImpl(@NotNull KtExpression expression, @NotNull KotlinType type2, @Nullable ReceiverValue original) {
                Intrinsics.checkNotNullParameter(expression, "expression");
                Intrinsics.checkNotNullParameter(type2, "type");
                super(type2, original);
                this.expression = expression;
            }

            @Override
            @NotNull
            public KtExpression getExpression() {
                return this.expression;
            }

            @Override
            @NotNull
            public ExpressionReceiverImpl replaceType(@NotNull KotlinType newType) {
                Intrinsics.checkNotNullParameter(newType, "newType");
                return new ExpressionReceiverImpl(this.getExpression(), newType, this.getOriginal());
            }

            @NotNull
            public String toString() {
                return this.getType() + " {" + this.getExpression() + ": " + this.getExpression().getText() + '}';
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B)\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\b\u0010\t\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u0003H\u0017\u00a2\u0006\u0004\b\r\u0010\u000eR\u001a\u0010\u0004\u001a\u00020\u00038\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b\u0004\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011"}, d2={"Lorg/jetbrains/kotlin/resolve/scopes/receivers/ExpressionReceiver$Companion$SuperExpressionReceiver;", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ExpressionReceiver$Companion$ExpressionReceiverImpl;", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/SuperCallReceiverValue;", "Lorg/jetbrains/kotlin/types/KotlinType;", "thisType", "Lorg/jetbrains/kotlin/psi/KtExpression;", "expression", "type", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "original", "<init>", "(Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;)V", "newType", "replaceType", "(Lorg/jetbrains/kotlin/types/KotlinType;)Lorg/jetbrains/kotlin/resolve/scopes/receivers/ExpressionReceiver$Companion$SuperExpressionReceiver;", "Lorg/jetbrains/kotlin/types/KotlinType;", "getThisType", "()Lorg/jetbrains/kotlin/types/KotlinType;"})
        private static final class SuperExpressionReceiver
        extends ExpressionReceiverImpl
        implements SuperCallReceiverValue {
            @NotNull
            private final KotlinType thisType;

            public SuperExpressionReceiver(@NotNull KotlinType thisType, @NotNull KtExpression expression, @NotNull KotlinType type2, @Nullable ReceiverValue original) {
                Intrinsics.checkNotNullParameter(thisType, "thisType");
                Intrinsics.checkNotNullParameter(expression, "expression");
                Intrinsics.checkNotNullParameter(type2, "type");
                super(expression, type2, original);
                this.thisType = thisType;
            }

            @Override
            @NotNull
            public KotlinType getThisType() {
                return this.thisType;
            }

            @Override
            @NotNull
            public SuperExpressionReceiver replaceType(@NotNull KotlinType newType) {
                Intrinsics.checkNotNullParameter(newType, "newType");
                return new SuperExpressionReceiver(this.getThisType(), this.getExpression(), newType, this.getOriginal());
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B)\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\b\u0010\n\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000e\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0007H\u0017\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0004\u001a\u00020\u00038\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012"}, d2={"Lorg/jetbrains/kotlin/resolve/scopes/receivers/ExpressionReceiver$Companion$ThisExpressionClassReceiver;", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ExpressionReceiver$Companion$ExpressionReceiverImpl;", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ThisClassReceiver;", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "classDescriptor", "Lorg/jetbrains/kotlin/psi/KtExpression;", "expression", "Lorg/jetbrains/kotlin/types/KotlinType;", "type", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "original", "<init>", "(Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;)V", "newType", "replaceType", "(Lorg/jetbrains/kotlin/types/KotlinType;)Lorg/jetbrains/kotlin/resolve/scopes/receivers/ExpressionReceiver$Companion$ThisExpressionClassReceiver;", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "getClassDescriptor", "()Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;"})
        private static final class ThisExpressionClassReceiver
        extends ExpressionReceiverImpl
        implements ThisClassReceiver {
            @NotNull
            private final ClassDescriptor classDescriptor;

            public ThisExpressionClassReceiver(@NotNull ClassDescriptor classDescriptor, @NotNull KtExpression expression, @NotNull KotlinType type2, @Nullable ReceiverValue original) {
                Intrinsics.checkNotNullParameter(classDescriptor, "classDescriptor");
                Intrinsics.checkNotNullParameter(expression, "expression");
                Intrinsics.checkNotNullParameter(type2, "type");
                super(expression, type2, original);
                this.classDescriptor = classDescriptor;
            }

            @Override
            @NotNull
            public ClassDescriptor getClassDescriptor() {
                return this.classDescriptor;
            }

            @Override
            @NotNull
            public ThisExpressionClassReceiver replaceType(@NotNull KotlinType newType) {
                Intrinsics.checkNotNullParameter(newType, "newType");
                return new ThisExpressionClassReceiver(this.getClassDescriptor(), this.getExpression(), newType, this.getOriginal());
            }
        }
    }
}

