/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.scopes.receivers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.ChainedMemberScope;
import org.jetbrains.kotlin.resolve.scopes.DescriptorKindFilter;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.resolve.scopes.MemberScopeImpl;
import org.jetbrains.kotlin.resolve.scopes.receivers.ClassValueReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ClassifierQualifier;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.utils.Printer;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u001bB\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tR\u001a\u0010\u0003\u001a\u00020\u00028\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\n\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\u0005\u001a\u00020\u00048\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\r\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0007\u001a\u00020\u00068\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0007\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0016\u001a\u0004\u0018\u00010\u00138WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u001a\u001a\u00020\u00178WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019"}, d2={"Lorg/jetbrains/kotlin/resolve/scopes/receivers/TypeAliasQualifier;", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ClassifierQualifier;", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "referenceExpression", "Lorg/jetbrains/kotlin/descriptors/TypeAliasDescriptor;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "classDescriptor", "<init>", "(Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;Lorg/jetbrains/kotlin/descriptors/TypeAliasDescriptor;Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;)V", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "getReferenceExpression", "()Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "Lorg/jetbrains/kotlin/descriptors/TypeAliasDescriptor;", "getDescriptor", "()Lorg/jetbrains/kotlin/descriptors/TypeAliasDescriptor;", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "getClassDescriptor", "()Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ClassValueReceiver;", "getClassValueReceiver", "()Lorg/jetbrains/kotlin/resolve/scopes/receivers/ClassValueReceiver;", "classValueReceiver", "Lorg/jetbrains/kotlin/resolve/scopes/MemberScope;", "getStaticScope", "()Lorg/jetbrains/kotlin/resolve/scopes/MemberScope;", "staticScope", "EnumEntriesScope"})
public final class TypeAliasQualifier
implements ClassifierQualifier {
    @NotNull
    private final KtSimpleNameExpression referenceExpression;
    @NotNull
    private final TypeAliasDescriptor descriptor;
    @NotNull
    private final ClassDescriptor classDescriptor;

    public TypeAliasQualifier(@NotNull KtSimpleNameExpression referenceExpression, @NotNull TypeAliasDescriptor descriptor2, @NotNull ClassDescriptor classDescriptor) {
        Intrinsics.checkNotNullParameter(referenceExpression, "referenceExpression");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(classDescriptor, "classDescriptor");
        this.referenceExpression = referenceExpression;
        this.descriptor = descriptor2;
        this.classDescriptor = classDescriptor;
    }

    @Override
    @NotNull
    public KtSimpleNameExpression getReferenceExpression() {
        return this.referenceExpression;
    }

    @Override
    @NotNull
    public TypeAliasDescriptor getDescriptor() {
        return this.descriptor;
    }

    @NotNull
    public final ClassDescriptor getClassDescriptor() {
        return this.classDescriptor;
    }

    @Override
    @Nullable
    public ClassValueReceiver getClassValueReceiver() {
        ClassValueReceiver classValueReceiver;
        KotlinType kotlinType = DescriptorUtilsKt.getClassValueType(this.classDescriptor);
        if (kotlinType != null) {
            KotlinType it = kotlinType;
            boolean bl = false;
            classValueReceiver = new ClassValueReceiver(this, it, null, 4, null);
        } else {
            classValueReceiver = null;
        }
        return classValueReceiver;
    }

    @Override
    @NotNull
    public MemberScope getStaticScope() {
        MemberScope memberScope2;
        if (DescriptorUtils.isEnumClass(this.classDescriptor)) {
            MemberScope[] memberScopeArray = new MemberScope[]{this.classDescriptor.getStaticScope(), new EnumEntriesScope()};
            memberScope2 = ChainedMemberScope.Companion.create("Static scope for typealias " + this.getDescriptor().getName(), memberScopeArray);
        } else {
            MemberScope memberScope3 = this.classDescriptor.getStaticScope();
            memberScope2 = memberScope3;
            Intrinsics.checkNotNullExpressionValue(memberScope3, "getStaticScope(...)");
        }
        return memberScope2;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J1\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006H\u0017\u00a2\u0006\u0004\b\f\u0010\rJ!\u0010\u0012\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u000fH\u0017\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018"}, d2={"Lorg/jetbrains/kotlin/resolve/scopes/receivers/TypeAliasQualifier$EnumEntriesScope;", "Lorg/jetbrains/kotlin/resolve/scopes/MemberScopeImpl;", "<init>", "(Lorg/jetbrains/kotlin/resolve/scopes/receivers/TypeAliasQualifier;)V", "Lorg/jetbrains/kotlin/resolve/scopes/DescriptorKindFilter;", "kindFilter", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/name/Name;", "", "nameFilter", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "getContributedDescriptors", "(Lorg/jetbrains/kotlin/resolve/scopes/DescriptorKindFilter;Lkotlin/jvm/functions/Function1;)Ljava/util/Collection;", "name", "Lorg/jetbrains/kotlin/incremental/components/LookupLocation;", "location", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "getContributedClassifier", "(Lorg/jetbrains/kotlin/name/Name;Lorg/jetbrains/kotlin/incremental/components/LookupLocation;)Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "Lorg/jetbrains/kotlin/utils/Printer;", "p", "", "printScopeStructure", "(Lorg/jetbrains/kotlin/utils/Printer;)V"})
    private final class EnumEntriesScope
    extends MemberScopeImpl {
        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Collection<DeclarationDescriptor> getContributedDescriptors(@NotNull DescriptorKindFilter kindFilter, @NotNull Function1<? super Name, Boolean> nameFilter) {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter(kindFilter, "kindFilter");
            Intrinsics.checkNotNullParameter(nameFilter, "nameFilter");
            Iterable $this$filter$iv = TypeAliasQualifier.this.getClassDescriptor().getUnsubstitutedInnerClassesScope().getContributedDescriptors(kindFilter, nameFilter);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                DeclarationDescriptor it = (DeclarationDescriptor)element$iv$iv;
                boolean bl = false;
                if (!DescriptorUtils.isEnumEntry(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        @Override
        @Nullable
        public ClassifierDescriptor getContributedClassifier(@NotNull Name name, @NotNull LookupLocation location) {
            ClassifierDescriptor classifierDescriptor;
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(location, "location");
            ClassifierDescriptor classifierDescriptor2 = TypeAliasQualifier.this.getClassDescriptor().getUnsubstitutedInnerClassesScope().getContributedClassifier(name, location);
            if (classifierDescriptor2 != null) {
                ClassifierDescriptor classifierDescriptor3;
                ClassifierDescriptor it = classifierDescriptor3 = classifierDescriptor2;
                boolean bl = false;
                classifierDescriptor = DescriptorUtils.isEnumEntry(it) ? classifierDescriptor3 : null;
            } else {
                classifierDescriptor = null;
            }
            return classifierDescriptor;
        }

        @Override
        public void printScopeStructure(@NotNull Printer p) {
            Intrinsics.checkNotNullParameter(p, "p");
            Object[] objectArray = new Object[]{this.getClass().getSimpleName(), " {"};
            p.println(objectArray);
            p.pushIndent();
            objectArray = new Object[]{"descriptor = ", TypeAliasQualifier.this.getDescriptor()};
            p.println(objectArray);
            p.popIndent();
            objectArray = new Object[]{"}"};
            p.println(objectArray);
        }
    }
}

