/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.typeBinding;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.typeBinding.AbbreviatedTypeBinding;
import org.jetbrains.kotlin.resolve.typeBinding.ExplicitTypeBinding;
import org.jetbrains.kotlin.resolve.typeBinding.NoTypeElementBinding;
import org.jetbrains.kotlin.resolve.typeBinding.TypeArgumentBinding;
import org.jetbrains.kotlin.resolve.typeBinding.TypeArgumentBindingImpl;
import org.jetbrains.kotlin.resolve.typeBinding.TypeBinding;
import org.jetbrains.kotlin.types.AbbreviatedType;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.SpecialTypesKt;
import org.jetbrains.kotlin.types.TypeProjection;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u001a#\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0001H\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006\u001a5\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\f\u0010\r\u001a#\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u0003*\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u0001H\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011\u001aG\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00160\u0015\"\b\b\u0000\u0010\u0012*\u00020\u000f2\u0006\u0010\t\u001a\u00020\b2\u0018\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00030\u0013H\u0001\u00a2\u0006\u0004\b\u0017\u0010\u0018"}, d2={"Lorg/jetbrains/kotlin/psi/KtTypeReference;", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "trace", "Lorg/jetbrains/kotlin/resolve/typeBinding/TypeBinding;", "Lorg/jetbrains/kotlin/psi/KtTypeElement;", "createTypeBinding", "(Lorg/jetbrains/kotlin/psi/KtTypeReference;Lorg/jetbrains/kotlin/resolve/BindingContext;)Lorg/jetbrains/kotlin/resolve/typeBinding/TypeBinding;", "psiElement", "Lorg/jetbrains/kotlin/types/KotlinType;", "type", "", "isArgumentFromQualifier", "createTypeBindingFromPsi", "(Lorg/jetbrains/kotlin/resolve/BindingContext;Lorg/jetbrains/kotlin/psi/KtTypeElement;Lorg/jetbrains/kotlin/types/KotlinType;Z)Lorg/jetbrains/kotlin/resolve/typeBinding/TypeBinding;", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "Lcom/intellij/psi/PsiElement;", "createTypeBindingForReturnType", "(Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;Lorg/jetbrains/kotlin/resolve/BindingContext;)Lorg/jetbrains/kotlin/resolve/typeBinding/TypeBinding;", "P", "Lkotlin/Function1;", "createBinding", "", "Lorg/jetbrains/kotlin/resolve/typeBinding/TypeArgumentBinding;", "createTypeArgumentBindingsWithSinglePsiElement", "(Lorg/jetbrains/kotlin/types/KotlinType;Lkotlin/jvm/functions/Function1;)Ljava/util/List;"})
public final class TypeBindingKt {
    @Nullable
    public static final TypeBinding<KtTypeElement> createTypeBinding(@NotNull KtTypeReference $this$createTypeBinding, @NotNull BindingContext trace) {
        Intrinsics.checkNotNullParameter($this$createTypeBinding, "<this>");
        Intrinsics.checkNotNullParameter(trace, "trace");
        KotlinType type2 = (KotlinType)trace.get(BindingContext.TYPE, $this$createTypeBinding);
        KtTypeElement psiElement = $this$createTypeBinding.getTypeElement();
        return type2 == null || psiElement == null ? null : TypeBindingKt.createTypeBindingFromPsi(trace, psiElement, type2, false);
    }

    private static final TypeBinding<KtTypeElement> createTypeBindingFromPsi(BindingContext trace, KtTypeElement psiElement, KotlinType type2, boolean isArgumentFromQualifier) {
        AbbreviatedType abbreviatedType = SpecialTypesKt.getAbbreviatedType(type2);
        return abbreviatedType != null ? (TypeBinding)new AbbreviatedTypeBinding(type2, psiElement, isArgumentFromQualifier) : (TypeBinding)new ExplicitTypeBinding(trace, psiElement, type2, isArgumentFromQualifier);
    }

    @Nullable
    public static final TypeBinding<PsiElement> createTypeBindingForReturnType(@NotNull KtCallableDeclaration $this$createTypeBindingForReturnType, @NotNull BindingContext trace) {
        NoTypeElementBinding<PsiElement> noTypeElementBinding;
        KtTypeReference ktTypeReference;
        Intrinsics.checkNotNullParameter($this$createTypeBindingForReturnType, "<this>");
        Intrinsics.checkNotNullParameter(trace, "trace");
        KtTypeReference ktTypeReference2 = ktTypeReference = $this$createTypeBindingForReturnType.getTypeReference();
        if (ktTypeReference2 != null) {
            return TypeBindingKt.createTypeBinding(ktTypeReference2, trace);
        }
        DeclarationDescriptor descriptor2 = trace.get(BindingContext.DECLARATION_TO_DESCRIPTOR, $this$createTypeBindingForReturnType);
        if (!(descriptor2 instanceof CallableDescriptor)) {
            return null;
        }
        KotlinType kotlinType = ((CallableDescriptor)descriptor2).getReturnType();
        if (kotlinType != null) {
            KotlinType it = kotlinType;
            boolean bl = false;
            noTypeElementBinding = new NoTypeElementBinding<PsiElement>(trace, $this$createTypeBindingForReturnType, it);
        } else {
            noTypeElementBinding = null;
        }
        return noTypeElementBinding;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <P extends PsiElement> List<TypeArgumentBinding<P>> createTypeArgumentBindingsWithSinglePsiElement(@NotNull KotlinType type2, @NotNull Function1<? super KotlinType, ? extends TypeBinding<? extends P>> createBinding) {
        void $this$mapIndexedTo$iv$iv;
        Intrinsics.checkNotNullParameter(type2, "type");
        Intrinsics.checkNotNullParameter(createBinding, "createBinding");
        boolean isErrorBinding = KotlinTypeKt.isError(type2) || type2.getConstructor().getParameters().size() != type2.getArguments().size();
        Iterable $this$mapIndexed$iv = type2.getArguments();
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, 10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void typeProjection;
            void index2;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            TypeProjection typeProjection2 = (TypeProjection)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            TypeParameterDescriptor typeParameterDescriptor = isErrorBinding ? null : type2.getConstructor().getParameters().get((int)index2);
            KotlinType kotlinType = typeProjection.getType();
            Intrinsics.checkNotNullExpressionValue(kotlinType, "getType(...)");
            collection.add(new TypeArgumentBindingImpl<P>((TypeProjection)typeProjection, typeParameterDescriptor, createBinding.invoke(kotlinType)));
        }
        return (List)destination$iv$iv;
    }

    public static final /* synthetic */ TypeBinding access$createTypeBindingFromPsi(BindingContext trace, KtTypeElement psiElement, KotlinType type2, boolean isArgumentFromQualifier) {
        return TypeBindingKt.createTypeBindingFromPsi(trace, psiElement, type2, isArgumentFromQualifier);
    }
}

