/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.metadata.serialization.StringTable;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.error.ErrorUtils;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H&\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\t\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0007H&\u00a2\u0006\u0004\b\t\u0010\nJ\u0019\u0010\u000b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\u0007H'\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000e\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u0007H\"\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0011\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/serialization/DescriptorAwareStringTable;", "Lorg/jetbrains/kotlin/metadata/serialization/StringTable;", "Lorg/jetbrains/kotlin/name/ClassId;", "classId", "", "getQualifiedClassNameIndex", "(Lorg/jetbrains/kotlin/name/ClassId;)I", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptorWithTypeParameters;", "descriptor", "getFqNameIndex", "(Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptorWithTypeParameters;)I", "getLocalClassIdReplacement", "(Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptorWithTypeParameters;)Lorg/jetbrains/kotlin/name/ClassId;", "", "renderDescriptor", "(Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptorWithTypeParameters;)Ljava/lang/String;", "", "isLocalClassIdReplacementKeptGeneric", "()Z"})
public interface DescriptorAwareStringTable
extends StringTable {
    default public int getQualifiedClassNameIndex(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter(classId, "classId");
        return this.getQualifiedClassNameIndex(classId.asString(), classId.isLocal());
    }

    default public int getFqNameIndex(@NotNull ClassifierDescriptorWithTypeParameters descriptor2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        if (ErrorUtils.isError(descriptor2)) {
            throw new IllegalStateException("Cannot get FQ name of error class: " + this.renderDescriptor(descriptor2));
        }
        ClassId classId = DescriptorUtilsKt.getClassId((ClassifierDescriptor)descriptor2);
        if (classId == null && (classId = this.getLocalClassIdReplacement(descriptor2)) == null) {
            throw new IllegalStateException("Cannot get FQ name of local class: " + this.renderDescriptor(descriptor2));
        }
        ClassId classId2 = classId;
        return this.getQualifiedClassNameIndex(classId2);
    }

    @Nullable
    default public ClassId getLocalClassIdReplacement(@NotNull ClassifierDescriptorWithTypeParameters descriptor2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        return null;
    }

    default public boolean isLocalClassIdReplacementKeptGeneric() {
        return false;
    }

    private String renderDescriptor(ClassifierDescriptorWithTypeParameters descriptor2) {
        StringBuilder stringBuilder = new StringBuilder().append(DescriptorRenderer.COMPACT.render(descriptor2)).append(" defined in ");
        DeclarationDescriptor declarationDescriptor = descriptor2.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue(declarationDescriptor, "getContainingDeclaration(...)");
        return stringBuilder.append(DescriptorRenderer.FQ_NAMES_IN_TYPES.render(declarationDescriptor)).toString();
    }
}

