/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization.deserialization;

import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentProviderKt;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.deserialization.ClassDescriptorFactory;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.BinaryVersion;
import org.jetbrains.kotlin.metadata.deserialization.NameResolver;
import org.jetbrains.kotlin.metadata.deserialization.TypeTable;
import org.jetbrains.kotlin.metadata.deserialization.VersionRequirementTable;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.serialization.deserialization.ClassData;
import org.jetbrains.kotlin.serialization.deserialization.DeserializationComponents;
import org.jetbrains.kotlin.serialization.deserialization.DeserializationContext;
import org.jetbrains.kotlin.serialization.deserialization.DeserializedPackageFragment;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedClassDescriptor;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00152\u00020\u0001:\u0002\u0016\u0015B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J%\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0007\u001a\u00020\u00062\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\bH\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0019\u0010\u000f\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0011R\"\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\n0\u00128\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014"}, d2={"Lorg/jetbrains/kotlin/serialization/deserialization/ClassDeserializer;", "", "Lorg/jetbrains/kotlin/serialization/deserialization/DeserializationComponents;", "components", "<init>", "(Lorg/jetbrains/kotlin/serialization/deserialization/DeserializationComponents;)V", "Lorg/jetbrains/kotlin/name/ClassId;", "classId", "Lorg/jetbrains/kotlin/serialization/deserialization/ClassData;", "classData", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "deserializeClass", "(Lorg/jetbrains/kotlin/name/ClassId;Lorg/jetbrains/kotlin/serialization/deserialization/ClassData;)Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "Lorg/jetbrains/kotlin/serialization/deserialization/ClassDeserializer$ClassKey;", "key", "createClass", "(Lorg/jetbrains/kotlin/serialization/deserialization/ClassDeserializer$ClassKey;)Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "Lorg/jetbrains/kotlin/serialization/deserialization/DeserializationComponents;", "Lkotlin/Function1;", "classes", "Lkotlin/jvm/functions/Function1;", "Companion", "ClassKey"})
public final class ClassDeserializer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DeserializationComponents components;
    @NotNull
    private final Function1<ClassKey, ClassDescriptor> classes;
    @NotNull
    private static final Set<ClassId> BLACK_LIST = SetsKt.setOf(ClassId.Companion.topLevel(StandardNames.FqNames.cloneable.toSafe()));

    public ClassDeserializer(@NotNull DeserializationComponents components) {
        Intrinsics.checkNotNullParameter(components, "components");
        this.components = components;
        this.classes = this.components.getStorageManager().createMemoizedFunctionWithNullableValues(arg_0 -> ClassDeserializer.classes$lambda$0(this, arg_0));
    }

    @Nullable
    public final ClassDescriptor deserializeClass(@NotNull ClassId classId, @Nullable ClassData classData) {
        Intrinsics.checkNotNullParameter(classId, "classId");
        return this.classes.invoke(new ClassKey(classId, classData));
    }

    public static /* synthetic */ ClassDescriptor deserializeClass$default(ClassDeserializer classDeserializer, ClassId classId, ClassData classData, int n, Object object) {
        if ((n & 2) != 0) {
            classData = null;
        }
        return classDeserializer.deserializeClass(classId, classData);
    }

    private final ClassDescriptor createClass(ClassKey key) {
        DeserializationContext deserializationContext;
        ClassId classId = key.getClassId();
        for (ClassDescriptorFactory factory2 : this.components.getFictitiousClassDescriptorFactories()) {
            ClassDescriptor classDescriptor = factory2.createClass(classId);
            if (classDescriptor == null) continue;
            ClassDescriptor it = classDescriptor;
            boolean bl = false;
            return it;
        }
        if (BLACK_LIST.contains(classId)) {
            return null;
        }
        ClassData classData = key.getClassData();
        if (classData == null && (classData = this.components.getClassDataFinder().findClassData(classId)) == null) {
            return null;
        }
        ClassData classData2 = classData;
        NameResolver nameResolver = classData2.component1();
        ProtoBuf.Class classProto2 = classData2.component2();
        BinaryVersion metadataVersion = classData2.component3();
        SourceElement sourceElement = classData2.component4();
        ClassId outerClassId = classId.getOuterClassId();
        if (outerClassId != null) {
            ClassDescriptor classDescriptor = ClassDeserializer.deserializeClass$default(this, outerClassId, null, 2, null);
            DeserializedClassDescriptor deserializedClassDescriptor = classDescriptor instanceof DeserializedClassDescriptor ? (DeserializedClassDescriptor)classDescriptor : null;
            if (deserializedClassDescriptor == null) {
                return null;
            }
            DeserializedClassDescriptor outerClass = deserializedClassDescriptor;
            if (!outerClass.hasNestedClass$deserialization(classId.getShortClassName())) {
                return null;
            }
            deserializationContext = outerClass.getC();
        } else {
            Object v3;
            block9: {
                List<PackageFragmentDescriptor> fragments2 = PackageFragmentProviderKt.packageFragments(this.components.getPackageFragmentProvider(), classId.getPackageFqName());
                Iterable $this$firstOrNull$iv = fragments2;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    PackageFragmentDescriptor it = (PackageFragmentDescriptor)element$iv;
                    boolean bl = false;
                    if (!(!(it instanceof DeserializedPackageFragment) || ((DeserializedPackageFragment)it).hasTopLevelClass(classId.getShortClassName()))) continue;
                    v3 = element$iv;
                    break block9;
                }
                v3 = null;
            }
            PackageFragmentDescriptor packageFragmentDescriptor = v3;
            if (packageFragmentDescriptor == null) {
                return null;
            }
            PackageFragmentDescriptor fragment = packageFragmentDescriptor;
            ProtoBuf.TypeTable typeTable = classProto2.getTypeTable();
            Intrinsics.checkNotNullExpressionValue(typeTable, "getTypeTable(...)");
            TypeTable typeTable2 = new TypeTable(typeTable);
            ProtoBuf.VersionRequirementTable versionRequirementTable = classProto2.getVersionRequirementTable();
            Intrinsics.checkNotNullExpressionValue(versionRequirementTable, "getVersionRequirementTable(...)");
            deserializationContext = this.components.createContext(fragment, nameResolver, typeTable2, VersionRequirementTable.Companion.create(versionRequirementTable), metadataVersion, null);
        }
        DeserializationContext outerContext = deserializationContext;
        return new DeserializedClassDescriptor(outerContext, classProto2, nameResolver, metadataVersion, sourceElement);
    }

    private static final ClassDescriptor classes$lambda$0(ClassDeserializer this$0, ClassKey key) {
        Intrinsics.checkNotNullParameter(key, "key");
        return this$0.createClass(key);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\n\u001a\u00020\t2\b\u0010\b\u001a\u0004\u0018\u00010\u0001H\u0096\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eR\u001a\u0010\u0003\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u00048\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014"}, d2={"Lorg/jetbrains/kotlin/serialization/deserialization/ClassDeserializer$ClassKey;", "", "Lorg/jetbrains/kotlin/name/ClassId;", "classId", "Lorg/jetbrains/kotlin/serialization/deserialization/ClassData;", "classData", "<init>", "(Lorg/jetbrains/kotlin/name/ClassId;Lorg/jetbrains/kotlin/serialization/deserialization/ClassData;)V", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "Lorg/jetbrains/kotlin/name/ClassId;", "getClassId", "()Lorg/jetbrains/kotlin/name/ClassId;", "Lorg/jetbrains/kotlin/serialization/deserialization/ClassData;", "getClassData", "()Lorg/jetbrains/kotlin/serialization/deserialization/ClassData;"})
    private static final class ClassKey {
        @NotNull
        private final ClassId classId;
        @Nullable
        private final ClassData classData;

        public ClassKey(@NotNull ClassId classId, @Nullable ClassData classData) {
            Intrinsics.checkNotNullParameter(classId, "classId");
            this.classId = classId;
            this.classData = classData;
        }

        @NotNull
        public final ClassId getClassId() {
            return this.classId;
        }

        @Nullable
        public final ClassData getClassData() {
            return this.classData;
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof ClassKey && Intrinsics.areEqual(this.classId, ((ClassKey)other).classId);
        }

        public int hashCode() {
            return this.classId.hashCode();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R \u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\b\u0010\t"}, d2={"Lorg/jetbrains/kotlin/serialization/deserialization/ClassDeserializer$Companion;", "", "<init>", "()V", "", "Lorg/jetbrains/kotlin/name/ClassId;", "BLACK_LIST", "Ljava/util/Set;", "getBLACK_LIST", "()Ljava/util/Set;"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<ClassId> getBLACK_LIST() {
            return BLACK_LIST;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

