/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization.deserialization;

import java.io.InputStream;
import java.util.List;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.builtins.BuiltInsBinaryVersion;
import org.jetbrains.kotlin.metadata.deserialization.BinaryVersion;
import org.jetbrains.kotlin.metadata.deserialization.NameResolver;
import org.jetbrains.kotlin.metadata.deserialization.NameResolverImpl;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.serialization.deserialization.ClassData;
import org.jetbrains.kotlin.serialization.deserialization.ClassDataFinder;
import org.jetbrains.kotlin.serialization.deserialization.KotlinMetadataFinder;
import org.jetbrains.kotlin.serialization.deserialization.MetadataClassDataFinder;
import org.jetbrains.kotlin.serialization.deserialization.MetadataUtilKt;
import org.jetbrains.kotlin.serialization.deserialization.NameResolverUtilKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0019\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0017\u00a2\u0006\u0004\b\t\u0010\nR\u001a\u0010\u0003\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u000b\u001a\u0004\b\f\u0010\r"}, d2={"Lorg/jetbrains/kotlin/serialization/deserialization/MetadataClassDataFinder;", "Lorg/jetbrains/kotlin/serialization/deserialization/ClassDataFinder;", "Lorg/jetbrains/kotlin/serialization/deserialization/KotlinMetadataFinder;", "finder", "<init>", "(Lorg/jetbrains/kotlin/serialization/deserialization/KotlinMetadataFinder;)V", "Lorg/jetbrains/kotlin/name/ClassId;", "classId", "Lorg/jetbrains/kotlin/serialization/deserialization/ClassData;", "findClassData", "(Lorg/jetbrains/kotlin/name/ClassId;)Lorg/jetbrains/kotlin/serialization/deserialization/ClassData;", "Lorg/jetbrains/kotlin/serialization/deserialization/KotlinMetadataFinder;", "getFinder", "()Lorg/jetbrains/kotlin/serialization/deserialization/KotlinMetadataFinder;"})
public final class MetadataClassDataFinder
implements ClassDataFinder {
    @NotNull
    private final KotlinMetadataFinder finder;

    public MetadataClassDataFinder(@NotNull KotlinMetadataFinder finder) {
        Intrinsics.checkNotNullParameter(finder, "finder");
        this.finder = finder;
    }

    @NotNull
    public final KotlinMetadataFinder getFinder() {
        return this.finder;
    }

    @Override
    @Nullable
    public ClassData findClassData(@NotNull ClassId classId) {
        ClassData classData;
        Object v2;
        BuiltInsBinaryVersion version;
        NameResolverImpl nameResolver;
        block4: {
            Intrinsics.checkNotNullParameter(classId, "classId");
            ClassId topLevelClassId2 = SequencesKt.last(SequencesKt.generateSequence(classId, (Function1)findClassData.topLevelClassId.1.INSTANCE));
            InputStream inputStream = this.finder.findMetadata(topLevelClassId2);
            if (inputStream == null) {
                return null;
            }
            InputStream stream = inputStream;
            Triple<ProtoBuf.PackageFragment, NameResolverImpl, BuiltInsBinaryVersion> triple = MetadataUtilKt.readProto(stream);
            ProtoBuf.PackageFragment message = triple.component1();
            nameResolver = triple.component2();
            version = triple.component3();
            List<ProtoBuf.Class> list = message.getClass_List();
            Intrinsics.checkNotNullExpressionValue(list, "getClass_List(...)");
            Iterable $this$firstOrNull$iv = list;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ProtoBuf.Class classProto2 = (ProtoBuf.Class)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(NameResolverUtilKt.getClassId(nameResolver, classProto2.getFqName()), classId)) continue;
                v2 = element$iv;
                break block4;
            }
            v2 = null;
        }
        ProtoBuf.Class clazz = v2;
        if (clazz != null) {
            ProtoBuf.Class classProto3 = clazz;
            boolean bl = false;
            NameResolver nameResolver2 = nameResolver;
            BinaryVersion binaryVersion = version;
            SourceElement sourceElement = SourceElement.NO_SOURCE;
            Intrinsics.checkNotNullExpressionValue(sourceElement, "NO_SOURCE");
            classData = new ClassData(nameResolver2, classProto3, binaryVersion, sourceElement);
        } else {
            classData = null;
        }
        return classData;
    }
}

