/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization.deserialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FindClassInModuleKt;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.Flags;
import org.jetbrains.kotlin.metadata.deserialization.ProtoTypeTableUtilKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.serialization.deserialization.DeserializationContext;
import org.jetbrains.kotlin.serialization.deserialization.NameResolverUtilKt;
import org.jetbrains.kotlin.serialization.deserialization.ProtoEnumFlags;
import org.jetbrains.kotlin.serialization.deserialization.SuspendFunctionTypeUtilKt;
import org.jetbrains.kotlin.serialization.deserialization.TypeDeserializer;
import org.jetbrains.kotlin.serialization.deserialization.TypeDeserializerKt;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedAnnotations;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedTypeParameterDescriptor;
import org.jetbrains.kotlin.types.DefinitelyNotNullType;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeFactory;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.SpecialTypesKt;
import org.jetbrains.kotlin.types.StarProjectionForAbsentTypeParameter;
import org.jetbrains.kotlin.types.StarProjectionImpl;
import org.jetbrains.kotlin.types.TypeAttributeTranslator;
import org.jetbrains.kotlin.types.TypeAttributes;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.error.ErrorTypeKind;
import org.jetbrains.kotlin.types.error.ErrorUtils;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0005\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0000\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\rH\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J1\u0010\u001a\u001a\u00020\u0019*\b\u0012\u0004\u0012\u00020\u00120\u00052\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0017H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ!\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u000e\u001a\u00020\r2\b\b\u0002\u0010\u001d\u001a\u00020\u001cH\u0007\u00a2\u0006\u0004\b\u001f\u0010 J\u0017\u0010!\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b!\u0010\"J5\u0010(\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\u00192\u0006\u0010$\u001a\u00020\u00152\f\u0010&\u001a\b\u0012\u0004\u0012\u00020%0\u00052\u0006\u0010'\u001a\u00020\u001cH\u0002\u00a2\u0006\u0004\b(\u0010)J7\u0010*\u001a\u0004\u0018\u00010\u001e2\u0006\u0010#\u001a\u00020\u00192\u0006\u0010$\u001a\u00020\u00152\f\u0010&\u001a\b\u0012\u0004\u0012\u00020%0\u00052\u0006\u0010'\u001a\u00020\u001cH\u0002\u00a2\u0006\u0004\b*\u0010)J\u0019\u0010,\u001a\u0004\u0018\u00010\u001e2\u0006\u0010+\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b,\u0010-J\u001f\u0010/\u001a\u00020\u001e2\u0006\u0010+\u001a\u00020\u000f2\u0006\u0010.\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b/\u00100J\u0019\u00104\u001a\u0004\u0018\u0001032\u0006\u00102\u001a\u000201H\u0002\u00a2\u0006\u0004\b4\u00105J\u0019\u00108\u001a\u0004\u0018\u0001072\u0006\u00106\u001a\u000201H\u0002\u00a2\u0006\u0004\b8\u00109J\u0019\u0010;\u001a\u0004\u0018\u00010\u001e2\u0006\u0010:\u001a\u000201H\u0002\u00a2\u0006\u0004\b;\u0010<J\u0019\u0010=\u001a\u0004\u0018\u0001072\u0006\u00106\u001a\u000201H\u0002\u00a2\u0006\u0004\b=\u00109J!\u0010A\u001a\u00020%2\b\u0010>\u001a\u0004\u0018\u0001032\u0006\u0010@\u001a\u00020?H\u0002\u00a2\u0006\u0004\bA\u0010BJ\u000f\u0010C\u001a\u00020\bH\u0017\u00a2\u0006\u0004\bC\u0010DR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010ER\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u00008\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010FR\u0014\u0010\t\u001a\u00020\b8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010GR\u0014\u0010\n\u001a\u00020\b8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\n\u0010GR\"\u0010I\u001a\u0010\u0012\u0004\u0012\u000201\u0012\u0006\u0012\u0004\u0018\u0001070H8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\bI\u0010JR\"\u0010K\u001a\u0010\u0012\u0004\u0012\u000201\u0012\u0006\u0012\u0004\u0018\u0001070H8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\bK\u0010JR \u0010M\u001a\u000e\u0012\u0004\u0012\u000201\u0012\u0004\u0012\u0002030L8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\bM\u0010NR\u0017\u0010Q\u001a\b\u0012\u0004\u0012\u0002030\u00058G\u00a2\u0006\u0006\u001a\u0004\bO\u0010P"}, d2={"Lorg/jetbrains/kotlin/serialization/deserialization/TypeDeserializer;", "", "Lorg/jetbrains/kotlin/serialization/deserialization/DeserializationContext;", "c", "parent", "", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$TypeParameter;", "typeParameterProtos", "", "debugName", "containerPresentableName", "<init>", "(Lorg/jetbrains/kotlin/serialization/deserialization/DeserializationContext;Lorg/jetbrains/kotlin/serialization/deserialization/TypeDeserializer;Ljava/util/List;Ljava/lang/String;Ljava/lang/String;)V", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Type;", "proto", "Lorg/jetbrains/kotlin/types/KotlinType;", "type", "(Lorg/jetbrains/kotlin/metadata/ProtoBuf$Type;)Lorg/jetbrains/kotlin/types/KotlinType;", "Lorg/jetbrains/kotlin/types/TypeAttributeTranslator;", "Lorg/jetbrains/kotlin/descriptors/annotations/Annotations;", "annotations", "Lorg/jetbrains/kotlin/types/TypeConstructor;", "constructor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "containingDeclaration", "Lorg/jetbrains/kotlin/types/TypeAttributes;", "toAttributes", "(Ljava/util/List;Lorg/jetbrains/kotlin/descriptors/annotations/Annotations;Lorg/jetbrains/kotlin/types/TypeConstructor;Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;)Lorg/jetbrains/kotlin/types/TypeAttributes;", "", "expandTypeAliases", "Lorg/jetbrains/kotlin/types/SimpleType;", "simpleType", "(Lorg/jetbrains/kotlin/metadata/ProtoBuf$Type;Z)Lorg/jetbrains/kotlin/types/SimpleType;", "typeConstructor", "(Lorg/jetbrains/kotlin/metadata/ProtoBuf$Type;)Lorg/jetbrains/kotlin/types/TypeConstructor;", "attributes", "functionTypeConstructor", "Lorg/jetbrains/kotlin/types/TypeProjection;", "arguments", "nullable", "createSuspendFunctionType", "(Lorg/jetbrains/kotlin/types/TypeAttributes;Lorg/jetbrains/kotlin/types/TypeConstructor;Ljava/util/List;Z)Lorg/jetbrains/kotlin/types/SimpleType;", "createSuspendFunctionTypeForBasicCase", "funType", "transformRuntimeFunctionTypeToSuspendFunction", "(Lorg/jetbrains/kotlin/types/KotlinType;)Lorg/jetbrains/kotlin/types/SimpleType;", "suspendReturnType", "createSimpleSuspendFunctionType", "(Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/types/KotlinType;)Lorg/jetbrains/kotlin/types/SimpleType;", "", "typeParameterId", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "loadTypeParameter", "(I)Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "fqNameIndex", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "computeClassifierDescriptor", "(I)Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "className", "computeLocalClassifierReplacementType", "(I)Lorg/jetbrains/kotlin/types/SimpleType;", "computeTypeAliasDescriptor", "parameter", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Type$Argument;", "typeArgumentProto", "typeArgument", "(Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;Lorg/jetbrains/kotlin/metadata/ProtoBuf$Type$Argument;)Lorg/jetbrains/kotlin/types/TypeProjection;", "toString", "()Ljava/lang/String;", "Lorg/jetbrains/kotlin/serialization/deserialization/DeserializationContext;", "Lorg/jetbrains/kotlin/serialization/deserialization/TypeDeserializer;", "Ljava/lang/String;", "Lkotlin/Function1;", "classifierDescriptors", "Lkotlin/jvm/functions/Function1;", "typeAliasDescriptors", "", "typeParameterDescriptors", "Ljava/util/Map;", "getOwnTypeParameters", "()Ljava/util/List;", "ownTypeParameters"})
public final class TypeDeserializer {
    @NotNull
    private final DeserializationContext c;
    @Nullable
    private final TypeDeserializer parent;
    @NotNull
    private final String debugName;
    @NotNull
    private final String containerPresentableName;
    @NotNull
    private final Function1<Integer, ClassifierDescriptor> classifierDescriptors;
    @NotNull
    private final Function1<Integer, ClassifierDescriptor> typeAliasDescriptors;
    @NotNull
    private final Map<Integer, TypeParameterDescriptor> typeParameterDescriptors;

    public TypeDeserializer(@NotNull DeserializationContext c, @Nullable TypeDeserializer parent2, @NotNull List<ProtoBuf.TypeParameter> typeParameterProtos, @NotNull String debugName, @NotNull String containerPresentableName) {
        Map map2;
        Intrinsics.checkNotNullParameter(c, "c");
        Intrinsics.checkNotNullParameter(typeParameterProtos, "typeParameterProtos");
        Intrinsics.checkNotNullParameter(debugName, "debugName");
        Intrinsics.checkNotNullParameter(containerPresentableName, "containerPresentableName");
        this.c = c;
        this.parent = parent2;
        this.debugName = debugName;
        this.containerPresentableName = containerPresentableName;
        this.classifierDescriptors = this.c.getStorageManager().createMemoizedFunctionWithNullableValues(arg_0 -> TypeDeserializer.classifierDescriptors$lambda$0(this, arg_0));
        this.typeAliasDescriptors = this.c.getStorageManager().createMemoizedFunctionWithNullableValues(arg_0 -> TypeDeserializer.typeAliasDescriptors$lambda$1(this, arg_0));
        TypeDeserializer typeDeserializer = this;
        if (typeParameterProtos.isEmpty()) {
            map2 = MapsKt.emptyMap();
        } else {
            LinkedHashMap result2 = new LinkedHashMap();
            Iterator iterator2 = ((Iterable)typeParameterProtos).iterator();
            int n = 0;
            TypeDeserializer typeDeserializer2 = typeDeserializer;
            while (iterator2.hasNext()) {
                int index2 = n++;
                ProtoBuf.TypeParameter proto = (ProtoBuf.TypeParameter)iterator2.next();
                ((Map)result2).put(proto.getId(), new DeserializedTypeParameterDescriptor(this.c, proto, index2));
            }
            typeDeserializer = typeDeserializer2;
            map2 = result2;
        }
        typeDeserializer.typeParameterDescriptors = map2;
    }

    @NotNull
    public final List<TypeParameterDescriptor> getOwnTypeParameters() {
        return CollectionsKt.toList((Iterable)this.typeParameterDescriptors.values());
    }

    @NotNull
    public final KotlinType type(@NotNull ProtoBuf.Type proto) {
        Intrinsics.checkNotNullParameter(proto, "proto");
        if (proto.hasFlexibleTypeCapabilitiesId()) {
            String id = this.c.getNameResolver().getString(proto.getFlexibleTypeCapabilitiesId());
            SimpleType lowerBound = TypeDeserializer.simpleType$default(this, proto, false, 2, null);
            ProtoBuf.Type type2 = ProtoTypeTableUtilKt.flexibleUpperBound(proto, this.c.getTypeTable());
            Intrinsics.checkNotNull(type2);
            SimpleType upperBound = TypeDeserializer.simpleType$default(this, type2, false, 2, null);
            return this.c.getComponents().getFlexibleTypeDeserializer().create(proto, id, lowerBound, upperBound);
        }
        return this.simpleType(proto, true);
    }

    /*
     * WARNING - void declaration
     */
    private final TypeAttributes toAttributes(List<? extends TypeAttributeTranslator> $this$toAttributes, Annotations annotations2, TypeConstructor constructor, DeclarationDescriptor containingDeclaration) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $this$toAttributes;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void translator;
            TypeAttributeTranslator typeAttributeTranslator = (TypeAttributeTranslator)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(translator.toAttributes(annotations2, constructor, containingDeclaration));
        }
        List translated = CollectionsKt.flatten((List)destination$iv$iv);
        return TypeAttributes.Companion.create(translated);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final SimpleType simpleType(@NotNull ProtoBuf.Type proto, boolean expandTypeAliases) {
        Object object;
        block15: {
            SimpleType simpleType2;
            block14: {
                SimpleType simpleType3;
                void $this$mapIndexedTo$iv$iv;
                SimpleType localClassifierType;
                Intrinsics.checkNotNullParameter(proto, "proto");
                SimpleType simpleType4 = localClassifierType = proto.hasClassName() ? this.computeLocalClassifierReplacementType(proto.getClassName()) : (proto.hasTypeAliasName() ? this.computeLocalClassifierReplacementType(proto.getTypeAliasName()) : null);
                if (simpleType4 != null) {
                    return simpleType4;
                }
                TypeConstructor constructor = this.typeConstructor(proto);
                if (ErrorUtils.isError(constructor.getDeclarationDescriptor())) {
                    String[] stringArray = new String[]{constructor.toString()};
                    return ErrorUtils.INSTANCE.createErrorType(ErrorTypeKind.TYPE_FOR_ERROR_TYPE_CONSTRUCTOR, constructor, stringArray);
                }
                DeserializedAnnotations annotations2 = new DeserializedAnnotations(this.c.getStorageManager(), () -> TypeDeserializer.simpleType$lambda$3(this, proto));
                TypeAttributes attributes = this.toAttributes(this.c.getComponents().getTypeAttributeTranslators(), annotations2, constructor, this.c.getContainingDeclaration());
                Iterable $this$mapIndexed$iv = TypeDeserializer.simpleType$collectAllArguments(proto, this);
                boolean $i$f$mapIndexed = false;
                Iterable iterable = $this$mapIndexed$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, 10));
                boolean $i$f$mapIndexedTo = false;
                int index$iv$iv = 0;
                for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                    void argumentProto;
                    void index2;
                    int n;
                    if ((n = index$iv$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    ProtoBuf.Type.Argument argument = (ProtoBuf.Type.Argument)item$iv$iv;
                    int n2 = n;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    List<TypeParameterDescriptor> list = constructor.getParameters();
                    Intrinsics.checkNotNullExpressionValue(list, "getParameters(...)");
                    collection.add(this.typeArgument(CollectionsKt.getOrNull(list, (int)index2), (ProtoBuf.Type.Argument)argumentProto));
                }
                List arguments2 = CollectionsKt.toList((List)destination$iv$iv);
                ClassifierDescriptor declarationDescriptor = constructor.getDeclarationDescriptor();
                if (expandTypeAliases && declarationDescriptor instanceof TypeAliasDescriptor) {
                    KotlinTypeFactory $this$simpleType_u24lambda_u245 = KotlinTypeFactory.INSTANCE;
                    boolean bl = false;
                    SimpleType expandedType = KotlinTypeFactory.computeExpandedType((TypeAliasDescriptor)declarationDescriptor, arguments2);
                    TypeAttributes expandedAttributes = this.toAttributes(this.c.getComponents().getTypeAttributeTranslators(), Annotations.Companion.create(CollectionsKt.plus((Iterable)annotations2, (Iterable)expandedType.getAnnotations())), constructor, this.c.getContainingDeclaration());
                    simpleType3 = expandedType.makeNullableAsSpecified(KotlinTypeKt.isNullable(expandedType) || proto.getNullable()).replaceAttributes(expandedAttributes);
                } else if (Flags.SUSPEND_TYPE.get(proto.getFlags()).booleanValue()) {
                    simpleType3 = this.createSuspendFunctionType(attributes, constructor, arguments2, proto.getNullable());
                } else {
                    SimpleType it = KotlinTypeFactory.simpleType$default(attributes, constructor, arguments2, proto.getNullable(), null, 16, null);
                    boolean bl = false;
                    if (Flags.DEFINITELY_NOT_NULL_TYPE.get(proto.getFlags()).booleanValue()) {
                        DefinitelyNotNullType definitelyNotNullType = DefinitelyNotNullType.Companion.makeDefinitelyNotNull$default(DefinitelyNotNullType.Companion, it, true, false, 4, null);
                        if (definitelyNotNullType == null) {
                            throw new IllegalStateException(("null DefinitelyNotNullType for '" + it + '\'').toString());
                        }
                        simpleType3 = definitelyNotNullType;
                    } else {
                        simpleType3 = it;
                    }
                }
                simpleType2 = simpleType3;
                object = ProtoTypeTableUtilKt.abbreviatedType(proto, this.c.getTypeTable());
                if (object == null) break block14;
                ProtoBuf.Type it = object;
                boolean bl = false;
                SimpleType simpleType5 = SpecialTypesKt.withAbbreviation(simpleType2, this.simpleType(it, false));
                object = simpleType5;
                if (simpleType5 != null) break block15;
            }
            object = simpleType2;
        }
        Object computedType = object;
        return computedType;
    }

    public static /* synthetic */ SimpleType simpleType$default(TypeDeserializer typeDeserializer, ProtoBuf.Type type2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return typeDeserializer.simpleType(type2, bl);
    }

    private final TypeConstructor typeConstructor(ProtoBuf.Type proto) {
        ClassifierDescriptor classifierDescriptor;
        if (proto.hasClassName()) {
            classifierDescriptor = this.classifierDescriptors.invoke(proto.getClassName());
            if (classifierDescriptor == null) {
                classifierDescriptor = TypeDeserializer.typeConstructor$notFoundClass(this, proto, proto.getClassName());
            }
        } else if (proto.hasTypeParameter()) {
            TypeParameterDescriptor typeParameterDescriptor = this.loadTypeParameter(proto.getTypeParameter());
            if (typeParameterDescriptor == null) {
                String[] stringArray = new String[]{String.valueOf(proto.getTypeParameter()), this.containerPresentableName};
                return ErrorUtils.INSTANCE.createErrorTypeConstructor(ErrorTypeKind.CANNOT_LOAD_DESERIALIZE_TYPE_PARAMETER, stringArray);
            }
            classifierDescriptor = typeParameterDescriptor;
        } else if (proto.hasTypeParameterName()) {
            Object v2;
            String name;
            block13: {
                name = this.c.getNameResolver().getString(proto.getTypeParameterName());
                Iterable iterable = this.getOwnTypeParameters();
                for (Object t : iterable) {
                    TypeParameterDescriptor it = (TypeParameterDescriptor)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual(it.getName().asString(), name)) continue;
                    v2 = t;
                    break block13;
                }
                v2 = null;
            }
            TypeParameterDescriptor typeParameterDescriptor = v2;
            if (typeParameterDescriptor == null) {
                String[] stringArray = new String[]{name, this.c.getContainingDeclaration().toString()};
                return ErrorUtils.INSTANCE.createErrorTypeConstructor(ErrorTypeKind.CANNOT_LOAD_DESERIALIZE_TYPE_PARAMETER_BY_NAME, stringArray);
            }
            classifierDescriptor = typeParameterDescriptor;
        } else if (proto.hasTypeAliasName()) {
            classifierDescriptor = this.typeAliasDescriptors.invoke(proto.getTypeAliasName());
            if (classifierDescriptor == null) {
                classifierDescriptor = TypeDeserializer.typeConstructor$notFoundClass(this, proto, proto.getTypeAliasName());
            }
        } else {
            return ErrorUtils.INSTANCE.createErrorTypeConstructor(ErrorTypeKind.UNKNOWN_TYPE, new String[0]);
        }
        ClassifierDescriptor classifier2 = classifierDescriptor;
        TypeConstructor typeConstructor2 = classifier2.getTypeConstructor();
        Intrinsics.checkNotNullExpressionValue(typeConstructor2, "getTypeConstructor(...)");
        return typeConstructor2;
    }

    private final SimpleType createSuspendFunctionType(TypeAttributes attributes, TypeConstructor functionTypeConstructor, List<? extends TypeProjection> arguments2, boolean nullable) {
        SimpleType result2;
        SimpleType simpleType2;
        SimpleType simpleType3;
        switch (functionTypeConstructor.getParameters().size() - arguments2.size()) {
            case 0: {
                simpleType3 = this.createSuspendFunctionTypeForBasicCase(attributes, functionTypeConstructor, arguments2, nullable);
                break;
            }
            case 1: {
                int arity = arguments2.size() - 1;
                if (arity >= 0) {
                    TypeConstructor typeConstructor2 = functionTypeConstructor.getBuiltIns().getSuspendFunction(arity).getTypeConstructor();
                    Intrinsics.checkNotNullExpressionValue(typeConstructor2, "getTypeConstructor(...)");
                    simpleType3 = KotlinTypeFactory.simpleType$default(attributes, typeConstructor2, arguments2, nullable, null, 16, null);
                    break;
                }
                simpleType3 = null;
                break;
            }
            default: {
                simpleType3 = null;
            }
        }
        if ((simpleType2 = (result2 = simpleType3)) == null) {
            simpleType2 = ErrorUtils.INSTANCE.createErrorTypeWithArguments(ErrorTypeKind.INCONSISTENT_SUSPEND_FUNCTION, arguments2, functionTypeConstructor, new String[0]);
        }
        return simpleType2;
    }

    private final SimpleType createSuspendFunctionTypeForBasicCase(TypeAttributes attributes, TypeConstructor functionTypeConstructor, List<? extends TypeProjection> arguments2, boolean nullable) {
        SimpleType functionType = KotlinTypeFactory.simpleType$default(attributes, functionTypeConstructor, arguments2, nullable, null, 16, null);
        return !FunctionTypesKt.isFunctionType(functionType) ? null : this.transformRuntimeFunctionTypeToSuspendFunction(functionType);
    }

    private final SimpleType transformRuntimeFunctionTypeToSuspendFunction(KotlinType funType) {
        FqName continuationArgumentFqName;
        Object object = CollectionsKt.lastOrNull(FunctionTypesKt.getValueParameterTypesFromFunctionType(funType));
        if (object == null || (object = object.getType()) == null) {
            return null;
        }
        Object continuationArgumentType = object;
        ClassifierDescriptor classifierDescriptor = ((KotlinType)continuationArgumentType).getConstructor().getDeclarationDescriptor();
        FqName fqName2 = continuationArgumentFqName = classifierDescriptor != null ? DescriptorUtilsKt.getFqNameSafe(classifierDescriptor) : null;
        if (((KotlinType)continuationArgumentType).getArguments().size() != 1 || !Intrinsics.areEqual(continuationArgumentFqName, StandardNames.CONTINUATION_INTERFACE_FQ_NAME) && !Intrinsics.areEqual(continuationArgumentFqName, TypeDeserializerKt.access$getEXPERIMENTAL_CONTINUATION_FQ_NAME$p())) {
            return (SimpleType)funType;
        }
        KotlinType kotlinType = CollectionsKt.single(((KotlinType)continuationArgumentType).getArguments()).getType();
        Intrinsics.checkNotNullExpressionValue(kotlinType, "getType(...)");
        KotlinType suspendReturnType = kotlinType;
        DeclarationDescriptor declarationDescriptor = this.c.getContainingDeclaration();
        CallableDescriptor callableDescriptor = declarationDescriptor instanceof CallableDescriptor ? (CallableDescriptor)declarationDescriptor : null;
        if (Intrinsics.areEqual(callableDescriptor != null ? DescriptorUtilsKt.fqNameOrNull(callableDescriptor) : null, SuspendFunctionTypeUtilKt.KOTLIN_SUSPEND_BUILT_IN_FUNCTION_FQ_NAME)) {
            return this.createSimpleSuspendFunctionType(funType, suspendReturnType);
        }
        return this.createSimpleSuspendFunctionType(funType, suspendReturnType);
    }

    /*
     * WARNING - void declaration
     */
    private final SimpleType createSimpleSuspendFunctionType(KotlinType funType, KotlinType suspendReturnType) {
        Collection<KotlinType> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = CollectionsKt.dropLast(FunctionTypesKt.getValueParameterTypesFromFunctionType(funType), 1);
        List<KotlinType> list = FunctionTypesKt.getContextReceiverTypesFromFunctionType(funType);
        KotlinType kotlinType = FunctionTypesKt.getReceiverTypeFromFunctionType(funType);
        Annotations annotations2 = funType.getAnnotations();
        KotlinBuiltIns kotlinBuiltIns = TypeUtilsKt.getBuiltIns(funType);
        boolean $i$f$map = false;
        void var5_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            TypeProjection typeProjection = (TypeProjection)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.getType());
        }
        collection = (List)destination$iv$iv;
        return FunctionTypesKt.createFunctionType(kotlinBuiltIns, annotations2, kotlinType, list, (List<? extends KotlinType>)collection, null, suspendReturnType, true).makeNullableAsSpecified(funType.isMarkedNullable());
    }

    private final TypeParameterDescriptor loadTypeParameter(int typeParameterId) {
        TypeParameterDescriptor typeParameterDescriptor = this.typeParameterDescriptors.get(typeParameterId);
        if (typeParameterDescriptor == null) {
            TypeDeserializer typeDeserializer = this.parent;
            typeParameterDescriptor = typeDeserializer != null ? typeDeserializer.loadTypeParameter(typeParameterId) : null;
        }
        return typeParameterDescriptor;
    }

    private final ClassifierDescriptor computeClassifierDescriptor(int fqNameIndex) {
        ClassId id = NameResolverUtilKt.getClassId(this.c.getNameResolver(), fqNameIndex);
        if (id.isLocal()) {
            return this.c.getComponents().deserializeClass(id);
        }
        return FindClassInModuleKt.findClassifierAcrossModuleDependencies(this.c.getComponents().getModuleDescriptor(), id);
    }

    private final SimpleType computeLocalClassifierReplacementType(int className) {
        if (NameResolverUtilKt.getClassId(this.c.getNameResolver(), className).isLocal()) {
            return this.c.getComponents().getLocalClassifierTypeSettings().getReplacementTypeForLocalClassifiers();
        }
        return null;
    }

    private final ClassifierDescriptor computeTypeAliasDescriptor(int fqNameIndex) {
        ClassId id = NameResolverUtilKt.getClassId(this.c.getNameResolver(), fqNameIndex);
        if (id.isLocal()) {
            return null;
        }
        return FindClassInModuleKt.findTypeAliasAcrossModuleDependencies(this.c.getComponents().getModuleDescriptor(), id);
    }

    private final TypeProjection typeArgument(TypeParameterDescriptor parameter, ProtoBuf.Type.Argument typeArgumentProto) {
        if (typeArgumentProto.getProjection() == ProtoBuf.Type.Argument.Projection.STAR) {
            return parameter == null ? (TypeProjection)new StarProjectionForAbsentTypeParameter(this.c.getComponents().getModuleDescriptor().getBuiltIns()) : (TypeProjection)new StarProjectionImpl(parameter);
        }
        ProtoBuf.Type.Argument.Projection projection = typeArgumentProto.getProjection();
        Intrinsics.checkNotNullExpressionValue(projection, "getProjection(...)");
        Variance projection2 = ProtoEnumFlags.INSTANCE.variance(projection);
        ProtoBuf.Type type2 = ProtoTypeTableUtilKt.type(typeArgumentProto, this.c.getTypeTable());
        if (type2 == null) {
            String[] stringArray = new String[]{typeArgumentProto.toString()};
            return new TypeProjectionImpl(ErrorUtils.createErrorType(ErrorTypeKind.NO_RECORDED_TYPE, stringArray));
        }
        ProtoBuf.Type type3 = type2;
        return new TypeProjectionImpl(projection2, this.type(type3));
    }

    @NotNull
    public String toString() {
        return this.debugName + (this.parent == null ? "" : ". Child of " + this.parent.debugName);
    }

    private static final ClassifierDescriptor classifierDescriptors$lambda$0(TypeDeserializer this$0, int fqNameIndex) {
        return this$0.computeClassifierDescriptor(fqNameIndex);
    }

    private static final ClassifierDescriptor typeAliasDescriptors$lambda$1(TypeDeserializer this$0, int fqNameIndex) {
        return this$0.computeTypeAliasDescriptor(fqNameIndex);
    }

    private static final List simpleType$lambda$3(TypeDeserializer this$0, ProtoBuf.Type $proto) {
        return this$0.c.getComponents().getAnnotationAndConstantLoader().loadTypeAnnotations($proto, this$0.c.getNameResolver());
    }

    private static final List<ProtoBuf.Type.Argument> simpleType$collectAllArguments(ProtoBuf.Type $this$simpleType_u24collectAllArguments, TypeDeserializer this$0) {
        List<ProtoBuf.Type.Argument> list = $this$simpleType_u24collectAllArguments.getArgumentList();
        Intrinsics.checkNotNullExpressionValue(list, "getArgumentList(...)");
        Collection collection = list;
        ProtoBuf.Type type2 = ProtoTypeTableUtilKt.outerType($this$simpleType_u24collectAllArguments, this$0.c.getTypeTable());
        List<ProtoBuf.Type.Argument> list2 = type2 != null ? TypeDeserializer.simpleType$collectAllArguments(type2, this$0) : null;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        return CollectionsKt.plus(collection, (Iterable)list2);
    }

    private static final ProtoBuf.Type typeConstructor$notFoundClass$lambda$8(TypeDeserializer this$0, ProtoBuf.Type it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return ProtoTypeTableUtilKt.outerType(it, this$0.c.getTypeTable());
    }

    private static final int typeConstructor$notFoundClass$lambda$9(ProtoBuf.Type it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getArgumentCount();
    }

    private static final ClassDescriptor typeConstructor$notFoundClass(TypeDeserializer this$0, ProtoBuf.Type $proto, int classIdIndex) {
        ClassId classId = NameResolverUtilKt.getClassId(this$0.c.getNameResolver(), classIdIndex);
        List<Integer> typeParametersCount2 = SequencesKt.toMutableList(SequencesKt.map(SequencesKt.generateSequence($proto, arg_0 -> TypeDeserializer.typeConstructor$notFoundClass$lambda$8(this$0, arg_0)), TypeDeserializer::typeConstructor$notFoundClass$lambda$9));
        int classNestingLevel2 = SequencesKt.count(SequencesKt.generateSequence(classId, (Function1)typeConstructor.notFoundClass.classNestingLevel.1.INSTANCE));
        while (typeParametersCount2.size() < classNestingLevel2) {
            typeParametersCount2.add(0);
        }
        return this$0.c.getComponents().getNotFoundClasses().getClass(classId, typeParametersCount2);
    }
}

