/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization.js;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.serialization.deserialization.FlexibleTypeDeserializer;
import org.jetbrains.kotlin.types.DynamicTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.checker.StrictEqualityTypeChecker;
import org.jetbrains.kotlin.types.error.ErrorTypeKind;
import org.jetbrains.kotlin.types.error.ErrorUtils;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J/\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0017\u00a2\u0006\u0004\b\f\u0010\r"}, d2={"Lorg/jetbrains/kotlin/serialization/js/DynamicTypeDeserializer;", "Lorg/jetbrains/kotlin/serialization/deserialization/FlexibleTypeDeserializer;", "<init>", "()V", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Type;", "proto", "", "flexibleId", "Lorg/jetbrains/kotlin/types/SimpleType;", "lowerBound", "upperBound", "Lorg/jetbrains/kotlin/types/KotlinType;", "create", "(Lorg/jetbrains/kotlin/metadata/ProtoBuf$Type;Ljava/lang/String;Lorg/jetbrains/kotlin/types/SimpleType;Lorg/jetbrains/kotlin/types/SimpleType;)Lorg/jetbrains/kotlin/types/KotlinType;"})
public final class DynamicTypeDeserializer
implements FlexibleTypeDeserializer {
    @NotNull
    public static final DynamicTypeDeserializer INSTANCE = new DynamicTypeDeserializer();

    private DynamicTypeDeserializer() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public KotlinType create(@NotNull ProtoBuf.Type proto, @NotNull String flexibleId, @NotNull SimpleType lowerBound, @NotNull SimpleType upperBound) {
        KotlinType kotlinType;
        Intrinsics.checkNotNullParameter(proto, "proto");
        Intrinsics.checkNotNullParameter(flexibleId, "flexibleId");
        Intrinsics.checkNotNullParameter(lowerBound, "lowerBound");
        Intrinsics.checkNotNullParameter(upperBound, "upperBound");
        if (!Intrinsics.areEqual(flexibleId, "kotlin.DynamicType")) {
            String[] stringArray = new String[]{flexibleId, lowerBound.toString(), upperBound.toString()};
            return ErrorUtils.createErrorType(ErrorTypeKind.UNEXPECTED_FLEXIBLE_TYPE_ID, stringArray);
        }
        SimpleType simpleType2 = TypeUtilsKt.getBuiltIns(lowerBound).getNothingType();
        Intrinsics.checkNotNullExpressionValue(simpleType2, "getNothingType(...)");
        if (StrictEqualityTypeChecker.INSTANCE.strictEqualTypes(lowerBound, simpleType2)) {
            SimpleType simpleType3 = TypeUtilsKt.getBuiltIns(upperBound).getNullableAnyType();
            Intrinsics.checkNotNullExpressionValue(simpleType3, "getNullableAnyType(...)");
            if (StrictEqualityTypeChecker.INSTANCE.strictEqualTypes(upperBound, simpleType3)) {
                kotlinType = DynamicTypesKt.createDynamicType(TypeUtilsKt.getBuiltIns(lowerBound));
                return kotlinType;
            }
        }
        String[] stringArray = new String[]{lowerBound.toString(), upperBound.toString()};
        kotlinType = ErrorUtils.createErrorType(ErrorTypeKind.ILLEGAL_TYPE_RANGE_FOR_DYNAMIC, stringArray);
        return kotlinType;
    }
}

