/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.storage;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.storage.DefaultSimpleLock;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0004\b\n\u0010\u000bB%\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0004\b\n\u0010\fJ\u000f\u0010\u0003\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u0003\u0010\rR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u000eR \u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00068\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\u000f"}, d2={"Lorg/jetbrains/kotlin/storage/CancellableSimpleLock;", "Lorg/jetbrains/kotlin/storage/DefaultSimpleLock;", "Ljava/util/concurrent/locks/Lock;", "lock", "Ljava/lang/Runnable;", "checkCancelled", "Lkotlin/Function1;", "Ljava/lang/InterruptedException;", "", "interruptedExceptionHandler", "<init>", "(Ljava/util/concurrent/locks/Lock;Ljava/lang/Runnable;Lkotlin/jvm/functions/Function1;)V", "(Ljava/lang/Runnable;Lkotlin/jvm/functions/Function1;)V", "()V", "Ljava/lang/Runnable;", "Lkotlin/jvm/functions/Function1;"})
public final class CancellableSimpleLock
extends DefaultSimpleLock {
    @NotNull
    private final Runnable checkCancelled;
    @NotNull
    private final Function1<InterruptedException, Unit> interruptedExceptionHandler;

    public CancellableSimpleLock(@NotNull Lock lock, @NotNull Runnable checkCancelled, @NotNull Function1<? super InterruptedException, Unit> interruptedExceptionHandler) {
        Intrinsics.checkNotNullParameter(lock, "lock");
        Intrinsics.checkNotNullParameter(checkCancelled, "checkCancelled");
        Intrinsics.checkNotNullParameter(interruptedExceptionHandler, "interruptedExceptionHandler");
        super(lock);
        this.checkCancelled = checkCancelled;
        this.interruptedExceptionHandler = interruptedExceptionHandler;
    }

    public CancellableSimpleLock(@NotNull Runnable checkCancelled, @NotNull Function1<? super InterruptedException, Unit> interruptedExceptionHandler) {
        Intrinsics.checkNotNullParameter(checkCancelled, "checkCancelled");
        Intrinsics.checkNotNullParameter(interruptedExceptionHandler, "interruptedExceptionHandler");
        ReentrantLock reentrantLock = new ReentrantLock();
        this((Lock)reentrantLock, checkCancelled, interruptedExceptionHandler);
    }

    @Override
    public void lock() {
        try {
            while (!this.getLock().tryLock(50L, TimeUnit.MILLISECONDS)) {
                this.checkCancelled.run();
            }
        }
        catch (InterruptedException e) {
            this.interruptedExceptionHandler.invoke(e);
        }
    }
}

