/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.storage;

import com.intellij.openapi.util.ModificationTracker;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.storage.CacheResetOnProcessCanceled;
import org.jetbrains.kotlin.storage.LockBasedStorageManager;
import org.jetbrains.kotlin.util.ReenteringLazyValueComputationException;
import org.jetbrains.kotlin.utils.ExceptionUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001b\u0010\t\u001a\u00060\u0007j\u0002`\b2\u0006\u0010\u0006\u001a\u00020\u0005H\u0017\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\f\u0010\u0004J\u000f\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0011\u001a\u00020\u0010H\u0017\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0014\u001a\u00020\u00138\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015"}, d2={"Lorg/jetbrains/kotlin/storage/ExceptionTracker;", "Lcom/intellij/openapi/util/ModificationTracker;", "Lorg/jetbrains/kotlin/storage/LockBasedStorageManager$ExceptionHandlingStrategy;", "<init>", "()V", "", "throwable", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "handleException", "(Ljava/lang/Throwable;)Ljava/lang/RuntimeException;", "", "incCounter", "", "getModificationCount", "()J", "", "toString", "()Ljava/lang/String;", "Ljava/util/concurrent/atomic/AtomicLong;", "cancelledTracker", "Ljava/util/concurrent/atomic/AtomicLong;"})
public class ExceptionTracker
implements ModificationTracker,
LockBasedStorageManager.ExceptionHandlingStrategy {
    @NotNull
    private final AtomicLong cancelledTracker = new AtomicLong();

    @Override
    @NotNull
    public RuntimeException handleException(@NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter(throwable, "throwable");
        if (!(throwable instanceof ReenteringLazyValueComputationException || ExceptionUtilsKt.isProcessCanceledException(throwable) && !CacheResetOnProcessCanceled.INSTANCE.getEnabled())) {
            this.incCounter();
        }
        throw ExceptionUtilsKt.rethrow(throwable);
    }

    private final void incCounter() {
        this.cancelledTracker.getAndIncrement();
    }

    @Override
    public long getModificationCount() {
        return this.cancelledTracker.get();
    }

    @NotNull
    public String toString() {
        return this.getClass().getName() + ": " + this.getModificationCount();
    }
}

