/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.storage;

import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;
import org.jetbrains.kotlin.storage.CacheWithNotNullValues;
import org.jetbrains.kotlin.storage.CacheWithNullableValues;
import org.jetbrains.kotlin.storage.LazyResolveStorageManager;
import org.jetbrains.kotlin.storage.MemoizedFunctionToNotNull;
import org.jetbrains.kotlin.storage.MemoizedFunctionToNullable;
import org.jetbrains.kotlin.storage.NotNullLazyValue;
import org.jetbrains.kotlin.storage.NullableLazyValue;
import org.jetbrains.kotlin.storage.StorageManager;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u00012\u00020\u0002:\u0002=>B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0005JH\u0010\r\u001a\u0013\u0012\t\u0012\u00078\u0000\u00a2\u0006\u0002\b\f\u0012\u0004\u0012\u00028\u00010\u000b\"\b\b\u0000\u0010\u0007*\u00020\u0006\"\b\b\u0001\u0010\b*\u00020\u00062\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\tH\u0017\u00a2\u0006\u0004\b\r\u0010\u000eJH\u0010\u0010\u001a\u0013\u0012\t\u0012\u00078\u0000\u00a2\u0006\u0002\b\f\u0012\u0004\u0012\u00028\u00010\u000f\"\b\b\u0000\u0010\u0007*\u00020\u0006\"\b\b\u0001\u0010\b*\u00020\u00062\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\tH\u0017\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0017\u00a2\u0006\u0004\b\u0014\u0010\u0015J*\u0010\n\u001a\u00028\u0000\"\n\b\u0000\u0010\u0016*\u0004\u0018\u00010\u00062\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u0017H\u0096\u0001\u00a2\u0006\u0004\b\n\u0010\u0019J2\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u001a\"\n\b\u0000\u0010\u0007*\u0004\u0018\u00010\u0006\"\b\b\u0001\u0010\b*\u00020\u0006H\u0097\u0001\u00a2\u0006\u0004\b\u001b\u0010\u001cJ2\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u001d\"\n\b\u0000\u0010\u0007*\u0004\u0018\u00010\u0006\"\b\b\u0001\u0010\b*\u00020\u0006H\u0097\u0001\u00a2\u0006\u0004\b\u001e\u0010\u001fJ.\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00000 \"\b\b\u0000\u0010\u0016*\u00020\u00062\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u0017H\u0097\u0001\u00a2\u0006\u0004\b!\u0010\"JB\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00000 \"\b\b\u0000\u0010\u0016*\u00020\u00062\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u00172\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00028\u00000\tH\u0097\u0001\u00a2\u0006\u0004\b!\u0010%JX\u0010(\u001a\b\u0012\u0004\u0012\u00028\u00000 \"\b\b\u0000\u0010\u0016*\u00020\u00062\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u00172\u0014\u0010$\u001a\u0010\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00028\u0000\u0018\u00010\t2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020&0\tH\u0097\u0001\u00a2\u0006\u0004\b(\u0010)JF\u0010*\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000b\"\n\b\u0000\u0010\u0007*\u0004\u0018\u00010\u0006\"\b\b\u0001\u0010\b*\u00020\u00062\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\tH\u0097\u0001\u00a2\u0006\u0004\b*\u0010\u000eJZ\u0010*\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000b\"\n\b\u0000\u0010\u0007*\u0004\u0018\u00010\u0006\"\b\b\u0001\u0010\b*\u00020\u00062\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\t2\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00060+H\u0097\u0001\u00a2\u0006\u0004\b*\u0010-J`\u0010*\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000b\"\n\b\u0000\u0010\u0007*\u0004\u0018\u00010\u0006\"\b\b\u0001\u0010\b*\u00020\u00062\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\t2\u0018\u0010$\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00028\u00010.H\u0097\u0001\u00a2\u0006\u0004\b*\u0010/Jt\u0010*\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000b\"\n\b\u0000\u0010\u0007*\u0004\u0018\u00010\u0006\"\b\b\u0001\u0010\b*\u00020\u00062\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\t2\u0018\u0010$\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00028\u00010.2\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00060+H\u0097\u0001\u00a2\u0006\u0004\b*\u00100JH\u00101\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000f\"\n\b\u0000\u0010\u0007*\u0004\u0018\u00010\u0006\"\b\b\u0001\u0010\b*\u00020\u00062\u0014\u0010\n\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00018\u00010\tH\u0097\u0001\u00a2\u0006\u0004\b1\u0010\u0011JZ\u00101\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000f\"\n\b\u0000\u0010\u0007*\u0004\u0018\u00010\u0006\"\b\b\u0001\u0010\b*\u00020\u00062\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\t2\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00060+H\u0097\u0001\u00a2\u0006\u0004\b1\u00102J0\u00104\u001a\b\u0012\u0004\u0012\u00028\u000003\"\b\b\u0000\u0010\u0016*\u00020\u00062\u000e\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0017H\u0097\u0001\u00a2\u0006\u0004\b4\u00105JF\u00106\u001a\b\u0012\u0004\u0012\u00028\u000003\"\b\b\u0000\u0010\u0016*\u00020\u00062\u000e\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u00172\u0014\u0010'\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0012\u0004\u0012\u00020&0\tH\u0097\u0001\u00a2\u0006\u0004\b6\u00107J6\u00108\u001a\b\u0012\u0004\u0012\u00028\u00000 \"\b\b\u0000\u0010\u0016*\u00020\u00062\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u00172\u0006\u0010$\u001a\u00028\u0000H\u0097\u0001\u00a2\u0006\u0004\b8\u00109J:\u0010:\u001a\b\u0012\u0004\u0012\u00028\u000003\"\b\b\u0000\u0010\u0016*\u00020\u00062\u000e\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u00172\b\u0010$\u001a\u0004\u0018\u00018\u0000H\u0097\u0001\u00a2\u0006\u0004\b:\u0010;R\u0014\u0010\u0003\u001a\u00020\u00018\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010<"}, d2={"Lorg/jetbrains/kotlin/storage/LockBasedLazyResolveStorageManager;", "Lorg/jetbrains/kotlin/storage/StorageManager;", "Lorg/jetbrains/kotlin/storage/LazyResolveStorageManager;", "storageManager", "<init>", "(Lorg/jetbrains/kotlin/storage/StorageManager;)V", "", "K", "V", "Lkotlin/Function1;", "compute", "Lorg/jetbrains/kotlin/storage/MemoizedFunctionToNotNull;", "Lorg/jetbrains/annotations/NotNull;", "createSoftlyRetainedMemoizedFunction", "(Lkotlin/jvm/functions/Function1;)Lorg/jetbrains/kotlin/storage/MemoizedFunctionToNotNull;", "Lorg/jetbrains/kotlin/storage/MemoizedFunctionToNullable;", "createSoftlyRetainedMemoizedFunctionWithNullableValues", "(Lkotlin/jvm/functions/Function1;)Lorg/jetbrains/kotlin/storage/MemoizedFunctionToNullable;", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "originalTrace", "createSafeTrace", "(Lorg/jetbrains/kotlin/resolve/BindingTrace;)Lorg/jetbrains/kotlin/resolve/BindingTrace;", "T", "Lkotlin/Function0;", "computable", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "Lorg/jetbrains/kotlin/storage/CacheWithNotNullValues;", "createCacheWithNotNullValues", "()Lorg/jetbrains/kotlin/storage/CacheWithNotNullValues;", "Lorg/jetbrains/kotlin/storage/CacheWithNullableValues;", "createCacheWithNullableValues", "()Lorg/jetbrains/kotlin/storage/CacheWithNullableValues;", "Lorg/jetbrains/kotlin/storage/NotNullLazyValue;", "createLazyValue", "(Lkotlin/jvm/functions/Function0;)Lorg/jetbrains/kotlin/storage/NotNullLazyValue;", "", "onRecursiveCall", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;)Lorg/jetbrains/kotlin/storage/NotNullLazyValue;", "", "postCompute", "createLazyValueWithPostCompute", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)Lorg/jetbrains/kotlin/storage/NotNullLazyValue;", "createMemoizedFunction", "Ljava/util/concurrent/ConcurrentMap;", "map", "(Lkotlin/jvm/functions/Function1;Ljava/util/concurrent/ConcurrentMap;)Lorg/jetbrains/kotlin/storage/MemoizedFunctionToNotNull;", "Lkotlin/Function2;", "(Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function2;)Lorg/jetbrains/kotlin/storage/MemoizedFunctionToNotNull;", "(Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function2;Ljava/util/concurrent/ConcurrentMap;)Lorg/jetbrains/kotlin/storage/MemoizedFunctionToNotNull;", "createMemoizedFunctionWithNullableValues", "(Lkotlin/jvm/functions/Function1;Ljava/util/concurrent/ConcurrentMap;)Lorg/jetbrains/kotlin/storage/MemoizedFunctionToNullable;", "Lorg/jetbrains/kotlin/storage/NullableLazyValue;", "createNullableLazyValue", "(Lkotlin/jvm/functions/Function0;)Lorg/jetbrains/kotlin/storage/NullableLazyValue;", "createNullableLazyValueWithPostCompute", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;)Lorg/jetbrains/kotlin/storage/NullableLazyValue;", "createRecursionTolerantLazyValue", "(Lkotlin/jvm/functions/Function0;Ljava/lang/Object;)Lorg/jetbrains/kotlin/storage/NotNullLazyValue;", "createRecursionTolerantNullableLazyValue", "(Lkotlin/jvm/functions/Function0;Ljava/lang/Object;)Lorg/jetbrains/kotlin/storage/NullableLazyValue;", "Lorg/jetbrains/kotlin/storage/StorageManager;", "LockProtectedContext", "LockProtectedTrace"})
public final class LockBasedLazyResolveStorageManager
implements LazyResolveStorageManager {
    @NotNull
    private final StorageManager storageManager;

    public LockBasedLazyResolveStorageManager(@NotNull StorageManager storageManager) {
        Intrinsics.checkNotNullParameter(storageManager, "storageManager");
        this.storageManager = storageManager;
    }

    @NotNull
    public <K, V> MemoizedFunctionToNotNull<K, V> createSoftlyRetainedMemoizedFunction(@NotNull Function1<? super K, ? extends V> compute) {
        Intrinsics.checkNotNullParameter(compute, "compute");
        ConcurrentMap concurrentMap = ContainerUtil.createConcurrentSoftValueMap();
        Intrinsics.checkNotNullExpressionValue(concurrentMap, "createConcurrentSoftValueMap(...)");
        return this.storageManager.createMemoizedFunction(compute, concurrentMap);
    }

    @NotNull
    public <K, V> MemoizedFunctionToNullable<K, V> createSoftlyRetainedMemoizedFunctionWithNullableValues(@NotNull Function1<? super K, ? extends V> compute) {
        Intrinsics.checkNotNullParameter(compute, "compute");
        ConcurrentMap concurrentMap = ContainerUtil.createConcurrentSoftValueMap();
        Intrinsics.checkNotNullExpressionValue(concurrentMap, "createConcurrentSoftValueMap(...)");
        return this.storageManager.createMemoizedFunctionWithNullableValues(compute, concurrentMap);
    }

    @Override
    @NotNull
    public BindingTrace createSafeTrace(@NotNull BindingTrace originalTrace) {
        Intrinsics.checkNotNullParameter(originalTrace, "originalTrace");
        return new LockProtectedTrace(this.storageManager, originalTrace);
    }

    @Override
    @NotNull
    public <K, V> MemoizedFunctionToNotNull<K, V> createMemoizedFunction(@NotNull Function1<? super K, ? extends V> compute) {
        Intrinsics.checkNotNullParameter(compute, "compute");
        return this.storageManager.createMemoizedFunction(compute);
    }

    @Override
    @NotNull
    public <K, V> MemoizedFunctionToNotNull<K, V> createMemoizedFunction(@NotNull Function1<? super K, ? extends V> compute, @NotNull Function2<? super K, ? super Boolean, ? extends V> onRecursiveCall) {
        Intrinsics.checkNotNullParameter(compute, "compute");
        Intrinsics.checkNotNullParameter(onRecursiveCall, "onRecursiveCall");
        return this.storageManager.createMemoizedFunction(compute, onRecursiveCall);
    }

    @Override
    @NotNull
    public <K, V> MemoizedFunctionToNotNull<K, V> createMemoizedFunction(@NotNull Function1<? super K, ? extends V> compute, @NotNull ConcurrentMap<K, Object> map2) {
        Intrinsics.checkNotNullParameter(compute, "compute");
        Intrinsics.checkNotNullParameter(map2, "map");
        return this.storageManager.createMemoizedFunction(compute, map2);
    }

    @Override
    @NotNull
    public <K, V> MemoizedFunctionToNotNull<K, V> createMemoizedFunction(@NotNull Function1<? super K, ? extends V> compute, @NotNull Function2<? super K, ? super Boolean, ? extends V> onRecursiveCall, @NotNull ConcurrentMap<K, Object> map2) {
        Intrinsics.checkNotNullParameter(compute, "compute");
        Intrinsics.checkNotNullParameter(onRecursiveCall, "onRecursiveCall");
        Intrinsics.checkNotNullParameter(map2, "map");
        return this.storageManager.createMemoizedFunction(compute, onRecursiveCall, map2);
    }

    @Override
    @NotNull
    public <K, V> MemoizedFunctionToNullable<K, V> createMemoizedFunctionWithNullableValues(@NotNull Function1<? super K, ? extends V> compute) {
        Intrinsics.checkNotNullParameter(compute, "compute");
        return this.storageManager.createMemoizedFunctionWithNullableValues(compute);
    }

    @Override
    @NotNull
    public <K, V> MemoizedFunctionToNullable<K, V> createMemoizedFunctionWithNullableValues(@NotNull Function1<? super K, ? extends V> compute, @NotNull ConcurrentMap<K, Object> map2) {
        Intrinsics.checkNotNullParameter(compute, "compute");
        Intrinsics.checkNotNullParameter(map2, "map");
        return this.storageManager.createMemoizedFunctionWithNullableValues(compute, map2);
    }

    @Override
    @NotNull
    public <K, V> CacheWithNullableValues<K, V> createCacheWithNullableValues() {
        return this.storageManager.createCacheWithNullableValues();
    }

    @Override
    @NotNull
    public <K, V> CacheWithNotNullValues<K, V> createCacheWithNotNullValues() {
        return this.storageManager.createCacheWithNotNullValues();
    }

    @Override
    @NotNull
    public <T> NotNullLazyValue<T> createLazyValue(@NotNull Function0<? extends T> computable) {
        Intrinsics.checkNotNullParameter(computable, "computable");
        return this.storageManager.createLazyValue(computable);
    }

    @Override
    @NotNull
    public <T> NotNullLazyValue<T> createLazyValue(@NotNull Function0<? extends T> computable, @NotNull Function1<? super Boolean, ? extends T> onRecursiveCall) {
        Intrinsics.checkNotNullParameter(computable, "computable");
        Intrinsics.checkNotNullParameter(onRecursiveCall, "onRecursiveCall");
        return this.storageManager.createLazyValue(computable, onRecursiveCall);
    }

    @Override
    @NotNull
    public <T> NotNullLazyValue<T> createRecursionTolerantLazyValue(@NotNull Function0<? extends T> computable, @NotNull T onRecursiveCall) {
        Intrinsics.checkNotNullParameter(computable, "computable");
        Intrinsics.checkNotNullParameter(onRecursiveCall, "onRecursiveCall");
        return this.storageManager.createRecursionTolerantLazyValue(computable, onRecursiveCall);
    }

    @Override
    @NotNull
    public <T> NotNullLazyValue<T> createLazyValueWithPostCompute(@NotNull Function0<? extends T> computable, @Nullable Function1<? super Boolean, ? extends T> onRecursiveCall, @NotNull Function1<? super T, Unit> postCompute) {
        Intrinsics.checkNotNullParameter(computable, "computable");
        Intrinsics.checkNotNullParameter(postCompute, "postCompute");
        return this.storageManager.createLazyValueWithPostCompute(computable, onRecursiveCall, postCompute);
    }

    @Override
    @NotNull
    public <T> NullableLazyValue<T> createNullableLazyValue(@NotNull Function0<? extends T> computable) {
        Intrinsics.checkNotNullParameter(computable, "computable");
        return this.storageManager.createNullableLazyValue(computable);
    }

    @Override
    @NotNull
    public <T> NullableLazyValue<T> createRecursionTolerantNullableLazyValue(@NotNull Function0<? extends T> computable, @Nullable T onRecursiveCall) {
        Intrinsics.checkNotNullParameter(computable, "computable");
        return this.storageManager.createRecursionTolerantNullableLazyValue(computable, onRecursiveCall);
    }

    @Override
    @NotNull
    public <T> NullableLazyValue<T> createNullableLazyValueWithPostCompute(@NotNull Function0<? extends T> computable, @NotNull Function1<? super T, Unit> postCompute) {
        Intrinsics.checkNotNullParameter(computable, "computable");
        Intrinsics.checkNotNullParameter(postCompute, "postCompute");
        return this.storageManager.createNullableLazyValueWithPostCompute(computable, postCompute);
    }

    @Override
    public <T> T compute(@NotNull Function0<? extends T> computable) {
        Intrinsics.checkNotNullParameter(computable, "computable");
        return this.storageManager.compute(computable);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0019\u0010\n\u001a\u0004\u0018\u00010\t2\u0006\u0010\b\u001a\u00020\u0007H\u0017\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\r\u001a\u00020\fH\u0017\u00a2\u0006\u0004\b\r\u0010\u000eJ:\u0010\u0014\u001a\u0004\u0018\u00018\u0001\"\u0004\b\u0000\u0010\u000f\"\u0004\b\u0001\u0010\u00102\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00112\u0006\u0010\u0013\u001a\u00028\u0000H\u0097\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J9\u0010\u0018\u001a\f\u0012\b\u0012\u0006*\u00028\u00008\u00000\u0017\"\u0004\b\u0000\u0010\u000f\"\u0004\b\u0001\u0010\u00102\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0016H\u0017\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001f\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001cH\u0016\u00a2\u0006\u0004\b\u001f\u0010 JC\u0010\"\u001a\u0016\u0012\b\u0012\u0006*\u00028\u00008\u0000\u0012\b\u0012\u0006*\u00028\u00018\u00010!\"\u0004\b\u0000\u0010\u000f\"\u0004\b\u0001\u0010\u00102\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0011H\u0017\u00a2\u0006\u0004\b\"\u0010#J\u0011\u0010%\u001a\u0004\u0018\u00010$H\u0017\u00a2\u0006\u0004\b%\u0010&R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010'R\u0014\u0010\u0004\u001a\u00020\u00018\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010("}, d2={"Lorg/jetbrains/kotlin/storage/LockBasedLazyResolveStorageManager$LockProtectedContext;", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "Lorg/jetbrains/kotlin/storage/StorageManager;", "storageManager", "context", "<init>", "(Lorg/jetbrains/kotlin/storage/StorageManager;Lorg/jetbrains/kotlin/resolve/BindingContext;)V", "Lorg/jetbrains/kotlin/psi/KtExpression;", "expression", "Lorg/jetbrains/kotlin/types/KotlinType;", "getType", "(Lorg/jetbrains/kotlin/psi/KtExpression;)Lorg/jetbrains/kotlin/types/KotlinType;", "Lorg/jetbrains/kotlin/resolve/diagnostics/Diagnostics;", "getDiagnostics", "()Lorg/jetbrains/kotlin/resolve/diagnostics/Diagnostics;", "K", "V", "Lorg/jetbrains/kotlin/util/slicedMap/ReadOnlySlice;", "slice", "key", "get", "(Lorg/jetbrains/kotlin/util/slicedMap/ReadOnlySlice;Ljava/lang/Object;)Ljava/lang/Object;", "Lorg/jetbrains/kotlin/util/slicedMap/WritableSlice;", "", "getKeys", "(Lorg/jetbrains/kotlin/util/slicedMap/WritableSlice;)Ljava/util/Collection;", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "trace", "", "commitDiagnostics", "", "addOwnDataTo", "(Lorg/jetbrains/kotlin/resolve/BindingTrace;Z)V", "Lcom/google/common/collect/ImmutableMap;", "getSliceContents", "(Lorg/jetbrains/kotlin/util/slicedMap/ReadOnlySlice;)Lcom/google/common/collect/ImmutableMap;", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "Lorg/jetbrains/kotlin/storage/StorageManager;", "Lorg/jetbrains/kotlin/resolve/BindingContext;"})
    private static final class LockProtectedContext
    implements BindingContext {
        @NotNull
        private final StorageManager storageManager;
        @NotNull
        private final BindingContext context;

        public LockProtectedContext(@NotNull StorageManager storageManager, @NotNull BindingContext context) {
            Intrinsics.checkNotNullParameter(storageManager, "storageManager");
            Intrinsics.checkNotNullParameter(context, "context");
            this.storageManager = storageManager;
            this.context = context;
        }

        @Override
        @Nullable
        public KotlinType getType(@NotNull KtExpression expression) {
            Intrinsics.checkNotNullParameter(expression, "expression");
            return this.storageManager.compute(() -> LockProtectedContext.getType$lambda$0(this, expression));
        }

        @Override
        @NotNull
        public Diagnostics getDiagnostics() {
            Diagnostics diagnostics = this.storageManager.compute(() -> LockProtectedContext.getDiagnostics$lambda$1(this));
            Intrinsics.checkNotNullExpressionValue(diagnostics, "compute(...)");
            return diagnostics;
        }

        @Override
        @Nullable
        public <K, V> V get(@NotNull ReadOnlySlice<K, V> slice, K key) {
            Intrinsics.checkNotNullParameter(slice, "slice");
            return (V)this.storageManager.compute(() -> LockProtectedContext.get$lambda$2(this, slice, key));
        }

        @Override
        @NotNull
        public <K, V> Collection<K> getKeys(@NotNull WritableSlice<K, V> slice) {
            Intrinsics.checkNotNullParameter(slice, "slice");
            Collection collection = this.storageManager.compute(() -> LockProtectedContext.getKeys$lambda$3(this, slice));
            Intrinsics.checkNotNullExpressionValue(collection, "compute(...)");
            return collection;
        }

        @Override
        public void addOwnDataTo(@NotNull BindingTrace trace, boolean commitDiagnostics) {
            Intrinsics.checkNotNullParameter(trace, "trace");
            this.storageManager.compute(() -> LockProtectedContext.addOwnDataTo$lambda$4(this, trace, commitDiagnostics));
        }

        @Override
        @NotNull
        public <K, V> ImmutableMap<K, V> getSliceContents(@NotNull ReadOnlySlice<K, V> slice) {
            Intrinsics.checkNotNullParameter(slice, "slice");
            ImmutableMap immutableMap = this.storageManager.compute(() -> LockProtectedContext.getSliceContents$lambda$5(this, slice));
            Intrinsics.checkNotNullExpressionValue(immutableMap, "compute(...)");
            return immutableMap;
        }

        @Override
        @Nullable
        public Project getProject() {
            return this.context.getProject();
        }

        private static final KotlinType getType$lambda$0(LockProtectedContext this$0, KtExpression $expression) {
            return this$0.context.getType($expression);
        }

        private static final Diagnostics getDiagnostics$lambda$1(LockProtectedContext this$0) {
            return this$0.context.getDiagnostics();
        }

        private static final Object get$lambda$2(LockProtectedContext this$0, ReadOnlySlice $slice, Object $key) {
            return this$0.context.get($slice, $key);
        }

        private static final Collection getKeys$lambda$3(LockProtectedContext this$0, WritableSlice $slice) {
            return this$0.context.getKeys($slice);
        }

        private static final Unit addOwnDataTo$lambda$4(LockProtectedContext this$0, BindingTrace $trace, boolean $commitDiagnostics) {
            this$0.context.addOwnDataTo($trace, $commitDiagnostics);
            return Unit.INSTANCE;
        }

        private static final ImmutableMap getSliceContents$lambda$5(LockProtectedContext this$0, ReadOnlySlice $slice) {
            return this$0.context.getSliceContents($slice);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0005\u0010\u0006J!\u0010\f\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u00072\b\u0010\n\u001a\u0004\u0018\u00010\tH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u0019\u0010\u000e\u001a\u0004\u0018\u00010\t2\u0006\u0010\b\u001a\u00020\u0007H\u0017\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0011\u001a\u00020\u0010H\u0017\u00a2\u0006\u0004\b\u0011\u0010\u0012J?\u0010\u0019\u001a\u00020\u000b\"\u0004\b\u0000\u0010\u0013\"\u0004\b\u0001\u0010\u00142\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00152\u0006\u0010\u0017\u001a\u00028\u00002\u0006\u0010\u0018\u001a\u00028\u0001H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ1\u0010\u0019\u001a\u00020\u000b\"\u0004\b\u0000\u0010\u00132\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u001b0\u00152\u0006\u0010\u0017\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001cJ:\u0010\u001e\u001a\u0004\u0018\u00018\u0001\"\u0004\b\u0000\u0010\u0013\"\u0004\b\u0001\u0010\u00142\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u001d2\u0006\u0010\u0017\u001a\u00028\u0000H\u0097\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ5\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00000 \"\u0004\b\u0000\u0010\u0013\"\u0004\b\u0001\u0010\u00142\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0015H\u0017\u00a2\u0006\u0004\b!\u0010\"J\u0017\u0010%\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020#H\u0016\u00a2\u0006\u0004\b%\u0010&J\u000f\u0010'\u001a\u00020\u001bH\u0016\u00a2\u0006\u0004\b'\u0010(J\u000f\u0010*\u001a\u00020)H\u0017\u00a2\u0006\u0004\b*\u0010+J\u0011\u0010-\u001a\u0004\u0018\u00010,H\u0017\u00a2\u0006\u0004\b-\u0010.R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010/R\u0014\u0010\u0004\u001a\u00020\u00018\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u00100R\u0014\u00101\u001a\u00020\u00108\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b1\u00102"}, d2={"Lorg/jetbrains/kotlin/storage/LockBasedLazyResolveStorageManager$LockProtectedTrace;", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "Lorg/jetbrains/kotlin/storage/StorageManager;", "storageManager", "trace", "<init>", "(Lorg/jetbrains/kotlin/storage/StorageManager;Lorg/jetbrains/kotlin/resolve/BindingTrace;)V", "Lorg/jetbrains/kotlin/psi/KtExpression;", "expression", "Lorg/jetbrains/kotlin/types/KotlinType;", "type", "", "recordType", "(Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/types/KotlinType;)V", "getType", "(Lorg/jetbrains/kotlin/psi/KtExpression;)Lorg/jetbrains/kotlin/types/KotlinType;", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "getBindingContext", "()Lorg/jetbrains/kotlin/resolve/BindingContext;", "K", "V", "Lorg/jetbrains/kotlin/util/slicedMap/WritableSlice;", "slice", "key", "value", "record", "(Lorg/jetbrains/kotlin/util/slicedMap/WritableSlice;Ljava/lang/Object;Ljava/lang/Object;)V", "", "(Lorg/jetbrains/kotlin/util/slicedMap/WritableSlice;Ljava/lang/Object;)V", "Lorg/jetbrains/kotlin/util/slicedMap/ReadOnlySlice;", "get", "(Lorg/jetbrains/kotlin/util/slicedMap/ReadOnlySlice;Ljava/lang/Object;)Ljava/lang/Object;", "", "getKeys", "(Lorg/jetbrains/kotlin/util/slicedMap/WritableSlice;)Ljava/util/Collection;", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "diagnostic", "report", "(Lorg/jetbrains/kotlin/diagnostics/Diagnostic;)V", "wantsDiagnostics", "()Z", "", "toString", "()Ljava/lang/String;", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "Lorg/jetbrains/kotlin/storage/StorageManager;", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;"})
    private static final class LockProtectedTrace
    implements BindingTrace {
        @NotNull
        private final StorageManager storageManager;
        @NotNull
        private final BindingTrace trace;
        @NotNull
        private final BindingContext context;

        public LockProtectedTrace(@NotNull StorageManager storageManager, @NotNull BindingTrace trace) {
            Intrinsics.checkNotNullParameter(storageManager, "storageManager");
            Intrinsics.checkNotNullParameter(trace, "trace");
            this.storageManager = storageManager;
            this.trace = trace;
            BindingContext bindingContext = this.trace.getBindingContext();
            Intrinsics.checkNotNullExpressionValue(bindingContext, "getBindingContext(...)");
            this.context = new LockProtectedContext(this.storageManager, bindingContext);
        }

        @Override
        public void recordType(@NotNull KtExpression expression, @Nullable KotlinType type2) {
            Intrinsics.checkNotNullParameter(expression, "expression");
            this.storageManager.compute(() -> LockProtectedTrace.recordType$lambda$0(this, expression, type2));
        }

        @Override
        @Nullable
        public KotlinType getType(@NotNull KtExpression expression) {
            Intrinsics.checkNotNullParameter(expression, "expression");
            return this.storageManager.compute(() -> LockProtectedTrace.getType$lambda$1(this, expression));
        }

        @Override
        @NotNull
        public BindingContext getBindingContext() {
            return this.context;
        }

        @Override
        public <K, V> void record(@NotNull WritableSlice<K, V> slice, K key, V value2) {
            Intrinsics.checkNotNullParameter(slice, "slice");
            this.storageManager.compute(() -> LockProtectedTrace.record$lambda$2(this, slice, key, value2));
        }

        @Override
        public <K> void record(@NotNull WritableSlice<K, Boolean> slice, K key) {
            Intrinsics.checkNotNullParameter(slice, "slice");
            this.storageManager.compute(() -> LockProtectedTrace.record$lambda$3(this, slice, key));
        }

        @Override
        @Nullable
        public <K, V> V get(@NotNull ReadOnlySlice<K, V> slice, K key) {
            Intrinsics.checkNotNullParameter(slice, "slice");
            return (V)this.storageManager.compute(() -> LockProtectedTrace.get$lambda$4(this, slice, key));
        }

        @Override
        @NotNull
        public <K, V> Collection<K> getKeys(@NotNull WritableSlice<K, V> slice) {
            Intrinsics.checkNotNullParameter(slice, "slice");
            Collection collection = this.storageManager.compute(() -> LockProtectedTrace.getKeys$lambda$5(this, slice));
            Intrinsics.checkNotNullExpressionValue(collection, "compute(...)");
            return collection;
        }

        @Override
        public void report(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkNotNullParameter(diagnostic, "diagnostic");
            this.storageManager.compute(() -> LockProtectedTrace.report$lambda$6(this, diagnostic));
        }

        @Override
        public boolean wantsDiagnostics() {
            return this.trace.wantsDiagnostics();
        }

        @NotNull
        public String toString() {
            return "Lock-protected trace of LockBasedLazyResolveStorageManager " + this.storageManager;
        }

        @Override
        @Nullable
        public Project getProject() {
            return this.trace.getProject();
        }

        private static final Unit recordType$lambda$0(LockProtectedTrace this$0, KtExpression $expression, KotlinType $type) {
            this$0.trace.recordType($expression, $type);
            return Unit.INSTANCE;
        }

        private static final KotlinType getType$lambda$1(LockProtectedTrace this$0, KtExpression $expression) {
            return this$0.trace.getType($expression);
        }

        private static final Unit record$lambda$2(LockProtectedTrace this$0, WritableSlice $slice, Object $key, Object $value) {
            this$0.trace.record($slice, $key, $value);
            return Unit.INSTANCE;
        }

        private static final Unit record$lambda$3(LockProtectedTrace this$0, WritableSlice $slice, Object $key) {
            this$0.trace.record($slice, $key);
            return Unit.INSTANCE;
        }

        private static final Object get$lambda$4(LockProtectedTrace this$0, ReadOnlySlice $slice, Object $key) {
            return this$0.trace.get($slice, $key);
        }

        private static final Collection getKeys$lambda$5(LockProtectedTrace this$0, WritableSlice $slice) {
            return this$0.trace.getKeys($slice);
        }

        private static final Unit report$lambda$6(LockProtectedTrace this$0, Diagnostic $diagnostic) {
            this$0.trace.report($diagnostic);
            return Unit.INSTANCE;
        }
    }
}

