/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types;

import com.google.common.collect.Maps;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.PlatformSpecificCastChecker;
import org.jetbrains.kotlin.builtins.PlatformToKotlinClassMapper;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.psi.KtAnnotatedExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionImpl;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.IntersectionTypeConstructor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeIntersector;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeReconstructionResult;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUnifier;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.checker.TypeCheckingProcedure;
import org.jetbrains.kotlin.types.expressions.DataFlowAnalyzer;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\b\f\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\f\u0010\rJ'\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J%\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0017\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u0018J%\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001c\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u001f\u0010#\u001a\u00020\"2\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010!\u001a\u00020 H\u0007\u00a2\u0006\u0004\b#\u0010$J\u0017\u0010%\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b%\u0010\u0018J-\u0010,\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020&2\u0006\u0010)\u001a\u00020(2\u0006\u0010*\u001a\u00020\u00042\u0006\u0010+\u001a\u00020\u0004\u00a2\u0006\u0004\b,\u0010-J+\u00101\u001a\u00020\u000b2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00040.2\u0006\u0010*\u001a\u00020\u00042\u0006\u00100\u001a\u00020\u000b\u00a2\u0006\u0004\b1\u00102J\u001f\u00100\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020&2\u0006\u00103\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b0\u00104J\u001f\u00106\u001a\u00020\u000b2\u0006\u00105\u001a\u00020\u00042\u0006\u0010*\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b6\u00107J\u001f\u00108\u001a\u00020\u000b2\u0006\u00105\u001a\u00020\u00042\u0006\u0010*\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b8\u00107J\u0017\u00109\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020&H\u0002\u00a2\u0006\u0004\b9\u0010:"}, d2={"Lorg/jetbrains/kotlin/types/CastDiagnosticsUtil;", "", "<init>", "()V", "Lorg/jetbrains/kotlin/types/KotlinType;", "lhsType", "rhsType", "Lorg/jetbrains/kotlin/builtins/PlatformToKotlinClassMapper;", "platformToKotlinClassMapper", "Lorg/jetbrains/kotlin/builtins/PlatformSpecificCastChecker;", "platformSpecificCastChecker", "", "isCastPossible", "(Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/builtins/PlatformToKotlinClassMapper;Lorg/jetbrains/kotlin/builtins/PlatformSpecificCastChecker;)Z", "a", "b", "isRelated", "(Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/builtins/PlatformToKotlinClassMapper;)Z", "type", "", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "mapToPlatformIndependentClasses", "(Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/builtins/PlatformToKotlinClassMapper;)Ljava/util/List;", "isFinal", "(Lorg/jetbrains/kotlin/types/KotlinType;)Z", "isTrait", "supertype", "subtype", "Lorg/jetbrains/kotlin/types/checker/KotlinTypeChecker;", "typeChecker", "isCastErased", "(Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/types/checker/KotlinTypeChecker;)Z", "Lorg/jetbrains/kotlin/types/TypeConstructor;", "subtypeConstructor", "Lorg/jetbrains/kotlin/types/TypeReconstructionResult;", "findStaticallyKnownSubtype", "(Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/types/TypeConstructor;)Lorg/jetbrains/kotlin/types/TypeReconstructionResult;", "allParametersReified", "Lorg/jetbrains/kotlin/psi/KtBinaryExpressionWithTypeRHS;", "expression", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;", "context", "targetType", "actualType", "castIsUseless", "(Lorg/jetbrains/kotlin/psi/KtBinaryExpressionWithTypeRHS;Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/types/KotlinType;)Z", "", "possibleTypes", "shouldCheckForExactType", "isRefinementUseless", "(Ljava/util/Collection;Lorg/jetbrains/kotlin/types/KotlinType;Z)Z", "expectedType", "(Lorg/jetbrains/kotlin/psi/KtBinaryExpressionWithTypeRHS;Lorg/jetbrains/kotlin/types/KotlinType;)Z", "candidateType", "isExactTypeCast", "(Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/types/KotlinType;)Z", "isUpcast", "checkExactTypeForUselessCast", "(Lorg/jetbrains/kotlin/psi/KtBinaryExpressionWithTypeRHS;)Z"})
public final class CastDiagnosticsUtil {
    @NotNull
    public static final CastDiagnosticsUtil INSTANCE = new CastDiagnosticsUtil();

    private CastDiagnosticsUtil() {
    }

    public static final boolean isCastPossible(@NotNull KotlinType lhsType, @NotNull KotlinType rhsType, @NotNull PlatformToKotlinClassMapper platformToKotlinClassMapper, @NotNull PlatformSpecificCastChecker platformSpecificCastChecker) {
        Intrinsics.checkNotNullParameter(lhsType, "lhsType");
        Intrinsics.checkNotNullParameter(rhsType, "rhsType");
        Intrinsics.checkNotNullParameter(platformToKotlinClassMapper, "platformToKotlinClassMapper");
        Intrinsics.checkNotNullParameter(platformSpecificCastChecker, "platformSpecificCastChecker");
        TypeConstructor typeConstructor2 = lhsType.getConstructor();
        if (typeConstructor2 instanceof IntersectionTypeConstructor) {
            boolean bl;
            block14: {
                Iterable $this$any$iv = ((IntersectionTypeConstructor)typeConstructor2).getSupertypes();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        KotlinType it = (KotlinType)element$iv;
                        boolean bl2 = false;
                        if (!CastDiagnosticsUtil.isCastPossible(it, rhsType, platformToKotlinClassMapper, platformSpecificCastChecker)) continue;
                        bl = true;
                        break block14;
                    }
                    bl = false;
                }
            }
            return bl;
        }
        boolean rhsNullable = TypeUtils.isNullableType(rhsType);
        boolean lhsNullable = TypeUtils.isNullableType(lhsType);
        if (KotlinBuiltIns.isNothing(lhsType)) {
            return true;
        }
        if (KotlinBuiltIns.isNullableNothing(lhsType) && !rhsNullable) {
            return false;
        }
        if (KotlinBuiltIns.isNothing(rhsType)) {
            return false;
        }
        if (KotlinBuiltIns.isNullableNothing(rhsType)) {
            return lhsNullable;
        }
        if (lhsNullable && rhsNullable) {
            return true;
        }
        if (KotlinTypeKt.isError(lhsType)) {
            return true;
        }
        if (INSTANCE.isRelated(lhsType, rhsType, platformToKotlinClassMapper)) {
            return true;
        }
        if (TypeUtils.isTypeParameter(lhsType) || TypeUtils.isTypeParameter(rhsType)) {
            return true;
        }
        if (platformSpecificCastChecker.isCastPossible(lhsType, rhsType)) {
            return true;
        }
        if (INSTANCE.isFinal(lhsType) || INSTANCE.isFinal(rhsType)) {
            return false;
        }
        return INSTANCE.isTrait(lhsType) || INSTANCE.isTrait(rhsType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isRelated(KotlinType a, KotlinType b, PlatformToKotlinClassMapper platformToKotlinClassMapper) {
        ClassDescriptor it;
        boolean bl;
        List<ClassDescriptor> aClasses = this.mapToPlatformIndependentClasses(a, platformToKotlinClassMapper);
        List<ClassDescriptor> bClasses = this.mapToPlatformIndependentClasses(b, platformToKotlinClassMapper);
        Iterable $this$any$iv = aClasses;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            bl = false;
        } else {
            for (Object element$iv : $this$any$iv) {
                it = (ClassDescriptor)element$iv;
                boolean bl2 = false;
                if (!DescriptorUtils.isSubtypeOfClass(b, it)) continue;
                return true;
            }
            bl = false;
        }
        if (bl) return true;
        $this$any$iv = bClasses;
        $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            Object element$iv;
            if (!iterator2.hasNext()) return false;
            element$iv = iterator2.next();
            it = (ClassDescriptor)element$iv;
            boolean bl3 = false;
        } while (!DescriptorUtils.isSubtypeOfClass(a, it));
        return true;
    }

    private final List<ClassDescriptor> mapToPlatformIndependentClasses(KotlinType type2, PlatformToKotlinClassMapper platformToKotlinClassMapper) {
        ClassifierDescriptor classifierDescriptor = type2.getConstructor().getDeclarationDescriptor();
        ClassDescriptor classDescriptor = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
        if (classDescriptor == null) {
            return CollectionsKt.emptyList();
        }
        ClassDescriptor descriptor2 = classDescriptor;
        Collection<ClassDescriptor> collection = platformToKotlinClassMapper.mapPlatformClass(descriptor2);
        Intrinsics.checkNotNullExpressionValue(collection, "mapPlatformClass(...)");
        return CollectionsKt.plus(collection, descriptor2);
    }

    private final boolean isFinal(KotlinType type2) {
        return !TypeUtils.canHaveSubtypes(KotlinTypeChecker.DEFAULT, type2);
    }

    private final boolean isTrait(KotlinType type2) {
        ClassifierDescriptor it = type2.getConstructor().getDeclarationDescriptor();
        boolean bl = false;
        return it instanceof ClassDescriptor && ((ClassDescriptor)it).getKind() == ClassKind.INTERFACE;
    }

    public static final boolean isCastErased(@NotNull KotlinType supertype, @NotNull KotlinType subtype, @NotNull KotlinTypeChecker typeChecker) {
        Intrinsics.checkNotNullParameter(supertype, "supertype");
        Intrinsics.checkNotNullParameter(subtype, "subtype");
        Intrinsics.checkNotNullParameter(typeChecker, "typeChecker");
        boolean isNonReifiedTypeParameter = TypeUtils.isNonReifiedTypeParameter(subtype);
        boolean isUpcast = typeChecker.isSubtypeOf(supertype, subtype);
        if (isNonReifiedTypeParameter && !isUpcast) {
            boolean nullableToDefinitelyNotNull;
            boolean bl = nullableToDefinitelyNotNull = !TypeUtils.isNullableType(subtype) && Intrinsics.areEqual(TypeUtilsKt.makeNotNullable(supertype), subtype);
            if (!nullableToDefinitelyNotNull) {
                return true;
            }
        }
        if (supertype.isMarkedNullable() || subtype.isMarkedNullable()) {
            KotlinType kotlinType = TypeUtils.makeNotNullable(supertype);
            Intrinsics.checkNotNullExpressionValue(kotlinType, "makeNotNullable(...)");
            KotlinType kotlinType2 = TypeUtils.makeNotNullable(subtype);
            Intrinsics.checkNotNullExpressionValue(kotlinType2, "makeNotNullable(...)");
            return CastDiagnosticsUtil.isCastErased(kotlinType, kotlinType2, typeChecker);
        }
        if (isUpcast) {
            return false;
        }
        if (isNonReifiedTypeParameter) {
            return true;
        }
        if (INSTANCE.allParametersReified(subtype)) {
            return false;
        }
        KotlinType kotlinType = CastDiagnosticsUtil.findStaticallyKnownSubtype(supertype, subtype.getConstructor()).getResultingType();
        if (kotlinType == null) {
            return true;
        }
        KotlinType staticallyKnownSubtype = kotlinType;
        return !typeChecker.isSubtypeOf(staticallyKnownSubtype, subtype);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final TypeReconstructionResult findStaticallyKnownSubtype(@NotNull KotlinType supertype, @NotNull TypeConstructor subtypeConstructor) {
        Map map2;
        HashMap<Object, Object> $i$f$map2;
        void $this$mapTo$iv$iv;
        boolean bl;
        Intrinsics.checkNotNullParameter(supertype, "supertype");
        Intrinsics.checkNotNullParameter(subtypeConstructor, "subtypeConstructor");
        boolean bl2 = bl = !supertype.isMarkedNullable();
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-CastDiagnosticsUtil$findStaticallyKnownSubtype$22 = false;
            String $i$a$-assert-CastDiagnosticsUtil$findStaticallyKnownSubtype$22 = "This method only makes sense for non-nullable types";
            throw new AssertionError((Object)$i$a$-assert-CastDiagnosticsUtil$findStaticallyKnownSubtype$22);
        }
        ClassifierDescriptor classifierDescriptor = subtypeConstructor.getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            throw new IllegalStateException(("Can't create default type for " + subtypeConstructor).toString());
        }
        ClassifierDescriptor descriptor2 = classifierDescriptor;
        SimpleType simpleType2 = descriptor2.getDefaultType();
        Intrinsics.checkNotNullExpressionValue(simpleType2, "getDefaultType(...)");
        SimpleType subtypeWithVariables = simpleType2;
        KotlinType supertypeWithVariables = TypeCheckingProcedure.findCorrespondingSupertype(subtypeWithVariables, supertype);
        List<TypeParameterDescriptor> list = subtypeWithVariables.getConstructor().getParameters();
        Intrinsics.checkNotNullExpressionValue(list, "getParameters(...)");
        List<TypeParameterDescriptor> variables = list;
        Iterable $this$map$iv = variables;
        boolean $i$f$map2 = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            collection.add(p0.getTypeConstructor());
        }
        Set variableConstructors = CollectionsKt.toSet((List)destination$iv$iv);
        if (supertypeWithVariables != null) {
            TypeUnifier.UnificationResult unificationResult = TypeUnifier.unify(new TypeProjectionImpl(supertype), new TypeProjectionImpl(supertypeWithVariables), variableConstructors::contains);
            Intrinsics.checkNotNullExpressionValue(unificationResult, "unify(...)");
            TypeUnifier.UnificationResult solution = unificationResult;
            $i$f$map2 = Maps.newHashMap(solution.getSubstitution());
            Intrinsics.checkNotNull($i$f$map2);
            map2 = $i$f$map2;
        } else {
            $i$f$map2 = Maps.newHashMapWithExpectedSize(variables.size());
            Intrinsics.checkNotNull($i$f$map2);
            map2 = $i$f$map2;
        }
        Map substitution = map2;
        boolean allArgumentsInferred = true;
        for (TypeParameterDescriptor variable : variables) {
            TypeProjection value2 = (TypeProjection)substitution.get(variable.getTypeConstructor());
            if (value2 != null) continue;
            TypeConstructor typeConstructor2 = variable.getTypeConstructor();
            Intrinsics.checkNotNullExpressionValue(typeConstructor2, "getTypeConstructor(...)");
            TypeProjection typeProjection = TypeUtils.makeStarProjection(variable);
            Intrinsics.checkNotNullExpressionValue(typeProjection, "makeStarProjection(...)");
            substitution.put(typeConstructor2, typeProjection);
            allArgumentsInferred = false;
        }
        KotlinType substituted = TypeSubstitutor.create(substitution).substitute(subtypeWithVariables, Variance.INVARIANT);
        return new TypeReconstructionResult(substituted, allArgumentsInferred);
    }

    private final boolean allParametersReified(KotlinType subtype) {
        boolean bl;
        block3: {
            List<TypeParameterDescriptor> list = subtype.getConstructor().getParameters();
            Intrinsics.checkNotNullExpressionValue(list, "getParameters(...)");
            Iterable $this$all$iv = list;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    TypeParameterDescriptor it = (TypeParameterDescriptor)element$iv;
                    boolean bl2 = false;
                    if (it.isReified()) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    public final boolean castIsUseless(@NotNull KtBinaryExpressionWithTypeRHS expression, @NotNull ExpressionTypingContext context, @NotNull KotlinType targetType, @NotNull KotlinType actualType) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(targetType, "targetType");
        Intrinsics.checkNotNullParameter(actualType, "actualType");
        KotlinType kotlinType = KtPsiUtil.isSafeCast(expression) ? TypeUtils.makeNullable(targetType) : targetType;
        Intrinsics.checkNotNull(kotlinType);
        KotlinType refinedTargetType = kotlinType;
        Collection<KotlinType> collection = DataFlowAnalyzer.getAllPossibleTypes(expression.getLeft(), actualType, context);
        Intrinsics.checkNotNullExpressionValue(collection, "getAllPossibleTypes(...)");
        Collection<KotlinType> possibleTypes = collection;
        KotlinType kotlinType2 = context.expectedType;
        Intrinsics.checkNotNullExpressionValue(kotlinType2, "expectedType");
        return this.isRefinementUseless(possibleTypes, refinedTargetType, this.shouldCheckForExactType(expression, kotlinType2));
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isRefinementUseless(@NotNull Collection<? extends KotlinType> possibleTypes, @NotNull KotlinType targetType, boolean shouldCheckForExactType) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(possibleTypes, "possibleTypes");
        Intrinsics.checkNotNullParameter(targetType, "targetType");
        Iterable $this$map$iv = possibleTypes;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KotlinType kotlinType = (KotlinType)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(FlexibleTypesKt.upperIfFlexible((KotlinType)it));
        }
        KotlinType kotlinType = TypeIntersector.intersectTypes((List)destination$iv$iv);
        if (kotlinType == null) {
            return false;
        }
        KotlinType intersectedType = kotlinType;
        return shouldCheckForExactType ? this.isExactTypeCast(intersectedType, targetType) : this.isUpcast(intersectedType, targetType);
    }

    private final boolean shouldCheckForExactType(KtBinaryExpressionWithTypeRHS expression, KotlinType expectedType) {
        if (TypeUtils.noExpectedType(expectedType)) {
            return this.checkExactTypeForUselessCast(expression);
        }
        return TypeUtils.isDontCarePlaceholder(expectedType);
    }

    private final boolean isExactTypeCast(KotlinType candidateType, KotlinType targetType) {
        return Intrinsics.areEqual(candidateType, targetType) && FunctionTypesKt.isExtensionFunctionType(candidateType) == FunctionTypesKt.isExtensionFunctionType(targetType);
    }

    private final boolean isUpcast(KotlinType candidateType, KotlinType targetType) {
        if (!KotlinTypeChecker.DEFAULT.isSubtypeOf(candidateType, targetType)) {
            return false;
        }
        if (FunctionTypesKt.isFunctionType(candidateType) && FunctionTypesKt.isFunctionType(targetType)) {
            return FunctionTypesKt.isExtensionFunctionType(candidateType) == FunctionTypesKt.isExtensionFunctionType(targetType);
        }
        return true;
    }

    private final boolean checkExactTypeForUselessCast(KtBinaryExpressionWithTypeRHS expression) {
        boolean bl;
        PsiElement parent2 = expression.getParent();
        while (parent2 instanceof KtParenthesizedExpression || parent2 instanceof KtLabeledExpression || parent2 instanceof KtAnnotatedExpression) {
            parent2 = ((KtExpressionImpl)parent2).getParent();
        }
        PsiElement psiElement = parent2;
        if (psiElement instanceof KtValueArgument) {
            bl = true;
        } else if (psiElement instanceof KtQualifiedExpression) {
            KtExpression receiver = ((KtQualifiedExpression)parent2).getReceiverExpression();
            bl = PsiTreeUtil.isAncestor(receiver, expression, false);
        } else {
            bl = psiElement instanceof KtBinaryExpression || psiElement instanceof KtUnaryExpression ? true : psiElement instanceof KtProperty || psiElement instanceof KtPropertyAccessor || psiElement instanceof KtNamedFunction || psiElement instanceof KtFunctionLiteral;
        }
        return bl;
    }
}

