/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.error.ErrorUtils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H'\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\r\u001a\u00020\f2\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u0096\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0010\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0004H$\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001f\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004H\u0004\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0011R\u0016\u0010\b\u001a\u00020\u00078\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\b\u0010\u0018"}, d2={"Lorg/jetbrains/kotlin/types/ClassifierBasedTypeConstructor;", "Lorg/jetbrains/kotlin/types/TypeConstructor;", "<init>", "()V", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "getDeclarationDescriptor", "()Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "", "hashCode", "()I", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "classifier", "isSameClassifier", "(Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;)Z", "first", "second", "areFqNamesEqual", "(Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;)Z", "descriptor", "hasMeaningfulFqName", "I"})
public abstract class ClassifierBasedTypeConstructor
implements TypeConstructor {
    private int hashCode;

    @Override
    @NotNull
    public abstract ClassifierDescriptor getDeclarationDescriptor();

    public int hashCode() {
        int computedHashCode;
        int n;
        int cachedHashCode = this.hashCode;
        if (cachedHashCode != 0) {
            return cachedHashCode;
        }
        ClassifierDescriptor descriptor2 = this.getDeclarationDescriptor();
        int it = n = (computedHashCode = this.hasMeaningfulFqName(descriptor2) ? DescriptorUtils.getFqName(descriptor2).hashCode() : System.identityHashCode(this));
        boolean bl = false;
        this.hashCode = it;
        return n;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TypeConstructor)) {
            return false;
        }
        if (other.hashCode() != this.hashCode()) {
            return false;
        }
        if (((TypeConstructor)other).getParameters().size() != this.getParameters().size()) {
            return false;
        }
        ClassifierDescriptor myDescriptor = this.getDeclarationDescriptor();
        ClassifierDescriptor classifierDescriptor = ((TypeConstructor)other).getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            return false;
        }
        ClassifierDescriptor otherDescriptor = classifierDescriptor;
        if (!this.hasMeaningfulFqName(myDescriptor) || !this.hasMeaningfulFqName(otherDescriptor)) {
            return false;
        }
        return this.isSameClassifier(otherDescriptor);
    }

    protected abstract boolean isSameClassifier(@NotNull ClassifierDescriptor var1);

    protected final boolean areFqNamesEqual(@NotNull ClassifierDescriptor first2, @NotNull ClassifierDescriptor second2) {
        Intrinsics.checkNotNullParameter(first2, "first");
        Intrinsics.checkNotNullParameter(second2, "second");
        if (!Intrinsics.areEqual(first2.getName(), second2.getName())) {
            return false;
        }
        DeclarationDescriptor a = first2.getContainingDeclaration();
        for (DeclarationDescriptor b = second2.getContainingDeclaration(); a != null && b != null; a = a.getContainingDeclaration(), b = b.getContainingDeclaration()) {
            if (a instanceof ModuleDescriptor) {
                return b instanceof ModuleDescriptor;
            }
            if (b instanceof ModuleDescriptor) {
                return false;
            }
            if (a instanceof PackageFragmentDescriptor) {
                return b instanceof PackageFragmentDescriptor && Intrinsics.areEqual(((PackageFragmentDescriptor)a).getFqName(), ((PackageFragmentDescriptor)b).getFqName());
            }
            if (b instanceof PackageFragmentDescriptor) {
                return false;
            }
            if (Intrinsics.areEqual(a.getName(), b.getName())) continue;
            return false;
        }
        return true;
    }

    private final boolean hasMeaningfulFqName(ClassifierDescriptor descriptor2) {
        return !ErrorUtils.isError(descriptor2) && !DescriptorUtils.isLocal(descriptor2);
    }
}

