/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.renderer.DescriptorRendererOptions;
import org.jetbrains.kotlin.types.FlexibleType;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeAttributes;
import org.jetbrains.kotlin.types.TypeWithEnhancement;
import org.jetbrains.kotlin.types.TypeWithEnhancementKt;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.checker.KotlinTypeRefiner;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\bH\u0017\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\rH\u0017\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001f\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0013H\u0017\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0018H\u0017\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u000f\u0010\u001c\u001a\u00020\u0015H\u0017\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u001a\u0010\u0003\u001a\u00020\u00018\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001e\u001a\u0004\b\u001f\u0010 R\u001a\u0010\u0005\u001a\u00020\u00048\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010!\u001a\u0004\b\"\u0010#R\u0014\u0010'\u001a\u00020$8WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&"}, d2={"Lorg/jetbrains/kotlin/types/FlexibleTypeWithEnhancement;", "Lorg/jetbrains/kotlin/types/FlexibleType;", "Lorg/jetbrains/kotlin/types/TypeWithEnhancement;", "origin", "Lorg/jetbrains/kotlin/types/KotlinType;", "enhancement", "<init>", "(Lorg/jetbrains/kotlin/types/FlexibleType;Lorg/jetbrains/kotlin/types/KotlinType;)V", "Lorg/jetbrains/kotlin/types/TypeAttributes;", "newAttributes", "Lorg/jetbrains/kotlin/types/UnwrappedType;", "replaceAttributes", "(Lorg/jetbrains/kotlin/types/TypeAttributes;)Lorg/jetbrains/kotlin/types/UnwrappedType;", "", "newNullability", "makeNullableAsSpecified", "(Z)Lorg/jetbrains/kotlin/types/UnwrappedType;", "Lorg/jetbrains/kotlin/renderer/DescriptorRenderer;", "renderer", "Lorg/jetbrains/kotlin/renderer/DescriptorRendererOptions;", "options", "", "render", "(Lorg/jetbrains/kotlin/renderer/DescriptorRenderer;Lorg/jetbrains/kotlin/renderer/DescriptorRendererOptions;)Ljava/lang/String;", "Lorg/jetbrains/kotlin/types/checker/KotlinTypeRefiner;", "kotlinTypeRefiner", "refine", "(Lorg/jetbrains/kotlin/types/checker/KotlinTypeRefiner;)Lorg/jetbrains/kotlin/types/FlexibleTypeWithEnhancement;", "toString", "()Ljava/lang/String;", "Lorg/jetbrains/kotlin/types/FlexibleType;", "getOrigin", "()Lorg/jetbrains/kotlin/types/FlexibleType;", "Lorg/jetbrains/kotlin/types/KotlinType;", "getEnhancement", "()Lorg/jetbrains/kotlin/types/KotlinType;", "Lorg/jetbrains/kotlin/types/SimpleType;", "getDelegate", "()Lorg/jetbrains/kotlin/types/SimpleType;", "delegate"})
public final class FlexibleTypeWithEnhancement
extends FlexibleType
implements TypeWithEnhancement {
    @NotNull
    private final FlexibleType origin;
    @NotNull
    private final KotlinType enhancement;

    public FlexibleTypeWithEnhancement(@NotNull FlexibleType origin, @NotNull KotlinType enhancement) {
        Intrinsics.checkNotNullParameter(origin, "origin");
        Intrinsics.checkNotNullParameter(enhancement, "enhancement");
        super(origin.getLowerBound(), origin.getUpperBound());
        this.origin = origin;
        this.enhancement = enhancement;
    }

    @Override
    @NotNull
    public FlexibleType getOrigin() {
        return this.origin;
    }

    @Override
    @NotNull
    public KotlinType getEnhancement() {
        return this.enhancement;
    }

    @Override
    @NotNull
    public UnwrappedType replaceAttributes(@NotNull TypeAttributes newAttributes) {
        Intrinsics.checkNotNullParameter(newAttributes, "newAttributes");
        return TypeWithEnhancementKt.wrapEnhancement(this.getOrigin().replaceAttributes(newAttributes), this.getEnhancement());
    }

    @Override
    @NotNull
    public UnwrappedType makeNullableAsSpecified(boolean newNullability) {
        return TypeWithEnhancementKt.wrapEnhancement(this.getOrigin().makeNullableAsSpecified(newNullability), this.getEnhancement().unwrap().makeNullableAsSpecified(newNullability));
    }

    @Override
    @NotNull
    public String render(@NotNull DescriptorRenderer renderer, @NotNull DescriptorRendererOptions options) {
        Intrinsics.checkNotNullParameter(renderer, "renderer");
        Intrinsics.checkNotNullParameter(options, "options");
        if (options.getEnhancedTypes()) {
            return renderer.renderType(this.getEnhancement());
        }
        return this.getOrigin().render(renderer, options);
    }

    @Override
    @NotNull
    public SimpleType getDelegate() {
        return this.getOrigin().getDelegate();
    }

    @Override
    @NotNull
    public FlexibleTypeWithEnhancement refine(@NotNull KotlinTypeRefiner kotlinTypeRefiner) {
        Intrinsics.checkNotNullParameter(kotlinTypeRefiner, "kotlinTypeRefiner");
        KotlinType kotlinType = kotlinTypeRefiner.refineType(this.getOrigin());
        Intrinsics.checkNotNull(kotlinType, "null cannot be cast to non-null type org.jetbrains.kotlin.types.FlexibleType");
        return new FlexibleTypeWithEnhancement((FlexibleType)kotlinType, kotlinTypeRefiner.refineType(this.getEnhancement()));
    }

    @Override
    @NotNull
    public String toString() {
        return "[@EnhancedForWarnings(" + this.getEnhancement() + ")] " + this.getOrigin();
    }
}

