/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.reflect.KProperty1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FindClassInModuleKt;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.storage.CacheWithNotNullValues;
import org.jetbrains.kotlin.storage.LockBasedStorageManager;
import org.jetbrains.kotlin.storage.StorageManager;
import org.jetbrains.kotlin.types.AbbreviatedType;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeRefinerImpl;
import org.jetbrains.kotlin.types.KotlinTypeRefinerImplKt;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.checker.KotlinTypeRefiner;
import org.jetbrains.kotlin.types.checker.KotlinTypeRefinerKt;
import org.jetbrains.kotlin.types.checker.Ref;
import org.jetbrains.kotlin.types.checker.TypeRefinementSupport;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.utils.DFS;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 >2\u00020\u0001:\u0001>B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007B!\b\u0012\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u0006\u0010\nJ\u0017\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u000bH\u0017\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0010\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001b\u0010\u0013\u001a\u00020\r*\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0001H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0013\u0010\u0015\u001a\u00020\b*\u00020\rH\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0013\u0010\u0017\u001a\u00020\b*\u00020\rH\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0016J\u0013\u0010\u0018\u001a\u00020\b*\u00020\rH\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0016J\u001d\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\r0\u001b2\u0006\u0010\u001a\u001a\u00020\u0019H\u0017\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0019\u0010!\u001a\u0004\u0018\u00010 2\u0006\u0010\u001f\u001a\u00020\u001eH\u0017\u00a2\u0006\u0004\b!\u0010\"J\u0019\u0010%\u001a\u0004\u0018\u00010\u00192\u0006\u0010$\u001a\u00020#H\u0017\u00a2\u0006\u0004\b%\u0010&J\u0017\u0010'\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b'\u0010(J\u0017\u0010+\u001a\u00020\b2\u0006\u0010*\u001a\u00020)H\u0016\u00a2\u0006\u0004\b+\u0010,J/\u00101\u001a\u00028\u0000\"\b\b\u0000\u0010.*\u00020-2\u0006\u0010\u001a\u001a\u00020\u00192\f\u00100\u001a\b\u0012\u0004\u0012\u00028\u00000/H\u0017\u00a2\u0006\u0004\b1\u00102J\u0013\u00103\u001a\u00020\b*\u00020)H\u0002\u00a2\u0006\u0004\b3\u0010,J\u0015\u00104\u001a\u00020\b*\u0004\u0018\u00010\u001eH\u0002\u00a2\u0006\u0004\b4\u00105J\u0013\u00106\u001a\u00020\b*\u00020)H\u0002\u00a2\u0006\u0004\b6\u0010,R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u00107R \u00109\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020\r088\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b9\u0010:R \u0010;\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\b088\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b;\u0010:R \u0010<\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020-088\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b<\u0010:R\u0016\u0010\t\u001a\u00020\b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b\t\u0010="}, d2={"Lorg/jetbrains/kotlin/types/KotlinTypeRefinerImpl;", "Lorg/jetbrains/kotlin/types/checker/KotlinTypeRefiner;", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "moduleDescriptor", "Lorg/jetbrains/kotlin/storage/StorageManager;", "storageManager", "<init>", "(Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/storage/StorageManager;)V", "", "isStandalone", "(Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/storage/StorageManager;Z)V", "Lorg/jetbrains/kotlin/types/model/KotlinTypeMarker;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "refineType", "(Lorg/jetbrains/kotlin/types/model/KotlinTypeMarker;)Lorg/jetbrains/kotlin/types/KotlinType;", "doRefineType", "(Lorg/jetbrains/kotlin/types/KotlinType;)Lorg/jetbrains/kotlin/types/KotlinType;", "refiner", "refineWithRespectToAbbreviatedTypes", "(Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/types/checker/KotlinTypeRefiner;)Lorg/jetbrains/kotlin/types/KotlinType;", "needsRefinement", "(Lorg/jetbrains/kotlin/types/KotlinType;)Z", "canBeCached", "needsRefinementHackForKtij24195", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "classDescriptor", "", "refineSupertypes", "(Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;)Ljava/util/Collection;", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "refineDescriptor", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;)Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "Lorg/jetbrains/kotlin/name/ClassId;", "classId", "findClassAcrossModuleDependencies", "(Lorg/jetbrains/kotlin/name/ClassId;)Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "isRefinementNeededForModule", "(Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;)Z", "Lorg/jetbrains/kotlin/types/TypeConstructor;", "typeConstructor", "isRefinementNeededForTypeConstructor", "(Lorg/jetbrains/kotlin/types/TypeConstructor;)Z", "Lorg/jetbrains/kotlin/resolve/scopes/MemberScope;", "S", "Lkotlin/Function0;", "compute", "getOrPutScopeForClass", "(Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;Lkotlin/jvm/functions/Function0;)Lorg/jetbrains/kotlin/resolve/scopes/MemberScope;", "isRefinementNeededForTypeConstructorNoCache", "isEnumEntryOrEnum", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;)Z", "areThereExpectSupertypes", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "Lorg/jetbrains/kotlin/storage/CacheWithNotNullValues;", "refinedTypeCache", "Lorg/jetbrains/kotlin/storage/CacheWithNotNullValues;", "isRefinementNeededForTypeConstructorCache", "scopes", "Z", "Companion"})
public final class KotlinTypeRefinerImpl
extends KotlinTypeRefiner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ModuleDescriptor moduleDescriptor;
    @NotNull
    private final CacheWithNotNullValues<TypeConstructor, KotlinType> refinedTypeCache;
    @NotNull
    private final CacheWithNotNullValues<ClassifierDescriptor, Boolean> isRefinementNeededForTypeConstructorCache;
    @NotNull
    private final CacheWithNotNullValues<ClassDescriptor, MemberScope> scopes;
    private boolean isStandalone;

    public KotlinTypeRefinerImpl(@NotNull ModuleDescriptor moduleDescriptor, @NotNull StorageManager storageManager) {
        block1: {
            Intrinsics.checkNotNullParameter(moduleDescriptor, "moduleDescriptor");
            Intrinsics.checkNotNullParameter(storageManager, "storageManager");
            this.moduleDescriptor = moduleDescriptor;
            this.refinedTypeCache = storageManager.createCacheWithNotNullValues();
            this.isRefinementNeededForTypeConstructorCache = storageManager.createCacheWithNotNullValues();
            this.scopes = storageManager.createCacheWithNotNullValues();
            if (this.isStandalone) break block1;
            Ref<TypeRefinementSupport> ref = this.moduleDescriptor.getCapability(KotlinTypeRefinerKt.getREFINER_CAPABILITY());
            if (ref != null) {
                ref.setValue(new TypeRefinementSupport.Enabled(this));
            }
        }
    }

    private KotlinTypeRefinerImpl(ModuleDescriptor moduleDescriptor, StorageManager storageManager, boolean isStandalone) {
        this(moduleDescriptor, storageManager);
        this.isStandalone = isStandalone;
    }

    @Override
    @NotNull
    public KotlinType refineType(@NotNull KotlinTypeMarker type2) {
        Intrinsics.checkNotNullParameter(type2, "type");
        if (!(type2 instanceof KotlinType)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        ClassifierDescriptor classifierDescriptor = ((KotlinType)type2).getConstructor().getDeclarationDescriptor();
        if (Intrinsics.areEqual(classifierDescriptor != null ? DescriptorUtilsKt.getModule(classifierDescriptor) : null, this.moduleDescriptor)) {
            return (KotlinType)type2;
        }
        return this.needsRefinementHackForKtij24195((KotlinType)type2) ? this.doRefineType(((AbbreviatedType)type2).getAbbreviation()) : (this.needsRefinement((KotlinType)type2) ? this.doRefineType((KotlinType)type2) : (KotlinType)type2);
    }

    private final KotlinType doRefineType(KotlinType type2) {
        KotlinType kotlinType;
        if (this.canBeCached(type2)) {
            KotlinType cached = this.refinedTypeCache.computeIfAbsent(type2.getConstructor(), () -> KotlinTypeRefinerImpl.doRefineType$lambda$0(this, type2));
            kotlinType = KotlinTypeRefinerImplKt.access$restoreAdditionalTypeInformation(cached, type2);
        } else {
            kotlinType = this.refineWithRespectToAbbreviatedTypes(type2, this);
        }
        return kotlinType;
    }

    private final KotlinType refineWithRespectToAbbreviatedTypes(KotlinType $this$refineWithRespectToAbbreviatedTypes, KotlinTypeRefiner refiner) {
        KotlinType previousRefinement = null;
        KotlinType currentRefinement = $this$refineWithRespectToAbbreviatedTypes;
        while ((currentRefinement = (previousRefinement = currentRefinement).refine(refiner)) instanceof AbbreviatedType && !Intrinsics.areEqual(currentRefinement, previousRefinement)) {
        }
        return currentRefinement;
    }

    private final boolean needsRefinement(KotlinType $this$needsRefinement) {
        return this.isRefinementNeededForTypeConstructor($this$needsRefinement.getConstructor());
    }

    private final boolean canBeCached(KotlinType $this$canBeCached) {
        return $this$canBeCached.getHasNotTrivialRefinementFactory() && $this$canBeCached.getConstructor().getDeclarationDescriptor() != null;
    }

    private final boolean needsRefinementHackForKtij24195(KotlinType $this$needsRefinementHackForKtij24195) {
        if (!($this$needsRefinementHackForKtij24195 instanceof AbbreviatedType)) {
            return false;
        }
        if (!(((AbbreviatedType)$this$needsRefinementHackForKtij24195).getAbbreviation().getConstructor().getDeclarationDescriptor() instanceof TypeAliasDescriptor)) {
            return false;
        }
        ClassId classId = DescriptorUtilsKt.getClassId(((AbbreviatedType)$this$needsRefinementHackForKtij24195).getExpandedType().getConstructor().getDeclarationDescriptor());
        if (classId == null) {
            return false;
        }
        ClassId expansionDescriptorClassId = classId;
        return FindClassInModuleKt.findClassifierAcrossModuleDependencies(this.moduleDescriptor, expansionDescriptorClassId) == null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<KotlinType> refineSupertypes(@NotNull ClassDescriptor classDescriptor) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(classDescriptor, "classDescriptor");
        Collection<KotlinType> collection = classDescriptor.getTypeConstructor().getSupertypes();
        Intrinsics.checkNotNullExpressionValue(collection, "getSupertypes(...)");
        Iterable $this$map$iv = collection;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KotlinType kotlinType = (KotlinType)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(it);
            collection2.add(this.refineType((KotlinTypeMarker)it));
        }
        return (List)destination$iv$iv;
    }

    @Override
    @Nullable
    public ClassifierDescriptor refineDescriptor(@NotNull DeclarationDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        if (!(descriptor2 instanceof ClassifierDescriptorWithTypeParameters)) {
            return null;
        }
        ClassId classId = DescriptorUtilsKt.getClassId((ClassifierDescriptor)descriptor2);
        if (classId == null) {
            return null;
        }
        ClassId classId2 = classId;
        return FindClassInModuleKt.findClassifierAcrossModuleDependencies(this.moduleDescriptor, classId2);
    }

    @Override
    @Nullable
    public ClassDescriptor findClassAcrossModuleDependencies(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter(classId, "classId");
        return FindClassInModuleKt.findClassAcrossModuleDependencies(this.moduleDescriptor, classId);
    }

    @Override
    public boolean isRefinementNeededForModule(@NotNull ModuleDescriptor moduleDescriptor) {
        Intrinsics.checkNotNullParameter(moduleDescriptor, "moduleDescriptor");
        return this.moduleDescriptor != moduleDescriptor;
    }

    @Override
    public boolean isRefinementNeededForTypeConstructor(@NotNull TypeConstructor typeConstructor2) {
        Intrinsics.checkNotNullParameter(typeConstructor2, "typeConstructor");
        ClassifierDescriptor classifierDescriptor = typeConstructor2.getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            return this.isRefinementNeededForTypeConstructorNoCache(typeConstructor2);
        }
        ClassifierDescriptor owner = classifierDescriptor;
        return this.isRefinementNeededForTypeConstructorCache.computeIfAbsent(owner, () -> KotlinTypeRefinerImpl.isRefinementNeededForTypeConstructor$lambda$2(this, typeConstructor2));
    }

    @Override
    @NotNull
    public <S extends MemberScope> S getOrPutScopeForClass(@NotNull ClassDescriptor classDescriptor, @NotNull Function0<? extends S> compute) {
        Intrinsics.checkNotNullParameter(classDescriptor, "classDescriptor");
        Intrinsics.checkNotNullParameter(compute, "compute");
        S s = this.scopes.computeIfAbsent(classDescriptor, compute);
        Intrinsics.checkNotNull(s, "null cannot be cast to non-null type S of org.jetbrains.kotlin.types.KotlinTypeRefinerImpl.getOrPutScopeForClass");
        return (S)((MemberScope)s);
    }

    private final boolean isRefinementNeededForTypeConstructorNoCache(TypeConstructor $this$isRefinementNeededForTypeConstructorNoCache) {
        return this.isEnumEntryOrEnum($this$isRefinementNeededForTypeConstructorNoCache.getDeclarationDescriptor()) || this.areThereExpectSupertypes($this$isRefinementNeededForTypeConstructorNoCache);
    }

    private final boolean isEnumEntryOrEnum(DeclarationDescriptor $this$isEnumEntryOrEnum) {
        return $this$isEnumEntryOrEnum instanceof ClassDescriptor ? ((ClassDescriptor)$this$isEnumEntryOrEnum).getKind() == ClassKind.ENUM_CLASS || KotlinBuiltIns.isEnum((ClassDescriptor)$this$isEnumEntryOrEnum) : false;
    }

    private final boolean areThereExpectSupertypes(TypeConstructor $this$areThereExpectSupertypes) {
        Ref.BooleanRef result2 = new Ref.BooleanRef();
        DFS.dfs((Collection)CollectionsKt.listOf($this$areThereExpectSupertypes), arg_0 -> KotlinTypeRefinerImpl.areThereExpectSupertypes$lambda$3(areThereExpectSupertypes.1.INSTANCE, arg_0), new DFS.VisitedWithSet(), new DFS.AbstractNodeHandler<TypeConstructor, Unit>(this, result2){
            final /* synthetic */ KotlinTypeRefinerImpl this$0;
            final /* synthetic */ Ref.BooleanRef $result;
            {
                this.this$0 = $receiver;
                this.$result = $result;
            }

            public boolean beforeChildren(TypeConstructor current) {
                Intrinsics.checkNotNullParameter(current, "current");
                if (KotlinTypeRefinerImplKt.access$isExpectClass(current)) {
                    ClassifierDescriptor classifierDescriptor = current.getDeclarationDescriptor();
                    if (!Intrinsics.areEqual(classifierDescriptor != null ? DescriptorUtilsKt.getModule(classifierDescriptor) : null, KotlinTypeRefinerImpl.access$getModuleDescriptor$p(this.this$0))) {
                        this.$result.element = true;
                        return false;
                    }
                }
                return true;
            }

            public void result() {
            }
        });
        return result2.element;
    }

    private static final KotlinType doRefineType$lambda$0(KotlinTypeRefinerImpl this$0, KotlinType $type) {
        ClassifierDescriptor classifierDescriptor = $type.getConstructor().getDeclarationDescriptor();
        Intrinsics.checkNotNull(classifierDescriptor);
        SimpleType simpleType2 = classifierDescriptor.getDefaultType();
        Intrinsics.checkNotNullExpressionValue(simpleType2, "getDefaultType(...)");
        return this$0.refineWithRespectToAbbreviatedTypes(simpleType2, this$0);
    }

    private static final boolean isRefinementNeededForTypeConstructor$lambda$2(KotlinTypeRefinerImpl this$0, TypeConstructor $typeConstructor) {
        return this$0.isRefinementNeededForTypeConstructorNoCache($typeConstructor);
    }

    private static final Iterable areThereExpectSupertypes$lambda$3(KProperty1 $tmp0, TypeConstructor p0) {
        return (Iterable)((Function1)$tmp0).invoke(p0);
    }

    public static final /* synthetic */ ModuleDescriptor access$getModuleDescriptor$p(KotlinTypeRefinerImpl $this) {
        return $this.moduleDescriptor;
    }

    public /* synthetic */ KotlinTypeRefinerImpl(ModuleDescriptor moduleDescriptor, StorageManager storageManager, boolean isStandalone, DefaultConstructorMarker $constructor_marker) {
        this(moduleDescriptor, storageManager, isStandalone);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\b"}, d2={"Lorg/jetbrains/kotlin/types/KotlinTypeRefinerImpl$Companion;", "", "<init>", "()V", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "moduleDescriptor", "Lorg/jetbrains/kotlin/types/KotlinTypeRefinerImpl;", "createStandaloneInstanceFor", "(Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;)Lorg/jetbrains/kotlin/types/KotlinTypeRefinerImpl;"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KotlinTypeRefinerImpl createStandaloneInstanceFor(@NotNull ModuleDescriptor moduleDescriptor) {
            Intrinsics.checkNotNullParameter(moduleDescriptor, "moduleDescriptor");
            StorageManager storageManager = LockBasedStorageManager.NO_LOCKS;
            Intrinsics.checkNotNullExpressionValue(storageManager, "NO_LOCKS");
            return new KotlinTypeRefinerImpl(moduleDescriptor, storageManager, true, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

