/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.resolve.calls.components.ClassicTypeSystemContextForCS;
import org.jetbrains.kotlin.types.AbstractTypeApproximator;
import org.jetbrains.kotlin.types.AlternativeTypeSubstitutionKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeApproximatorConfiguration;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.checker.KotlinTypeRefiner;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001f\u0010\r\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ!\u0010\u0012\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0010H\u0007\u00a2\u0006\u0004\b\u0012\u0010\u0013J!\u0010\u0014\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0010H\u0007\u00a2\u0006\u0004\b\u0014\u0010\u0013J)\u0010\u0016\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\nH\u0007\u00a2\u0006\u0004\b\u0016\u0010\u0017"}, d2={"Lorg/jetbrains/kotlin/types/TypeApproximator;", "Lorg/jetbrains/kotlin/types/AbstractTypeApproximator;", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "builtIns", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "languageVersionSettings", "<init>", "(Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)V", "Lorg/jetbrains/kotlin/types/KotlinType;", "baseType", "", "local", "Lorg/jetbrains/kotlin/types/UnwrappedType;", "approximateDeclarationType", "(Lorg/jetbrains/kotlin/types/KotlinType;Z)Lorg/jetbrains/kotlin/types/UnwrappedType;", "type", "Lorg/jetbrains/kotlin/types/TypeApproximatorConfiguration;", "conf", "approximateToSuperType", "(Lorg/jetbrains/kotlin/types/UnwrappedType;Lorg/jetbrains/kotlin/types/TypeApproximatorConfiguration;)Lorg/jetbrains/kotlin/types/UnwrappedType;", "approximateToSubType", "toSuperType", "approximateTo", "(Lorg/jetbrains/kotlin/types/UnwrappedType;Lorg/jetbrains/kotlin/types/TypeApproximatorConfiguration;Z)Lorg/jetbrains/kotlin/types/UnwrappedType;"})
public final class TypeApproximator
extends AbstractTypeApproximator {
    public TypeApproximator(@NotNull KotlinBuiltIns builtIns, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter(builtIns, "builtIns");
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        super(new ClassicTypeSystemContextForCS(builtIns, KotlinTypeRefiner.Default.INSTANCE), languageVersionSettings);
    }

    @NotNull
    public final UnwrappedType approximateDeclarationType(@NotNull KotlinType baseType, boolean local) {
        TypeApproximatorConfiguration.AllFlexibleSameValue configuration2;
        Intrinsics.checkNotNullParameter(baseType, "baseType");
        if (!this.getLanguageVersionSettings().supportsFeature(LanguageFeature.NewInference)) {
            return baseType.unwrap();
        }
        UnwrappedType preparedType = local ? baseType.unwrap() : AlternativeTypeSubstitutionKt.substituteAlternativesInPublicType(baseType);
        UnwrappedType unwrappedType = this.approximateToSuperType(preparedType, (TypeApproximatorConfiguration)(configuration2 = local ? (TypeApproximatorConfiguration.AllFlexibleSameValue)TypeApproximatorConfiguration.LocalDeclaration.INSTANCE : (TypeApproximatorConfiguration.AllFlexibleSameValue)TypeApproximatorConfiguration.PublicDeclaration.SaveAnonymousTypes.INSTANCE));
        if (unwrappedType == null) {
            unwrappedType = preparedType;
        }
        return unwrappedType;
    }

    @Nullable
    public final UnwrappedType approximateToSuperType(@NotNull UnwrappedType type2, @NotNull TypeApproximatorConfiguration conf) {
        Intrinsics.checkNotNullParameter(type2, "type");
        Intrinsics.checkNotNullParameter(conf, "conf");
        return (UnwrappedType)super.approximateToSuperType(type2, conf);
    }

    @Nullable
    public final UnwrappedType approximateToSubType(@NotNull UnwrappedType type2, @NotNull TypeApproximatorConfiguration conf) {
        Intrinsics.checkNotNullParameter(type2, "type");
        Intrinsics.checkNotNullParameter(conf, "conf");
        return (UnwrappedType)super.approximateToSubType(type2, conf);
    }

    @Nullable
    public final UnwrappedType approximateTo(@NotNull UnwrappedType type2, @NotNull TypeApproximatorConfiguration conf, boolean toSuperType) {
        Intrinsics.checkNotNullParameter(type2, "type");
        Intrinsics.checkNotNullParameter(conf, "conf");
        return toSuperType ? this.approximateToSuperType(type2, conf) : this.approximateToSubType(type2, conf);
    }
}

