/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.checker;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.types.FlexibleTypeBoundsChecker;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0004\b\u000b\u0010\fR \u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0004\u0010\r\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0006\u001a\u00020\u00058\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0010"}, d2={"Lorg/jetbrains/kotlin/types/checker/CapturedArguments;", "", "", "Lorg/jetbrains/kotlin/types/TypeProjection;", "capturedArguments", "Lorg/jetbrains/kotlin/types/KotlinType;", "originalType", "<init>", "(Ljava/util/List;Lorg/jetbrains/kotlin/types/KotlinType;)V", "type", "", "isSuitableForType", "(Lorg/jetbrains/kotlin/types/KotlinType;)Z", "Ljava/util/List;", "getCapturedArguments", "()Ljava/util/List;", "Lorg/jetbrains/kotlin/types/KotlinType;"})
final class CapturedArguments {
    @NotNull
    private final List<TypeProjection> capturedArguments;
    @NotNull
    private final KotlinType originalType;

    public CapturedArguments(@NotNull List<? extends TypeProjection> capturedArguments, @NotNull KotlinType originalType) {
        Intrinsics.checkNotNullParameter(capturedArguments, "capturedArguments");
        Intrinsics.checkNotNullParameter(originalType, "originalType");
        this.capturedArguments = capturedArguments;
        this.originalType = originalType;
    }

    @NotNull
    public final List<TypeProjection> getCapturedArguments() {
        return this.capturedArguments;
    }

    public final boolean isSuitableForType(@NotNull KotlinType type2) {
        boolean areConstructorsMatched;
        boolean areArgumentsMatched;
        block4: {
            boolean bl;
            Intrinsics.checkNotNullParameter(type2, "type");
            Iterable $this$all$iv = CollectionsKt.withIndex((Iterable)type2.getArguments());
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                Iterator iterator2 = $this$all$iv.iterator();
                while (iterator2.hasNext()) {
                    IndexedValue element$iv;
                    IndexedValue indexedValue = element$iv = iterator2.next();
                    boolean bl2 = false;
                    int i = indexedValue.component1();
                    TypeProjection typeArgumentsType = (TypeProjection)indexedValue.component2();
                    if (this.originalType.getArguments().size() > i && Intrinsics.areEqual(typeArgumentsType, this.originalType.getArguments().get(i))) continue;
                    bl = false;
                    break block4;
                }
                bl = areArgumentsMatched = true;
            }
        }
        if (!areArgumentsMatched) {
            return false;
        }
        boolean bl = areConstructorsMatched = Intrinsics.areEqual(this.originalType.getConstructor(), type2.getConstructor()) || FlexibleTypeBoundsChecker.INSTANCE.areTypesMayBeLowerAndUpperBoundsOfSameFlexibleTypeByMutability(this.originalType, type2);
        return areConstructorsMatched;
    }
}

