/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.checker;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.types.FlexibleType;
import org.jetbrains.kotlin.types.FlexibleTypeBoundsChecker;
import org.jetbrains.kotlin.types.IntersectionTypeConstructor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeFactory;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeConstructorSubstitution;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSubstitutionKt;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.CapturedArguments;
import org.jetbrains.kotlin.types.checker.IntersectionTypeKt;
import org.jetbrains.kotlin.types.checker.KotlinTypePreparator;
import org.jetbrains.kotlin.types.checker.NewCapturedType;
import org.jetbrains.kotlin.types.model.CaptureStatus;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0019\u0010\u0002\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u0001\u001a\u00020\u0000H\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u001a\u0019\u0010\u0005\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u0004\u001a\u00020\u0000H\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0003\u001a!\u0010\t\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0004\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0007H\u0001\u00a2\u0006\u0004\b\t\u0010\n\u001a\u001f\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u0006\u0010\u0004\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000f\u001a!\u0010\t\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u0004\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\t\u0010\u0010\u001a!\u0010\u0013\u001a\u00020\u0006*\u00020\u00002\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\fH\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014\u001a'\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\f2\u0006\u0010\u0004\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016"}, d2={"Lorg/jetbrains/kotlin/types/UnwrappedType;", "argumentType", "prepareArgumentTypeRegardingCaptureTypes", "(Lorg/jetbrains/kotlin/types/UnwrappedType;)Lorg/jetbrains/kotlin/types/UnwrappedType;", "type", "captureFromExpression", "Lorg/jetbrains/kotlin/types/SimpleType;", "Lorg/jetbrains/kotlin/types/model/CaptureStatus;", "status", "captureFromArguments", "(Lorg/jetbrains/kotlin/types/SimpleType;Lorg/jetbrains/kotlin/types/model/CaptureStatus;)Lorg/jetbrains/kotlin/types/SimpleType;", "Lorg/jetbrains/kotlin/types/KotlinType;", "", "Lorg/jetbrains/kotlin/types/checker/CapturedArguments;", "captureArgumentsForIntersectionType", "(Lorg/jetbrains/kotlin/types/KotlinType;)Ljava/util/List;", "(Lorg/jetbrains/kotlin/types/UnwrappedType;Lorg/jetbrains/kotlin/types/model/CaptureStatus;)Lorg/jetbrains/kotlin/types/UnwrappedType;", "Lorg/jetbrains/kotlin/types/TypeProjection;", "arguments", "replaceArguments", "(Lorg/jetbrains/kotlin/types/UnwrappedType;Ljava/util/List;)Lorg/jetbrains/kotlin/types/SimpleType;", "captureArguments", "(Lorg/jetbrains/kotlin/types/UnwrappedType;Lorg/jetbrains/kotlin/types/model/CaptureStatus;)Ljava/util/List;"})
public final class NewCapturedTypeKt {
    @Nullable
    public static final UnwrappedType prepareArgumentTypeRegardingCaptureTypes(@NotNull UnwrappedType argumentType) {
        Intrinsics.checkNotNullParameter(argumentType, "argumentType");
        return argumentType instanceof NewCapturedType ? null : NewCapturedTypeKt.captureFromExpression(argumentType);
    }

    @Nullable
    public static final UnwrappedType captureFromExpression(@NotNull UnwrappedType type2) {
        UnwrappedType unwrappedType;
        Intrinsics.checkNotNullParameter(type2, "type");
        TypeConstructor typeConstructor2 = type2.getConstructor();
        if (!(typeConstructor2 instanceof IntersectionTypeConstructor)) {
            return NewCapturedTypeKt.captureFromArguments(type2, CaptureStatus.FROM_EXPRESSION);
        }
        List<CapturedArguments> list = NewCapturedTypeKt.captureArgumentsForIntersectionType(type2);
        if (list == null) {
            return null;
        }
        List<CapturedArguments> capturedArgumentsByComponents = list;
        if (type2 instanceof FlexibleType) {
            SimpleType lowerIntersectedType = IntersectionTypeKt.intersectTypes((Collection<? extends SimpleType>)NewCapturedTypeKt.captureFromExpression$replaceArgumentsWithCapturedArgumentsByIntersectionComponents(capturedArgumentsByComponents, ((FlexibleType)type2).getLowerBound())).makeNullableAsSpecified(((FlexibleType)type2).getLowerBound().isMarkedNullable());
            SimpleType upperIntersectedType = IntersectionTypeKt.intersectTypes((Collection<? extends SimpleType>)NewCapturedTypeKt.captureFromExpression$replaceArgumentsWithCapturedArgumentsByIntersectionComponents(capturedArgumentsByComponents, ((FlexibleType)type2).getUpperBound())).makeNullableAsSpecified(((FlexibleType)type2).getUpperBound().isMarkedNullable());
            unwrappedType = KotlinTypeFactory.flexibleType(lowerIntersectedType, upperIntersectedType);
        } else {
            unwrappedType = IntersectionTypeKt.intersectTypes((Collection<? extends SimpleType>)NewCapturedTypeKt.captureFromExpression$replaceArgumentsWithCapturedArgumentsByIntersectionComponents(capturedArgumentsByComponents, type2)).makeNullableAsSpecified(type2.isMarkedNullable());
        }
        return unwrappedType;
    }

    @Nullable
    public static final SimpleType captureFromArguments(@NotNull SimpleType type2, @NotNull CaptureStatus status2) {
        SimpleType simpleType2;
        Intrinsics.checkNotNullParameter(type2, "type");
        Intrinsics.checkNotNullParameter((Object)status2, "status");
        List<TypeProjection> list = NewCapturedTypeKt.captureArguments(type2, status2);
        if (list != null) {
            List<TypeProjection> it = list;
            boolean bl = false;
            simpleType2 = NewCapturedTypeKt.replaceArguments(type2, it);
        } else {
            simpleType2 = null;
        }
        return simpleType2;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<CapturedArguments> captureArgumentsForIntersectionType(KotlinType type2) {
        void $this$mapNotNullTo$iv$iv;
        Collection collection;
        HashSet<Pair<Object, List<TypeProjection>>> set$iv;
        if (type2 instanceof FlexibleType) {
            List<KotlinType> typesToCapture = CollectionsKt.plus(NewCapturedTypeKt.captureArgumentsForIntersectionType$getTypesToCapture(((FlexibleType)type2).getLowerBound()), (Iterable)NewCapturedTypeKt.captureArgumentsForIntersectionType$getTypesToCapture(((FlexibleType)type2).getUpperBound()));
            Iterable $this$distinctBy$iv = typesToCapture;
            boolean $i$f$distinctBy = false;
            set$iv = new HashSet<Pair<Object, List<TypeProjection>>>();
            ArrayList list$iv = new ArrayList();
            for (Object e$iv : $this$distinctBy$iv) {
                Pair<Object, List<TypeProjection>> key$iv;
                KotlinType it = (KotlinType)e$iv;
                boolean bl = false;
                Intrinsics.checkNotNull(it);
                Object object = FlexibleTypeBoundsChecker.INSTANCE.getBaseBoundFqNameByMutability(it);
                if (object == null) {
                    object = it.getConstructor();
                }
                if (!set$iv.add(key$iv = TuplesKt.to(object, it.getArguments()))) continue;
                list$iv.add(e$iv);
            }
            collection = list$iv;
        } else {
            collection = type2.getConstructor().getSupertypes();
        }
        Collection collection2 = collection;
        Intrinsics.checkNotNull(collection2);
        Collection filteredTypesToCapture = collection2;
        boolean changed = false;
        HashSet<Pair<Object, List<TypeProjection>>> $this$mapNotNull$iv = (HashSet<Pair<Object, List<TypeProjection>>>)filteredTypesToCapture;
        boolean $i$f$mapNotNull = false;
        set$iv = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            CapturedArguments capturedArguments;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            KotlinType typeToCapture = (KotlinType)element$iv$iv;
            boolean bl2 = false;
            if (NewCapturedTypeKt.captureArguments(typeToCapture.unwrap(), CaptureStatus.FROM_EXPRESSION) == null) {
                capturedArguments = null;
            } else {
                List<TypeProjection> capturedArguments2;
                changed = true;
                Intrinsics.checkNotNull(typeToCapture);
                capturedArguments = new CapturedArguments(capturedArguments2, typeToCapture);
            }
            if (capturedArguments == null) continue;
            CapturedArguments it$iv$iv = capturedArguments;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List capturedArgumentsByTypes = (List)destination$iv$iv;
        if (!changed) {
            return null;
        }
        return capturedArgumentsByTypes;
    }

    private static final UnwrappedType captureFromArguments(UnwrappedType type2, CaptureStatus status2) {
        List<TypeProjection> list = NewCapturedTypeKt.captureArguments(type2, status2);
        if (list == null) {
            return null;
        }
        List<TypeProjection> capturedArguments = list;
        return type2 instanceof FlexibleType ? KotlinTypeFactory.flexibleType(NewCapturedTypeKt.replaceArguments(((FlexibleType)type2).getLowerBound(), capturedArguments), NewCapturedTypeKt.replaceArguments(((FlexibleType)type2).getUpperBound(), capturedArguments)) : (UnwrappedType)NewCapturedTypeKt.replaceArguments(type2, capturedArguments);
    }

    private static final SimpleType replaceArguments(UnwrappedType $this$replaceArguments, List<? extends TypeProjection> arguments2) {
        return KotlinTypeFactory.simpleType$default($this$replaceArguments.getAttributes(), $this$replaceArguments.getConstructor(), arguments2, $this$replaceArguments.isMarkedNullable(), null, 16, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<TypeProjection> captureArguments(UnwrappedType type2, CaptureStatus status2) {
        KotlinType lowerType;
        Collection collection;
        Object object;
        void $this$mapTo$iv$iv;
        Object element$iv2;
        boolean bl;
        List<TypeProjection> arguments2;
        block11: {
            if (type2.getArguments().size() != type2.getConstructor().getParameters().size()) {
                return null;
            }
            arguments2 = type2.getArguments();
            Iterable $this$all$iv = arguments2;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv2 : $this$all$iv) {
                    TypeProjection it = (TypeProjection)element$iv2;
                    boolean bl2 = false;
                    if (it.getProjectionKind() == Variance.INVARIANT) continue;
                    bl = false;
                    break block11;
                }
                bl = true;
            }
        }
        if (bl) {
            return null;
        }
        Iterable iterable = arguments2;
        List<TypeParameterDescriptor> list = type2.getConstructor().getParameters();
        Intrinsics.checkNotNullExpressionValue(list, "getParameters(...)");
        Iterable $this$map$iv = CollectionsKt.zip(iterable, (Iterable)list);
        boolean $i$f$map = false;
        element$iv2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            TypeProjection typeProjection;
            object = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl3 = false;
            TypeProjection projection = (TypeProjection)((Pair)object).component1();
            TypeParameterDescriptor parameter = (TypeParameterDescriptor)((Pair)object).component2();
            if (projection.getProjectionKind() == Variance.INVARIANT) {
                typeProjection = projection;
            } else {
                lowerType = !projection.isStarProjection() && projection.getProjectionKind() == Variance.IN_VARIANCE ? projection.getType().unwrap() : null;
                Intrinsics.checkNotNull(parameter);
                typeProjection = TypeUtilsKt.asTypeProjection(new NewCapturedType(status2, (UnwrappedType)lowerType, projection, parameter));
            }
            collection.add(typeProjection);
        }
        List capturedArguments = (List)destination$iv$iv;
        TypeSubstitutor substitutor2 = TypeConstructorSubstitution.Companion.create(type2.getConstructor(), capturedArguments).buildSubstitutor();
        int n = ((Collection)arguments2).size();
        for (int index2 = 0; index2 < n; ++index2) {
            void destination$iv;
            void $this$mapTo$iv;
            Object item$iv$iv;
            TypeProjection oldProjection = arguments2.get(index2);
            TypeProjection newProjection = (TypeProjection)capturedArguments.get(index2);
            if (oldProjection.getProjectionKind() == Variance.INVARIANT) continue;
            List<KotlinType> list2 = type2.getConstructor().getParameters().get(index2).getUpperBounds();
            Intrinsics.checkNotNullExpressionValue(list2, "getUpperBounds(...)");
            item$iv$iv = list2;
            object = new ArrayList();
            boolean $i$f$mapTo2 = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it;
                lowerType = (KotlinType)item$iv;
                collection = destination$iv;
                boolean bl4 = false;
                collection.add(KotlinTypePreparator.Default.INSTANCE.prepareType(substitutor2.safeSubstitute((KotlinType)it, Variance.INVARIANT).unwrap()));
            }
            List capturedTypeSupertypes = (List)destination$iv;
            if (!oldProjection.isStarProjection() && oldProjection.getProjectionKind() == Variance.OUT_VARIANCE) {
                ((Collection)capturedTypeSupertypes).add(KotlinTypePreparator.Default.INSTANCE.prepareType(oldProjection.getType().unwrap()));
            }
            KotlinType kotlinType = newProjection.getType();
            Intrinsics.checkNotNull(kotlinType, "null cannot be cast to non-null type org.jetbrains.kotlin.types.checker.NewCapturedType");
            NewCapturedType capturedType = (NewCapturedType)kotlinType;
            capturedType.getConstructor().initializeSupertypes(capturedTypeSupertypes);
        }
        return capturedArguments;
    }

    private static final List<TypeProjection> captureFromExpression$findCorrespondingCapturedArgumentsForType(List<CapturedArguments> capturedArgumentsByComponents, KotlinType type2) {
        Object v0;
        block1: {
            Iterable iterable = capturedArgumentsByComponents;
            for (Object t : iterable) {
                CapturedArguments typeToCapture = (CapturedArguments)t;
                boolean bl = false;
                if (!typeToCapture.isSuitableForType(type2)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        CapturedArguments capturedArguments = v0;
        return capturedArguments != null ? capturedArguments.getCapturedArguments() : null;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<SimpleType> captureFromExpression$replaceArgumentsWithCapturedArgumentsByIntersectionComponents(List<CapturedArguments> capturedArgumentsByComponents, UnwrappedType typeToReplace) {
        List list;
        if (typeToReplace.getConstructor() instanceof IntersectionTypeConstructor) {
            void $this$mapTo$iv$iv;
            Collection<KotlinType> collection = typeToReplace.getConstructor().getSupertypes();
            Intrinsics.checkNotNullExpressionValue(collection, "getSupertypes(...)");
            Iterable $this$map$iv = collection;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                List<TypeProjection> capturedArguments;
                void componentType;
                KotlinType kotlinType = (KotlinType)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull(componentType);
                collection2.add(NewCapturedTypeKt.captureFromExpression$findCorrespondingCapturedArgumentsForType(capturedArgumentsByComponents, (KotlinType)componentType) == null ? TypeSubstitutionKt.asSimpleType((KotlinType)componentType) : NewCapturedTypeKt.replaceArguments(componentType.unwrap(), capturedArguments));
            }
            list = (List)destination$iv$iv;
        } else {
            List<TypeProjection> list2 = NewCapturedTypeKt.captureFromExpression$findCorrespondingCapturedArgumentsForType(capturedArgumentsByComponents, typeToReplace);
            if (list2 == null) {
                return CollectionsKt.listOf(TypeSubstitutionKt.asSimpleType(typeToReplace));
            }
            List<TypeProjection> capturedArguments = list2;
            list = CollectionsKt.listOf(NewCapturedTypeKt.replaceArguments(typeToReplace.unwrap(), capturedArguments));
        }
        return list;
    }

    private static final Collection<KotlinType> captureArgumentsForIntersectionType$getTypesToCapture(KotlinType type2) {
        Collection<KotlinType> collection;
        if (type2.getConstructor() instanceof IntersectionTypeConstructor) {
            Collection<KotlinType> collection2 = type2.getConstructor().getSupertypes();
            collection = collection2;
            Intrinsics.checkNotNullExpressionValue(collection2, "getSupertypes(...)");
        } else {
            collection = (Collection<KotlinType>)CollectionsKt.listOf(type2);
        }
        return collection;
    }
}

