/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.error;

import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorWithDeprecation;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.scopes.DescriptorKindFilter;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.types.error.ErrorClassDescriptor;
import org.jetbrains.kotlin.types.error.ErrorEntity;
import org.jetbrains.kotlin.types.error.ErrorFunctionDescriptor;
import org.jetbrains.kotlin.types.error.ErrorScopeKind;
import org.jetbrains.kotlin.types.error.ErrorUtils;
import org.jetbrains.kotlin.utils.Printer;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001f\u0010\r\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0017\u00a2\u0006\u0004\b\r\u0010\u000eJ'\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000f2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0017\u00a2\u0006\u0004\b\u0010\u0010\u0011J%\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0017\u00a2\u0006\u0004\b\u0014\u0010\u0015J%\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u00122\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0017\u00a2\u0006\u0004\b\u0017\u0010\u0015J1\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u0019\u001a\u00020\u00182\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0017\u00a2\u0006\u0004\b\u001f\u0010 J\u0015\u0010!\u001a\b\u0012\u0004\u0012\u00020\b0\u0012H\u0017\u00a2\u0006\u0004\b!\u0010\"J\u0015\u0010#\u001a\b\u0012\u0004\u0012\u00020\b0\u0012H\u0017\u00a2\u0006\u0004\b#\u0010\"J\u0015\u0010$\u001a\b\u0012\u0004\u0012\u00020\b0\u0012H\u0017\u00a2\u0006\u0004\b$\u0010\"J\u001f\u0010&\u001a\u00020%2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b&\u0010'J\u0017\u0010(\u001a\u00020\u001b2\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b(\u0010)J\u000f\u0010*\u001a\u00020\u0004H\u0017\u00a2\u0006\u0004\b*\u0010+J\u0017\u0010.\u001a\u00020%2\u0006\u0010-\u001a\u00020,H\u0016\u00a2\u0006\u0004\b.\u0010/R\u001a\u0010\u0003\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u00100\u001a\u0004\b1\u00102R\u001a\u00103\u001a\u00020\u00048\u0005X\u0085\u0004\u00a2\u0006\f\n\u0004\b3\u00104\u001a\u0004\b5\u0010+"}, d2={"Lorg/jetbrains/kotlin/types/error/ErrorScope;", "Lorg/jetbrains/kotlin/resolve/scopes/MemberScope;", "Lorg/jetbrains/kotlin/types/error/ErrorScopeKind;", "kind", "", "formatParams", "<init>", "(Lorg/jetbrains/kotlin/types/error/ErrorScopeKind;[Ljava/lang/String;)V", "Lorg/jetbrains/kotlin/name/Name;", "name", "Lorg/jetbrains/kotlin/incremental/components/LookupLocation;", "location", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "getContributedClassifier", "(Lorg/jetbrains/kotlin/name/Name;Lorg/jetbrains/kotlin/incremental/components/LookupLocation;)Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "Lorg/jetbrains/kotlin/descriptors/DescriptorWithDeprecation;", "getContributedClassifierIncludeDeprecated", "(Lorg/jetbrains/kotlin/name/Name;Lorg/jetbrains/kotlin/incremental/components/LookupLocation;)Lorg/jetbrains/kotlin/descriptors/DescriptorWithDeprecation;", "", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "getContributedVariables", "(Lorg/jetbrains/kotlin/name/Name;Lorg/jetbrains/kotlin/incremental/components/LookupLocation;)Ljava/util/Set;", "Lorg/jetbrains/kotlin/descriptors/SimpleFunctionDescriptor;", "getContributedFunctions", "Lorg/jetbrains/kotlin/resolve/scopes/DescriptorKindFilter;", "kindFilter", "Lkotlin/Function1;", "", "nameFilter", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "getContributedDescriptors", "(Lorg/jetbrains/kotlin/resolve/scopes/DescriptorKindFilter;Lkotlin/jvm/functions/Function1;)Ljava/util/Collection;", "getFunctionNames", "()Ljava/util/Set;", "getVariableNames", "getClassifierNames", "", "recordLookup", "(Lorg/jetbrains/kotlin/name/Name;Lorg/jetbrains/kotlin/incremental/components/LookupLocation;)V", "definitelyDoesNotContainName", "(Lorg/jetbrains/kotlin/name/Name;)Z", "toString", "()Ljava/lang/String;", "Lorg/jetbrains/kotlin/utils/Printer;", "p", "printScopeStructure", "(Lorg/jetbrains/kotlin/utils/Printer;)V", "Lorg/jetbrains/kotlin/types/error/ErrorScopeKind;", "getKind", "()Lorg/jetbrains/kotlin/types/error/ErrorScopeKind;", "debugMessage", "Ljava/lang/String;", "getDebugMessage"})
public class ErrorScope
implements MemberScope {
    @NotNull
    private final ErrorScopeKind kind;
    @NotNull
    private final String debugMessage;

    public ErrorScope(@NotNull ErrorScopeKind kind, String ... formatParams) {
        Intrinsics.checkNotNullParameter((Object)kind, "kind");
        Intrinsics.checkNotNullParameter(formatParams, "formatParams");
        this.kind = kind;
        String[] stringArray = Arrays.copyOf(formatParams, formatParams.length);
        String string2 = String.format(this.kind.getDebugMessage(), Arrays.copyOf(stringArray, stringArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
        this.debugMessage = string2;
    }

    @NotNull
    public final ErrorScopeKind getKind() {
        return this.kind;
    }

    @NotNull
    protected final String getDebugMessage() {
        return this.debugMessage;
    }

    @Override
    @NotNull
    public ClassifierDescriptor getContributedClassifier(@NotNull Name name, @NotNull LookupLocation location) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(location, "location");
        String string2 = ErrorEntity.ERROR_CLASS.getDebugText();
        Object[] objectArray = new Object[]{name};
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string3, "format(...)");
        Name name2 = Name.special(string3);
        Intrinsics.checkNotNullExpressionValue(name2, "special(...)");
        return new ErrorClassDescriptor(name2);
    }

    @Override
    @Nullable
    public DescriptorWithDeprecation<ClassifierDescriptor> getContributedClassifierIncludeDeprecated(@NotNull Name name, @NotNull LookupLocation location) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(location, "location");
        return null;
    }

    @NotNull
    public Set<PropertyDescriptor> getContributedVariables(@NotNull Name name, @NotNull LookupLocation location) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(location, "location");
        return ErrorUtils.INSTANCE.getErrorPropertyGroup();
    }

    @NotNull
    public Set<SimpleFunctionDescriptor> getContributedFunctions(@NotNull Name name, @NotNull LookupLocation location) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(location, "location");
        return SetsKt.setOf(new ErrorFunctionDescriptor(ErrorUtils.INSTANCE.getErrorClass()));
    }

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getContributedDescriptors(@NotNull DescriptorKindFilter kindFilter, @NotNull Function1<? super Name, Boolean> nameFilter) {
        Intrinsics.checkNotNullParameter(kindFilter, "kindFilter");
        Intrinsics.checkNotNullParameter(nameFilter, "nameFilter");
        return CollectionsKt.emptyList();
    }

    @Override
    @NotNull
    public Set<Name> getFunctionNames() {
        return SetsKt.emptySet();
    }

    @Override
    @NotNull
    public Set<Name> getVariableNames() {
        return SetsKt.emptySet();
    }

    @Override
    @NotNull
    public Set<Name> getClassifierNames() {
        return SetsKt.emptySet();
    }

    @Override
    public void recordLookup(@NotNull Name name, @NotNull LookupLocation location) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(location, "location");
    }

    @Override
    public boolean definitelyDoesNotContainName(@NotNull Name name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return false;
    }

    @NotNull
    public String toString() {
        return "ErrorScope{" + this.debugMessage + '}';
    }

    @Override
    public void printScopeStructure(@NotNull Printer p) {
        Intrinsics.checkNotNullParameter(p, "p");
        Object[] objectArray = new Object[]{this.getClass().getSimpleName(), ": ", this.debugMessage};
        p.println(objectArray);
    }
}

