/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.error;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.DefaultBuiltIns;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.checker.KotlinTypeRefiner;
import org.jetbrains.kotlin.types.error.ErrorEntity;
import org.jetbrains.kotlin.types.error.ErrorTypeKind;
import org.jetbrains.kotlin.types.error.ErrorUtils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\n\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\bH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0015\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0017\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0015\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0017\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0015\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000f\u0010\u0017\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0016J\u000f\u0010\u0019\u001a\u00020\u0018H\u0017\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u000f\u0010\u001c\u001a\u00020\u001bH\u0017\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u000f\u0010\u001e\u001a\u00020\u0004H\u0017\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0017\u0010\"\u001a\u00020\u00012\u0006\u0010!\u001a\u00020 H\u0017\u00a2\u0006\u0004\b\"\u0010#R\u001a\u0010\u0003\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010$\u001a\u0004\b%\u0010&R\"\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040'8\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010(\u001a\u0004\b)\u0010*R\u0014\u0010+\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b+\u0010,"}, d2={"Lorg/jetbrains/kotlin/types/error/ErrorTypeConstructor;", "Lorg/jetbrains/kotlin/types/TypeConstructor;", "Lorg/jetbrains/kotlin/types/error/ErrorTypeKind;", "kind", "", "formatParams", "<init>", "(Lorg/jetbrains/kotlin/types/error/ErrorTypeKind;[Ljava/lang/String;)V", "", "i", "getParam", "(I)Ljava/lang/String;", "", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "getParameters", "()Ljava/util/List;", "", "Lorg/jetbrains/kotlin/types/KotlinType;", "getSupertypes", "()Ljava/util/Collection;", "", "isFinal", "()Z", "isDenotable", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "getDeclarationDescriptor", "()Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "getBuiltIns", "()Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "toString", "()Ljava/lang/String;", "Lorg/jetbrains/kotlin/types/checker/KotlinTypeRefiner;", "kotlinTypeRefiner", "refine", "(Lorg/jetbrains/kotlin/types/checker/KotlinTypeRefiner;)Lorg/jetbrains/kotlin/types/TypeConstructor;", "Lorg/jetbrains/kotlin/types/error/ErrorTypeKind;", "getKind", "()Lorg/jetbrains/kotlin/types/error/ErrorTypeKind;", "", "[Ljava/lang/String;", "getFormatParams", "()[Ljava/lang/String;", "debugText", "Ljava/lang/String;"})
public final class ErrorTypeConstructor
implements TypeConstructor {
    @NotNull
    private final ErrorTypeKind kind;
    @NotNull
    private final String[] formatParams;
    @NotNull
    private final String debugText;

    public ErrorTypeConstructor(@NotNull ErrorTypeKind kind, String ... formatParams) {
        Intrinsics.checkNotNullParameter((Object)kind, "kind");
        Intrinsics.checkNotNullParameter(formatParams, "formatParams");
        this.kind = kind;
        this.formatParams = formatParams;
        String string2 = ErrorEntity.ERROR_TYPE.getDebugText();
        Object[] objectArray = new Object[1];
        String string3 = this.kind.getDebugMessage();
        String[] stringArray = this.formatParams;
        stringArray = Arrays.copyOf(stringArray, stringArray.length);
        Intrinsics.checkNotNullExpressionValue(String.format(string3, Arrays.copyOf(stringArray, stringArray.length)), "format(...)");
        String string4 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string4, "format(...)");
        this.debugText = string4;
    }

    @NotNull
    public final ErrorTypeKind getKind() {
        return this.kind;
    }

    @NotNull
    public final String[] getFormatParams() {
        return this.formatParams;
    }

    @NotNull
    public final String getParam(int i) {
        return this.formatParams[i];
    }

    @Override
    @NotNull
    public List<TypeParameterDescriptor> getParameters() {
        return CollectionsKt.emptyList();
    }

    @Override
    @NotNull
    public Collection<KotlinType> getSupertypes() {
        return CollectionsKt.emptyList();
    }

    @Override
    public boolean isFinal() {
        return false;
    }

    @Override
    public boolean isDenotable() {
        return false;
    }

    @Override
    @NotNull
    public ClassifierDescriptor getDeclarationDescriptor() {
        return ErrorUtils.INSTANCE.getErrorClass();
    }

    @Override
    @NotNull
    public KotlinBuiltIns getBuiltIns() {
        return DefaultBuiltIns.Companion.getInstance();
    }

    @NotNull
    public String toString() {
        return this.debugText;
    }

    @Override
    @NotNull
    public TypeConstructor refine(@NotNull KotlinTypeRefiner kotlinTypeRefiner) {
        Intrinsics.checkNotNullParameter(kotlinTypeRefiner, "kotlinTypeRefiner");
        return this;
    }
}

