/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.SetMultimap;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001:\u0001 B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0017\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0016H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019R \u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00070\u001a8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001dR\u0018\u0010\u001e\u001a\u0004\u0018\u00010\r8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001f"}, d2={"Lorg/jetbrains/kotlin/types/expressions/AssignedVariablesSearcher;", "Lorg/jetbrains/kotlin/psi/KtTreeVisitorVoid;", "<init>", "()V", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "variableDescriptor", "", "Lorg/jetbrains/kotlin/types/expressions/AssignedVariablesSearcher$Writer;", "writers", "(Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;)Ljava/util/Set;", "", "hasWriters", "(Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;)Z", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "declaration", "", "visitDeclaration", "(Lorg/jetbrains/kotlin/psi/KtDeclaration;)V", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "lambdaExpression", "visitLambdaExpression", "(Lorg/jetbrains/kotlin/psi/KtLambdaExpression;)V", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "binaryExpression", "visitBinaryExpression", "(Lorg/jetbrains/kotlin/psi/KtBinaryExpression;)V", "Lcom/google/common/collect/SetMultimap;", "Lorg/jetbrains/kotlin/name/Name;", "assignedNames", "Lcom/google/common/collect/SetMultimap;", "currentDeclaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "Writer"})
public abstract class AssignedVariablesSearcher
extends KtTreeVisitorVoid {
    @NotNull
    private final SetMultimap<Name, Writer> assignedNames;
    @Nullable
    private KtDeclaration currentDeclaration;

    public AssignedVariablesSearcher() {
        LinkedHashMultimap linkedHashMultimap = LinkedHashMultimap.create();
        Intrinsics.checkNotNullExpressionValue(linkedHashMultimap, "create(...)");
        this.assignedNames = linkedHashMultimap;
    }

    @NotNull
    public Set<Writer> writers(@NotNull VariableDescriptor variableDescriptor) {
        Intrinsics.checkNotNullParameter(variableDescriptor, "variableDescriptor");
        Collection collection = this.assignedNames.get((Object)variableDescriptor.getName());
        Intrinsics.checkNotNullExpressionValue(collection, "get(...)");
        return collection;
    }

    public final boolean hasWriters(@NotNull VariableDescriptor variableDescriptor) {
        Intrinsics.checkNotNullParameter(variableDescriptor, "variableDescriptor");
        return !((Collection)this.writers(variableDescriptor)).isEmpty();
    }

    @Override
    public void visitDeclaration(@NotNull KtDeclaration declaration) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        KtDeclaration previous = this.currentDeclaration;
        if (declaration instanceof KtDeclarationWithBody || declaration instanceof KtClassOrObject || declaration instanceof KtAnonymousInitializer) {
            this.currentDeclaration = declaration;
        }
        super.visitDeclaration(declaration);
        this.currentDeclaration = previous;
    }

    @Override
    public void visitLambdaExpression(@NotNull KtLambdaExpression lambdaExpression) {
        Intrinsics.checkNotNullParameter(lambdaExpression, "lambdaExpression");
        KtDeclaration previous = this.currentDeclaration;
        this.currentDeclaration = lambdaExpression.getFunctionLiteral();
        super.visitLambdaExpression(lambdaExpression);
        this.currentDeclaration = previous;
    }

    @Override
    public void visitBinaryExpression(@NotNull KtBinaryExpression binaryExpression) {
        KtExpression left;
        Intrinsics.checkNotNullParameter(binaryExpression, "binaryExpression");
        if (binaryExpression.getOperationToken() == KtTokens.EQ && (left = KtPsiUtil.deparenthesize(binaryExpression.getLeft())) instanceof KtNameReferenceExpression) {
            this.assignedNames.put(((KtNameReferenceExpression)left).getReferencedNameAsName(), new Writer(binaryExpression, this.currentDeclaration));
        }
        super.visitBinaryExpression(binaryExpression);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\u0002H\u00c7\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\u0012\u0010\n\u001a\u0004\u0018\u00010\u0004H\u00c7\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ&\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u00c7\u0001\u00a2\u0006\u0004\b\f\u0010\rJ\u001a\u0010\u0010\u001a\u00020\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0013\u001a\u00020\u0012H\u00d6\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0010\u0010\u0016\u001a\u00020\u0015H\u00d7\u0001\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0003\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0018\u001a\u0004\b\u0019\u0010\tR\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u00048\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001a\u001a\u0004\b\u001b\u0010\u000b"}, d2={"Lorg/jetbrains/kotlin/types/expressions/AssignedVariablesSearcher$Writer;", "", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "assignment", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "declaration", "<init>", "(Lorg/jetbrains/kotlin/psi/KtBinaryExpression;Lorg/jetbrains/kotlin/psi/KtDeclaration;)V", "component1", "()Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "component2", "()Lorg/jetbrains/kotlin/psi/KtDeclaration;", "copy", "(Lorg/jetbrains/kotlin/psi/KtBinaryExpression;Lorg/jetbrains/kotlin/psi/KtDeclaration;)Lorg/jetbrains/kotlin/types/expressions/AssignedVariablesSearcher$Writer;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "getAssignment", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "getDeclaration"})
    public static final class Writer {
        @NotNull
        private final KtBinaryExpression assignment;
        @Nullable
        private final KtDeclaration declaration;

        public Writer(@NotNull KtBinaryExpression assignment, @Nullable KtDeclaration declaration) {
            Intrinsics.checkNotNullParameter(assignment, "assignment");
            this.assignment = assignment;
            this.declaration = declaration;
        }

        @NotNull
        public final KtBinaryExpression getAssignment() {
            return this.assignment;
        }

        @Nullable
        public final KtDeclaration getDeclaration() {
            return this.declaration;
        }

        @NotNull
        public final KtBinaryExpression component1() {
            return this.assignment;
        }

        @Nullable
        public final KtDeclaration component2() {
            return this.declaration;
        }

        @NotNull
        public final Writer copy(@NotNull KtBinaryExpression assignment, @Nullable KtDeclaration declaration) {
            Intrinsics.checkNotNullParameter(assignment, "assignment");
            return new Writer(assignment, declaration);
        }

        public static /* synthetic */ Writer copy$default(Writer writer, KtBinaryExpression ktBinaryExpression, KtDeclaration ktDeclaration, int n, Object object) {
            if ((n & 1) != 0) {
                ktBinaryExpression = writer.assignment;
            }
            if ((n & 2) != 0) {
                ktDeclaration = writer.declaration;
            }
            return writer.copy(ktBinaryExpression, ktDeclaration);
        }

        @NotNull
        public String toString() {
            return "Writer(assignment=" + this.assignment + ", declaration=" + this.declaration + ')';
        }

        public int hashCode() {
            int result2 = this.assignment.hashCode();
            result2 = result2 * 31 + (this.declaration == null ? 0 : this.declaration.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Writer)) {
                return false;
            }
            Writer writer = (Writer)other;
            if (!Intrinsics.areEqual(this.assignment, writer.assignment)) {
                return false;
            }
            return Intrinsics.areEqual(this.declaration, writer.declaration);
        }
    }
}

