/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.lazy.DeclarationScopeProviderImpl;
import org.jetbrains.kotlin.resolve.lazy.FileScopeProvider;
import org.jetbrains.kotlin.resolve.lazy.LazyDeclarationResolver;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.types.expressions.LocalClassDescriptorHolder;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\nH\u0017\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\nH\u0017\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0012"}, d2={"Lorg/jetbrains/kotlin/types/expressions/DeclarationScopeProviderForLocalClassifierAnalyzer;", "Lorg/jetbrains/kotlin/resolve/lazy/DeclarationScopeProviderImpl;", "Lorg/jetbrains/kotlin/resolve/lazy/LazyDeclarationResolver;", "lazyDeclarationResolver", "Lorg/jetbrains/kotlin/resolve/lazy/FileScopeProvider;", "fileScopeProvider", "Lorg/jetbrains/kotlin/types/expressions/LocalClassDescriptorHolder;", "localClassDescriptorManager", "<init>", "(Lorg/jetbrains/kotlin/resolve/lazy/LazyDeclarationResolver;Lorg/jetbrains/kotlin/resolve/lazy/FileScopeProvider;Lorg/jetbrains/kotlin/types/expressions/LocalClassDescriptorHolder;)V", "Lcom/intellij/psi/PsiElement;", "elementOfDeclaration", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "getResolutionScopeForDeclaration", "(Lcom/intellij/psi/PsiElement;)Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "getOuterDataFlowInfoForDeclaration", "(Lcom/intellij/psi/PsiElement;)Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "Lorg/jetbrains/kotlin/types/expressions/LocalClassDescriptorHolder;"})
public final class DeclarationScopeProviderForLocalClassifierAnalyzer
extends DeclarationScopeProviderImpl {
    @NotNull
    private final LocalClassDescriptorHolder localClassDescriptorManager;

    public DeclarationScopeProviderForLocalClassifierAnalyzer(@NotNull LazyDeclarationResolver lazyDeclarationResolver, @NotNull FileScopeProvider fileScopeProvider, @NotNull LocalClassDescriptorHolder localClassDescriptorManager) {
        Intrinsics.checkNotNullParameter(lazyDeclarationResolver, "lazyDeclarationResolver");
        Intrinsics.checkNotNullParameter(fileScopeProvider, "fileScopeProvider");
        Intrinsics.checkNotNullParameter(localClassDescriptorManager, "localClassDescriptorManager");
        super(lazyDeclarationResolver, fileScopeProvider);
        this.localClassDescriptorManager = localClassDescriptorManager;
    }

    @Override
    @NotNull
    public LexicalScope getResolutionScopeForDeclaration(@NotNull PsiElement elementOfDeclaration) {
        Intrinsics.checkNotNullParameter(elementOfDeclaration, "elementOfDeclaration");
        if (this.localClassDescriptorManager.isMyClass(elementOfDeclaration)) {
            return this.localClassDescriptorManager.getResolutionScopeForClass((KtClassOrObject)elementOfDeclaration);
        }
        LexicalScope lexicalScope = super.getResolutionScopeForDeclaration(elementOfDeclaration);
        Intrinsics.checkNotNullExpressionValue(lexicalScope, "getResolutionScopeForDeclaration(...)");
        return lexicalScope;
    }

    @Override
    @NotNull
    public DataFlowInfo getOuterDataFlowInfoForDeclaration(@NotNull PsiElement elementOfDeclaration) {
        Intrinsics.checkNotNullParameter(elementOfDeclaration, "elementOfDeclaration");
        if (this.localClassDescriptorManager.insideMyClass(elementOfDeclaration)) {
            DataFlowInfo dataFlowInfo = this.localClassDescriptorManager.getExpressionTypingContext().dataFlowInfo;
            Intrinsics.checkNotNullExpressionValue(dataFlowInfo, "dataFlowInfo");
            return dataFlowInfo;
        }
        DataFlowInfo dataFlowInfo = super.getOuterDataFlowInfoForDeclaration(elementOfDeclaration);
        Intrinsics.checkNotNullExpressionValue(dataFlowInfo, "getOuterDataFlowInfoForDeclaration(...)");
        return dataFlowInfo;
    }
}

