/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtVariableDeclaration;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DataClassDescriptorResolver;
import org.jetbrains.kotlin.resolve.LocalVariableResolver;
import org.jetbrains.kotlin.resolve.TypeResolver;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.kotlin.resolve.checkers.TrailingCommaChecker;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalWritableScope;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.error.ErrorType;
import org.jetbrains.kotlin.types.error.ErrorTypeKind;
import org.jetbrains.kotlin.types.error.ErrorUtils;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.kotlin.types.expressions.FakeCallKind;
import org.jetbrains.kotlin.types.expressions.FakeCallResolver;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJA\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0013\u001a\u00020\u0012H\u0007\u00a2\u0006\u0004\b\u0016\u0010\u0017J9\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b\u001b\u0010\u001cJ;\u0010\"\u001a\u00020!2\u0006\u0010\u001e\u001a\u00020\u001d2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u001fH\u0007\u00a2\u0006\u0004\b\"\u0010#J;\u0010&\u001a\u00020!2\u0006\u0010%\u001a\u00020$2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001d2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0010H\u0002\u00a2\u0006\u0004\b&\u0010'J\u001f\u0010(\u001a\u00020!2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001dH\u0002\u00a2\u0006\u0004\b(\u0010)R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010*R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010+R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010,"}, d2={"Lorg/jetbrains/kotlin/types/expressions/DestructuringDeclarationResolver;", "", "Lorg/jetbrains/kotlin/types/expressions/FakeCallResolver;", "fakeCallResolver", "Lorg/jetbrains/kotlin/resolve/LocalVariableResolver;", "localVariableResolver", "Lorg/jetbrains/kotlin/resolve/TypeResolver;", "typeResolver", "<init>", "(Lorg/jetbrains/kotlin/types/expressions/FakeCallResolver;Lorg/jetbrains/kotlin/resolve/LocalVariableResolver;Lorg/jetbrains/kotlin/resolve/TypeResolver;)V", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "scope", "Lorg/jetbrains/kotlin/psi/KtDestructuringDeclaration;", "destructuringDeclaration", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "receiver", "Lorg/jetbrains/kotlin/psi/KtExpression;", "initializer", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;", "context", "", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "resolveLocalVariablesFromDestructuringDeclaration", "(Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;Lorg/jetbrains/kotlin/psi/KtDestructuringDeclaration;Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;)Ljava/util/List;", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalWritableScope;", "writableScope", "", "defineLocalVariablesFromDestructuringDeclaration", "(Lorg/jetbrains/kotlin/resolve/scopes/LexicalWritableScope;Lorg/jetbrains/kotlin/psi/KtDestructuringDeclaration;Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;)V", "Lorg/jetbrains/kotlin/psi/KtDestructuringDeclarationEntry;", "entry", "", "componentIndex", "Lorg/jetbrains/kotlin/types/KotlinType;", "resolveInitializer", "(Lorg/jetbrains/kotlin/psi/KtDestructuringDeclarationEntry;Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;I)Lorg/jetbrains/kotlin/types/KotlinType;", "Lorg/jetbrains/kotlin/name/Name;", "componentName", "resolveComponentFunctionAndGetType", "(Lorg/jetbrains/kotlin/name/Name;Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;Lorg/jetbrains/kotlin/psi/KtDestructuringDeclarationEntry;Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;Lorg/jetbrains/kotlin/psi/KtExpression;)Lorg/jetbrains/kotlin/types/KotlinType;", "getExpectedTypeForComponent", "(Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;Lorg/jetbrains/kotlin/psi/KtDestructuringDeclarationEntry;)Lorg/jetbrains/kotlin/types/KotlinType;", "Lorg/jetbrains/kotlin/types/expressions/FakeCallResolver;", "Lorg/jetbrains/kotlin/resolve/LocalVariableResolver;", "Lorg/jetbrains/kotlin/resolve/TypeResolver;"})
public final class DestructuringDeclarationResolver {
    @NotNull
    private final FakeCallResolver fakeCallResolver;
    @NotNull
    private final LocalVariableResolver localVariableResolver;
    @NotNull
    private final TypeResolver typeResolver;

    public DestructuringDeclarationResolver(@NotNull FakeCallResolver fakeCallResolver, @NotNull LocalVariableResolver localVariableResolver, @NotNull TypeResolver typeResolver) {
        Intrinsics.checkNotNullParameter(fakeCallResolver, "fakeCallResolver");
        Intrinsics.checkNotNullParameter(localVariableResolver, "localVariableResolver");
        Intrinsics.checkNotNullParameter(typeResolver, "typeResolver");
        this.fakeCallResolver = fakeCallResolver;
        this.localVariableResolver = localVariableResolver;
        this.typeResolver = typeResolver;
    }

    @NotNull
    public final List<VariableDescriptor> resolveLocalVariablesFromDestructuringDeclaration(@NotNull LexicalScope scope2, @NotNull KtDestructuringDeclaration destructuringDeclaration, @Nullable ReceiverValue receiver, @Nullable KtExpression initializer, @NotNull ExpressionTypingContext context) {
        Intrinsics.checkNotNullParameter(scope2, "scope");
        Intrinsics.checkNotNullParameter(destructuringDeclaration, "destructuringDeclaration");
        Intrinsics.checkNotNullParameter(context, "context");
        ArrayList<LocalVariableDescriptor> result2 = new ArrayList<LocalVariableDescriptor>();
        Iterator iterator2 = ((Iterable)destructuringDeclaration.getEntries()).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int componentIndex = n++;
            KtDestructuringDeclarationEntry entry = (KtDestructuringDeclarationEntry)iterator2.next();
            Intrinsics.checkNotNull(entry);
            KotlinType componentType = this.resolveInitializer(entry, receiver, initializer, context, componentIndex);
            KtVariableDeclaration ktVariableDeclaration = entry;
            BindingTrace bindingTrace = context.trace;
            Intrinsics.checkNotNullExpressionValue(bindingTrace, "trace");
            LocalVariableDescriptor variableDescriptor = this.localVariableResolver.resolveLocalVariableDescriptorWithType$frontend(scope2, ktVariableDeclaration, componentType, bindingTrace);
            result2.add(variableDescriptor);
        }
        PsiElement psiElement = destructuringDeclaration.getTrailingComma();
        BindingTrace bindingTrace = context.trace;
        Intrinsics.checkNotNullExpressionValue(bindingTrace, "trace");
        LanguageVersionSettings languageVersionSettings = context.languageVersionSettings;
        Intrinsics.checkNotNullExpressionValue(languageVersionSettings, "languageVersionSettings");
        TrailingCommaChecker.INSTANCE.check(psiElement, bindingTrace, languageVersionSettings);
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    public final void defineLocalVariablesFromDestructuringDeclaration(@NotNull LexicalWritableScope writableScope, @NotNull KtDestructuringDeclaration destructuringDeclaration, @Nullable ReceiverValue receiver, @Nullable KtExpression initializer, @NotNull ExpressionTypingContext context) {
        void $this$forEach$iv;
        Intrinsics.checkNotNullParameter(writableScope, "writableScope");
        Intrinsics.checkNotNullParameter(destructuringDeclaration, "destructuringDeclaration");
        Intrinsics.checkNotNullParameter(context, "context");
        Iterable iterable = this.resolveLocalVariablesFromDestructuringDeclaration(writableScope, destructuringDeclaration, receiver, initializer, context);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VariableDescriptor it = (VariableDescriptor)element$iv;
            boolean bl = false;
            ExpressionTypingUtils.checkVariableShadowing(writableScope, context.trace, it);
            writableScope.addVariableDescriptor(it);
        }
    }

    @NotNull
    public final KotlinType resolveInitializer(@NotNull KtDestructuringDeclarationEntry entry, @Nullable ReceiverValue receiver, @Nullable KtExpression initializer, @NotNull ExpressionTypingContext context, int componentIndex) {
        Intrinsics.checkNotNullParameter(entry, "entry");
        Intrinsics.checkNotNullParameter(context, "context");
        Name componentName = DataClassDescriptorResolver.INSTANCE.createComponentName(componentIndex + 1);
        return this.resolveComponentFunctionAndGetType(componentName, context, entry, receiver, initializer);
    }

    private final KotlinType resolveComponentFunctionAndGetType(Name componentName, ExpressionTypingContext context, KtDestructuringDeclarationEntry entry, ReceiverValue receiver, KtExpression initializer) {
        KotlinType kotlinType;
        OverloadResolutionResults<FunctionDescriptor> results;
        if (receiver == null) {
            return DestructuringDeclarationResolver.resolveComponentFunctionAndGetType$errorType(componentName);
        }
        KotlinType expectedType = this.getExpectedTypeForComponent(context, entry);
        Object Context2 = ((ExpressionTypingContext)context.replaceExpectedType(expectedType)).replaceContextDependency(ContextDependency.INDEPENDENT);
        Intrinsics.checkNotNullExpressionValue(Context2, "replaceContextDependency(...)");
        ExpressionTypingContext newContext = (ExpressionTypingContext)Context2;
        ResolutionContext resolutionContext = newContext;
        KtExpression ktExpression = entry;
        KtExpression ktExpression2 = initializer;
        if (ktExpression2 == null) {
            ktExpression2 = entry;
        }
        if (!(results = this.fakeCallResolver.resolveFakeCall(resolutionContext, receiver, componentName, ktExpression, ktExpression2, FakeCallKind.COMPONENT, CollectionsKt.emptyList())).isSuccess()) {
            return DestructuringDeclarationResolver.resolveComponentFunctionAndGetType$errorType(componentName);
        }
        context.trace.record(BindingContext.COMPONENT_RESOLVED_CALL, entry, results.getResultingCall());
        KotlinType functionReturnType = results.getResultingDescriptor().getReturnType();
        if (functionReturnType != null && !TypeUtils.noExpectedType(expectedType) && !KotlinTypeChecker.DEFAULT.isSubtypeOf(functionReturnType, expectedType)) {
            BindingTrace bindingTrace = context.trace;
            KtExpression ktExpression3 = initializer;
            if (ktExpression3 == null) {
                ktExpression3 = entry;
            }
            bindingTrace.report(Errors.COMPONENT_FUNCTION_RETURN_TYPE_MISMATCH.on((KtExpression)((PsiElement)ktExpression3), componentName, functionReturnType, expectedType));
        }
        if ((kotlinType = functionReturnType) == null) {
            kotlinType = DestructuringDeclarationResolver.resolveComponentFunctionAndGetType$errorType(componentName);
        }
        return kotlinType;
    }

    private final KotlinType getExpectedTypeForComponent(ExpressionTypingContext context, KtDestructuringDeclarationEntry entry) {
        KtTypeReference ktTypeReference = entry.getTypeReference();
        if (ktTypeReference == null) {
            SimpleType simpleType2 = TypeUtils.NO_EXPECTED_TYPE;
            Intrinsics.checkNotNullExpressionValue(simpleType2, "NO_EXPECTED_TYPE");
            return simpleType2;
        }
        KtTypeReference entryTypeRef = ktTypeReference;
        LexicalScope lexicalScope = context.scope;
        Intrinsics.checkNotNullExpressionValue(lexicalScope, "scope");
        BindingTrace bindingTrace = context.trace;
        Intrinsics.checkNotNullExpressionValue(bindingTrace, "trace");
        return this.typeResolver.resolveType(lexicalScope, entryTypeRef, bindingTrace, true);
    }

    private static final ErrorType resolveComponentFunctionAndGetType$errorType(Name $componentName) {
        String[] stringArray = new String[]{$componentName.toString()};
        return ErrorUtils.createErrorType(ErrorTypeKind.ERROR_TYPE_FOR_DESTRUCTURING_COMPONENT, stringArray);
    }
}

