/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import com.google.common.collect.Lists;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.AnonymousFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.impl.SimpleFunctionDescriptorImpl;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.PsiDiagnosticUtils;
import org.jetbrains.kotlin.extensions.internal.TypeResolutionInterceptor;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTreeVisitor;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.ReservedCheckingKt;
import org.jetbrains.kotlin.psi.stubs.KotlinPlaceHolderStub;
import org.jetbrains.kotlin.resolve.AnnotationResolver;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DeclarationsCheckerBuilder;
import org.jetbrains.kotlin.resolve.FunctionDescriptorResolver;
import org.jetbrains.kotlin.resolve.FunctionDescriptorUtil;
import org.jetbrains.kotlin.resolve.IdentifierChecker;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.inference.BuilderInferenceSession;
import org.jetbrains.kotlin.resolve.calls.inference.model.TypeVariableTypeConstructor;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.tower.KotlinResolutionCallbacksImpl;
import org.jetbrains.kotlin.resolve.checkers.TrailingCommaChecker;
import org.jetbrains.kotlin.resolve.checkers.UnderscoreChecker;
import org.jetbrains.kotlin.resolve.lazy.ForceResolveUtil;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalWritableScope;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;
import org.jetbrains.kotlin.types.CommonSupertypes;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.expressions.CoercionStrategy;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingInternals;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingServices;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingVisitor;
import org.jetbrains.kotlin.types.expressions.FunctionsTypingVisitorKt;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.expressions.ValueParameterResolver;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryKt;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001f\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0017\u00a2\u0006\u0004\b\u000b\u0010\fJ1\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u000e2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0010H\u0007\u00a2\u0006\u0004\b\u000b\u0010\u0012J!\u0010\u0015\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\bH\u0017\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001f\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0013\u0010\u001b\u001a\u00020\u000e*\u00020\u001aH\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0013\u0010\u001d\u001a\u00020\u000e*\u00020\u001aH\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001cJ/\u0010!\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b!\u0010\"J3\u0010$\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\u001e2\b\u0010#\u001a\u0004\u0018\u00010\u001aH\u0002\u00a2\u0006\u0004\b$\u0010%J+\u0010)\u001a\u0004\u0018\u00010\u001a2\u0006\u0010'\u001a\u00020&2\u0006\u0010\r\u001a\u00020\b2\b\u0010(\u001a\u0004\u0018\u00010\u001aH\u0002\u00a2\u0006\u0004\b)\u0010*J%\u0010/\u001a\b\u0012\u0004\u0012\u00020.0-2\u0006\u0010'\u001a\u00020&2\u0006\u0010,\u001a\u00020+H\u0002\u00a2\u0006\u0004\b/\u00100J%\u00104\u001a\u0002032\u0006\u0010\u0007\u001a\u0002012\u0006\u0010,\u001a\u00020+2\u0006\u00102\u001a\u00020\u001a\u00a2\u0006\u0004\b4\u00105J%\u0010/\u001a\b\u0012\u0004\u0012\u00020.062\u0006\u0010\u0007\u001a\u0002012\u0006\u0010,\u001a\u00020+H\u0002\u00a2\u0006\u0004\b/\u00107"}, d2={"Lorg/jetbrains/kotlin/types/expressions/FunctionsTypingVisitor;", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingVisitor;", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingInternals;", "facade", "<init>", "(Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingInternals;)V", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "function", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;", "data", "Lorg/jetbrains/kotlin/types/expressions/KotlinTypeInfo;", "visitNamedFunction", "(Lorg/jetbrains/kotlin/psi/KtNamedFunction;Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;)Lorg/jetbrains/kotlin/types/expressions/KotlinTypeInfo;", "context", "", "isDeclaration", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalWritableScope;", "statementScope", "(Lorg/jetbrains/kotlin/psi/KtNamedFunction;Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;ZLorg/jetbrains/kotlin/resolve/scopes/LexicalWritableScope;)Lorg/jetbrains/kotlin/types/expressions/KotlinTypeInfo;", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "expression", "visitLambdaExpression", "(Lorg/jetbrains/kotlin/psi/KtLambdaExpression;Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;)Lorg/jetbrains/kotlin/types/expressions/KotlinTypeInfo;", "Lorg/jetbrains/kotlin/descriptors/impl/AnonymousFunctionDescriptor;", "createFunctionLiteralDescriptor", "(Lorg/jetbrains/kotlin/psi/KtLambdaExpression;Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;)Lorg/jetbrains/kotlin/descriptors/impl/AnonymousFunctionDescriptor;", "Lorg/jetbrains/kotlin/types/KotlinType;", "isBuiltinFunctionalType", "(Lorg/jetbrains/kotlin/types/KotlinType;)Z", "isSuspendFunctionType", "Lorg/jetbrains/kotlin/descriptors/impl/SimpleFunctionDescriptorImpl;", "functionDescriptor", "functionTypeExpected", "computeReturnType", "(Lorg/jetbrains/kotlin/psi/KtLambdaExpression;Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;Lorg/jetbrains/kotlin/descriptors/impl/SimpleFunctionDescriptorImpl;Z)Lorg/jetbrains/kotlin/types/KotlinType;", "expectedReturnType", "computeUnsafeReturnType", "(Lorg/jetbrains/kotlin/psi/KtLambdaExpression;Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;Lorg/jetbrains/kotlin/descriptors/impl/SimpleFunctionDescriptorImpl;Lorg/jetbrains/kotlin/types/KotlinType;)Lorg/jetbrains/kotlin/types/KotlinType;", "Lorg/jetbrains/kotlin/psi/KtFunctionLiteral;", "functionLiteral", "typeOfBodyExpression", "computeReturnTypeBasedOnReturnExpressions", "(Lorg/jetbrains/kotlin/psi/KtFunctionLiteral;Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;Lorg/jetbrains/kotlin/types/KotlinType;)Lorg/jetbrains/kotlin/types/KotlinType;", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "trace", "", "Lorg/jetbrains/kotlin/psi/KtReturnExpression;", "collectReturns", "(Lorg/jetbrains/kotlin/psi/KtFunctionLiteral;Lorg/jetbrains/kotlin/resolve/BindingTrace;)Ljava/util/Collection;", "Lorg/jetbrains/kotlin/psi/KtDeclarationWithBody;", "actualReturnType", "", "checkTypesForReturnStatements", "(Lorg/jetbrains/kotlin/psi/KtDeclarationWithBody;Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/types/KotlinType;)V", "", "(Lorg/jetbrains/kotlin/psi/KtDeclarationWithBody;Lorg/jetbrains/kotlin/resolve/BindingTrace;)Ljava/util/List;"})
public final class FunctionsTypingVisitor
extends ExpressionTypingVisitor {
    public FunctionsTypingVisitor(@NotNull ExpressionTypingInternals facade) {
        Intrinsics.checkNotNullParameter(facade, "facade");
        super(facade);
    }

    @Override
    @NotNull
    public KotlinTypeInfo visitNamedFunction(@NotNull KtNamedFunction function2, @NotNull ExpressionTypingContext data2) {
        Intrinsics.checkNotNullParameter(function2, "function");
        Intrinsics.checkNotNullParameter(data2, "data");
        return this.visitNamedFunction(function2, data2, false, null);
    }

    @NotNull
    public final KotlinTypeInfo visitNamedFunction(@NotNull KtNamedFunction function2, @NotNull ExpressionTypingContext context, boolean isDeclaration, @Nullable LexicalWritableScope statementScope) {
        KotlinTypeInfo kotlinTypeInfo;
        Intrinsics.checkNotNullParameter(function2, "function");
        Intrinsics.checkNotNullParameter(context, "context");
        if (!isDeclaration) {
            if (!function2.getTypeParameters().isEmpty()) {
                context.trace.report(Errors.TYPE_PARAMETERS_NOT_ALLOWED.on((KtDeclaration)((PsiElement)function2)));
            }
            if (function2.getName() != null) {
                BindingTrace bindingTrace = context.trace;
                PsiElement psiElement = function2.getNameIdentifier();
                Intrinsics.checkNotNull(psiElement);
                bindingTrace.report(Errors.ANONYMOUS_FUNCTION_WITH_NAME.on(psiElement));
            }
            for (KtParameter parameter : function2.getValueParameters()) {
                if (parameter.hasDefaultValue()) {
                    context.trace.report(Errors.ANONYMOUS_FUNCTION_PARAMETER_WITH_DEFAULT_VALUE.on((KtParameter)((PsiElement)parameter)));
                }
                if (!parameter.isVarArg()) continue;
                context.trace.report(Errors.USELESS_VARARG_ON_PARAMETER.on((KtParameter)((PsiElement)parameter)));
            }
        }
        SimpleFunctionDescriptor functionDescriptor = null;
        if (isDeclaration) {
            boolean parameter;
            FunctionDescriptorResolver functionDescriptorResolver = this.components.functionDescriptorResolver;
            DeclarationDescriptor declarationDescriptor = context.scope.getOwnerDescriptor();
            LexicalScope lexicalScope = context.scope;
            Intrinsics.checkNotNullExpressionValue(lexicalScope, "scope");
            BindingTrace bindingTrace = context.trace;
            Intrinsics.checkNotNullExpressionValue(bindingTrace, "trace");
            DataFlowInfo dataFlowInfo = context.dataFlowInfo;
            Intrinsics.checkNotNullExpressionValue(dataFlowInfo, "dataFlowInfo");
            functionDescriptor = functionDescriptorResolver.resolveFunctionDescriptor(declarationDescriptor, lexicalScope, function2, bindingTrace, dataFlowInfo, context.inferenceSession);
            boolean bl = parameter = statementScope != null;
            if (_Assertions.ENABLED && !parameter) {
                boolean $i$a$-assert-FunctionsTypingVisitor$visitNamedFunction$22 = false;
                String $i$a$-assert-FunctionsTypingVisitor$visitNamedFunction$22 = "statementScope must be not null for function: " + function2.getName() + " at location " + PsiDiagnosticUtils.atLocation(function2);
                throw new AssertionError((Object)$i$a$-assert-FunctionsTypingVisitor$visitNamedFunction$22);
            }
            LexicalWritableScope lexicalWritableScope = statementScope;
            Intrinsics.checkNotNull(lexicalWritableScope);
            lexicalWritableScope.addFunctionDescriptor(functionDescriptor);
        } else {
            FunctionDescriptorResolver functionDescriptorResolver = this.components.functionDescriptorResolver;
            DeclarationDescriptor declarationDescriptor = context.scope.getOwnerDescriptor();
            LexicalScope lexicalScope = context.scope;
            Intrinsics.checkNotNullExpressionValue(lexicalScope, "scope");
            BindingTrace bindingTrace = context.trace;
            Intrinsics.checkNotNullExpressionValue(bindingTrace, "trace");
            DataFlowInfo dataFlowInfo = context.dataFlowInfo;
            Intrinsics.checkNotNullExpressionValue(dataFlowInfo, "dataFlowInfo");
            KotlinType kotlinType = context.expectedType;
            Intrinsics.checkNotNullExpressionValue(kotlinType, "expectedType");
            functionDescriptor = functionDescriptorResolver.resolveFunctionExpressionDescriptor(declarationDescriptor, lexicalScope, function2, bindingTrace, dataFlowInfo, kotlinType, context.inferenceSession);
        }
        ForceResolveUtil.forceResolveAllContents(functionDescriptor.getAnnotations());
        LexicalScope lexicalScope = FunctionDescriptorUtil.getFunctionInnerScope(context.scope, functionDescriptor, context.trace, this.components.overloadChecker);
        Intrinsics.checkNotNullExpressionValue(lexicalScope, "getFunctionInnerScope(...)");
        LexicalScope functionInnerScope = lexicalScope;
        if (!function2.hasDeclaredReturnType() && !function2.hasBlockBody()) {
            ForceResolveUtil.forceResolveAllContents(functionDescriptor.getReturnType());
        } else {
            this.components.expressionTypingServices.checkFunctionReturnType(functionInnerScope, function2, functionDescriptor, context.dataFlowInfo, null, context.trace, context);
        }
        ValueParameterResolver valueParameterResolver = this.components.valueParameterResolver;
        List<KtParameter> list = function2.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list, "getValueParameters(...)");
        List<ValueParameterDescriptor> list2 = functionDescriptor.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list2, "getValueParameters(...)");
        DataFlowInfo dataFlowInfo = context.dataFlowInfo;
        Intrinsics.checkNotNullExpressionValue(dataFlowInfo, "dataFlowInfo");
        BindingTrace bindingTrace = context.trace;
        Intrinsics.checkNotNullExpressionValue(bindingTrace, "trace");
        valueParameterResolver.resolveValueParameters(list, list2, functionInnerScope, dataFlowInfo, bindingTrace, context.inferenceSession);
        this.components.modifiersChecker.withTrace(context.trace).checkModifiersForLocalDeclaration(function2, functionDescriptor);
        IdentifierChecker identifierChecker = this.components.identifierChecker;
        KtDeclaration ktDeclaration = function2;
        BindingTrace bindingTrace2 = context.trace;
        Intrinsics.checkNotNullExpressionValue(bindingTrace2, "trace");
        identifierChecker.checkDeclaration(ktDeclaration, bindingTrace2);
        DeclarationsCheckerBuilder declarationsCheckerBuilder = this.components.declarationsCheckerBuilder;
        BindingTrace bindingTrace3 = context.trace;
        Intrinsics.checkNotNullExpressionValue(bindingTrace3, "trace");
        declarationsCheckerBuilder.withTrace(bindingTrace3).checkFunction(function2, functionDescriptor);
        if (isDeclaration) {
            kotlinTypeInfo = TypeInfoFactoryKt.createTypeInfo(this.components.dataFlowAnalyzer.checkStatementType(function2, context), context);
        } else {
            boolean newInferenceEnabled = this.components.languageVersionSettings.supportsFeature(LanguageFeature.NewInference);
            KotlinBuiltIns kotlinBuiltIns = this.components.builtIns;
            Intrinsics.checkNotNullExpressionValue(kotlinBuiltIns, "builtIns");
            KotlinType resultType = FunctionsTypingVisitorKt.createFunctionType$default(functionDescriptor, kotlinBuiltIns, false, false, 4, null);
            if (newInferenceEnabled) {
                KotlinType kotlinType = context.expectedType;
                Intrinsics.checkNotNullExpressionValue(kotlinType, "expectedType");
                if (!TypeUtilsKt.contains(kotlinType, FunctionsTypingVisitor::visitNamedFunction$lambda$1)) {
                    KotlinBuiltIns kotlinBuiltIns2 = this.components.builtIns;
                    Intrinsics.checkNotNullExpressionValue(kotlinBuiltIns2, "builtIns");
                    KotlinType typeToTypeCheck = FunctionsTypingVisitorKt.createFunctionType(functionDescriptor, kotlinBuiltIns2, false, true);
                    this.components.dataFlowAnalyzer.checkType(typeToTypeCheck, (KtExpression)function2, (ResolutionContext)context);
                }
                kotlinTypeInfo = TypeInfoFactoryKt.createTypeInfo(resultType, context);
            } else {
                KotlinTypeInfo kotlinTypeInfo2 = this.components.dataFlowAnalyzer.createCheckedTypeInfo(resultType, context, function2);
                Intrinsics.checkNotNull(kotlinTypeInfo2);
                kotlinTypeInfo = kotlinTypeInfo2;
            }
        }
        return kotlinTypeInfo;
    }

    @Override
    @Nullable
    public KotlinTypeInfo visitLambdaExpression(@NotNull KtLambdaExpression expression, @NotNull ExpressionTypingContext context) {
        KtParameterList valueParameterList;
        Intrinsics.checkNotNullParameter(expression, "expression");
        Intrinsics.checkNotNullParameter(context, "context");
        if (!this.components.languageVersionSettings.supportsFeature(LanguageFeature.YieldIsNoMoreReserved)) {
            PsiElement psiElement = expression;
            BindingTrace bindingTrace = context.trace;
            Intrinsics.checkNotNullExpressionValue(bindingTrace, "trace");
            ReservedCheckingKt.checkReservedYieldBeforeLambda(psiElement, bindingTrace);
        }
        if (!expression.getFunctionLiteral().hasBody()) {
            return null;
        }
        KotlinType kotlinType = context.expectedType;
        Intrinsics.checkNotNullExpressionValue(kotlinType, "expectedType");
        KotlinType expectedType = kotlinType;
        boolean functionTypeExpected = this.isBuiltinFunctionalType(expectedType);
        boolean suspendFunctionTypeExpected = this.isSuspendFunctionType(expectedType);
        AnonymousFunctionDescriptor functionDescriptor = this.createFunctionLiteralDescriptor(expression, context);
        List<KtParameter> list = expression.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list, "getValueParameters(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtParameter it = (KtParameter)element$iv;
            boolean bl = false;
            IdentifierChecker identifierChecker = this.components.identifierChecker;
            Intrinsics.checkNotNull(it);
            KtDeclaration ktDeclaration = it;
            BindingTrace bindingTrace = context.trace;
            Intrinsics.checkNotNullExpressionValue(bindingTrace, "trace");
            identifierChecker.checkDeclaration(ktDeclaration, bindingTrace);
            KtNamedDeclaration ktNamedDeclaration = it;
            BindingTrace bindingTrace2 = context.trace;
            Intrinsics.checkNotNullExpressionValue(bindingTrace2, "trace");
            DiagnosticSink diagnosticSink = bindingTrace2;
            LanguageVersionSettings languageVersionSettings = this.components.languageVersionSettings;
            Intrinsics.checkNotNullExpressionValue(languageVersionSettings, "languageVersionSettings");
            UnderscoreChecker.INSTANCE.checkNamed(ktNamedDeclaration, diagnosticSink, languageVersionSettings, true);
        }
        KtParameterList ktParameterList = valueParameterList = expression.getFunctionLiteral().getValueParameterList();
        if ((ktParameterList != null ? (KotlinPlaceHolderStub)ktParameterList.getStub() : null) == null) {
            KtParameterList ktParameterList2 = valueParameterList;
            PsiElement psiElement = ktParameterList2 != null ? ktParameterList2.getTrailingComma() : null;
            BindingTrace bindingTrace = context.trace;
            Intrinsics.checkNotNullExpressionValue(bindingTrace, "trace");
            LanguageVersionSettings languageVersionSettings = context.languageVersionSettings;
            Intrinsics.checkNotNullExpressionValue(languageVersionSettings, "languageVersionSettings");
            TrailingCommaChecker.INSTANCE.check(psiElement, bindingTrace, languageVersionSettings);
        }
        KotlinType safeReturnType = this.computeReturnType(expression, context, functionDescriptor, functionTypeExpected);
        functionDescriptor.setReturnType(safeReturnType);
        TypeResolutionInterceptor typeResolutionInterceptor = this.components.typeResolutionInterceptor;
        KtElement ktElement = expression;
        SimpleFunctionDescriptor simpleFunctionDescriptor = functionDescriptor;
        KotlinBuiltIns kotlinBuiltIns = this.components.builtIns;
        Intrinsics.checkNotNullExpressionValue(kotlinBuiltIns, "builtIns");
        KotlinType kotlinType2 = FunctionsTypingVisitorKt.createFunctionType$default(simpleFunctionDescriptor, kotlinBuiltIns, suspendFunctionTypeExpected, false, 4, null);
        Intrinsics.checkNotNull(kotlinType2);
        KotlinType resultType = typeResolutionInterceptor.interceptType(ktElement, context, kotlinType2);
        if (context.inferenceSession instanceof BuilderInferenceSession) {
            ((BuilderInferenceSession)context.inferenceSession).addExpression(expression);
        }
        if (functionTypeExpected) {
            return TypeInfoFactoryKt.createTypeInfo(resultType, context);
        }
        return this.components.dataFlowAnalyzer.createCheckedTypeInfo(resultType, context, expression);
    }

    private final AnonymousFunctionDescriptor createFunctionLiteralDescriptor(KtLambdaExpression expression, ExpressionTypingContext context) {
        KtFunctionLiteral ktFunctionLiteral = expression.getFunctionLiteral();
        Intrinsics.checkNotNullExpressionValue(ktFunctionLiteral, "getFunctionLiteral(...)");
        KtFunctionLiteral functionLiteral = ktFunctionLiteral;
        DeclarationDescriptor declarationDescriptor = context.scope.getOwnerDescriptor();
        AnnotationResolver annotationResolver = this.components.annotationResolver;
        LexicalScope lexicalScope = context.scope;
        Intrinsics.checkNotNullExpressionValue(lexicalScope, "scope");
        List<KtAnnotationEntry> list = KtPsiUtilKt.getAnnotationEntries(expression);
        BindingTrace bindingTrace = context.trace;
        Intrinsics.checkNotNullExpressionValue(bindingTrace, "trace");
        Annotations annotations2 = annotationResolver.resolveAnnotationsWithArguments(lexicalScope, list, bindingTrace);
        SourceElement sourceElement = KotlinSourceElementKt.toSourceElement(functionLiteral);
        KotlinType kotlinType = context.expectedType;
        Intrinsics.checkNotNullExpressionValue(kotlinType, "expectedType");
        AnonymousFunctionDescriptor it = new AnonymousFunctionDescriptor(declarationDescriptor, annotations2, CallableMemberDescriptor.Kind.DECLARATION, sourceElement, this.isSuspendFunctionType(kotlinType));
        boolean bl = false;
        AnonymousFunctionDescriptor functionDescriptor = this.facade.getComponents().typeResolutionInterceptor.interceptFunctionLiteralDescriptor(expression, context, it);
        FunctionDescriptorResolver functionDescriptorResolver = this.components.functionDescriptorResolver;
        DeclarationDescriptor declarationDescriptor2 = context.scope.getOwnerDescriptor();
        LexicalScope lexicalScope2 = context.scope;
        Intrinsics.checkNotNullExpressionValue(lexicalScope2, "scope");
        KtFunction ktFunction = functionLiteral;
        SimpleFunctionDescriptorImpl simpleFunctionDescriptorImpl = functionDescriptor;
        BindingTrace bindingTrace2 = context.trace;
        Intrinsics.checkNotNullExpressionValue(bindingTrace2, "trace");
        KotlinType kotlinType2 = context.expectedType;
        Intrinsics.checkNotNullExpressionValue(kotlinType2, "expectedType");
        DataFlowInfo dataFlowInfo = context.dataFlowInfo;
        Intrinsics.checkNotNullExpressionValue(dataFlowInfo, "dataFlowInfo");
        functionDescriptorResolver.initializeFunctionDescriptorAndExplicitReturnType(declarationDescriptor2, lexicalScope2, ktFunction, simpleFunctionDescriptorImpl, bindingTrace2, kotlinType2, dataFlowInfo, context.inferenceSession);
        for (ValueParameterDescriptor parameterDescriptor : functionDescriptor.getValueParameters()) {
            ForceResolveUtil.forceResolveAllContents(parameterDescriptor.getAnnotations());
        }
        BindingContextUtils.recordFunctionDeclarationToDescriptor(context.trace, functionLiteral, functionDescriptor);
        return functionDescriptor;
    }

    private final boolean isBuiltinFunctionalType(KotlinType $this$isBuiltinFunctionalType) {
        return !TypeUtils.noExpectedType($this$isBuiltinFunctionalType) && FunctionTypesKt.isBuiltinFunctionalType($this$isBuiltinFunctionalType);
    }

    private final boolean isSuspendFunctionType(KotlinType $this$isSuspendFunctionType) {
        return !TypeUtils.noExpectedType($this$isSuspendFunctionType) && FunctionTypesKt.isSuspendFunctionType($this$isSuspendFunctionType);
    }

    private final KotlinType computeReturnType(KtLambdaExpression expression, ExpressionTypingContext context, SimpleFunctionDescriptorImpl functionDescriptor, boolean functionTypeExpected) {
        KotlinType kotlinType;
        KotlinType kotlinType2;
        if (functionTypeExpected) {
            KotlinType kotlinType3 = context.expectedType;
            Intrinsics.checkNotNullExpressionValue(kotlinType3, "expectedType");
            kotlinType2 = FunctionTypesKt.getReturnTypeFromFunctionType(kotlinType3);
        } else {
            kotlinType2 = null;
        }
        KotlinType expectedReturnType = kotlinType2;
        KotlinType returnType = this.computeUnsafeReturnType(expression, context, functionDescriptor, expectedReturnType);
        if (!expression.getFunctionLiteral().hasDeclaredReturnType() && functionTypeExpected) {
            KotlinType kotlinType4 = expectedReturnType;
            Intrinsics.checkNotNull(kotlinType4);
            if (!TypeUtils.noExpectedType(kotlinType4) && KotlinBuiltIns.isUnit(expectedReturnType)) {
                SimpleType simpleType2 = this.components.builtIns.getUnitType();
                Intrinsics.checkNotNullExpressionValue(simpleType2, "getUnitType(...)");
                return simpleType2;
            }
        }
        if ((kotlinType = returnType) == null) {
            SimpleType simpleType3 = TypeUtils.CANNOT_INFER_FUNCTION_PARAM_TYPE;
            Intrinsics.checkNotNullExpressionValue(simpleType3, "CANNOT_INFER_FUNCTION_PARAM_TYPE");
            kotlinType = simpleType3;
        }
        return kotlinType;
    }

    private final KotlinType computeUnsafeReturnType(KtLambdaExpression expression, ExpressionTypingContext context, SimpleFunctionDescriptorImpl functionDescriptor, KotlinType expectedReturnType) {
        KotlinType typeOfBodyExpression;
        KtFunctionLiteral functionLiteral;
        block2: {
            KtFunctionLiteral ktFunctionLiteral = expression.getFunctionLiteral();
            Intrinsics.checkNotNullExpressionValue(ktFunctionLiteral, "getFunctionLiteral(...)");
            functionLiteral = ktFunctionLiteral;
            KotlinType kotlinType = expectedReturnType;
            if (kotlinType == null) {
                SimpleType simpleType2 = TypeUtils.NO_EXPECTED_TYPE;
                Intrinsics.checkNotNullExpressionValue(simpleType2, "NO_EXPECTED_TYPE");
                kotlinType = simpleType2;
            }
            KotlinType expectedType = kotlinType;
            LexicalScope lexicalScope = FunctionDescriptorUtil.getFunctionInnerScope(context.scope, functionDescriptor, context.trace, this.components.overloadChecker);
            Intrinsics.checkNotNullExpressionValue(lexicalScope, "getFunctionInnerScope(...)");
            LexicalScope functionInnerScope = lexicalScope;
            Object Context2 = ((ExpressionTypingContext)context.replaceScope(functionInnerScope)).replaceExpectedType(expectedType);
            Intrinsics.checkNotNullExpressionValue(Context2, "replaceExpectedType(...)");
            ExpressionTypingContext newContext = (ExpressionTypingContext)Context2;
            context.trace.record(BindingContext.EXPECTED_RETURN_TYPE, functionLiteral, expectedType);
            KotlinResolutionCallbacksImpl.LambdaInfo newInferenceLambdaInfo = (KotlinResolutionCallbacksImpl.LambdaInfo)context.trace.get(BindingContext.NEW_INFERENCE_LAMBDA_INFO, expression.getFunctionLiteral());
            if (newInferenceLambdaInfo == null && context.languageVersionSettings.supportsFeature(LanguageFeature.NewInference)) {
                Object Context3 = newContext.replaceContextDependency(ContextDependency.INDEPENDENT);
                Intrinsics.checkNotNullExpressionValue(Context3, "replaceContextDependency(...)");
                newContext = (ExpressionTypingContext)Context3;
            }
            ExpressionTypingServices expressionTypingServices = this.components.expressionTypingServices;
            KtBlockExpression ktBlockExpression = functionLiteral.getBodyExpression();
            Intrinsics.checkNotNull(ktBlockExpression);
            KotlinTypeInfo kotlinTypeInfo = expressionTypingServices.getBlockReturnedType(ktBlockExpression, CoercionStrategy.COERCION_TO_UNIT, newContext);
            Intrinsics.checkNotNullExpressionValue(kotlinTypeInfo, "getBlockReturnedType(...)");
            KotlinTypeInfo blockReturnedType = kotlinTypeInfo;
            typeOfBodyExpression = blockReturnedType.getType();
            KotlinResolutionCallbacksImpl.LambdaInfo lambdaInfo = newInferenceLambdaInfo;
            if (lambdaInfo == null) break block2;
            KotlinResolutionCallbacksImpl.LambdaInfo it = lambdaInfo;
            boolean bl = false;
            it.getLastExpressionInfo().setDataFlowInfoAfter(blockReturnedType.getDataFlowInfo());
        }
        return this.computeReturnTypeBasedOnReturnExpressions(functionLiteral, context, typeOfBodyExpression);
    }

    private final KotlinType computeReturnTypeBasedOnReturnExpressions(KtFunctionLiteral functionLiteral, ExpressionTypingContext context, KotlinType typeOfBodyExpression) {
        boolean bl;
        ArrayList returnedExpressionTypes;
        block9: {
            KtExpression returnedExpression;
            returnedExpressionTypes = Lists.newArrayList();
            boolean hasEmptyReturn = false;
            BindingTrace bindingTrace = context.trace;
            Intrinsics.checkNotNullExpressionValue(bindingTrace, "trace");
            Collection<KtReturnExpression> returnExpressions = this.collectReturns(functionLiteral, bindingTrace);
            for (KtReturnExpression returnExpression : returnExpressions) {
                returnedExpression = returnExpression.getReturnedExpression();
                if (returnedExpression == null) {
                    hasEmptyReturn = true;
                    continue;
                }
                Intrinsics.checkNotNull(returnedExpressionTypes);
                CollectionsKt.addIfNotNull(returnedExpressionTypes, context.trace.getType(returnedExpression));
            }
            if (hasEmptyReturn) {
                for (KtReturnExpression returnExpression : returnExpressions) {
                    KotlinType type2;
                    returnedExpression = returnExpression.getReturnedExpression();
                    if (returnedExpression == null || (type2 = context.trace.getType(returnedExpression)) != null && KotlinBuiltIns.isUnit(type2)) continue;
                    context.trace.report(Errors.RETURN_TYPE_MISMATCH.on((KtExpression)((PsiElement)returnedExpression), this.components.builtIns.getUnitType()));
                }
                return this.components.builtIns.getUnitType();
            }
            Intrinsics.checkNotNull(returnedExpressionTypes);
            CollectionsKt.addIfNotNull(returnedExpressionTypes, typeOfBodyExpression);
            if (returnedExpressionTypes.isEmpty()) {
                return null;
            }
            Iterable $this$any$iv = returnedExpressionTypes;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KotlinType it = (KotlinType)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull(it);
                    if (!TypeUtilsKt.contains(it, FunctionsTypingVisitor::computeReturnTypeBasedOnReturnExpressions$lambda$6$lambda$5)) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
        }
        if (bl) {
            return null;
        }
        return CommonSupertypes.commonSupertype(returnedExpressionTypes);
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<KtReturnExpression> collectReturns(KtFunctionLiteral functionLiteral, BindingTrace trace) {
        void $this$filterTo$iv$iv;
        KtBlockExpression bodyExpression;
        ArrayList result2 = Lists.newArrayList();
        KtBlockExpression ktBlockExpression = bodyExpression = functionLiteral.getBodyExpression();
        if (ktBlockExpression != null) {
            Void cfr_ignored_0 = (Void)ktBlockExpression.accept((KtVisitor)new KtTreeVisitor<List<KtReturnExpression>>(){

                public Void visitReturnExpression(KtReturnExpression expression, List<KtReturnExpression> insideActualFunction) {
                    Intrinsics.checkNotNullParameter(expression, "expression");
                    Intrinsics.checkNotNullParameter(insideActualFunction, "insideActualFunction");
                    insideActualFunction.add(expression);
                    return null;
                }
            }, result2);
        }
        Intrinsics.checkNotNull(result2);
        Iterable $this$filter$iv = result2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PsiElement psiElement;
            KtReturnExpression it = (KtReturnExpression)element$iv$iv;
            boolean bl = false;
            if (it.getTargetLabel() != null) {
                KtSimpleNameExpression it2;
                boolean bl2 = false;
                psiElement = (PsiElement)trace.get(BindingContext.LABEL_TARGET, it2);
            } else {
                psiElement = null;
            }
            if (!Intrinsics.areEqual(psiElement, functionLiteral)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final void checkTypesForReturnStatements(@NotNull KtDeclarationWithBody function2, @NotNull BindingTrace trace, @NotNull KotlinType actualReturnType) {
        Intrinsics.checkNotNullParameter(function2, "function");
        Intrinsics.checkNotNullParameter(trace, "trace");
        Intrinsics.checkNotNullParameter(actualReturnType, "actualReturnType");
        if (function2.hasBlockBody()) {
            return;
        }
        if (!(function2 instanceof KtNamedFunction && ((KtNamedFunction)function2).getTypeReference() == null || function2 instanceof KtPropertyAccessor && ((KtPropertyAccessor)function2).getReturnTypeReference() != null)) {
            return;
        }
        for (KtReturnExpression returnForCheck : this.collectReturns(function2, trace)) {
            KotlinType expressionType;
            KtExpression expression = returnForCheck.getReturnedExpression();
            if (expression == null) {
                if (TypeUtilsKt.isUnit(actualReturnType)) continue;
                trace.report(Errors.RETURN_TYPE_MISMATCH.on((KtExpression)((PsiElement)returnForCheck), actualReturnType));
                continue;
            }
            if (trace.getType(expression) == null || KotlinTypeChecker.DEFAULT.isSubtypeOf(expressionType, actualReturnType)) continue;
            trace.report(Errors.TYPE_MISMATCH.on((KtExpression)((PsiElement)expression), expressionType, actualReturnType));
        }
    }

    private final List<KtReturnExpression> collectReturns(KtDeclarationWithBody function2, BindingTrace trace) {
        KtExpression ktExpression = function2.getBodyExpression();
        if (ktExpression == null) {
            return kotlin.collections.CollectionsKt.emptyList();
        }
        KtExpression bodyExpression = ktExpression;
        ArrayList<KtReturnExpression> returns = new ArrayList<KtReturnExpression>();
        bodyExpression.accept((KtVisitor)new KtTreeVisitor<Boolean>(function2, returns, trace){
            final /* synthetic */ KtDeclarationWithBody $function;
            final /* synthetic */ ArrayList<KtReturnExpression> $returns;
            final /* synthetic */ BindingTrace $trace;
            {
                this.$function = $function;
                this.$returns = $returns;
                this.$trace = $trace;
            }

            public Void visitReturnExpression(KtReturnExpression expression, boolean insideActualFunction) {
                PsiElement labelTarget;
                PsiElement psiElement;
                Intrinsics.checkNotNullParameter(expression, "expression");
                KtSimpleNameExpression ktSimpleNameExpression = expression.getTargetLabel();
                if (ktSimpleNameExpression != null) {
                    KtSimpleNameExpression ktSimpleNameExpression2 = ktSimpleNameExpression;
                    BindingTrace bindingTrace = this.$trace;
                    KtSimpleNameExpression it = ktSimpleNameExpression2;
                    boolean bl = false;
                    psiElement = (PsiElement)bindingTrace.get(BindingContext.LABEL_TARGET, it);
                } else {
                    psiElement = labelTarget = null;
                }
                if (Intrinsics.areEqual(labelTarget, this.$function) || labelTarget == null && insideActualFunction) {
                    this.$returns.add(expression);
                }
                return (Void)super.visitReturnExpression(expression, insideActualFunction);
            }

            public Void visitNamedFunction(KtNamedFunction function2, boolean data2) {
                Intrinsics.checkNotNullParameter(function2, "function");
                return (Void)super.visitNamedFunction(function2, false);
            }

            public Void visitPropertyAccessor(KtPropertyAccessor accessor, boolean data2) {
                Intrinsics.checkNotNullParameter(accessor, "accessor");
                return (Void)super.visitPropertyAccessor(accessor, false);
            }

            public Void visitAnonymousInitializer(KtAnonymousInitializer initializer, boolean data2) {
                Intrinsics.checkNotNullParameter(initializer, "initializer");
                return (Void)super.visitAnonymousInitializer(initializer, false);
            }
        }, true);
        return returns;
    }

    private static final boolean visitNamedFunction$lambda$1(UnwrappedType it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it == TypeUtils.NO_EXPECTED_TYPE;
    }

    private static final boolean computeReturnTypeBasedOnReturnExpressions$lambda$6$lambda$5(UnwrappedType it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getConstructor() instanceof TypeVariableTypeConstructor;
    }
}

