/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import com.google.common.collect.Multimap;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtContextReceiver;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionWithLabel;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtInstanceExpressionWithLabel;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.psi.psiUtil.ReservedCheckingKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorResolver;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u00016B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JE\u0010\u000f\u001a \u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\f0\u000bj\b\u0012\u0004\u0012\u00020\f`\r\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J%\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u00142\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\bH\u0007\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0019\u0010\u0018\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0012\u001a\u00020\u0017H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0017\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0017H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0019\u0010\u001e\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001d\u001a\u00020\u0017H\u0002\u00a2\u0006\u0004\b\u001e\u0010\u0019J\u0019\u0010 \u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u001d\u001a\u00020\u0017H\u0002\u00a2\u0006\u0004\b \u0010!J%\u0010%\u001a\u0004\u0018\u00010\f2\u0006\u0010\u001d\u001a\u00020\"2\n\u0010$\u001a\u0006\u0012\u0002\b\u00030#H\u0007\u00a2\u0006\u0004\b%\u0010&J)\u0010)\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010(\u001a\u00020'H\u0002\u00a2\u0006\u0004\b)\u0010*J+\u0010-\u001a\u00020,2\u0006\u0010\u001d\u001a\u00020+2\n\u0010$\u001a\u0006\u0012\u0002\b\u00030#2\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b-\u0010.J7\u00104\u001a\u0002032\u0006\u0010(\u001a\u00020'2\u0006\u0010/\u001a\u00020\u00062\u0006\u00100\u001a\u00020\u00112\u0006\u00101\u001a\u00020\f2\u0006\u00102\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b4\u00105"}, d2={"Lorg/jetbrains/kotlin/types/expressions/LabelResolver;", "", "<init>", "()V", "Lorg/jetbrains/kotlin/name/Name;", "labelName", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "labelExpression", "", "classNameLabelsEnabled", "Lkotlin/Pair;", "Ljava/util/LinkedHashSet;", "Lorg/jetbrains/kotlin/psi/KtElement;", "Lkotlin/collections/LinkedHashSet;", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "getElementsByLabelName", "(Lorg/jetbrains/kotlin/name/Name;Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;Z)Lkotlin/Pair;", "Lcom/intellij/psi/PsiElement;", "element", "addClassNameLabels", "", "getLabelNamesIfAny", "(Lcom/intellij/psi/PsiElement;Z)Ljava/util/List;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "getLabelForFunctionalExpression", "(Lorg/jetbrains/kotlin/psi/KtExpression;)Lorg/jetbrains/kotlin/name/Name;", "labeledExpression", "getExpressionUnderLabel", "(Lorg/jetbrains/kotlin/psi/KtExpression;)Lorg/jetbrains/kotlin/psi/KtExpression;", "expression", "getCallerName", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "getContainingCallExpression", "(Lorg/jetbrains/kotlin/psi/KtExpression;)Lorg/jetbrains/kotlin/psi/KtCallExpression;", "Lorg/jetbrains/kotlin/psi/KtExpressionWithLabel;", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "context", "resolveControlLabel", "(Lorg/jetbrains/kotlin/psi/KtExpressionWithLabel;Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;)Lorg/jetbrains/kotlin/psi/KtElement;", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "trace", "resolveNamedLabel", "(Lorg/jetbrains/kotlin/name/Name;Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;Lorg/jetbrains/kotlin/resolve/BindingTrace;)Lorg/jetbrains/kotlin/psi/KtElement;", "Lorg/jetbrains/kotlin/psi/KtInstanceExpressionWithLabel;", "Lorg/jetbrains/kotlin/types/expressions/LabelResolver$LabeledReceiverResolutionResult;", "resolveThisOrSuperLabel", "(Lorg/jetbrains/kotlin/psi/KtInstanceExpressionWithLabel;Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;Lorg/jetbrains/kotlin/name/Name;)Lorg/jetbrains/kotlin/types/expressions/LabelResolver$LabeledReceiverResolutionResult;", "target", "declarationElement", "closestElement", "isForExtensionReceiver", "", "reportLabelResolveWillChange", "(Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/psi/KtElement;Z)V", "LabeledReceiverResolutionResult"})
public final class LabelResolver {
    @NotNull
    public static final LabelResolver INSTANCE = new LabelResolver();

    private LabelResolver() {
    }

    private final Pair<LinkedHashSet<KtElement>, KtCallableDeclaration> getElementsByLabelName(Name labelName, KtSimpleNameExpression labelExpression, boolean classNameLabelsEnabled) {
        LinkedHashSet<KtExpression> elements = new LinkedHashSet<KtExpression>();
        KtCallableDeclaration typedElement = null;
        PsiElement parent2 = labelExpression.getParent();
        while (parent2 != null) {
            List<Name> names = this.getLabelNamesIfAny(parent2, classNameLabelsEnabled);
            if (names.contains(labelName)) {
                elements.add(this.getExpressionUnderLabel((KtExpression)parent2));
            } else if (parent2 instanceof KtCallableDeclaration && typedElement == null) {
                String nameForReceiverLabel;
                KtTypeReference receiverTypeReference;
                KtTypeReference ktTypeReference = receiverTypeReference = ((KtCallableDeclaration)parent2).getReceiverTypeReference();
                String string2 = nameForReceiverLabel = ktTypeReference != null ? ktTypeReference.nameForReceiverLabel() : null;
                if (Intrinsics.areEqual(nameForReceiverLabel, labelName.asString())) {
                    typedElement = (KtCallableDeclaration)parent2;
                }
            }
            parent2 = parent2 instanceof KtCodeFragment ? ((KtCodeFragment)parent2).getContext() : parent2.getParent();
        }
        return TuplesKt.to(elements, typedElement);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Name> getLabelNamesIfAny(@NotNull PsiElement element, boolean addClassNameLabels) {
        KtDeclaration ktDeclaration;
        Object $i$f$mapNotNullTo2;
        Intrinsics.checkNotNullParameter(element, "element");
        List result2 = new ArrayList();
        Object object = element;
        if (object instanceof KtLabeledExpression) {
            CollectionsKt.addIfNotNull(result2, ((KtLabeledExpression)element).getLabelNameAsName());
        } else {
            if (object instanceof KtFunctionLiteral) {
                PsiElement psiElement = ((KtFunctionLiteral)element).getParent();
                Intrinsics.checkNotNullExpressionValue(psiElement, "getParent(...)");
                return this.getLabelNamesIfAny(psiElement, false);
            }
            if (object instanceof KtLambdaExpression) {
                CollectionsKt.addIfNotNull(result2, this.getLabelForFunctionalExpression((KtExpression)element));
            }
        }
        if (element instanceof KtClass) {
            void $this$mapNotNullTo$iv;
            object = ((KtClass)element).getContextReceivers();
            boolean $i$f$mapNotNullTo2 = false;
            void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Name name;
                Object element$iv$iv;
                Object element$iv = element$iv$iv = iterator2.next();
                boolean bl = false;
                KtContextReceiver it = (KtContextReceiver)element$iv;
                boolean bl2 = false;
                if (it.name() != null) {
                    String s;
                    boolean bl3 = false;
                    name = Name.identifier(s);
                } else {
                    name = null;
                }
                if (name == null) continue;
                Name it$iv = name;
                boolean bl4 = false;
                ((Collection)result2).add(it$iv);
            }
        }
        if (($i$f$mapNotNullTo2 = element) instanceof KtNamedFunction) {
            Collection collection = result2;
            Name name = ((KtNamedFunction)element).getNameAsName();
            if (name == null) {
                name = this.getLabelForFunctionalExpression((KtExpression)element);
            }
            CollectionsKt.addIfNotNull(collection, name);
            ktDeclaration = (KtDeclaration)element;
        } else if ($i$f$mapNotNullTo2 instanceof KtPropertyAccessor) {
            KtProperty ktProperty = ((KtPropertyAccessor)element).getProperty();
            Intrinsics.checkNotNullExpressionValue(ktProperty, "getProperty(...)");
            ktDeclaration = ktProperty;
        } else {
            return result2;
        }
        KtDeclaration functionOrProperty = ktDeclaration;
        if (addClassNameLabels) {
            void $this$mapNotNullTo$iv;
            Object object2 = ((KtCallableDeclaration)functionOrProperty).getReceiverTypeReference();
            if (object2 != null && (object2 = ((KtTypeReference)object2).nameForReceiverLabel()) != null) {
                Object it = object2;
                boolean bl = false;
                Name name = Name.identifier((String)it);
                Intrinsics.checkNotNullExpressionValue(name, "identifier(...)");
                result2.add(name);
            }
            List<KtContextReceiver> list = ((KtCallableDeclaration)functionOrProperty).getContextReceivers();
            Intrinsics.checkNotNullExpressionValue(list, "getContextReceivers(...)");
            $i$f$mapNotNullTo2 = list;
            boolean $i$f$mapNotNullTo3 = false;
            void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
            boolean $i$f$forEach = false;
            Iterator iterator3 = $this$forEach$iv$iv.iterator();
            while (iterator3.hasNext()) {
                Name name;
                Object element$iv$iv;
                Object element$iv = element$iv$iv = iterator3.next();
                boolean bl = false;
                KtContextReceiver it = (KtContextReceiver)element$iv;
                boolean bl5 = false;
                if (it.name() != null) {
                    String s;
                    boolean bl6 = false;
                    name = Name.identifier(s);
                } else {
                    name = null;
                }
                if (name == null) continue;
                Name it$iv = name;
                boolean bl7 = false;
                ((Collection)result2).add(it$iv);
            }
        }
        return result2;
    }

    private final Name getLabelForFunctionalExpression(KtExpression element) {
        PsiElement parent2 = element.getParent();
        return parent2 instanceof KtLabeledExpression ? kotlin.collections.CollectionsKt.singleOrNull(this.getLabelNamesIfAny(parent2, false)) : (parent2 instanceof KtBinaryExpression ? ((KtBinaryExpression)parent2).getOperationReference().getReferencedNameAsName() : this.getCallerName(element));
    }

    private final KtExpression getExpressionUnderLabel(KtExpression labeledExpression) {
        KtExpression ktExpression;
        KtExpression ktExpression2 = KtPsiUtil.safeDeparenthesize(labeledExpression);
        Intrinsics.checkNotNullExpressionValue(ktExpression2, "safeDeparenthesize(...)");
        KtExpression expression = ktExpression2;
        if (expression instanceof KtLambdaExpression) {
            KtFunctionLiteral ktFunctionLiteral = ((KtLambdaExpression)expression).getFunctionLiteral();
            Intrinsics.checkNotNullExpressionValue(ktFunctionLiteral, "getFunctionLiteral(...)");
            ktExpression = ktFunctionLiteral;
        } else {
            ktExpression = expression;
        }
        return ktExpression;
    }

    private final Name getCallerName(KtExpression expression) {
        KtSimpleNameExpression calleeExpression;
        KtCallExpression ktCallExpression = this.getContainingCallExpression(expression);
        if (ktCallExpression == null) {
            return null;
        }
        KtCallExpression callExpression = ktCallExpression;
        KtExpression ktExpression = callExpression.getCalleeExpression();
        KtSimpleNameExpression ktSimpleNameExpression = calleeExpression = ktExpression instanceof KtSimpleNameExpression ? (KtSimpleNameExpression)ktExpression : null;
        return ktSimpleNameExpression != null ? ktSimpleNameExpression.getReferencedNameAsName() : null;
    }

    private final KtCallExpression getContainingCallExpression(KtExpression expression) {
        PsiElement call2;
        PsiElement parent2 = expression.getParent();
        if (parent2 instanceof KtLambdaArgument && (call2 = ((KtLambdaArgument)parent2).getParent()) instanceof KtCallExpression) {
            return (KtCallExpression)call2;
        }
        if (parent2 instanceof KtValueArgument) {
            PsiElement psiElement = ((KtValueArgument)parent2).getParent();
            if (psiElement == null) {
                return null;
            }
            PsiElement argList = psiElement;
            PsiElement call3 = argList.getParent();
            if (call3 instanceof KtCallExpression) {
                return (KtCallExpression)call3;
            }
        }
        return null;
    }

    @Nullable
    public final KtElement resolveControlLabel(@NotNull KtExpressionWithLabel expression, @NotNull ResolutionContext<?> context) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        Intrinsics.checkNotNullParameter(context, "context");
        KtSimpleNameExpression labelElement = expression.getTargetLabel();
        if (!context.languageVersionSettings.supportsFeature(LanguageFeature.YieldIsNoMoreReserved)) {
            BindingTrace bindingTrace = context.trace;
            Intrinsics.checkNotNullExpressionValue(bindingTrace, "trace");
            ReservedCheckingKt.checkReservedYield(labelElement, bindingTrace);
        }
        Name labelName = expression.getLabelNameAsName();
        if (labelElement == null || labelName == null) {
            return null;
        }
        BindingTrace bindingTrace = context.trace;
        Intrinsics.checkNotNullExpressionValue(bindingTrace, "trace");
        KtElement ktElement = this.resolveNamedLabel(labelName, labelElement, bindingTrace);
        if (ktElement == null) {
            LabelResolver $this$resolveControlLabel_u24lambda_u245 = this;
            boolean bl = false;
            context.trace.report(Errors.UNRESOLVED_REFERENCE.on((KtReferenceExpression)((PsiElement)labelElement), labelElement));
            ktElement = null;
        }
        return ktElement;
    }

    private final KtElement resolveNamedLabel(Name labelName, KtSimpleNameExpression labelExpression, BindingTrace trace) {
        LinkedHashSet<KtElement> list = this.getElementsByLabelName(labelName, labelExpression, false).getFirst();
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() > 1) {
            trace.report(Errors.LABEL_NAME_CLASH.on((KtSimpleNameExpression)((PsiElement)labelExpression)));
        }
        Object t = kotlin.collections.CollectionsKt.first((Iterable)list);
        KtElement it = (KtElement)t;
        boolean bl = false;
        trace.record(BindingContext.LABEL_TARGET, labelExpression, it);
        return (KtElement)t;
    }

    @NotNull
    public final LabeledReceiverResolutionResult resolveThisOrSuperLabel(@NotNull KtInstanceExpressionWithLabel expression, @NotNull ResolutionContext<?> context, @NotNull Name labelName) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(labelName, "labelName");
        KtReferenceExpression ktReferenceExpression = expression.getInstanceReference();
        Intrinsics.checkNotNullExpressionValue(ktReferenceExpression, "getInstanceReference(...)");
        KtReferenceExpression referenceExpression = ktReferenceExpression;
        KtSimpleNameExpression ktSimpleNameExpression = expression.getTargetLabel();
        if (ktSimpleNameExpression == null) {
            throw new IllegalStateException(((Object)expression).toString());
        }
        KtSimpleNameExpression targetLabelExpression = ktSimpleNameExpression;
        LexicalScope lexicalScope = context.scope;
        Intrinsics.checkNotNullExpressionValue(lexicalScope, "scope");
        LexicalScope scope2 = lexicalScope;
        Collection<DeclarationDescriptor> declarationsByLabel = ScopeUtilsKt.getDeclarationsByLabel(scope2, labelName);
        Pair<LinkedHashSet<KtElement>, KtCallableDeclaration> pair = this.getElementsByLabelName(labelName, targetLabelExpression, expression instanceof KtThisExpression && context.languageVersionSettings.supportsFeature(LanguageFeature.ContextReceivers));
        LinkedHashSet<KtElement> elementsByLabel = pair.component1();
        KtCallableDeclaration typedElement = pair.component2();
        BindingTrace bindingTrace = context.trace;
        Intrinsics.checkNotNullExpressionValue(bindingTrace, "trace");
        BindingTrace trace = bindingTrace;
        switch (declarationsByLabel.size()) {
            case 1: {
                ReceiverParameterDescriptor receiverParameterDescriptor;
                DeclarationDescriptor declarationDescriptor;
                DeclarationDescriptor declarationDescriptor2 = declarationDescriptor = (DeclarationDescriptor)kotlin.collections.CollectionsKt.single((Iterable)declarationsByLabel);
                if (declarationDescriptor2 instanceof ClassDescriptor) {
                    receiverParameterDescriptor = ((ClassDescriptor)declarationDescriptor).getThisAsReceiverParameter();
                } else if (declarationDescriptor2 instanceof FunctionDescriptor) {
                    receiverParameterDescriptor = ((FunctionDescriptor)declarationDescriptor).getExtensionReceiverParameter();
                } else if (declarationDescriptor2 instanceof PropertyDescriptor) {
                    receiverParameterDescriptor = ((PropertyDescriptor)declarationDescriptor).getExtensionReceiverParameter();
                } else {
                    throw new UnsupportedOperationException("Unsupported descriptor: " + declarationDescriptor);
                }
                ReceiverParameterDescriptor thisReceiver = receiverParameterDescriptor;
                PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration(declarationDescriptor);
                if (psiElement == null) {
                    throw new IllegalStateException(("No PSI element for descriptor: " + declarationDescriptor).toString());
                }
                PsiElement declarationElement = psiElement;
                trace.record(BindingContext.LABEL_TARGET, targetLabelExpression, declarationElement);
                trace.record(BindingContext.REFERENCE_TARGET, referenceExpression, declarationDescriptor);
                KtElement closestElement = (KtElement)kotlin.collections.CollectionsKt.firstOrNull((Iterable)elementsByLabel);
                if (closestElement != null && SequencesKt.contains(PsiUtilsKt.getParents(closestElement), declarationElement)) {
                    this.reportLabelResolveWillChange(trace, targetLabelExpression, declarationElement, closestElement, false);
                } else if (typedElement != null && SequencesKt.contains(PsiUtilsKt.getParents(typedElement), declarationElement)) {
                    this.reportLabelResolveWillChange(trace, targetLabelExpression, declarationElement, typedElement, true);
                }
                if (declarationDescriptor instanceof ClassDescriptor && !DescriptorResolver.checkHasOuterClassInstance(scope2, trace, targetLabelExpression, (ClassDescriptor)declarationDescriptor)) {
                    return LabeledReceiverResolutionResult.Companion.labelResolutionFailed();
                }
                return LabeledReceiverResolutionResult.Companion.labelResolutionSuccess(thisReceiver);
            }
            case 0: {
                KtElement ktElement;
                if (elementsByLabel.size() > 1) {
                    trace.report(Errors.LABEL_NAME_CLASH.on((KtSimpleNameExpression)((PsiElement)targetLabelExpression)));
                }
                KtElement ktElement2 = (KtElement)kotlin.collections.CollectionsKt.firstOrNull((Iterable)elementsByLabel);
                if (ktElement2 != null) {
                    KtElement declarationElement;
                    KtElement it = declarationElement = ktElement2;
                    boolean bl = false;
                    trace.record(BindingContext.LABEL_TARGET, targetLabelExpression, it);
                    ktElement = declarationElement;
                } else {
                    ktElement = null;
                }
                KtElement element = ktElement;
                DeclarationDescriptor declarationDescriptor = trace.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, element);
                if (declarationDescriptor instanceof FunctionDescriptor || declarationDescriptor instanceof ClassDescriptor) {
                    Object object;
                    ReceiverParameterDescriptor receiverParameterDescriptor;
                    Multimap labelNameToReceiverMap;
                    DeclarationDescriptor declarationDescriptor3;
                    BindingContext bindingContext = trace.getBindingContext();
                    ReadOnlySlice readOnlySlice = BindingContext.DESCRIPTOR_TO_CONTEXT_RECEIVER_MAP;
                    if (declarationDescriptor instanceof PropertyAccessorDescriptor) {
                        PropertyDescriptor propertyDescriptor = ((PropertyAccessorDescriptor)declarationDescriptor).getCorrespondingProperty();
                        declarationDescriptor3 = propertyDescriptor;
                        Intrinsics.checkNotNullExpressionValue(propertyDescriptor, "getCorrespondingProperty(...)");
                    } else {
                        declarationDescriptor3 = declarationDescriptor;
                    }
                    Multimap multimap = labelNameToReceiverMap = (Multimap)bindingContext.get(readOnlySlice, declarationDescriptor3);
                    Collection thisReceivers = multimap != null ? multimap.get(labelName.getIdentifier()) : null;
                    Object object2 = thisReceivers;
                    if (object2 == null || object2.isEmpty()) {
                        FunctionDescriptor functionDescriptor = declarationDescriptor instanceof FunctionDescriptor ? (FunctionDescriptor)declarationDescriptor : null;
                        receiverParameterDescriptor = functionDescriptor != null ? functionDescriptor.getExtensionReceiverParameter() : null;
                    } else if (thisReceivers.size() == 1) {
                        receiverParameterDescriptor = (ReceiverParameterDescriptor)kotlin.collections.CollectionsKt.single(thisReceivers);
                    } else {
                        BindingContextUtils.reportAmbiguousLabel(trace, targetLabelExpression, declarationsByLabel);
                        return LabeledReceiverResolutionResult.Companion.labelResolutionFailed();
                    }
                    ReceiverParameterDescriptor receiverParameterDescriptor2 = receiverParameterDescriptor;
                    if (receiverParameterDescriptor2 != null) {
                        Object it = object2 = receiverParameterDescriptor2;
                        boolean bl = false;
                        trace.record(BindingContext.LABEL_TARGET, targetLabelExpression, element);
                        trace.record(BindingContext.REFERENCE_TARGET, referenceExpression, declarationDescriptor);
                        object = object2;
                    } else {
                        object = null;
                    }
                    Object thisReceiver = object;
                    return LabeledReceiverResolutionResult.Companion.labelResolutionSuccess((ReceiverParameterDescriptor)thisReceiver);
                }
                trace.report(Errors.UNRESOLVED_REFERENCE.on((KtReferenceExpression)((PsiElement)targetLabelExpression), targetLabelExpression));
                break;
            }
            default: {
                BindingContextUtils.reportAmbiguousLabel(trace, targetLabelExpression, declarationsByLabel);
            }
        }
        return LabeledReceiverResolutionResult.Companion.labelResolutionFailed();
    }

    private final void reportLabelResolveWillChange(BindingTrace trace, KtSimpleNameExpression target, PsiElement declarationElement, KtElement closestElement, boolean isForExtensionReceiver) {
        KtElement ktElement = closestElement;
        String closestDescription = ktElement instanceof KtFunctionLiteral ? "anonymous function" : (ktElement instanceof KtNamedFunction ? "function " + ((KtNamedFunction)closestElement).getName() + ' ' + LabelResolver.reportLabelResolveWillChange$suffix(isForExtensionReceiver) : (ktElement instanceof KtPropertyAccessor ? "property " + ((KtPropertyAccessor)closestElement).getProperty().getName() + ' ' + LabelResolver.reportLabelResolveWillChange$suffix(isForExtensionReceiver) : "???"));
        PsiElement psiElement = declarationElement;
        String declarationDescription = psiElement instanceof KtClass ? "class " + ((KtClass)declarationElement).getName() : (psiElement instanceof KtNamedFunction ? "function " + ((KtNamedFunction)declarationElement).getName() : (psiElement instanceof KtProperty ? "property " + ((KtProperty)declarationElement).getName() : (psiElement instanceof KtNamedDeclaration ? "declaration with name " + ((KtNamedDeclaration)declarationElement).getName() : "unknown declaration")));
        trace.report(Errors.LABEL_RESOLVE_WILL_CHANGE.on((KtSimpleNameExpression)((PsiElement)target), declarationDescription, closestDescription));
    }

    private static final String reportLabelResolveWillChange$suffix(boolean $isForExtensionReceiver) {
        return $isForExtensionReceiver ? "extension receiver" : "context receiver";
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\n\u0018\u0000 \u00112\u00020\u0001:\u0002\u0012\u0011B\u001b\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\r\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0011\u0010\u000b\u001a\u0004\u0018\u00010\u0004H\u0007\u00a2\u0006\u0004\b\u000b\u0010\fR\u001a\u0010\u0003\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\r\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0010"}, d2={"Lorg/jetbrains/kotlin/types/expressions/LabelResolver$LabeledReceiverResolutionResult;", "", "Lorg/jetbrains/kotlin/types/expressions/LabelResolver$LabeledReceiverResolutionResult$Code;", "code", "Lorg/jetbrains/kotlin/descriptors/ReceiverParameterDescriptor;", "receiverParameterDescriptor", "<init>", "(Lorg/jetbrains/kotlin/types/expressions/LabelResolver$LabeledReceiverResolutionResult$Code;Lorg/jetbrains/kotlin/descriptors/ReceiverParameterDescriptor;)V", "", "success", "()Z", "getReceiverParameterDescriptor", "()Lorg/jetbrains/kotlin/descriptors/ReceiverParameterDescriptor;", "Lorg/jetbrains/kotlin/types/expressions/LabelResolver$LabeledReceiverResolutionResult$Code;", "getCode", "()Lorg/jetbrains/kotlin/types/expressions/LabelResolver$LabeledReceiverResolutionResult$Code;", "Lorg/jetbrains/kotlin/descriptors/ReceiverParameterDescriptor;", "Companion", "Code"})
    public static final class LabeledReceiverResolutionResult {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Code code;
        @Nullable
        private final ReceiverParameterDescriptor receiverParameterDescriptor;

        private LabeledReceiverResolutionResult(Code code, ReceiverParameterDescriptor receiverParameterDescriptor) {
            this.code = code;
            this.receiverParameterDescriptor = receiverParameterDescriptor;
        }

        @NotNull
        public final Code getCode() {
            return this.code;
        }

        public final boolean success() {
            return this.code == Code.SUCCESS;
        }

        @Nullable
        public final ReceiverParameterDescriptor getReceiverParameterDescriptor() {
            boolean bl = this.success();
            if (_Assertions.ENABLED && !bl) {
                boolean bl2 = false;
                String string2 = "Don't try to obtain the receiver when resolution failed with " + (Object)((Object)this.code);
                throw new AssertionError((Object)string2);
            }
            return this.receiverParameterDescriptor;
        }

        public /* synthetic */ LabeledReceiverResolutionResult(Code code, ReceiverParameterDescriptor receiverParameterDescriptor, DefaultConstructorMarker $constructor_marker) {
            this(code, receiverParameterDescriptor);
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006"}, d2={"Lorg/jetbrains/kotlin/types/expressions/LabelResolver$LabeledReceiverResolutionResult$Code;", "", "<init>", "(Ljava/lang/String;I)V", "LABEL_RESOLUTION_ERROR", "NO_THIS", "SUCCESS"})
        public static final class Code
        extends Enum<Code> {
            public static final /* enum */ Code LABEL_RESOLUTION_ERROR = new Code();
            public static final /* enum */ Code NO_THIS = new Code();
            public static final /* enum */ Code SUCCESS = new Code();
            private static final /* synthetic */ Code[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static Code[] values() {
                return (Code[])$VALUES.clone();
            }

            public static Code valueOf(String value2) {
                return Enum.valueOf(Code.class, value2);
            }

            @NotNull
            public static EnumEntries<Code> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = codeArray = new Code[]{Code.LABEL_RESOLUTION_ERROR, Code.NO_THIS, Code.SUCCESS};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0019\u0010\u0007\u001a\u00020\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\t\u0010\n"}, d2={"Lorg/jetbrains/kotlin/types/expressions/LabelResolver$LabeledReceiverResolutionResult$Companion;", "", "<init>", "()V", "Lorg/jetbrains/kotlin/descriptors/ReceiverParameterDescriptor;", "receiverParameterDescriptor", "Lorg/jetbrains/kotlin/types/expressions/LabelResolver$LabeledReceiverResolutionResult;", "labelResolutionSuccess", "(Lorg/jetbrains/kotlin/descriptors/ReceiverParameterDescriptor;)Lorg/jetbrains/kotlin/types/expressions/LabelResolver$LabeledReceiverResolutionResult;", "labelResolutionFailed", "()Lorg/jetbrains/kotlin/types/expressions/LabelResolver$LabeledReceiverResolutionResult;"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final LabeledReceiverResolutionResult labelResolutionSuccess(@Nullable ReceiverParameterDescriptor receiverParameterDescriptor) {
                if (receiverParameterDescriptor == null) {
                    return new LabeledReceiverResolutionResult(Code.NO_THIS, null, null);
                }
                return new LabeledReceiverResolutionResult(Code.SUCCESS, receiverParameterDescriptor, null);
            }

            @NotNull
            public final LabeledReceiverResolutionResult labelResolutionFailed() {
                return new LabeledReceiverResolutionResult(Code.LABEL_RESOLUTION_ERROR, null, null);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

