/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorResolver;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.checkers.NewSchemeOfIntegerOperatorResolutionChecker;
import org.jetbrains.kotlin.resolve.calls.components.InferenceSession;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.lazy.ForceResolveUtil;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeImpl;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeKind;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingServices;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJK\u0010\u001a\u001a\u00020\u00192\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\f2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00152\b\u0010\u0018\u001a\u0004\u0018\u00010\u0017\u00a2\u0006\u0004\b\u001a\u0010\u001bJ'\u0010 \u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020\u001eH\u0002\u00a2\u0006\u0004\b \u0010!R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\"R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010#R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010$R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010%"}, d2={"Lorg/jetbrains/kotlin/types/expressions/ValueParameterResolver;", "", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingServices;", "expressionTypingServices", "Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator;", "constantExpressionEvaluator", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "languageVersionSettings", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;", "dataFlowValueFactory", "<init>", "(Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingServices;Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;)V", "", "Lorg/jetbrains/kotlin/psi/KtParameter;", "valueParameters", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "valueParameterDescriptors", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "declaringScope", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "dataFlowInfo", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "trace", "Lorg/jetbrains/kotlin/resolve/calls/components/InferenceSession;", "inferenceSession", "", "resolveValueParameters", "(Ljava/util/List;Ljava/util/List;Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/resolve/calls/components/InferenceSession;)V", "valueParameterDescriptor", "parameter", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;", "context", "resolveDefaultValue", "(Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;Lorg/jetbrains/kotlin/psi/KtParameter;Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;)V", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingServices;", "Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator;", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;"})
public final class ValueParameterResolver {
    @NotNull
    private final ExpressionTypingServices expressionTypingServices;
    @NotNull
    private final ConstantExpressionEvaluator constantExpressionEvaluator;
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    @NotNull
    private final DataFlowValueFactory dataFlowValueFactory;

    public ValueParameterResolver(@NotNull ExpressionTypingServices expressionTypingServices, @NotNull ConstantExpressionEvaluator constantExpressionEvaluator, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull DataFlowValueFactory dataFlowValueFactory) {
        Intrinsics.checkNotNullParameter(expressionTypingServices, "expressionTypingServices");
        Intrinsics.checkNotNullParameter(constantExpressionEvaluator, "constantExpressionEvaluator");
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        Intrinsics.checkNotNullParameter(dataFlowValueFactory, "dataFlowValueFactory");
        this.expressionTypingServices = expressionTypingServices;
        this.constantExpressionEvaluator = constantExpressionEvaluator;
        this.languageVersionSettings = languageVersionSettings;
        this.dataFlowValueFactory = dataFlowValueFactory;
    }

    public final void resolveValueParameters(@NotNull List<? extends KtParameter> valueParameters2, @NotNull List<? extends ValueParameterDescriptor> valueParameterDescriptors, @NotNull LexicalScope declaringScope, @NotNull DataFlowInfo dataFlowInfo, @NotNull BindingTrace trace, @Nullable InferenceSession inferenceSession) {
        Intrinsics.checkNotNullParameter(valueParameters2, "valueParameters");
        Intrinsics.checkNotNullParameter(valueParameterDescriptors, "valueParameterDescriptors");
        Intrinsics.checkNotNullParameter(declaringScope, "declaringScope");
        Intrinsics.checkNotNullParameter(dataFlowInfo, "dataFlowInfo");
        Intrinsics.checkNotNullParameter(trace, "trace");
        LexicalScopeImpl scopeForDefaultValue = new LexicalScopeImpl(declaringScope, declaringScope.getOwnerDescriptor(), false, null, CollectionsKt.emptyList(), LexicalScopeKind.DEFAULT_VALUE, null, null, 192, null);
        ExpressionTypingContext expressionTypingContext = ExpressionTypingContext.newContext(trace, scopeForDefaultValue, dataFlowInfo, TypeUtils.NO_EXPECTED_TYPE, this.languageVersionSettings, this.dataFlowValueFactory, inferenceSession);
        Intrinsics.checkNotNullExpressionValue(expressionTypingContext, "newContext(...)");
        ExpressionTypingContext contextForDefaultValue = expressionTypingContext;
        for (Pair pair : CollectionsKt.zip((Iterable)valueParameterDescriptors, (Iterable)valueParameters2)) {
            ValueParameterDescriptor descriptor2 = (ValueParameterDescriptor)pair.component1();
            KtParameter parameter = (KtParameter)pair.component2();
            ForceResolveUtil.forceResolveAllContents(descriptor2.getAnnotations());
            this.resolveDefaultValue(descriptor2, parameter, contextForDefaultValue);
        }
    }

    private final void resolveDefaultValue(ValueParameterDescriptor valueParameterDescriptor, KtParameter parameter, ExpressionTypingContext context) {
        if (!valueParameterDescriptor.declaresDefaultValue()) {
            return;
        }
        KtExpression ktExpression = parameter.getDefaultValue();
        if (ktExpression == null) {
            return;
        }
        KtExpression defaultValue = ktExpression;
        KotlinType kotlinType = valueParameterDescriptor.getType();
        Intrinsics.checkNotNullExpressionValue(kotlinType, "getType(...)");
        KotlinType type2 = kotlinType;
        this.expressionTypingServices.getTypeInfo(defaultValue, (ResolutionContext)context.replaceExpectedType(type2));
        BindingTrace bindingTrace = context.trace;
        Intrinsics.checkNotNullExpressionValue(bindingTrace, "trace");
        NewSchemeOfIntegerOperatorResolutionChecker.checkArgument(type2, defaultValue, bindingTrace, this.constantExpressionEvaluator.getModule$frontend());
        if (DescriptorUtils.isAnnotationClass(DescriptorResolver.getContainingClass(context.scope))) {
            BindingTrace bindingTrace2 = context.trace;
            Intrinsics.checkNotNullExpressionValue(bindingTrace2, "trace");
            CompileTimeConstant<?> constant = this.constantExpressionEvaluator.evaluateExpression(defaultValue, bindingTrace2, type2);
            if ((constant == null || constant.getUsesNonConstValAsConstant()) && !KotlinTypeKt.isError(type2)) {
                context.trace.report(Errors.ANNOTATION_PARAMETER_DEFAULT_VALUE_MUST_BE_CONSTANT.on((KtExpression)((PsiElement)defaultValue)));
            }
        }
    }
}

