/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.util;

import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.util.Check;
import org.jetbrains.kotlin.util.CheckResult;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0011\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001BK\b\u0002\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u0012\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u0006\u0012\u0014\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\n0\b\u0012\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fB)\b\u0016\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0016\b\u0002\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\n0\b\u00a2\u0006\u0004\b\u000e\u0010\u0011B1\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0016\b\u0002\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\n0\b\u00a2\u0006\u0004\b\u000e\u0010\u0012B1\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0016\b\u0002\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\n0\b\u00a2\u0006\u0004\b\u000e\u0010\u0013B7\b\u0016\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0016\b\u0002\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\n0\b\u00a2\u0006\u0004\b\u000e\u0010\u0014J\u0015\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\t\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\u001a\u0010\u001bR\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001c\u001a\u0004\b\u001d\u0010\u001eR\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u00048\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001f\u001a\u0004\b \u0010!R\"\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00068\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0007\u0010\"\u001a\u0004\b#\u0010$R(\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\n0\b8\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u000b\u0010%\u001a\u0004\b&\u0010'R\"\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0(8\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\r\u0010)\u001a\u0004\b*\u0010+"}, d2={"Lorg/jetbrains/kotlin/util/Checks;", "", "Lorg/jetbrains/kotlin/name/Name;", "name", "Lkotlin/text/Regex;", "regex", "", "nameList", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "", "additionalCheck", "Lorg/jetbrains/kotlin/util/Check;", "checks", "<init>", "(Lorg/jetbrains/kotlin/name/Name;Lkotlin/text/Regex;Ljava/util/Collection;Lkotlin/jvm/functions/Function1;[Lorg/jetbrains/kotlin/util/Check;)V", "additionalChecks", "([Lorg/jetbrains/kotlin/util/Check;Lkotlin/jvm/functions/Function1;)V", "(Lorg/jetbrains/kotlin/name/Name;[Lorg/jetbrains/kotlin/util/Check;Lkotlin/jvm/functions/Function1;)V", "(Lkotlin/text/Regex;[Lorg/jetbrains/kotlin/util/Check;Lkotlin/jvm/functions/Function1;)V", "(Ljava/util/Collection;[Lorg/jetbrains/kotlin/util/Check;Lkotlin/jvm/functions/Function1;)V", "functionDescriptor", "", "isApplicable", "(Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;)Z", "Lorg/jetbrains/kotlin/util/CheckResult;", "checkAll", "(Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;)Lorg/jetbrains/kotlin/util/CheckResult;", "Lorg/jetbrains/kotlin/name/Name;", "getName", "()Lorg/jetbrains/kotlin/name/Name;", "Lkotlin/text/Regex;", "getRegex", "()Lkotlin/text/Regex;", "Ljava/util/Collection;", "getNameList", "()Ljava/util/Collection;", "Lkotlin/jvm/functions/Function1;", "getAdditionalCheck", "()Lkotlin/jvm/functions/Function1;", "", "[Lorg/jetbrains/kotlin/util/Check;", "getChecks", "()[Lorg/jetbrains/kotlin/util/Check;"})
public final class Checks {
    @Nullable
    private final Name name;
    @Nullable
    private final Regex regex;
    @Nullable
    private final Collection<Name> nameList;
    @NotNull
    private final Function1<FunctionDescriptor, String> additionalCheck;
    @NotNull
    private final Check[] checks;

    private Checks(Name name, Regex regex, Collection<Name> nameList, Function1<? super FunctionDescriptor, String> additionalCheck2, Check ... checks2) {
        this.name = name;
        this.regex = regex;
        this.nameList = nameList;
        this.additionalCheck = additionalCheck2;
        this.checks = checks2;
    }

    @Nullable
    public final Name getName() {
        return this.name;
    }

    @Nullable
    public final Regex getRegex() {
        return this.regex;
    }

    @Nullable
    public final Collection<Name> getNameList() {
        return this.nameList;
    }

    @NotNull
    public final Function1<FunctionDescriptor, String> getAdditionalCheck() {
        return this.additionalCheck;
    }

    @NotNull
    public final Check[] getChecks() {
        return this.checks;
    }

    public final boolean isApplicable(@NotNull FunctionDescriptor functionDescriptor) {
        Intrinsics.checkNotNullParameter(functionDescriptor, "functionDescriptor");
        if (this.name != null && !Intrinsics.areEqual(functionDescriptor.getName(), this.name)) {
            return false;
        }
        if (this.regex != null) {
            String string2 = functionDescriptor.getName().asString();
            Intrinsics.checkNotNullExpressionValue(string2, "asString(...)");
            CharSequence charSequence = string2;
            if (!this.regex.matches(charSequence)) {
                return false;
            }
        }
        return this.nameList == null || this.nameList.contains(functionDescriptor.getName());
    }

    @NotNull
    public final CheckResult checkAll(@NotNull FunctionDescriptor functionDescriptor) {
        Intrinsics.checkNotNullParameter(functionDescriptor, "functionDescriptor");
        for (Check check2 : this.checks) {
            String checkResult = check2.invoke(functionDescriptor);
            if (checkResult == null) continue;
            return new CheckResult.IllegalSignature(checkResult);
        }
        String additionalCheckResult = this.additionalCheck.invoke(functionDescriptor);
        if (additionalCheckResult != null) {
            return new CheckResult.IllegalSignature(additionalCheckResult);
        }
        return CheckResult.SuccessCheck.INSTANCE;
    }

    public Checks(@NotNull Check[] checks2, @NotNull Function1<? super FunctionDescriptor, String> additionalChecks) {
        Intrinsics.checkNotNullParameter(checks2, "checks");
        Intrinsics.checkNotNullParameter(additionalChecks, "additionalChecks");
        this(null, null, null, additionalChecks, Arrays.copyOf(checks2, checks2.length));
    }

    public /* synthetic */ Checks(Check[] checkArray, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            function1 = 1.INSTANCE;
        }
        this(checkArray, function1);
    }

    public Checks(@NotNull Name name, @NotNull Check[] checks2, @NotNull Function1<? super FunctionDescriptor, String> additionalChecks) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(checks2, "checks");
        Intrinsics.checkNotNullParameter(additionalChecks, "additionalChecks");
        this(name, null, null, additionalChecks, Arrays.copyOf(checks2, checks2.length));
    }

    public /* synthetic */ Checks(Name name, Check[] checkArray, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            function1 = 2.INSTANCE;
        }
        this(name, checkArray, (Function1<? super FunctionDescriptor, String>)function1);
    }

    public Checks(@NotNull Regex regex, @NotNull Check[] checks2, @NotNull Function1<? super FunctionDescriptor, String> additionalChecks) {
        Intrinsics.checkNotNullParameter(regex, "regex");
        Intrinsics.checkNotNullParameter(checks2, "checks");
        Intrinsics.checkNotNullParameter(additionalChecks, "additionalChecks");
        this(null, regex, null, additionalChecks, Arrays.copyOf(checks2, checks2.length));
    }

    public /* synthetic */ Checks(Regex regex, Check[] checkArray, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            function1 = 3.INSTANCE;
        }
        this(regex, checkArray, (Function1<? super FunctionDescriptor, String>)function1);
    }

    public Checks(@NotNull Collection<Name> nameList, @NotNull Check[] checks2, @NotNull Function1<? super FunctionDescriptor, String> additionalChecks) {
        Intrinsics.checkNotNullParameter(nameList, "nameList");
        Intrinsics.checkNotNullParameter(checks2, "checks");
        Intrinsics.checkNotNullParameter(additionalChecks, "additionalChecks");
        this(null, null, nameList, additionalChecks, Arrays.copyOf(checks2, checks2.length));
    }

    public /* synthetic */ Checks(Collection collection, Check[] checkArray, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            function1 = 4.INSTANCE;
        }
        this(collection, checkArray, (Function1<? super FunctionDescriptor, String>)function1);
    }
}

