/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.util;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.util.AbstractArrayMapOwner;
import org.jetbrains.kotlin.util.ArrayMap;
import org.jetbrains.kotlin.util.ArrayMapImpl;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000*\b\b\u0000\u0010\u0002*\u00020\u0001*\b\b\u0001\u0010\u0003*\u00020\u00012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0004B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001f\u0010\u000b\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00028\u0001H\u0004\u00a2\u0006\u0004\b\u000b\u0010\fJ \u0010\u000f\u001a\u00028\u00012\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\rH\u0085\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J!\u0010\u0011\u001a\u0004\u0018\u00018\u00012\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\rH\u0005\u00a2\u0006\u0004\b\u0011\u0010\u0010J\u001f\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015R \u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00010\u00168\u0005X\u0085\u0004\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0019\u0010\u001a"}, d2={"Lorg/jetbrains/kotlin/util/ComponentArrayOwner;", "", "K", "V", "Lorg/jetbrains/kotlin/util/AbstractArrayMapOwner;", "<init>", "()V", "", "keyQualifiedName", "value", "", "registerComponent", "(Ljava/lang/String;Ljava/lang/Object;)V", "Lkotlin/reflect/KClass;", "key", "get", "(Lkotlin/reflect/KClass;)Ljava/lang/Object;", "getOrNull", "", "id", "createDiagnosticMessage", "(ILjava/lang/String;)Ljava/lang/String;", "Lorg/jetbrains/kotlin/util/ArrayMap;", "arrayMap", "Lorg/jetbrains/kotlin/util/ArrayMap;", "getArrayMap", "()Lorg/jetbrains/kotlin/util/ArrayMap;"})
public abstract class ComponentArrayOwner<K, V>
extends AbstractArrayMapOwner<K, V> {
    @NotNull
    private final ArrayMap<V> arrayMap = new ArrayMapImpl();

    @Override
    @NotNull
    protected final ArrayMap<V> getArrayMap() {
        return this.arrayMap;
    }

    @Override
    protected final void registerComponent(@NotNull String keyQualifiedName, @NotNull V value2) {
        Intrinsics.checkNotNullParameter(keyQualifiedName, "keyQualifiedName");
        Intrinsics.checkNotNullParameter(value2, "value");
        int id = this.getTypeRegistry().getId(keyQualifiedName);
        try {
            this.arrayMap.set(id, value2);
        }
        catch (Exception e) {
            throw new RuntimeException(this.createDiagnosticMessage(id, keyQualifiedName), e);
        }
    }

    @NotNull
    protected final V get(@NotNull KClass<? extends K> key) {
        Intrinsics.checkNotNullParameter(key, "key");
        V v = this.getOrNull(key);
        if (v != null) {
            V it = v;
            boolean bl = false;
            return it;
        }
        int id = this.getTypeRegistry().getId(key);
        throw new IllegalStateException(("No '" + key + "'(" + id + ") component in array: " + this).toString());
    }

    @Nullable
    protected final V getOrNull(@NotNull KClass<? extends K> key) {
        Intrinsics.checkNotNullParameter(key, "key");
        int id = this.getTypeRegistry().getId(key);
        return this.arrayMap.get(id);
    }

    private final String createDiagnosticMessage(int id, String keyQualifiedName) {
        StringBuilder stringBuilder;
        StringBuilder $this$createDiagnosticMessage_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$createDiagnosticMessage_u24lambda_u241.append("Error occurred during registration of component in array").append('\n');
        $this$createDiagnosticMessage_u24lambda_u241.append("Currently registered").append('\n');
        $this$createDiagnosticMessage_u24lambda_u241.append("  " + id + ": " + keyQualifiedName).append('\n');
        $this$createDiagnosticMessage_u24lambda_u241.append("Registrar:").append('\n');
        for (Map.Entry<String, Integer> entry : this.getTypeRegistry().allValuesThreadUnsafeForRendering().entrySet()) {
            String kClass = entry.getKey();
            int x = ((Number)entry.getValue()).intValue();
            $this$createDiagnosticMessage_u24lambda_u241.append("  " + x + ": " + kClass).append('\n');
        }
        $this$createDiagnosticMessage_u24lambda_u241.append("Array map:").append('\n');
        int n = this.arrayMap.getSize();
        for (int i = 0; i < n; ++i) {
            Object element = this.arrayMap.get(i);
            if (element != null) {
                element = Reflection.getOrCreateKotlinClass(element.getClass());
            }
            $this$createDiagnosticMessage_u24lambda_u241.append("  " + i + ": " + element).append('\n');
        }
        return stringBuilder.toString();
    }
}

