/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.util.PerformanceCounter;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u00142\u00020\u0001:\u0002\u0014\u0015B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0005\u0010\u0006J#\u0010\n\u001a\u00028\u0000\"\u0004\b\u0000\u0010\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\bH\u0014\u00a2\u0006\u0004\b\n\u0010\u000bJ\r\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\r\u0010\u000f\u001a\u00020\f\u00a2\u0006\u0004\b\u000f\u0010\u000eR\u0014\u0010\u0013\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012"}, d2={"Lorg/jetbrains/kotlin/util/CounterWithExclude;", "Lorg/jetbrains/kotlin/util/PerformanceCounter;", "", "name", "excludedCounters", "<init>", "(Ljava/lang/String;[Lorg/jetbrains/kotlin/util/PerformanceCounter;)V", "T", "Lkotlin/Function0;", "block", "countTime", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "", "enterExcludedMethod", "()V", "exitExcludedMethod", "Lorg/jetbrains/kotlin/util/CounterWithExclude$CallStackWithTime;", "getCallStack", "()Lorg/jetbrains/kotlin/util/CounterWithExclude$CallStackWithTime;", "callStack", "Companion", "CallStackWithTime"})
public final class CounterWithExclude
extends PerformanceCounter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final ThreadLocal<Map<CounterWithExclude, CallStackWithTime>> counterToCallStackMapThreadLocal = new ThreadLocal();

    public CounterWithExclude(@NotNull String name, PerformanceCounter ... excludedCounters) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(excludedCounters, "excludedCounters");
        super(name);
        PerformanceCounter[] $this$forEach$iv = excludedCounters;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            PerformanceCounter element$iv;
            PerformanceCounter it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            it.getExcludedFrom$util_runtime().add(this);
        }
    }

    private final CallStackWithTime getCallStack() {
        return CounterWithExclude.Companion.getCallStack(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected <T> T countTime(@NotNull Function0<? extends T> block) {
        Intrinsics.checkNotNullParameter(block, "block");
        this.incrementTime(this.getCallStack().push(true));
        try {
            T t = block.invoke();
            return t;
        }
        finally {
            this.incrementTime(this.getCallStack().pop(true));
        }
    }

    public final void enterExcludedMethod() {
        this.incrementTime(this.getCallStack().push(false));
    }

    public final void exitExcludedMethod() {
        this.incrementTime(this.getCallStack().pop(false));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\f\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0006\u001a\u0006*\u00020\u00050\u0005*\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J)\u0010\f\u001a\u00020\u000b2\u0018\u0010\n\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0004\u0012\u00020\t0\bH\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u0015\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0015\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0011\u0010\u0010J\r\u0010\u0012\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0016\u001a\u00020\u000b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017"}, d2={"Lorg/jetbrains/kotlin/util/CounterWithExclude$CallStackWithTime;", "", "<init>", "()V", "Ljava/util/Stack;", "", "peekOrFalse", "(Ljava/util/Stack;)Ljava/lang/Boolean;", "Lkotlin/Function1;", "", "callStackUpdate", "", "intervalUsefulTime", "(Lkotlin/jvm/functions/Function1;)J", "usefulCall", "push", "(Z)J", "pop", "isEnteredCounter", "()Z", "callStack", "Ljava/util/Stack;", "intervalStartTime", "J"})
    private static final class CallStackWithTime {
        @NotNull
        private final Stack<Boolean> callStack = new Stack();
        private long intervalStartTime;

        public final Boolean peekOrFalse(@NotNull Stack<Boolean> $this$peekOrFalse) {
            Intrinsics.checkNotNullParameter($this$peekOrFalse, "<this>");
            return $this$peekOrFalse.isEmpty() ? Boolean.valueOf(false) : $this$peekOrFalse.peek();
        }

        private final long intervalUsefulTime(Function1<? super Stack<Boolean>, Unit> callStackUpdate) {
            long delta = this.peekOrFalse(this.callStack) != false ? PerformanceCounter.Companion.currentTime() - this.intervalStartTime : 0L;
            callStackUpdate.invoke(this.callStack);
            this.intervalStartTime = PerformanceCounter.Companion.currentTime();
            return delta;
        }

        public final long push(boolean usefulCall) {
            if (!this.isEnteredCounter() && !usefulCall) {
                return 0L;
            }
            return this.intervalUsefulTime(arg_0 -> CallStackWithTime.push$lambda$0(usefulCall, arg_0));
        }

        public final long pop(boolean usefulCall) {
            if (!this.isEnteredCounter()) {
                return 0L;
            }
            boolean bl = Intrinsics.areEqual(this.callStack.peek(), usefulCall);
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            return this.intervalUsefulTime(CallStackWithTime::pop$lambda$1);
        }

        public final boolean isEnteredCounter() {
            return !this.callStack.isEmpty();
        }

        private static final Unit push$lambda$0(boolean $usefulCall, Stack $this$intervalUsefulTime) {
            Intrinsics.checkNotNullParameter($this$intervalUsefulTime, "$this$intervalUsefulTime");
            $this$intervalUsefulTime.push($usefulCall);
            return Unit.INSTANCE;
        }

        private static final Unit pop$lambda$1(Stack $this$intervalUsefulTime) {
            Intrinsics.checkNotNullParameter($this$intervalUsefulTime, "$this$intervalUsefulTime");
            $this$intervalUsefulTime.pop();
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0007\u0010\bR&\u0010\u000b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00060\n0\t8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\f"}, d2={"Lorg/jetbrains/kotlin/util/CounterWithExclude$Companion;", "", "<init>", "()V", "Lorg/jetbrains/kotlin/util/CounterWithExclude;", "counter", "Lorg/jetbrains/kotlin/util/CounterWithExclude$CallStackWithTime;", "getCallStack", "(Lorg/jetbrains/kotlin/util/CounterWithExclude;)Lorg/jetbrains/kotlin/util/CounterWithExclude$CallStackWithTime;", "Ljava/lang/ThreadLocal;", "", "counterToCallStackMapThreadLocal", "Ljava/lang/ThreadLocal;"})
    public static final class Companion {
        private Companion() {
        }

        private final CallStackWithTime getCallStack(CounterWithExclude counter) {
            Object object;
            PerformanceCounter.Companion companion = PerformanceCounter.Companion;
            ThreadLocal threadLocal$iv = counterToCallStackMapThreadLocal;
            boolean $i$f$getOrPut$util_runtime = false;
            Object value$iv = threadLocal$iv.get();
            if (value$iv == null) {
                boolean bl = false;
                value$iv = new HashMap();
                threadLocal$iv.set(value$iv);
            }
            Map $this$getOrPut$iv = (Map)value$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv2 = $this$getOrPut$iv.get(counter);
            if (value$iv2 == null) {
                boolean bl = false;
                CallStackWithTime answer$iv = new CallStackWithTime();
                $this$getOrPut$iv.put(counter, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv2;
            }
            return (CallStackWithTime)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

