/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.util;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.util.AnalysisExceptionsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u000b\u0018\u00002\u00060\u0001j\u0002`\u0002B/\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0016\b\u0002\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u00a2\u0006\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u00038\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\fR\u001a\u0010\u0006\u001a\u00020\u00058\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b\u0006\u0010\r\u001a\u0004\b\u000e\u0010\u000fR\"\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0018\u00010\u00078\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\u0010R\u0014\u0010\u0013\u001a\u00020\u00038WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012"}, d2={"Lorg/jetbrains/kotlin/util/FileAnalysisException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "", "path", "", "cause", "Lkotlin/Pair;", "", "lineAndOffset", "<init>", "(Ljava/lang/String;Ljava/lang/Throwable;Lkotlin/Pair;)V", "Ljava/lang/String;", "Ljava/lang/Throwable;", "getCause", "()Ljava/lang/Throwable;", "Lkotlin/Pair;", "getMessage", "()Ljava/lang/String;", "message"})
public final class FileAnalysisException
extends Exception {
    @NotNull
    private final String path;
    @NotNull
    private final Throwable cause;
    @Nullable
    private final Pair<Integer, Integer> lineAndOffset;

    public FileAnalysisException(@NotNull String path, @NotNull Throwable cause, @Nullable Pair<Integer, Integer> lineAndOffset) {
        Intrinsics.checkNotNullParameter(path, "path");
        Intrinsics.checkNotNullParameter(cause, "cause");
        this.path = path;
        this.cause = cause;
        this.lineAndOffset = lineAndOffset;
    }

    public /* synthetic */ FileAnalysisException(String string2, Throwable throwable, Pair pair, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            pair = null;
        }
        this(string2, throwable, pair);
    }

    @Override
    @NotNull
    public Throwable getCause() {
        return this.cause;
    }

    @Override
    @NotNull
    public String getMessage() {
        Pair<Integer, Integer> pair = this.lineAndOffset;
        if (pair == null) {
            return "Somewhere in file " + this.path + ": " + AnalysisExceptionsKt.getClassNameAndMessage(this.getCause());
        }
        Pair<Integer, Integer> pair2 = pair;
        int line = ((Number)pair2.component1()).intValue();
        int offset = ((Number)pair2.component2()).intValue();
        return "While analysing " + this.path + ':' + (line + 1) + ':' + (offset + 1) + ": " + AnalysisExceptionsKt.getClassNameAndMessage(this.getCause());
    }
}

