/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.util;

import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorUtilKt;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.incremental.KotlinLookupLocation;
import org.jetbrains.kotlin.incremental.UtilsKt;
import org.jetbrains.kotlin.incremental.components.EnumWhenTracker;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a!\u0010\u0006\u001a\u00020\u0005*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007\u001a-\u0010\u0006\u001a\u00020\u0005*\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u00032\u0006\u0010\n\u001a\u00020\u00012\b\u0010\f\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\u0006\u0010\r"}, d2={"Lorg/jetbrains/kotlin/incremental/components/LookupTracker;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "expression", "Lorg/jetbrains/kotlin/types/KotlinType;", "type", "", "record", "(Lorg/jetbrains/kotlin/incremental/components/LookupTracker;Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/types/KotlinType;)V", "Lorg/jetbrains/kotlin/incremental/components/EnumWhenTracker;", "subjectType", "subjectExpression", "Lorg/jetbrains/kotlin/psi/KtWhenEntry;", "elseEntry", "(Lorg/jetbrains/kotlin/incremental/components/EnumWhenTracker;Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/psi/KtWhenEntry;)V"})
public final class IncrementalTrackerUtilKt {
    public static final void record(@NotNull LookupTracker $this$record, @NotNull KtExpression expression, @NotNull KotlinType type2) {
        Intrinsics.checkNotNullParameter($this$record, "<this>");
        Intrinsics.checkNotNullParameter(expression, "expression");
        Intrinsics.checkNotNullParameter(type2, "type");
        if (KotlinTypeKt.isError(type2) || TypeUtilsKt.isUnit(type2)) {
            return;
        }
        ClassifierDescriptor classifierDescriptor = type2.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            return;
        }
        ClassifierDescriptor typeDescriptor = classifierDescriptor;
        DeclarationDescriptor declarationDescriptor = typeDescriptor.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue(declarationDescriptor, "getContainingDeclaration(...)");
        DeclarationDescriptor scopeDescriptor = declarationDescriptor;
        if (scopeDescriptor instanceof PackageFragmentDescriptor && !DescriptorUtils.isLocal(typeDescriptor)) {
            LookupLocation lookupLocation = new KotlinLookupLocation(expression);
            PackageFragmentDescriptor packageFragmentDescriptor = (PackageFragmentDescriptor)scopeDescriptor;
            Name name = typeDescriptor.getName();
            Intrinsics.checkNotNullExpressionValue(name, "getName(...)");
            UtilsKt.record($this$record, lookupLocation, packageFragmentDescriptor, name);
        } else if (scopeDescriptor instanceof ClassDescriptor && !DescriptorUtils.isLocal(typeDescriptor)) {
            LookupLocation lookupLocation = new KotlinLookupLocation(expression);
            ClassDescriptor classDescriptor = (ClassDescriptor)scopeDescriptor;
            Name name = typeDescriptor.getName();
            Intrinsics.checkNotNullExpressionValue(name, "getName(...)");
            UtilsKt.record($this$record, lookupLocation, classDescriptor, name);
        }
        for (TypeProjection typeArgument : type2.getArguments()) {
            if (typeArgument.isStarProjection()) continue;
            KotlinType kotlinType = typeArgument.getType();
            Intrinsics.checkNotNullExpressionValue(kotlinType, "getType(...)");
            IncrementalTrackerUtilKt.record($this$record, expression, kotlinType);
        }
    }

    public static final void record(@NotNull EnumWhenTracker $this$record, @Nullable KotlinType subjectType, @NotNull KtExpression subjectExpression, @Nullable KtWhenEntry elseEntry) {
        String string2;
        Intrinsics.checkNotNullParameter($this$record, "<this>");
        Intrinsics.checkNotNullParameter(subjectExpression, "subjectExpression");
        if (elseEntry != null) {
            return;
        }
        if (!(subjectExpression instanceof KtNameReferenceExpression)) {
            return;
        }
        Object object = subjectType;
        if (object == null || (object = ((KotlinType)object).getConstructor()) == null || (object = object.getDeclarationDescriptor()) == null) {
            return;
        }
        Object declarationDescriptor = object;
        Object object2 = DescriptorUtilKt.containingPackage((DeclarationDescriptor)declarationDescriptor);
        if (object2 == null || (object2 = ((FqName)object2).toString()) == null) {
            return;
        }
        Object containingPackage = object2;
        String fqName2 = DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)declarationDescriptor).asString();
        Object object3 = ((KtNameReferenceExpression)subjectExpression).getContainingFile().getVirtualFile();
        if (object3 == null || (object3 = ((VirtualFile)object3).getPath()) == null) {
            return;
        }
        Object filePath = object3;
        if (StringsKt.startsWith$default(fqName2, (String)containingPackage + '.', false, 2, null)) {
            StringBuilder stringBuilder = new StringBuilder().append((String)containingPackage).append('.');
            String string3 = fqName2.substring(((String)containingPackage).length() + 1);
            Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
            string2 = stringBuilder.append(StringsKt.replace$default(string3, ".", "$", false, 4, null)).toString();
        } else {
            string2 = StringsKt.replace$default(fqName2, ".", "$", false, 4, null);
        }
        String owner = string2;
        $this$record.report((String)filePath, owner);
    }
}

