/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.util;

import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.compiled.ClsFieldImpl;
import com.intellij.psi.impl.java.stubs.PsiFieldStub;
import com.intellij.psi.impl.source.PsiFieldImpl;
import com.intellij.psi.tree.IElementType;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.load.java.structure.impl.NotEvaluatedConstAware;

final class IsConstantExpressionVisitor
extends JavaElementVisitor {
    private boolean myIsConstant;
    private final Map<PsiVariable, Boolean> varIsConst = new HashMap<PsiVariable, Boolean>();

    IsConstantExpressionVisitor() {
    }

    public boolean isConstant() {
        return this.myIsConstant;
    }

    @Override
    public void visitExpression(PsiExpression expression) {
        this.myIsConstant = false;
    }

    @Override
    public void visitLiteralExpression(PsiLiteralExpression expression) {
        this.myIsConstant = !"null".equals(expression.getText());
    }

    @Override
    public void visitClassObjectAccessExpression(PsiClassObjectAccessExpression expression) {
        this.myIsConstant = true;
    }

    @Override
    public void visitParenthesizedExpression(PsiParenthesizedExpression expression) {
        PsiExpression expr = expression.getExpression();
        if (expr != null) {
            expr.accept(this);
        }
    }

    @Override
    public void visitTypeCastExpression(PsiTypeCastExpression expression) {
        PsiExpression operand = expression.getOperand();
        if (operand == null) {
            this.myIsConstant = false;
            return;
        }
        operand.accept(this);
        if (!this.myIsConstant) {
            return;
        }
        PsiTypeElement element = expression.getCastType();
        if (element == null) {
            this.myIsConstant = false;
            return;
        }
        PsiType type2 = element.getType();
        if (type2 instanceof PsiPrimitiveType) {
            return;
        }
        if (type2.equalsToText("java.lang.String")) {
            return;
        }
        this.myIsConstant = false;
    }

    @Override
    public void visitPrefixExpression(PsiPrefixExpression expression) {
        PsiExpression operand = expression.getOperand();
        if (operand == null) {
            this.myIsConstant = false;
            return;
        }
        operand.accept(this);
        if (!this.myIsConstant) {
            return;
        }
        IElementType opType = expression.getOperationTokenType();
        if (opType == JavaTokenType.PLUS || opType == JavaTokenType.MINUS || opType == JavaTokenType.TILDE || opType == JavaTokenType.EXCL) {
            return;
        }
        this.myIsConstant = false;
    }

    @Override
    public void visitPolyadicExpression(PsiPolyadicExpression expression) {
        for (PsiExpression operand : expression.getOperands()) {
            operand.accept(this);
            if (!this.myIsConstant) {
                return;
            }
            if (this.checkForNotYetEvaluatedConstant(operand)) {
                return;
            }
            PsiType type2 = operand.getType();
            if (type2 == null || type2 instanceof PsiPrimitiveType || type2.equalsToText("java.lang.String")) continue;
            this.myIsConstant = false;
            return;
        }
    }

    @Override
    public void visitConditionalExpression(PsiConditionalExpression expression) {
        PsiExpression thenExpr = expression.getThenExpression();
        PsiExpression elseExpr = expression.getElseExpression();
        if (thenExpr == null || elseExpr == null) {
            this.myIsConstant = false;
            return;
        }
        expression.getCondition().accept(this);
        if (!this.myIsConstant) {
            return;
        }
        thenExpr.accept(this);
        if (!this.myIsConstant) {
            return;
        }
        elseExpr.accept(this);
    }

    @Override
    public void visitReferenceExpression(PsiReferenceExpression expression) {
        PsiExpression qualifierExpression = expression.getQualifierExpression();
        if (qualifierExpression != null && !(qualifierExpression instanceof PsiReferenceExpression)) {
            this.myIsConstant = false;
            return;
        }
        PsiElement refElement = expression.resolve();
        if (!(refElement instanceof PsiVariable)) {
            this.myIsConstant = false;
            return;
        }
        PsiVariable variable = (PsiVariable)refElement;
        Boolean isConst = this.varIsConst.get(variable);
        if (isConst != null) {
            this.myIsConstant &= isConst.booleanValue();
            return;
        }
        if (variable instanceof PsiEnumConstant) {
            this.myIsConstant = true;
            this.varIsConst.put(variable, Boolean.TRUE);
            return;
        }
        this.varIsConst.put(variable, Boolean.FALSE);
        if (!variable.hasModifierProperty("final")) {
            this.myIsConstant = false;
            return;
        }
        if (this.checkForNotYetEvaluatedConstant(expression)) {
            return;
        }
        variable.hasInitializer();
        PsiExpression initializer = PsiFieldImpl.getDetachedInitializer(variable);
        if (initializer == null) {
            this.myIsConstant = false;
            return;
        }
        initializer.accept(this);
        this.varIsConst.put(variable, this.myIsConstant);
    }

    private boolean checkForNotYetEvaluatedConstant(PsiExpression operand) {
        PsiElement refElement;
        NotEvaluatedConstAware notEvaluatedConstAware;
        if (operand instanceof PsiReferenceExpression && (notEvaluatedConstAware = IsConstantExpressionVisitor.getNotEvaluatedConstAware(refElement = ((PsiReferenceExpression)operand).resolve())) != null) {
            if (notEvaluatedConstAware.isNotYetComputed()) {
                this.myIsConstant = true;
                this.varIsConst.put((PsiVariable)refElement, Boolean.TRUE);
            }
            return true;
        }
        return false;
    }

    @Nullable
    private static NotEvaluatedConstAware getNotEvaluatedConstAware(PsiElement refElement) {
        if (refElement instanceof ClsFieldImpl) {
            PsiFieldStub stub2 = (PsiFieldStub)((ClsFieldImpl)refElement).getStub();
            if (stub2 instanceof NotEvaluatedConstAware) {
                return (NotEvaluatedConstAware)((Object)stub2);
            }
        } else if (refElement instanceof NotEvaluatedConstAware) {
            return (NotEvaluatedConstAware)((Object)refElement);
        }
        return null;
    }
}

