/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.util.CounterWithExclude;
import org.jetbrains.kotlin.util.ReenterableCounter;
import org.jetbrains.kotlin.util.SimpleCounter;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\t\b&\u0018\u0000 (2\u00020\u0001:\u0001(B\u0011\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\r\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ!\u0010\f\u001a\u00028\u0000\"\u0004\b\u0000\u0010\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\n\u00a2\u0006\u0004\b\f\u0010\rJ\r\u0010\u000e\u001a\u00020\u0006\u00a2\u0006\u0004\b\u000e\u0010\bJ\u0017\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u000fH\u0004\u00a2\u0006\u0004\b\u0011\u0010\u0012J#\u0010\u0013\u001a\u00028\u0000\"\u0004\b\u0000\u0010\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\nH$\u00a2\u0006\u0004\b\u0013\u0010\rJ!\u0010\u0016\u001a\u00020\u00062\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00060\u0014\u00a2\u0006\u0004\b\u0016\u0010\u0017J-\u0010\u0016\u001a\u00020\u00062\u001e\u0010\u0015\u001a\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00060\u0018\u00a2\u0006\u0004\b\u0016\u0010\u001aR\u001a\u0010\u0003\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001b\u001a\u0004\b\u001c\u0010\u001dR \u0010 \u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e8\u0001X\u0081\u0004\u00a2\u0006\f\n\u0004\b \u0010!\u001a\u0004\b\"\u0010#R\u0016\u0010$\u001a\u00020\u00198\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b$\u0010%R\u0016\u0010&\u001a\u00020\u000f8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b&\u0010'"}, d2={"Lorg/jetbrains/kotlin/util/PerformanceCounter;", "", "", "name", "<init>", "(Ljava/lang/String;)V", "", "increment", "()V", "T", "Lkotlin/Function0;", "block", "time", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "reset", "", "delta", "incrementTime", "(J)V", "countTime", "Lkotlin/Function1;", "consumer", "report", "(Lkotlin/jvm/functions/Function1;)V", "Lkotlin/Function3;", "", "(Lkotlin/jvm/functions/Function3;)V", "Ljava/lang/String;", "getName", "()Ljava/lang/String;", "", "Lorg/jetbrains/kotlin/util/CounterWithExclude;", "excludedFrom", "Ljava/util/List;", "getExcludedFrom$util_runtime", "()Ljava/util/List;", "count", "I", "totalTimeNanos", "J", "Companion"})
public abstract class PerformanceCounter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final List<CounterWithExclude> excludedFrom;
    private int count;
    private long totalTimeNanos;
    @NotNull
    private static final ArrayList<PerformanceCounter> allCounters = new ArrayList();
    private static boolean enabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PerformanceCounter(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        this.name = name;
        this.excludedFrom = new ArrayList();
        ArrayList<PerformanceCounter> arrayList = allCounters;
        synchronized (arrayList) {
            boolean bl = false;
            boolean bl2 = allCounters.add(this);
        }
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final List<CounterWithExclude> getExcludedFrom$util_runtime() {
        return this.excludedFrom;
    }

    public final void increment() {
        int n = this.count;
        this.count = n + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T time(@NotNull Function0<? extends T> block) {
        Intrinsics.checkNotNullParameter(block, "block");
        int n = this.count;
        this.count = n + 1;
        if (!enabled) {
            return block.invoke();
        }
        Iterable $this$forEach$iv = this.excludedFrom;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CounterWithExclude it = (CounterWithExclude)element$iv;
            boolean bl = false;
            it.enterExcludedMethod();
        }
        try {
            T t = this.countTime(block);
            return t;
        }
        finally {
            Iterable $this$forEach$iv2 = this.excludedFrom;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                CounterWithExclude it = (CounterWithExclude)element$iv;
                boolean bl = false;
                it.exitExcludedMethod();
            }
        }
    }

    public final void reset() {
        this.count = 0;
        this.totalTimeNanos = 0L;
    }

    protected final void incrementTime(long delta) {
        this.totalTimeNanos += delta;
    }

    protected abstract <T> T countTime(@NotNull Function0<? extends T> var1);

    public final void report(@NotNull Function1<? super String, Unit> consumer) {
        Intrinsics.checkNotNullParameter(consumer, "consumer");
        if (this.totalTimeNanos == 0L) {
            consumer.invoke(this.name + " performed " + this.count + " times");
        } else {
            long millis = TimeUnit.NANOSECONDS.toMillis(this.totalTimeNanos);
            consumer.invoke(this.name + " performed " + this.count + " times, total time " + millis + " ms");
        }
    }

    public final void report(@NotNull Function3<? super String, ? super Integer, ? super Long, Unit> consumer) {
        Intrinsics.checkNotNullParameter(consumer, "consumer");
        consumer.invoke(this.name, (Integer)this.count, (Long)this.totalTimeNanos);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J!\u0010\u000b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ-\u0010\u000b\u001a\u00020\t2\u001e\u0010\n\u001a\u001a\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0\r\u00a2\u0006\u0004\b\u000b\u0010\u000fJ\u0015\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0012\u0010\u0013J\r\u0010\u0014\u001a\u00020\t\u00a2\u0006\u0004\b\u0014\u0010\u0003J!\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00020\b2\b\b\u0002\u0010\u0016\u001a\u00020\u0010H\u0007\u00a2\u0006\u0004\b\u0018\u0010\u0019J+\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00020\b2\u0012\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170\u001a\"\u00020\u0017H\u0007\u00a2\u0006\u0004\b\u0018\u0010\u001cJ5\u0010$\u001a\u00028\u0000\"\u0004\b\u0000\u0010\u001d2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000\u001e2\f\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00000 H\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0004\b\"\u0010#R$\u0010'\u001a\u0012\u0012\u0004\u0012\u00020\u00170%j\b\u0012\u0004\u0012\u00020\u0017`&8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b'\u0010(R\u0016\u0010)\u001a\u00020\u00108\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b)\u0010*R\u0011\u0010-\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b+\u0010,\u0082\u0002\u0007\n\u0005\b\u009920\u0001"}, d2={"Lorg/jetbrains/kotlin/util/PerformanceCounter$Companion;", "", "<init>", "()V", "", "currentTime", "()J", "Lkotlin/Function1;", "", "", "consumer", "report", "(Lkotlin/jvm/functions/Function1;)V", "Lkotlin/Function3;", "", "(Lkotlin/jvm/functions/Function3;)V", "", "enable", "setTimeCounterEnabled", "(Z)V", "resetAllCounters", "name", "reenterable", "Lorg/jetbrains/kotlin/util/PerformanceCounter;", "create", "(Ljava/lang/String;Z)Lorg/jetbrains/kotlin/util/PerformanceCounter;", "", "excluded", "(Ljava/lang/String;[Lorg/jetbrains/kotlin/util/PerformanceCounter;)Lorg/jetbrains/kotlin/util/PerformanceCounter;", "T", "Ljava/lang/ThreadLocal;", "threadLocal", "Lkotlin/Function0;", "default", "getOrPut$util_runtime", "(Ljava/lang/ThreadLocal;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "getOrPut", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "allCounters", "Ljava/util/ArrayList;", "enabled", "Z", "getNumberOfCounters", "()I", "numberOfCounters"})
    public static final class Companion {
        private Companion() {
        }

        public final long currentTime() {
            return System.nanoTime();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void report(@NotNull Function1<? super String, Unit> consumer) {
            PerformanceCounter[] countersCopy;
            PerformanceCounter[] performanceCounterArray;
            Intrinsics.checkNotNullParameter(consumer, "consumer");
            ArrayList arrayList = allCounters;
            synchronized (arrayList) {
                boolean bl = false;
                Collection $this$toTypedArray$iv = allCounters;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                performanceCounterArray = thisCollection$iv.toArray(new PerformanceCounter[0]);
            }
            PerformanceCounter[] $this$forEach$iv = countersCopy = performanceCounterArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                PerformanceCounter element$iv;
                PerformanceCounter it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                it.report(consumer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void report(@NotNull Function3<? super String, ? super Integer, ? super Long, Unit> consumer) {
            PerformanceCounter[] countersCopy;
            PerformanceCounter[] performanceCounterArray;
            Intrinsics.checkNotNullParameter(consumer, "consumer");
            ArrayList arrayList = allCounters;
            synchronized (arrayList) {
                boolean bl = false;
                Collection $this$toTypedArray$iv = allCounters;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                performanceCounterArray = thisCollection$iv.toArray(new PerformanceCounter[0]);
            }
            PerformanceCounter[] $this$forEach$iv = countersCopy = performanceCounterArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                PerformanceCounter element$iv;
                PerformanceCounter it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                it.report(consumer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final int getNumberOfCounters() {
            int n;
            ArrayList arrayList = allCounters;
            synchronized (arrayList) {
                boolean bl = false;
                n = allCounters.size();
            }
            return n;
        }

        public final void setTimeCounterEnabled(boolean enable) {
            enabled = enable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void resetAllCounters() {
            ArrayList arrayList = allCounters;
            synchronized (arrayList) {
                boolean bl = false;
                Iterable $this$forEach$iv = allCounters;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    PerformanceCounter p0 = (PerformanceCounter)element$iv;
                    boolean bl2 = false;
                    p0.reset();
                }
                Unit unit = Unit.INSTANCE;
            }
        }

        @NotNull
        public final PerformanceCounter create(@NotNull String name, boolean reenterable) {
            Intrinsics.checkNotNullParameter(name, "name");
            return reenterable ? (PerformanceCounter)new ReenterableCounter(name) : (PerformanceCounter)new SimpleCounter(name);
        }

        public static /* synthetic */ PerformanceCounter create$default(Companion companion, String string2, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            return companion.create(string2, bl);
        }

        @NotNull
        public final PerformanceCounter create(@NotNull String name, PerformanceCounter ... excluded) {
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(excluded, "excluded");
            return new CounterWithExclude(name, Arrays.copyOf(excluded, excluded.length));
        }

        public final <T> T getOrPut$util_runtime(@NotNull ThreadLocal<T> threadLocal, @NotNull Function0<? extends T> function0) {
            Intrinsics.checkNotNullParameter(threadLocal, "threadLocal");
            Intrinsics.checkNotNullParameter(function0, "default");
            boolean $i$f$getOrPut$util_runtime = false;
            T value2 = threadLocal.get();
            if (value2 == null) {
                value2 = function0.invoke();
                threadLocal.set(value2);
            }
            return value2;
        }

        @NotNull
        public final PerformanceCounter create(@NotNull String name) {
            Intrinsics.checkNotNullParameter(name, "name");
            return org.jetbrains.kotlin.util.PerformanceCounter$Companion.create$default(this, name, false, 2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

