/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.util.collectionUtils;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.utils.SmartList;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\u001a7\u0010\u0003\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0001\"\u0004\b\u0000\u0010\u0000*\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00028\u00000\u0001H\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004\u001aM\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00010\u0001\"\u0004\b\u0000\u0010\u0005\"\u0004\b\u0001\u0010\u00002\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\u00062\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00010\bH\u0087\b\u00f8\u0001\u0000\u00a2\u0006\u0004\b\n\u0010\u000b\u001aU\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00010\u0001\"\u0004\b\u0000\u0010\u0005\"\u0004\b\u0001\u0010\u00002\u0006\u0010\f\u001a\u00028\u00002\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u00062\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00010\bH\u0087\b\u00f8\u0001\u0000\u00a2\u0006\u0004\b\n\u0010\u000e\u001aS\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00010\u0001\"\u0004\b\u0000\u0010\u0005\"\u0004\b\u0001\u0010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00018\u00002\b\u0010\u0011\u001a\u0004\u0018\u00018\u00002\u0018\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00010\bH\u0087\b\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0013\u0010\u0014\u001aA\u0010\u0017\u001a\u00020\u0015\"\u0004\b\u0000\u0010\u00052\b\u0010\u0010\u001a\u0004\u0018\u00018\u00002\b\u0010\u0011\u001a\u0004\u0018\u00018\u00002\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00150\bH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0017\u0010\u0018\u001a-\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00190\u001a2\u0016\u0010\u0007\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00190\u0006\"\u0004\u0018\u00010\u0019H\u0007\u00a2\u0006\u0004\b\u001b\u0010\u001c\u001a%\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00190\u001a2\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u001dH\u0007\u00a2\u0006\u0004\b\u001b\u0010\u001e\u001aI\u0010 \u001a\u0004\u0018\u00018\u0001\"\u0004\b\u0000\u0010\u0005\"\b\b\u0001\u0010\u0000*\u00020\u001f2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\u00062\u0014\u0010\t\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00018\u00010\bH\u0087\b\u00f8\u0001\u0000\u00a2\u0006\u0004\b \u0010!\u001a=\u0010%\u001a\b\u0012\u0004\u0012\u00028\u00000$\"\u0006\b\u0000\u0010\u000f\u0018\u0001*\u0006\u0012\u0002\b\u00030\u001d2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\"0\bH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0004\b%\u0010&\u0082\u0002\u0007\n\u0005\b\u009920\u0001"}, d2={"T", "", "collection", "concat", "(Ljava/util/Collection;Ljava/util/Collection;)Ljava/util/Collection;", "Scope", "", "scopes", "Lkotlin/Function1;", "callback", "getFromAllScopes", "([Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)Ljava/util/Collection;", "firstScope", "restScopes", "(Ljava/lang/Object;[Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)Ljava/util/Collection;", "R", "scope1", "scope2", "transform", "flatMapScopes", "(Ljava/lang/Object;Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)Ljava/util/Collection;", "", "action", "forEachScope", "(Ljava/lang/Object;Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)V", "Lorg/jetbrains/kotlin/resolve/scopes/MemberScope;", "Lorg/jetbrains/kotlin/utils/SmartList;", "listOfNonEmptyScopes", "([Lorg/jetbrains/kotlin/resolve/scopes/MemberScope;)Lorg/jetbrains/kotlin/utils/SmartList;", "", "(Ljava/lang/Iterable;)Lorg/jetbrains/kotlin/utils/SmartList;", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "getFirstClassifierDiscriminateHeaders", "([Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "", "predicate", "", "filterIsInstanceAnd", "(Ljava/lang/Iterable;Lkotlin/jvm/functions/Function1;)Ljava/util/List;"})
public final class ScopeUtilsKt {
    @Nullable
    public static final <T> Collection<T> concat(@Nullable Collection<? extends T> $this$concat, @NotNull Collection<? extends T> collection) {
        Intrinsics.checkNotNullParameter(collection, "collection");
        if (collection.isEmpty()) {
            return $this$concat;
        }
        if ($this$concat == null) {
            return collection;
        }
        if ($this$concat instanceof LinkedHashSet) {
            ((LinkedHashSet)$this$concat).addAll(collection);
            return $this$concat;
        }
        LinkedHashSet<T> result2 = new LinkedHashSet<T>($this$concat);
        result2.addAll(collection);
        return result2;
    }

    @NotNull
    public static final <Scope, T> Collection<T> getFromAllScopes(@NotNull Scope[] scopes, @NotNull Function1<? super Scope, ? extends Collection<? extends T>> callback) {
        Collection collection;
        Intrinsics.checkNotNullParameter(scopes, "scopes");
        Intrinsics.checkNotNullParameter(callback, "callback");
        boolean $i$f$getFromAllScopes = false;
        switch (scopes.length) {
            case 0: {
                collection = CollectionsKt.emptyList();
                break;
            }
            case 1: {
                collection = callback.invoke(scopes[0]);
                break;
            }
            default: {
                Collection result2 = null;
                for (Scope scope2 : scopes) {
                    result2 = ScopeUtilsKt.concat(result2, callback.invoke(scope2));
                }
                collection = result2;
                if (collection != null) break;
                collection = SetsKt.emptySet();
            }
        }
        return collection;
    }

    @NotNull
    public static final <Scope, T> Collection<T> getFromAllScopes(Scope firstScope, @NotNull Scope[] restScopes, @NotNull Function1<? super Scope, ? extends Collection<? extends T>> callback) {
        Intrinsics.checkNotNullParameter(restScopes, "restScopes");
        Intrinsics.checkNotNullParameter(callback, "callback");
        boolean $i$f$getFromAllScopes = false;
        Collection<T> result2 = callback.invoke(firstScope);
        for (Scope scope2 : restScopes) {
            result2 = ScopeUtilsKt.concat(result2, callback.invoke(scope2));
        }
        Collection<T> collection = result2;
        if (collection == null) {
            collection = SetsKt.emptySet();
        }
        return collection;
    }

    @NotNull
    public static final <Scope, R> Collection<R> flatMapScopes(@Nullable Scope scope1, @Nullable Scope scope2, @NotNull Function1<? super Scope, ? extends Collection<? extends R>> transform2) {
        List<R> list;
        Collection<R> results1;
        Intrinsics.checkNotNullParameter(transform2, "transform");
        boolean $i$f$flatMapScopes = false;
        Scope Scope = scope1;
        Collection<R> collection = results1 = Scope != null ? transform2.invoke(Scope) : (Collection<R>)CollectionsKt.emptyList();
        if (scope2 == null) {
            return results1;
        }
        Collection<? extends R> results2 = transform2.invoke(scope2);
        if (results1.isEmpty()) {
            return results2;
        }
        List<R> it = list = CollectionsKt.toMutableList(results1);
        boolean bl = false;
        it.addAll(results2);
        return list;
    }

    public static final <Scope> void forEachScope(@Nullable Scope scope1, @Nullable Scope scope2, @NotNull Function1<? super Scope, Unit> action) {
        Intrinsics.checkNotNullParameter(action, "action");
        boolean $i$f$forEachScope = false;
        if (scope1 != null) {
            action.invoke(scope1);
        }
        if (scope2 != null) {
            action.invoke(scope2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final SmartList<MemberScope> listOfNonEmptyScopes(MemberScope ... scopes) {
        void var2_2;
        void $this$filterTo$iv;
        Intrinsics.checkNotNullParameter(scopes, "scopes");
        MemberScope[] memberScopeArray = scopes;
        Collection destination$iv = new SmartList();
        boolean $i$f$filterTo = false;
        int n = ((void)$this$filterTo$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv;
            void it = element$iv = $this$filterTo$iv[i];
            boolean bl = false;
            if (!(it != null && it != MemberScope.Empty.INSTANCE)) continue;
            destination$iv.add(element$iv);
        }
        return (SmartList)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final SmartList<MemberScope> listOfNonEmptyScopes(@NotNull Iterable<? extends MemberScope> scopes) {
        void var2_2;
        void $this$filterTo$iv;
        Intrinsics.checkNotNullParameter(scopes, "scopes");
        Iterable<? extends MemberScope> iterable = scopes;
        Collection destination$iv = new SmartList();
        boolean $i$f$filterTo = false;
        for (Object element$iv : $this$filterTo$iv) {
            MemberScope it = (MemberScope)element$iv;
            boolean bl = false;
            if (!(it != null && it != MemberScope.Empty.INSTANCE)) continue;
            destination$iv.add(element$iv);
        }
        return (SmartList)var2_2;
    }

    @Nullable
    public static final <Scope, T extends ClassifierDescriptor> T getFirstClassifierDiscriminateHeaders(@NotNull Scope[] scopes, @NotNull Function1<? super Scope, ? extends T> callback) {
        Intrinsics.checkNotNullParameter(scopes, "scopes");
        Intrinsics.checkNotNullParameter(callback, "callback");
        boolean $i$f$getFirstClassifierDiscriminateHeaders = false;
        ClassifierDescriptor result2 = null;
        for (Scope scope2 : scopes) {
            ClassifierDescriptor newResult = (ClassifierDescriptor)callback.invoke(scope2);
            if (newResult == null) continue;
            if (newResult instanceof ClassifierDescriptorWithTypeParameters && ((MemberDescriptor)((Object)newResult)).isExpect()) {
                if (result2 != null) continue;
                result2 = newResult;
                continue;
            }
            return (T)newResult;
        }
        return (T)result2;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ <R> List<R> filterIsInstanceAnd(Iterable<?> $this$filterIsInstanceAnd, Function1<? super R, Boolean> predicate) {
        void $this$filterIsInstanceAndTo$iv;
        Intrinsics.checkNotNullParameter($this$filterIsInstanceAnd, "<this>");
        Intrinsics.checkNotNullParameter(predicate, "predicate");
        boolean $i$f$filterIsInstanceAnd = false;
        Iterable<?> iterable = $this$filterIsInstanceAnd;
        Collection destination$iv = new SmartList();
        boolean $i$f$filterIsInstanceAndTo = false;
        for (Object element$iv : $this$filterIsInstanceAndTo$iv) {
            Intrinsics.reifiedOperationMarker(3, "R");
            if (!(element$iv instanceof Object) || !predicate.invoke(element$iv).booleanValue()) continue;
            destination$iv.add(element$iv);
        }
        return (List)destination$iv;
    }
}

