/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.utils;

import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.utils.KotlinPaths;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0006H\u0017\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\t\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0006H\u0017\u00a2\u0006\u0004\b\t\u0010\bJ\u0019\u0010\n\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0007\u001a\u00020\u0006H\u0017\u00a2\u0006\u0004\b\n\u0010\bR\u001a\u0010\u0003\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u000b\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000f\u001a\u00020\u00028WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\rR\u0014\u0010\u0011\u001a\u00020\u00028WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\r"}, d2={"Lorg/jetbrains/kotlin/utils/KotlinPathsFromBaseDirectory;", "Lorg/jetbrains/kotlin/utils/KotlinPaths;", "Ljava/io/File;", "basePath", "<init>", "(Ljava/io/File;)V", "Lorg/jetbrains/kotlin/utils/KotlinPaths$Jar;", "jar", "(Lorg/jetbrains/kotlin/utils/KotlinPaths$Jar;)Ljava/io/File;", "klib", "sourcesJar", "Ljava/io/File;", "getBasePath", "()Ljava/io/File;", "getHomePath", "homePath", "getLibPath", "libPath"})
public class KotlinPathsFromBaseDirectory
implements KotlinPaths {
    @NotNull
    private final File basePath;

    public KotlinPathsFromBaseDirectory(@NotNull File basePath) {
        Intrinsics.checkNotNullParameter(basePath, "basePath");
        this.basePath = basePath;
    }

    @NotNull
    public final File getBasePath() {
        return this.basePath;
    }

    @Override
    @NotNull
    public File getHomePath() {
        throw new IllegalStateException("No home path defined");
    }

    @Override
    @NotNull
    public File getLibPath() {
        return this.basePath;
    }

    @Override
    @NotNull
    public File jar(@NotNull KotlinPaths.Jar jar) {
        Intrinsics.checkNotNullParameter((Object)jar, "jar");
        return FilesKt.resolve(this.basePath, jar.getBaseName() + ".jar");
    }

    @Override
    @NotNull
    public File klib(@NotNull KotlinPaths.Jar jar) {
        Intrinsics.checkNotNullParameter((Object)jar, "jar");
        return FilesKt.resolve(this.basePath, jar.getBaseName() + ".klib");
    }

    @Override
    @Nullable
    public File sourcesJar(@NotNull KotlinPaths.Jar jar) {
        Intrinsics.checkNotNullParameter((Object)jar, "jar");
        return FilesKt.resolve(this.basePath, jar.getBaseName() + "-sources.jar");
    }
}

