/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.wasm.analyze;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.checkers.PlatformDiagnosticSuppressor;
import org.jetbrains.kotlin.wasm.util.JsCodeUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\r\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\r\u0010\u000e"}, d2={"Lorg/jetbrains/kotlin/wasm/analyze/WasmDiagnosticSuppressor;", "Lorg/jetbrains/kotlin/resolve/checkers/PlatformDiagnosticSuppressor;", "<init>", "()V", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "parameter", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "bindingContext", "", "shouldReportUnusedParameter", "(Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;Lorg/jetbrains/kotlin/resolve/BindingContext;)Z", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "descriptor", "shouldReportNoBody", "(Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;)Z"})
public final class WasmDiagnosticSuppressor
implements PlatformDiagnosticSuppressor {
    @NotNull
    public static final WasmDiagnosticSuppressor INSTANCE = new WasmDiagnosticSuppressor();

    private WasmDiagnosticSuppressor() {
    }

    @Override
    public boolean shouldReportUnusedParameter(@NotNull VariableDescriptor parameter, @NotNull BindingContext bindingContext) {
        Intrinsics.checkNotNullParameter(parameter, "parameter");
        Intrinsics.checkNotNullParameter(bindingContext, "bindingContext");
        DeclarationDescriptor declarationDescriptor = parameter.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue(declarationDescriptor, "getContainingDeclaration(...)");
        DeclarationDescriptor containingDeclaration = declarationDescriptor;
        if (containingDeclaration instanceof FunctionDescriptor) {
            return !JsCodeUtilsKt.hasValidJsCodeBody((FunctionDescriptor)containingDeclaration, bindingContext);
        }
        return true;
    }

    @Override
    public boolean shouldReportNoBody(@NotNull CallableMemberDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        return true;
    }
}

